/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.net;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import nxm.ice.net.HFiles;
import nxm.ice.net.HPage;
import nxm.ice.net.HQuery;
import nxm.ice.net.HSource;
import nxm.ice.net.HSystem;
import nxm.sys.lib.Command;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Macro;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.prim.rmif;

public class HServer
implements Runnable {
    public static final int DEFAULT_PORT = 8080;
    public static final int DEFAULT_NUM_WORKERS = 5;
    public static final int BUF_SIZE = 2048;
    private static boolean debug = false;
    private static boolean debug2 = false;
    private static final int TIMEOUT = 1000;
    private Midas M = null;
    private LinkedList<HSource> sources = new LinkedList();
    private ServerSocket serverSocket;
    private String host;
    private int port;
    private int prange = 1;
    private String dsTitle = "nxm.ice.net.HServer";
    private String homePage;
    private String homeDir;
    private String appName;
    Command parent;
    private static boolean isHttps;
    private static boolean oneWay;
    static InetAddress hostip;

    public static HServer launch(Midas midas, String string, int n, int n2) {
        HServer hServer = new HServer(midas, n, n2);
        hServer.dsTitle = string;
        hServer.open();
        Thread thread = new Thread(hServer);
        thread.start();
        return hServer;
    }

    public static HServer launch(String string, int n) {
        return HServer.launch(null, string, n, 1);
    }

    public static HServer launch(Object object, String string, int n, int n2, String string2, String string3) {
        Midas midas = Convert.ref2Midas((Object)object);
        if (midas == null) {
            midas = Shell.getSharedMidasContext();
        }
        HServer hServer = HServer.launch(midas, string, n, n2);
        if (object instanceof Command) {
            hServer.setParent((Command)object);
        }
        if (string2 != null) {
            hServer.setHomePage(string2);
        }
        if (midas.macro != null) {
            hServer.addSource(new HQuery("Controls", midas.macro.controls, null, 128));
        }
        if (midas.macro != null) {
            hServer.addSource(new HQuery("Registry", midas.macro.getRegistry(), null, 128));
        }
        if (midas.macro != null) {
            hServer.addSource(new HQuery("Results", midas.macro.getResults(), null, 128));
        }
        if (!StringUtil.isNull((String)string3)) {
            hServer.addSource(new HFiles("Files", midas, string3));
        }
        hServer.addSource(new HSystem("System", midas));
        return hServer;
    }

    public static HServer launch(Object object, String string, int n, String string2, String string3) {
        return HServer.launch(object, string, n, 1, string2, string3);
    }

    public HServer() {
        this(null, 8080, 1);
    }

    public HServer(int n) {
        this(null, n, 1);
    }

    public HServer(Midas midas, int n, int n2) {
        this.M = midas;
        this.port = n;
        this.prange = n2;
        HServer.log("Creating new server starting on port " + n + " with range of " + n2);
        this.addSource(new ServerIndex());
        this.addSource(new HFiles("nmroot", Shell.getNmRoot()));
    }

    public void setTitle(String string) {
        this.dsTitle = string;
    }

    public Midas getMidas() {
        return this.M;
    }

    public Object getResult(String string) {
        return this.M.results.getO(string);
    }

    public Table getResults() {
        return this.M.results;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        if (this.host == null) {
            this.host = this.M.results.getS("ENV.HOSTNAME");
        }
        if (this.host == null) {
            InetAddress inetAddress = HServer.getHostIA();
            this.host = inetAddress == null ? "unknown" : inetAddress.getHostAddress();
        }
        return this.host;
    }

    public String getHostAddr() {
        return this.M.results.getS("ENV.HOSTADDR");
    }

    public String getHostPort() {
        return this.getHost() + ":" + this.getPort();
    }

    public void setAppName(String string) {
        int n;
        int n2 = string.length();
        int n3 = 80;
        int n4 = 0;
        for (n = 0; n < n2 && n < n3; ++n) {
            if (string.charAt(n) != ',') continue;
            n4 = n;
        }
        this.appName = n == n2 ? string : string.substring(0, n4) + ", ...";
    }

    public void setParent(Command command) {
        this.parent = command;
        Macro macro = command.M.macro;
        if (macro == null) {
            return;
        }
        String string = "/nmroot/nxm/" + macro.args.option + "/mcr/" + macro.args.name + ".html";
        this.setHomePage(string.toLowerCase());
        string = macro.toString();
        int n = string.indexOf(":");
        int n2 = string.indexOf(",/");
        if (n2 < 0) {
            n2 = string.length();
        }
        this.setAppName(string.substring(n + 1, n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSource(String string, HSource hSource, boolean bl) {
        if (string == null || hSource == null) {
            return;
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        HServer.log("Adding " + string);
        LinkedList<HSource> linkedList = this.sources;
        synchronized (linkedList) {
            this.removeSource(string);
            if (bl) {
                this.sources.add(0, hSource);
            } else {
                this.sources.add(hSource);
            }
        }
        hSource.setServer(this);
    }

    public void addSource(String string, HSource hSource) {
        this.addSource(string, hSource, false);
    }

    public void addSource(HSource hSource) {
        String string = hSource == null ? null : hSource.getName();
        this.addSource(string, hSource, false);
    }

    public void addSource(HSource hSource, boolean bl) {
        String string = hSource == null ? null : hSource.getName();
        this.addSource(string, hSource, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSource(String string) {
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        LinkedList<HSource> linkedList = this.sources;
        synchronized (linkedList) {
            for (HSource hSource : this.sources) {
                if (!hSource.getName().equals(string)) continue;
                this.removeSource(hSource);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSource(HSource hSource) {
        if (hSource == null) {
            return;
        }
        LinkedList<HSource> linkedList = this.sources;
        synchronized (linkedList) {
            this.sources.remove(hSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HSource getSource(String string) {
        LinkedList<HSource> linkedList = this.sources;
        synchronized (linkedList) {
            for (HSource hSource : this.sources) {
                if (!hSource.canHandleRequest(string)) continue;
                return hSource;
            }
        }
        return null;
    }

    private void createHttpsServer() throws IOException {
        SSLContext sSLContext;
        try {
            sSLContext = SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return;
        }
        this.serverSocket = sSLContext.getServerSocketFactory().createServerSocket(this.port);
        this.info("Starting HTTP Web Server at URL=https://" + this.getHost() + ":" + this.port + "/");
        if (!oneWay) {
            ((SSLServerSocket)this.serverSocket).setWantClientAuth(true);
            ((SSLServerSocket)this.serverSocket).setNeedClientAuth(true);
        } else {
            ((SSLServerSocket)this.serverSocket).setWantClientAuth(false);
            ((SSLServerSocket)this.serverSocket).setNeedClientAuth(false);
        }
    }

    private void createHttpServer() {
        while (this.serverSocket == null) {
            try {
                this.serverSocket = new ServerSocket(this.port);
                this.serverSocket.setSoTimeout(1000);
                this.port = this.serverSocket.getLocalPort();
                this.info("Starting HTTP Web Server at URL=http://" + this.getHost() + ":" + this.port + "/");
            }
            catch (BindException bindException) {
                HServer.log("Port " + this.port + " not available");
                if (--this.prange <= 0) {
                    this.printStackTrace("HServer.open(): Error opening server socket, no port(s) available (" + this.port + ")", bindException);
                    break;
                }
                ++this.port;
            }
            catch (IOException iOException) {
                this.printStackTrace("HServer.open(): Error opening server socket on port " + this.port, iOException);
                this.stopThread();
            }
        }
    }

    public static void setHTTPS(String string) {
        if (!(string = string.toUpperCase()).equals("OFF")) {
            HServer.setHttps(true);
        }
        if (string.startsWith("ONE")) {
            HServer.setOneWay(true);
        }
    }

    public int open() {
        if (isHttps) {
            System.out.println("HServer: HTTPS open OneWayAuth=" + oneWay + " at port=" + this.port);
            try {
                this.createHttpsServer();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            this.createHttpServer();
        }
        return 0;
    }

    public int process() {
        int n = -1;
        if (this.serverSocket != null) {
            try {
                Socket socket = this.serverSocket.accept();
                socket.setSoTimeout(0);
                socket.setTcpNoDelay(true);
                HPage hPage = new HPage(this, socket);
                Thread thread = new Thread(hPage);
                thread.start();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                if (debug2) {
                    HServer.log("Socket timeout after 1000 millisecs on port " + this.port);
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                this.printStackTrace("HServer: Got InterruptedIOException on port " + this.port, interruptedIOException);
            }
            catch (SocketException socketException) {
                if (this.serverSocket != null) {
                    if ("socket closed".equalsIgnoreCase(socketException.getMessage())) {
                        HServer.log("Server Socket closed. exiting HTTP server on port " + this.port);
                    } else {
                        this.printStackTrace("HServer: Got SocketException while closing server socket on port " + this.port, socketException);
                    }
                    n = 9;
                }
            }
            catch (Exception exception) {
                this.printStackTrace("HServer: Got exception on port " + this.port, exception);
            }
        } else {
            n = 9;
        }
        return n;
    }

    public int close() {
        this.stopThread();
        return 0;
    }

    @Override
    public void run() {
        int n = 0;
        while (n != 9) {
            n = this.process();
        }
        this.close();
    }

    public synchronized void stopThread() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (Exception exception) {
                this.printStackTrace("Error closing socket on port " + this.port, exception);
            }
        }
        this.serverSocket = null;
    }

    public boolean isRunning() {
        return this.serverSocket != null;
    }

    private void framesPage(HPage hPage) {
        String string = this.homePage != null ? this.homePage : "/nmroot/";
        boolean bl = this.dsTitle != null && this.dsTitle.equals("homepageonly");
        hPage.open();
        hPage.writeln("<html>");
        hPage.writeln("<head>");
        hPage.writeln("<title>HServer Frame</title>");
        hPage.writeln("</head>");
        if (bl) {
            hPage.writeln("<frameset rows='0,*'>");
        } else {
            hPage.writeln("<frameset rows='65,*'>");
        }
        hPage.writeln("<frame src='/header' name='headerFrame'>");
        hPage.writeln("<frame src='" + string + "' name='dataFrame'>");
        hPage.writeln("</frameset>");
        hPage.writeln("</html>");
        hPage.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void headerPage(HPage hPage) {
        String string = "unknown";
        String string2 = "unknown";
        try {
            InetAddress inetAddress = HServer.getHostIA();
            string = inetAddress.getHostName();
            string2 = inetAddress.getHostAddress();
        }
        catch (Exception exception) {
            Shell.warning((CharSequence)("Error in host lookup: " + exception));
        }
        int n = this.serverSocket.getLocalPort();
        int n2 = n / 10 * 10;
        int n3 = this.getPartners();
        String string3 = "&nbsp;&nbsp;";
        if (n3 > 0) {
            for (int i = 0; i <= n3; ++i) {
                string3 = string3 + "-<a href='http://" + string2 + ":" + (n2 + i) + "' target='_top'>" + i + "</a>";
            }
        }
        String string4 = string.equals(string2.toString()) ? "" : "Name=" + string;
        hPage.openToBody("HServer Header");
        if (this.dsTitle != null) {
            hPage.writeln("<center><b>" + this.dsTitle + "</b></center>");
        }
        hPage.writeln("<center><b>HOST " + string4 + " Address=" + string2 + " Port=" + n + "</b>" + string3 + "</center>");
        if (this.appName != null) {
            hPage.writeln("<center><b>" + this.appName + "</b></center>");
        }
        hPage.writeln("<center>");
        if (this.homePage != null) {
            hPage.writeln("<a href='" + this.homePage + "' target='dataFrame'>Home</a>");
        }
        if (this.homePage != null) {
            hPage.writeln("<b>-</b>");
        }
        LinkedList<HSource> linkedList = this.sources;
        synchronized (linkedList) {
            for (HSource hSource : this.sources) {
                String string5 = hSource.getName();
                if (string5.length() <= 0 || string5.equals("/nmroot/")) continue;
                String string6 = string5;
                if (string6.startsWith("/")) {
                    string6 = string6.substring(1);
                }
                if (string6.endsWith("/")) {
                    string6 = string6.substring(0, string6.length() - 1);
                }
                hPage.writeln("<a href='" + string5 + "' target='dataFrame'>" + string6 + "</a>");
                hPage.writeln("<b>-</b>");
            }
        }
        hPage.writeln("<a href='/nmroot/htdocs/help/index.html' target='dataFrame'>Help</a>");
        hPage.writeln("</center>");
        hPage.closeFromBody();
    }

    public void setHomePage(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.homePage = string;
        int n = this.homePage.lastIndexOf(47);
        if (n > 0) {
            this.homeDir = this.homePage.substring(0, n);
        }
    }

    public String getHomeDir() {
        return this.homeDir;
    }

    private int getPartners() {
        if (this.parent instanceof rmif) {
            return ((rmif)this.parent).getPartners();
        }
        return 0;
    }

    public static void setDebug(boolean bl) {
        debug = bl;
    }

    @Deprecated
    public static void setDebug(int n) {
        HServer.setDebug(n != 0);
    }

    protected static void log(String string) {
        if (debug) {
            Shell.writeln((CharSequence)("HServer : " + string));
        }
    }

    protected void info(CharSequence charSequence) {
        if (this.M != null) {
            this.M.info(charSequence);
        } else {
            Shell.info((CharSequence)charSequence);
        }
    }

    protected void printStackTrace(CharSequence charSequence, Throwable throwable) {
        if (this.M != null) {
            this.M.printStackTrace(charSequence, throwable);
        } else {
            Shell.printStackTrace((CharSequence)charSequence, (Throwable)throwable);
        }
    }

    public static InetAddress getHostIA() {
        if (hostip != null) {
            return hostip;
        }
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            if (!inetAddress.isLoopbackAddress()) {
                return inetAddress;
            }
            inetAddress = null;
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                String string = networkInterface.getName();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress2 = enumeration2.nextElement();
                    if (!inetAddress2.isSiteLocalAddress() || inetAddress2.isLoopbackAddress() || inetAddress != null && !string.endsWith("0")) continue;
                    inetAddress = inetAddress2;
                }
            }
            hostip = inetAddress;
            return inetAddress;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void setHttps(boolean bl) {
        isHttps = bl;
    }

    public static void setOneWay(boolean bl) {
        oneWay = bl;
    }

    protected class ServerIndex
    extends HSource {
        protected ServerIndex() {
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public boolean canHandleRequest(String string) {
            return string.equals("/") || string.equals("/header");
        }

        @Override
        public void handleRequest(String string, HPage hPage) {
            if (string.equals("/")) {
                HServer.this.framesPage(hPage);
            } else if (string.equals("/header")) {
                HServer.this.headerPage(hPage);
            }
        }

        public String toString() {
            return "Source List";
        }
    }
}

