/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.regex.Pattern;
import nxm.ice.net.HServer;
import nxm.ice.net.HSource;
import nxm.sys.inc.AsciiMap;
import nxm.sys.inc.MidasReference;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;

public class HPage
implements Runnable,
AsciiMap {
    private static boolean DEBUG = false;
    private static final Pattern DISP_SEP = Pattern.compile("[ ]*;[ ]*");
    private static final String RFC1123_DATE_PATTERN = "EEE, dd MMM yyyy HH:mm:ss 'GMT'";
    private static final String RFC850_DATE_PATTERN = "EEEE, dd-MMM-yy HH:mm:ss 'GMT'";
    private static final String ASCTIME_DATE_PATTERN = "EEE MMM d HH:mm:ss yyyy";
    private final SimpleDateFormat httpDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'");
    public static final String EOLSTR = "\r\n";
    public static final byte[] EOL = "\r\n".getBytes();
    public final HServer server;
    private Table reqHeader = null;
    private Table resHeader;
    private MultipartData[] postData;
    private Socket sock;
    private BufferedOutputStream os;
    private BufferedInputStream is;
    private String method;
    private String uri;
    private String version;
    private int status = 400;
    private boolean opened = false;
    private boolean closed = false;
    private String scheme = "US-ASCII";
    private String WS_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    byte[] m = new byte[4];

    public HPage(HServer hServer, Socket socket) throws IOException {
        this(hServer, socket, "US-ASCII");
    }

    public HPage(HServer hServer, Socket socket, String string) throws IOException {
        this.resHeader = new Table();
        this.setDate(new Date());
        this.resHeader.put("Server", (Object)("NeXtMidas/4.1.4 Java/" + Shell.getJavaVersion()));
        this.setContentType("text/html");
        this.server = hServer;
        this.sock = socket;
        this.scheme = string;
        this.os = new BufferedOutputStream(socket.getOutputStream());
        this.is = new BufferedInputStream(socket.getInputStream());
    }

    @Override
    public void run() {
        try {
            this.parseRequest();
            this.handleRequest();
            this.close();
            this.sock.close();
        }
        catch (Exception exception) {
            Shell.printStackTrace((CharSequence)("HPAGE: Error processing request URI=" + this.uri), (Throwable)exception);
            this.close();
            try {
                this.sock.close();
            }
            catch (Exception exception2) {
                Shell.printStackTrace((CharSequence)("HPAGE: Can not close socket. URI=" + this.uri), (Throwable)exception2);
            }
        }
        if (DEBUG) {
            System.out.println("Done " + this.uri);
        }
    }

    private void parseRequest() throws IOException {
        String string = this.readline();
        if (DEBUG) {
            System.out.println("Req: " + string);
        }
        if (string == null) {
            return;
        }
        int n = string.indexOf(32);
        int n2 = string.lastIndexOf(32);
        if (n < 0 || n2 < 0 || n2 <= n) {
            throw new IllegalArgumentException("Improperly formatted request line : " + string + "  HOST=" + this.sock.getRemoteSocketAddress());
        }
        this.method = string.substring(0, n);
        this.uri = string.substring(n + 1, n2);
        this.version = string.substring(n2 + 1);
        this.reqHeader = this.readHeader();
        if (this.server.parent != null && this.uri.indexOf(94) >= 0) {
            this.uri = this.server.parent.MA.evaluateCarets(this.uri);
        }
        if (this.method.equals("POST")) {
            this.postData = this.readPost(this.reqHeader);
        }
    }

    private MultipartData[] readPost(Table table) throws IOException {
        Object object;
        Object object2;
        int n;
        int n2;
        int n3;
        Object object3;
        String string = table.getS("Content-Type", null);
        String string2 = table.getS("Content-Length", null);
        int n4 = string2 == null ? -1 : Convert.s2l((String)string2);
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (string != null && string.startsWith("multipart/")) {
            object3 = string;
            while (((String)object3).length() > 0 && (n3 = ((String)object3).indexOf(59)) >= 0) {
                n2 = ((String)(object3 = ((String)object3).substring(n3 + 1).trim())).indexOf(61);
                if (n2 < 0) continue;
                n = ((String)object3).indexOf(59, n2);
                if (n < 0) {
                    n = ((String)object3).length();
                }
                object2 = ((String)object3).substring(0, n2).trim();
                String string3 = ((String)object3).substring(n2 + 1, n).trim();
                if (!object2.equalsIgnoreCase("boundary")) continue;
                object = "--" + string3 + EOLSTR;
                String string4 = "--" + string3 + "--" + EOLSTR;
                byArray = ((String)object).getBytes();
                byArray2 = string4.getBytes();
                break;
            }
        }
        if (byArray == null) {
            if (n4 < 0) {
                n4 = this.is.available();
            }
            object3 = new byte[n4];
            n3 = 0;
            n2 = n4;
            while (n2 > 0) {
                n = this.is.read((byte[])object3, n3, n2);
                if (n == 0) {
                    Time.sleep((double)0.1);
                    continue;
                }
                if (n < 0) {
                    throw new IOException("End of data before boundary reached.");
                }
                n3 += n;
                n2 -= n;
            }
            return new MultipartData[]{new MultipartData(table, (byte[])object3)};
        }
        boolean bl = this.readHeaderGap(byArray, byArray2);
        ArrayList<MultipartData> arrayList = new ArrayList<MultipartData>();
        block2: while (!bl) {
            Table table2 = this.readHeader();
            String string5 = table2.getS("Content-Type", null);
            if (string5 != null && string5.startsWith("multipart/")) {
                object2 = this.readPost(table2);
                arrayList.add(new MultipartData(table2, (MultipartData[])object2));
                bl = this.readHeaderGap(byArray, byArray2);
                continue;
            }
            if (DEBUG) {
                System.out.println("Dat: <data>");
            }
            object2 = new byte[4096];
            int n5 = 0;
            while (true) {
                object = this.readln();
                boolean bl2 = Arrays.equals((byte[])object, byArray);
                boolean bl3 = Arrays.equals((byte[])object, byArray2);
                if (bl2 || bl3) {
                    arrayList.add(new MultipartData(table2, (byte[])object2, 0, n5 - 2));
                    bl = bl3;
                    continue block2;
                }
                if (n5 + ((byte[])object).length > ((byte[])object2).length) {
                    int n6 = (n5 + ((byte[])object).length + 4095) / 4096 * 4096;
                    byte[] byArray3 = new byte[n6];
                    System.arraycopy(object2, 0, byArray3, 0, n5);
                    object2 = byArray3;
                }
                System.arraycopy(object, 0, object2, n5, ((byte[])object).length);
                n5 += ((byte[])object).length;
            }
        }
        return arrayList.toArray(new MultipartData[0]);
    }

    public MultipartData[] getPostData() {
        return this.postData;
    }

    public MultipartData getPostData(String string) {
        if (this.postData == null) {
            return null;
        }
        for (MultipartData multipartData : this.postData) {
            String string2 = multipartData.getHeaderValue("Content-Disposition");
            if (string2 == null || !string2.startsWith("form-data;")) continue;
            String[] stringArray = DISP_SEP.split(string2);
            for (int i = 1; i < stringArray.length; ++i) {
                String string3;
                if (!stringArray[i].startsWith("name=\"") || !stringArray[i].endsWith("\"") || !string.equals(string3 = stringArray[i].substring(6, stringArray[i].length() - 1))) continue;
                return multipartData;
            }
        }
        return null;
    }

    public String getMethod() {
        return this.method;
    }

    public Table getParameters() {
        String string = this.uri;
        try {
            string = URLDecoder.decode(this.uri, this.scheme);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Table table = HSource.getParameters(string, null);
        if (this.postData != null) {
            for (MultipartData multipartData : this.postData) {
                String string2 = multipartData.getHeaderValue("Content-Disposition");
                String string3 = multipartData.getHeaderValue("Content-Type");
                byte[] byArray = multipartData.getData();
                if (string3 == null || byArray == null || byArray.length == 0 || string2 != null && !string2.startsWith("form-data;") || !string3.equals("application/x-url-encoded") && !string3.equals("application/x-www-form-urlencoded")) continue;
                String string4 = "?" + new String(byArray);
                HSource.getParameters(string4, table);
            }
        }
        return table;
    }

    private void handleRequest() throws IOException {
        if ("GET".equals(this.method) || "HEAD".equals(this.method) || "POST".equals(this.method)) {
            HSource hSource = this.server.getSource(this.uri);
            if (DEBUG) {
                Shell.writeln((CharSequence)("HPage.handleRequest() uri=" + this.uri + " ds=" + hSource));
            }
            if (hSource == null) {
                this.setStatus(404);
                this.open();
                this.writeNotFound();
            } else if (this.method.equals("HEAD") && !hSource.handleHeadRequest()) {
                this.setStatus(200);
            } else {
                this.setStatus(200);
                hSource.handleRequest(this.uri, this);
            }
        } else {
            this.setStatus(501);
        }
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public static void setDebug(boolean bl) {
        DEBUG = bl;
    }

    public static boolean getDebug() {
        return DEBUG;
    }

    public String getURI() {
        return this.uri;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void openSocket() {
        this.open();
    }

    public void closeSocket() {
        this.close();
    }

    public void open() {
        if (!this.opened) {
            this.writeHeader();
            this.flush();
            this.opened = true;
        }
    }

    public void close() {
        if (!this.closed) {
            if (!this.opened) {
                this.open();
            }
            this.flush();
            this.closed = true;
            if (this.is != null) {
                try {
                    this.is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.os != null) {
                try {
                    this.os.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public void openToBody(String string) {
        this.openUpToBody(string);
        this.writeln("<body>");
    }

    public void openUpToBody(String string) {
        this.open();
        this.writeln("<html>");
        this.writeln("<head>");
        if (string != null) {
            this.writeln("<title>" + string + "</title>");
        }
        this.writeln("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        this.writeln("<meta http-equiv=\"Pragma\" content=\"no-cache\">");
        String string2 = this.server.getHomeDir();
        if (string2 != null) {
            this.writeln("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + string2 + "/style.css\">");
        }
        this.writeln("</head>");
    }

    public void closeFromBody() {
        this.writeln("</body>");
        this.writeln("</html>");
        this.close();
    }

    public void openWS(String string) {
        String string2 = this.getHeader("Sec-WebSocket-Key");
        String string3 = Convert.encodeBase64((byte[])Convert.getSHA1((String)(string2 + this.WS_GUID)));
        this.write("HTTP/1.1 101 Switching Protocols\r\n");
        this.write("Upgrade: websocket\r\n");
        this.write("Connection: upgrade\r\n");
        this.write("Sec-WebSocket-Accept: " + string3 + EOLSTR);
        this.write("Sec-WebSocket-Protocol: " + string + EOLSTR);
        this.write(EOL);
        this.flush();
        this.opened = true;
        this.resHeader = null;
    }

    public void closeWS() {
        this.close();
    }

    public int recvWS(byte[] byArray, int n, int n2) {
        int n3 = 0;
        try {
            int n4;
            boolean bl;
            int n5 = this.is.read();
            if (n5 < 0) {
                return -1;
            }
            int n6 = n5 & 0x7F;
            n5 = this.is.read();
            n3 = n5 & 0x7F;
            boolean bl2 = bl = (n5 & 0x80) != 0;
            if (n3 == 126) {
                n3 = 0;
                for (n4 = 0; n4 < 2; ++n4) {
                    n3 = n3 << 8 | this.is.read();
                }
            }
            if (n3 == 127) {
                n3 = 0;
                for (n4 = 0; n4 < 8; ++n4) {
                    n3 = n3 << 8 | this.is.read();
                }
            }
            if (bl) {
                for (n4 = 0; n4 < 4; ++n4) {
                    this.m[n4] = (byte)this.is.read();
                }
            }
            this.is.read(byArray, n, n3);
            if (bl) {
                for (n4 = 0; n4 < n3; ++n4) {
                    byArray[n4] = (byte)(byArray[n4] ^ this.m[n4 % 4]);
                }
            }
            switch (n6) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n3;
    }

    public int sendWS(byte[] byArray, int n, int n2) {
        int n3 = 0;
        this.m[n3++] = -126;
        if (n2 < 126) {
            this.m[n3++] = (byte)n2;
        } else {
            this.m[n3++] = 126;
            this.m[n3++] = (byte)(n2 >> 8 & 0xFF);
            this.m[n3++] = (byte)(n2 >> 0 & 0xFF);
        }
        try {
            this.os.write(this.m, 0, n3);
            this.os.write(byArray, n, n2);
            this.os.flush();
        }
        catch (Exception exception) {
            n2 = 0;
        }
        return n2;
    }

    public void flush() {
        block2: {
            try {
                this.os.flush();
            }
            catch (IOException iOException) {
                String string = iOException.getMessage();
                if ("Connection reset".equals(string) || "Broken pipe".equals(string)) break block2;
                Shell.getSharedMidasContext().warning((CharSequence)("HPAGE Error while flushing uri=" + this.uri + ": " + iOException));
            }
        }
    }

    public void setContentType(String string) {
        this.resHeader.put("Content-Type", (Object)string);
    }

    public void setContentLength(long l) {
        this.resHeader.put("Content-Length", (Object)Long.toString(l));
    }

    public void setContentRange(long l, long l2, long l3) {
        String string;
        String string2 = l3 < 0L ? "*" : Long.toString(l3);
        if (l > l2) {
            string = "*";
            this.setStatus(416);
        } else {
            string = l + "-" + l2;
            this.setStatus(206);
        }
        this.resHeader.put("Content-Range", (Object)("bytes " + string + "/" + string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDate(Date date) {
        String string;
        SimpleDateFormat simpleDateFormat = this.httpDateFormat;
        synchronized (simpleDateFormat) {
            string = this.httpDateFormat.format(date);
        }
        this.resHeader.put("Date", (Object)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastModified(Date date) {
        String string;
        SimpleDateFormat simpleDateFormat = this.httpDateFormat;
        synchronized (simpleDateFormat) {
            string = this.httpDateFormat.format(date);
        }
        this.resHeader.put("Last-Modified", (Object)string);
    }

    public String getHeader(String string) {
        if (this.reqHeader == null) {
            return null;
        }
        return this.reqHeader.getS(HPage.toTitleCase(string));
    }

    public void dumpHeader() {
        this.reqHeader.dump();
    }

    public double getHeaderD(String string) {
        String string2 = this.getHeader(string);
        if (string2 == null) {
            return -1.0;
        }
        int n = string2.indexOf(61);
        int n2 = string2.indexOf(45);
        return Convert.s2d((String)string2.substring(n + 1, n2));
    }

    private static String toTitleCase(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toUpperCase(cArray[0]);
        for (int i = 1; i < cArray.length; ++i) {
            cArray[i] = cArray[i - 1] == '-' ? Character.toUpperCase(cArray[i]) : Character.toLowerCase(cArray[i]);
        }
        return new String(cArray);
    }

    private void writeHeader() {
        if (this.resHeader == null) {
            return;
        }
        int n = this.write("HTTP/1.1 " + this.status + " " + EOLSTR);
        if (n > 0) {
            String string;
            String[] stringArray = this.resHeader.getKeys();
            int n2 = stringArray.length;
            for (int i = 0; i < n2 && (n = this.write((string = stringArray[i]) + ": " + this.resHeader.getS(string) + EOLSTR)) >= 0; ++i) {
            }
        }
        if (n > 0) {
            this.write(EOL);
        }
        this.resHeader = null;
    }

    public int write(String string) {
        return this.write(string.getBytes(), 0, -1);
    }

    public int writeln(String string) {
        int n = this.write(string.getBytes(), 0, -1);
        if (n < 0) {
            return n;
        }
        return n + this.write(EOL, 0, EOL.length);
    }

    public void writeFile(Object object, Object object2) {
        int n;
        long l;
        BaseFile baseFile = object instanceof MidasReference ? new BaseFile((MidasReference)object, object2) : new BaseFile((MidasReference)Convert.ref2Midas((Object)object), object2);
        baseFile.open();
        byte[] byArray = new byte[BaseFile.BUFFER_SIZE];
        this.setContentType(BaseFile.getMimeType((Object)object, (Object)object2));
        this.setContentLength(l);
        this.open();
        baseFile.io.seek(0L);
        for (l = (long)baseFile.getSize(); l > 0L; l -= (long)n) {
            int n2 = Math.min(byArray.length, (int)Math.min(Integer.MAX_VALUE, l));
            n = baseFile.read(byArray, 0, n2);
            if (n < 0) {
                throw new MidasException("End of file reached " + l + " bytes before end of file was expected.");
            }
            this.write(byArray, 0, n);
        }
        this.close();
        baseFile.close();
    }

    public int write(byte[] byArray) {
        return this.write(byArray, 0, byArray.length);
    }

    public int write(byte[] byArray, int n, int n2) {
        if (n2 < 0) {
            n2 = byArray.length;
        }
        try {
            this.os.write(byArray, n, n2);
            return n2;
        }
        catch (IOException iOException) {
            if (!iOException.getMessage().equals("Connection reset") && !iOException.getMessage().equals("Broken pipe")) {
                Shell.getSharedMidasContext().printStackTrace((CharSequence)("HPage err: " + iOException + " on " + this.uri), (Throwable)iOException);
            }
            return -1;
        }
    }

    private Table readHeader() throws IOException {
        String string = this.readline();
        Table table = new Table();
        while (string != null && string.length() > 0) {
            int n;
            if (DEBUG) {
                System.out.println("Hdr: " + string);
            }
            if ((n = string.indexOf(58)) > 0) {
                String string2 = string.substring(0, n).trim();
                String string3 = string.substring(n + 1).trim();
                table.put(HPage.toTitleCase(string2), (Object)string3);
            }
            string = this.readline();
        }
        if (string == null) {
            throw new IOException("Got EOF before end of header");
        }
        return table;
    }

    private boolean readHeaderGap(byte[] byArray, byte[] byArray2) throws IOException {
        byte[] byArray3;
        do {
            if ((byArray3 = this.readln()) == null) {
                throw new IOException("End of data before boundary reached.");
            }
            if (DEBUG) {
                System.out.println("Gap: " + new String(byArray3));
            }
            if (!Arrays.equals(byArray3, byArray)) continue;
            return false;
        } while (!Arrays.equals(byArray3, byArray2));
        return true;
    }

    public void write(ByteArrayOutputStream byteArrayOutputStream) {
        try {
            byteArrayOutputStream.writeTo(this.os);
        }
        catch (IOException iOException) {
            Shell.getSharedMidasContext().printStackTrace((CharSequence)("HPage err: " + iOException + " on " + this.uri), (Throwable)iOException);
        }
    }

    public void writeNotFound() {
        if (this.method.equals("HEAD")) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("<html><head><title>404 Not Found</title></head>\n");
        stringBuilder.append("<body><h1>Not Found</h1>\n");
        stringBuilder.append("<p>The requested URL <code>").append(this.uri).append("</code> was not found on this server.</p>\n");
        stringBuilder.append("</body></html>");
        this.writeln(stringBuilder.toString());
    }

    private String readline() throws IOException {
        byte[] byArray = this.readln();
        if (byArray == null) {
            return null;
        }
        String string = new String(byArray);
        if (string.endsWith(EOLSTR)) {
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }

    private byte[] readln() throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        int n2 = 0;
        while ((n = this.is.read()) >= 0) {
            if (n2 + 2 > byArray.length) {
                byte[] byArray2 = new byte[byArray.length * 2];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                byArray = byArray2;
            }
            if (n == 13) {
                int n3 = this.is.read();
                byArray[n2++] = (byte)n;
                byArray[n2++] = (byte)n3;
                if (n3 != 10) continue;
                break;
            }
            byArray[n2++] = (byte)n;
        }
        if (n < 0 && n2 == 0) {
            return null;
        }
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 0, byArray3, 0, n2);
        return byArray3;
    }

    public BufferedInputStream getInputStream() {
        return this.is;
    }

    public PrintStream getOutputStream() {
        return new PrintStream(this.os, true){

            @Override
            public void println() {
                this.print(HPage.EOLSTR);
            }
        };
    }

    public Socket getSocket() {
        return this.sock;
    }

    @Deprecated
    public boolean isHeadRequest() {
        return this.method.equals("HEAD");
    }

    @Deprecated
    public boolean isGetRequest() {
        return this.method.equals("GET");
    }

    @Deprecated
    public boolean isNotRequest() {
        return this.method.equals("OPTIONS") || this.method.equals("POST") || this.method.equals("PUT") || this.method.equals("DELETE") || this.method.equals("TRACE") || this.method.equals("CONNECT");
    }

    public static class MultipartData {
        private final Table header;
        private final byte[] data;
        private final MultipartData[] mpd;

        public MultipartData(Table table, byte[] byArray) {
            this(table, byArray, 0, byArray.length);
        }

        public MultipartData(Table table, byte[] byArray, int n, int n2) {
            if (n2 < 0) {
                n2 = 0;
            }
            if (n != 0 || n2 != byArray.length) {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, n, byArray2, 0, n2);
                byArray = byArray2;
            }
            this.header = table;
            this.data = byArray;
            this.mpd = null;
        }

        MultipartData(Table table, MultipartData[] multipartDataArray) {
            this.header = table;
            this.data = null;
            this.mpd = multipartDataArray;
        }

        public String getHeaderValue(String string) {
            if (this.header == null) {
                return null;
            }
            return this.header.getS(HPage.toTitleCase(string));
        }

        public byte[] getData() {
            return this.data;
        }

        public String getDataString() {
            return new String(this.getData());
        }

        public MultipartData[] getMultipartData() {
            return this.mpd;
        }
    }
}

