/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.net;

import java.util.Date;
import java.util.Hashtable;
import nxm.ice.net.HPage;
import nxm.ice.net.HQuery;
import nxm.ice.net.HSource;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.KeyObject;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.GPrompt;
import nxm.sys.libg.GValue;
import nxm.sys.libg.GWidget;

public class HFile
extends HSource {
    private BaseFile bf;
    private static boolean debug = false;
    private static final String htmlContentType = "text/html";
    private static final String textContentType = "text/plain";
    private static final String binaryContentType = "application/octet-stream";
    private static final String jarContentType = "application/x-java-archive";
    private static final String jnlpContentType = "application/x-java-jnlp-file";
    private static Hashtable<String, String> types;

    public HFile(String string, BaseFile baseFile) {
        this.name = string;
        this.bf = baseFile;
        if (debug) {
            Shell.writeln((CharSequence)("HFile() name=" + string + " bf=" + baseFile));
        }
    }

    public static void setDebug(boolean bl) {
        debug = bl;
    }

    public static boolean isDebug() {
        return debug;
    }

    @Override
    public boolean canHandleRequest(String string) {
        String string2 = this.getName();
        return string.equals(string2);
    }

    @Override
    public boolean handleHeadRequest() {
        return true;
    }

    @Override
    public void handleRequest(String string, HPage hPage) {
        HFile.handle(this.bf, hPage, null);
    }

    public static void handle(BaseFile baseFile, HPage hPage, String string) {
        if (debug) {
            Shell.writeln((CharSequence)("HFile.handle() " + hPage.getMethod() + " bf.url=" + baseFile.getURL()));
        }
        boolean bl = hPage.getMethod().equals("HEAD");
        baseFile.open(33);
        if (!baseFile.isOpen) {
            hPage.setStatus(404);
            hPage.open();
            if (!bl) {
                hPage.writeNotFound();
            }
            hPage.close();
            return;
        }
        int n = 0;
        int n2 = 32768;
        double d = baseFile.getSize();
        double d2 = hPage.getHeaderD("Range");
        String string2 = HFile.getContentType(baseFile.fn.getExt(), null);
        if (string2 == null) {
            string2 = BaseFile.getMimeType(null, (Object)baseFile.getName());
        }
        long l = baseFile.getResource().lastModified();
        if (d2 > 0.0) {
            baseFile.seek(d2);
            hPage.setContentRange((long)d2, (long)(d - 1.0), (long)d);
            d -= d2;
        }
        if (l > 0L) {
            hPage.setLastModified(new Date(l));
        }
        hPage.setContentType(string2);
        hPage.setContentLength((long)d);
        if (bl) {
            hPage.open();
        } else if (jnlpContentType.equals(string2)) {
            n = (int)d;
            byte[] byArray = new byte[n];
            baseFile.read(byArray, 0, n);
            String string3 = new String(byArray);
            if (hPage.server != null) {
                string3 = string3.replaceAll("MYHOST", hPage.server.getHost());
                string3 = string3.replaceAll("MYPORT", "" + hPage.server.getPort());
                string3 = hPage.server.parent.MA.evaluateCarets(string3);
                byArray = string3.getBytes();
                hPage.setContentLength(byArray.length);
            }
            hPage.open();
            hPage.write(byArray);
        } else if (d <= (double)n2) {
            n = (int)d;
            byte[] byArray = new byte[n];
            n = baseFile.read(byArray, 0, n);
            if (!binaryContentType.equals(string2) && !jarContentType.equals(string2)) {
                String string4 = new String(byArray, 0, Math.min(200, n));
                if (hPage.server != null && string4.indexOf("NMSSPP=ON") > 0) {
                    StringBuffer stringBuffer = new StringBuffer(new String(byArray, 0, n));
                    n = HFile.serverSidePreProcess(stringBuffer, hPage, string);
                    byArray = stringBuffer.toString().getBytes();
                    hPage.setContentLength(n);
                }
            }
            hPage.open();
            hPage.write(byArray, 0, n);
        } else {
            int n3;
            byte[] byArray = new byte[n2];
            hPage.open();
            while (d > 0.0 && (n3 = baseFile.read(byArray, 0, n = (int)Math.min(d, (double)n2))) >= 0 && hPage.write(byArray, 0, n3) >= 0) {
                d -= (double)n;
            }
        }
        hPage.close();
        baseFile.close();
    }

    private static int serverSidePreProcess(StringBuffer stringBuffer, HPage hPage, String string) {
        String string2;
        Object object;
        String string3;
        int n;
        int n2;
        int n3 = 1;
        if (hPage == null || hPage.server == null) {
            return stringBuffer.length();
        }
        Midas midas = hPage.server.getMidas();
        while ((n2 = stringBuffer.indexOf("<!-- FORALL")) >= 0) {
            n = stringBuffer.indexOf("<!-- ENDFOR -->", n2);
            int n4 = stringBuffer.indexOf(">", n2);
            string3 = HFile.serverSideSub(stringBuffer.substring(n2 + 12, n4 - 2), midas);
            int n5 = string3.indexOf(58);
            int n6 = Convert.s2l((String)string3.substring(n5 - 1, n5));
            int n7 = Convert.s2l((String)string3.substring(n5 + 1));
            object = stringBuffer.substring(n4 + 1, n);
            string2 = "";
            for (int i = n6; i <= n7; ++i) {
                string2 = string2 + StringUtil.replaceAll((String)object, (String)"#", (String)("" + i));
            }
            stringBuffer.replace(n2, n + 15, string2);
        }
        while ((n2 = stringBuffer.lastIndexOf("^{")) >= 0) {
            n = stringBuffer.indexOf("}", n2);
            string3 = stringBuffer.substring(n2 + 2, n).toUpperCase();
            object = null;
            string2 = "XXX";
            if (string3.startsWith("HS.")) {
                object = KeyObject.getKey((Object)hPage.server, (String)string3.substring(3), null, (Object)midas);
            } else if (midas != null) {
                object = midas.results.get(string3);
            }
            if (object instanceof GWidget) {
                GWidget gWidget = (GWidget)object;
                string2 = HFile.getControlWidget(gWidget, n3, hPage.server.getMidas());
                ++n3;
            } else if (object != null) {
                string2 = object.toString();
            }
            stringBuffer.replace(n2, n + 1, string2);
        }
        return stringBuffer.length();
    }

    private static String serverSideSub(String string, Midas midas) {
        int n;
        while ((n = string.lastIndexOf("^{")) >= 0) {
            int n2 = string.indexOf("}", n);
            String string2 = string.substring(n + 2, n2).toUpperCase();
            Object var5_5 = null;
            String string3 = "XXX";
            if (midas != null) {
                string3 = midas.results.getS(string2);
            }
            string = string.substring(0, n) + string3 + string.substring(n2 + 1);
        }
        return string;
    }

    public static String getControlWidget(GWidget gWidget, int n, Midas midas) {
        String string = gWidget.getValueString();
        String string2 = "'he" + n + "'";
        String string3 = "'he" + n + "q'";
        String string4 = "<a id=" + string2 + ">" + string + "</a>";
        boolean bl = gWidget.getFlag(8);
        if (bl) {
            string4 = "<span id=" + string2 + " onmouseover=gnoedit(" + string2 + ")>" + string + "</span>";
        } else if (gWidget instanceof GPrompt) {
            GPrompt gPrompt = (GPrompt)gWidget;
            String string5 = "&ltEnter&gt";
            if (gPrompt.isFileChooser()) {
                String string6;
                String string7;
                String[] stringArray;
                String string8 = gPrompt.getAux();
                String string9 = midas.results.getString("AUX.READ");
                if (string9.indexOf(string8) < 0) {
                    string9 = string8 + "|" + string9;
                }
                string5 = string5 + ",&ltAux=" + string8 + "&gt";
                string9 = string9.replace("|", ",");
                String string10 = "tmp|prm";
                String string11 = gPrompt.getFilter();
                int n2 = string11.indexOf(46);
                if (n2 > 0) {
                    string10 = string11.substring(n2 + 1);
                    string11 = string11.substring(0, n2);
                }
                if ((stringArray = midas.io.listFiles((Object)(string7 = midas.io.getAuxPath(string8)), string11, string6 = string8.equals("RAM") ? "" : string10)) != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        string5 = string5 + "," + stringArray[i];
                    }
                }
                string4 = "<span id=" + string3 + " onmouseover=gselect(" + string3 + ",'GC." + gWidget.label + ".AUX','" + string9 + "','" + string8 + "')>&nbsp</span>";
                string4 = string4 + "<span id=" + string2 + " onmouseover=gselect(" + string2 + ",'" + gWidget.label + "','" + string5 + "','" + string + "')>" + string + "</span>";
            } else {
                string4 = "<span id=" + string2 + " onmouseover=gselect(" + string2 + ",'" + gWidget.label + "','" + string5 + "','" + string + "')>" + string + "</span>";
            }
        } else if (gWidget instanceof GPrompt) {
            GPrompt gPrompt = (GPrompt)gWidget;
            string4 = "<span id=" + string2 + " onclick=gprompt(" + string2 + ",'" + gWidget.label + "','" + string + "')>" + string + "</span>";
        } else if (gWidget instanceof GMenu) {
            GMenu gMenu = (GMenu)gWidget;
            String string12 = gMenu.getFlag(0x200000) ? "&ltEnter&gt," : "";
            string4 = "<span id=" + string2 + " onmouseover=gselect(" + string2 + ",'" + gWidget.label + "','" + string12 + gMenu.getItems() + "','" + string + "')>" + string + "</span>";
        } else if (gWidget instanceof GValue) {
            GValue gValue = (GValue)gWidget;
            string4 = "<span id=" + string2 + " onmouseover=gvalue(" + string2 + ",'" + gWidget.label + "','" + string + "')>" + string + "</span>";
        } else if (gWidget instanceof GValue) {
            GValue gValue = (GValue)gWidget;
            string4 = "<span id=" + string2 + " onclick=gselect(" + string2 + ",'" + gWidget.label + "','" + string + "')>" + string + "</span>";
            string4 = "<span id=" + string2 + " onclick=gprompt(" + string2 + ",'" + gWidget.label + "','" + string + "')>" + string + "</span>";
            string4 = "<span id=" + string2 + " onclick=gvalue(" + string2 + ",'" + gWidget.label + "','" + string + "')>" + string + "</span>";
        }
        return string4;
    }

    public static String getControlWidgetOrig(GWidget gWidget, String string, Midas midas) {
        boolean bl = !gWidget.getFlag(8);
        boolean bl2 = string != null && string.equals(gWidget.label) && bl;
        String string2 = null;
        if (!bl2) {
            String string3 = gWidget.getValueString();
            if (string3 == null || string3.length() == 0) {
                string3 = "[]";
            }
            string2 = "<a href=\"?" + gWidget.label + "\">" + string3 + "</a>";
        } else if (gWidget instanceof GPrompt) {
            GPrompt gPrompt = (GPrompt)gWidget;
            String string4 = gWidget.getValueString();
            if (string4 == null || string4.length() == 0) {
                string4 = "[]";
            }
            if (gPrompt.isFileChooser()) {
                string2 = "[<a id=\"" + gWidget.label + "\" onClick=\"gcprompt('" + gWidget.label + "','" + string4 + "')\">Enter:</a>,<b>" + string4 + "</b>,Auxes";
                String string5 = midas.results.getString("AUX.READ");
                Parser parser = new Parser(string5, '|');
                parser.reset();
                while (parser.more()) {
                    String string6 = parser.next();
                    String string7 = midas.io.getAuxPath(string6);
                    string2 = string2 + ",<a href='filesPage.html?Aux" + string6 + "' target='filesFrame'>" + string6 + "</a>";
                }
                string2 = string2 + "]";
            } else {
                string2 = "[" + string4 + "] <a id=\"" + gWidget.label + "\" onClick=\"gcprompt('" + gWidget.label + "','" + string4 + "')\">Enter</a> <a href=\"?" + gWidget.label + "=" + string4 + ">Default</a>";
            }
        } else {
            string2 = gWidget.toString();
            string2 = HQuery.lookForChoices(gWidget.label, string2, false, bl);
            int n = string2.indexOf("[");
            int n2 = string2.lastIndexOf("]");
            if (n >= 0 && n2 > n) {
                string2 = string2.substring(n, n2 + 1);
            }
        }
        if (bl2) {
            string2 = "<a href=\"?\">&lt</a>" + string2;
        }
        return string2;
    }

    public static void handlePipe(DataFile dataFile, HPage hPage) {
        dataFile.open(33);
        boolean bl = hPage.getMethod().equals("HEAD");
        if (!dataFile.isOpen) {
            hPage.setStatus(404);
            hPage.open();
            if (!bl) {
                hPage.writeNotFound();
            }
            hPage.close();
            return;
        }
        int n = 0;
        int n2 = 1024;
        hPage.setContentType(binaryContentType);
        hPage.setContentLength(0x6400000L);
        hPage.open();
        if (!bl) {
            int n3;
            dataFile.setDataStart(512.0);
            dataFile.setDataSize(1048576.0);
            hPage.write(dataFile.hb, 0, 512);
            byte[] byArray = new byte[n2];
            while ((n3 = dataFile.read(byArray, 0, n = n2)) >= 0 && hPage.write(byArray, 0, n3) >= 0) {
            }
        }
        hPage.close();
        dataFile.close();
    }

    private static String getContentType(String string) {
        return HFile.getContentType(string, binaryContentType);
    }

    @InternalUseOnly
    public static String getContentType(String string, String string2) {
        Object object;
        string = string.toLowerCase();
        if (types == null) {
            object = new Hashtable<String, String>();
            ((Hashtable)object).put("xhtml", htmlContentType);
            ((Hashtable)object).put("html", htmlContentType);
            ((Hashtable)object).put("htm", htmlContentType);
            ((Hashtable)object).put("mm", textContentType);
            ((Hashtable)object).put("key", textContentType);
            ((Hashtable)object).put("txt", textContentType);
            ((Hashtable)object).put("java", textContentType);
            ((Hashtable)object).put("c", textContentType);
            ((Hashtable)object).put("h", textContentType);
            ((Hashtable)object).put("tmp", binaryContentType);
            ((Hashtable)object).put("prm", binaryContentType);
            ((Hashtable)object).put("pkt", binaryContentType);
            ((Hashtable)object).put("det", binaryContentType);
            ((Hashtable)object).put("jnlp", jnlpContentType);
            ((Hashtable)object).put("jar", jarContentType);
            ((Hashtable)object).put("jardiff", "application/x-java-archive-diff");
            types = object;
        }
        if ((object = types.get(string)) == null) {
            object = string2;
        }
        return object;
    }
}

