/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Time;

public class TimeCode {
    public static final int TCM_OFF = 0;
    public static final int TCM_CPU = 1;
    public static final int TCM_ZTC = 2;
    public static final int TCM_SDN = 3;
    public static final int TCM_SMS = 4;
    public static final int TCM_DTL = 5;
    public static final int TCM_IRB = 6;
    public static final int TCM_SDDS = 7;
    public static final String tcmodeList = "CPU,ZTC,SDN,SMS,DTL,IRB,SDDS";
    public Time time = new Time();
    private int tcmode;
    private int tcbit;
    private int tcbits;
    private int tcflags;
    private byte[] buffer = new byte[128];
    private byte fill;
    private byte mask;
    private final byte B1 = 1;
    private final byte B0 = 0;
    private double hack;
    private double yis;
    private int OPPS = 1;
    private int FILL = 2;
    private int VFT = 4;
    private int EXT = 8;
    private int TDC = 16;
    private int BARKER = 39;
    private boolean debug = false;

    public void setTime(Time time) {
        this.time.fromTime(time);
        this.yis = time.getYiS();
    }

    public void setMode(String string) {
        int n;
        int n2;
        this.tcbit = 0;
        this.tcmode = 0;
        this.tcflags = 0;
        for (n2 = string.length(); n2 < 3; ++n2) {
            string = string + ' ';
        }
        String string2 = string.substring(0, 3);
        this.tcmode = Parser.find((String)tcmodeList, (String)string2, (int)0);
        if (this.tcmode <= 0) {
            throw new MidasException("Mode string=" + string + " not found in " + tcmodeList);
        }
        if (this.tcmode == 4) {
            this.tcbit = 1;
        }
        if (this.tcmode == 3) {
            this.tcbit = 4;
            this.tcflags |= this.VFT;
        }
        if (n2 < 4) {
            return;
        }
        char c = string.charAt(3);
        if (c != 'X' && c != 'S') {
            if (c == '0') {
                this.tcbit = 0;
            } else if (c == '1') {
                this.tcbit = 1;
            } else if (c == '3') {
                this.tcbit = 3;
            } else if (c == '4') {
                this.tcbit = 4;
            } else {
                throw new MidasException("Bad tcmode string bit field: " + string);
            }
        }
        this.fill = (byte)(1 << this.tcbit);
        this.mask = ~this.fill;
        for (n = 4; n < n2; ++n) {
            c = string.charAt(n);
            if (c == 'P') {
                this.tcflags |= this.OPPS;
                continue;
            }
            if (c == 'F') {
                this.tcflags |= this.FILL;
                continue;
            }
            if (c == 'X') {
                this.tcflags |= this.EXT;
                continue;
            }
            if (c == 'Y') {
                this.tcflags &= ~this.VFT;
                continue;
            }
            if (c == 'D') {
                this.tcflags |= this.TDC;
                continue;
            }
            throw new MidasException("Bad tcmode string flag field: " + string);
        }
        this.hack = 0.001;
        if (this.tcmode == 3) {
            this.tcbits = 67;
        }
        if (this.tcmode == 5) {
            this.tcbits = 67;
        }
        if (this.tcmode == 4) {
            this.tcbits = 37;
            this.hack = 1.0;
        }
        if (this.tcmode == 6) {
            this.tcbits = 48;
            this.hack = 1.0;
        }
        if ((this.tcflags & this.EXT) == 0) {
            this.tcbits = Math.min(this.tcbits, 60);
        }
        for (n = 0; n < 128; n += 32) {
            this.setBits(this.buffer, n, 32, -1);
        }
        this.setBits(this.buffer, 1, 7, this.BARKER);
    }

    public void setMode(int n) {
        this.tcmode = n;
    }

    public void setBit(int n) {
        this.tcbit = n;
    }

    public void setFlags(int n) {
        this.tcflags = n;
    }

    private void getTC() {
        if (this.debug) {
            System.out.print("TcBits=[");
            for (int i = 0; i < this.tcbits; ++i) {
                System.out.print(this.buffer[i]);
            }
            System.out.println("]");
        }
        if (this.tcmode == 6) {
            this.getIRB(this.buffer, -1, this.tcbits);
        } else {
            this.getSDN(this.buffer, -1, this.tcbits);
        }
    }

    private void setTC() {
        if (this.tcmode == 6) {
            this.setIRB(this.buffer, 0, this.tcbits);
        } else {
            this.setSDN(this.buffer, 0, this.tcbits);
        }
    }

    public int nextHack(double d) {
        int n = (int)(this.hack / d);
        this.time.addSec((double)n * d);
        this.setTC();
        return n;
    }

    public int getHack(double d) {
        int n = (int)(this.hack / d);
        return n;
    }

    private void getIRB(byte[] byArray, int n, int n2) {
        double d = 0.0;
        double d2 = 0.0;
        int n3 = this.getbcd(byArray, (n += 8) + 1, 4, 9);
        d += (double)n3;
        n3 = this.getbcd(byArray, n + 6, 3, 5);
        d += (double)(n3 * 10);
        n3 = this.getbcd(byArray, n + 10, 4, 9);
        d += (double)(n3 * 60);
        n3 = this.getbcd(byArray, n + 15, 4, 5);
        d += (double)(n3 * 600);
        n3 = this.getbcd(byArray, n + 20, 4, 9);
        d += (double)(n3 * 3600);
        n3 = this.getbcd(byArray, n + 25, 4, 2);
        d += (double)(n3 * 36000);
        n3 = this.getbcd(byArray, n + 30, 4, 9);
        d += (double)((n3 - 1) * 86400);
        n3 = this.getbcd(byArray, n + 35, 4, 9);
        d += (double)(n3 * 864000);
        n3 = this.getbcd(byArray, n + 40, 4, 3);
        d += (double)(n3 * 8640000);
        d += 1.0;
        if (this.is(this.OPPS)) {
            d2 = 0.011;
        }
        this.time.fromJ1950(d, d2);
    }

    private void setIRB(byte[] byArray, int n, int n2) {
        double d = this.time.getWSec();
        n += 8;
        int n3 = (int)(d / 86400.0);
        int n4 = (int)((d -= (double)(n3 * 86400)) / 3600.0);
        int n5 = (int)((d -= (double)(n4 * 3600)) / 60.0);
        int n6 = (int)(d -= (double)(n5 * 60));
        --n3;
        this.setbcd(byArray, n + 1, 4, n6 % 10);
        this.setbcd(byArray, n + 6, 3, n6 / 10);
        this.setbcd(byArray, n + 10, 4, n5 % 10);
        this.setbcd(byArray, n + 15, 4, n5 / 10);
        this.setbcd(byArray, n + 20, 4, n4 % 10);
        this.setbcd(byArray, n + 25, 4, n4 / 10);
        this.setbcd(byArray, n + 30, 4, n3 % 10);
        this.setbcd(byArray, n + 35, 4, n3 / 10 % 10);
        this.setbcd(byArray, n + 40, 4, n3 / 100);
    }

    private void getSDN(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        double d = 0.0;
        double d2 = 0.0;
        if (n2 > 38) {
            n4 = this.getbcd(byArray, n + 8, 7, 59);
            d += (double)n4;
            n4 = this.getbcd(byArray, n + 15, 7, 59);
            d += (double)(n4 * 60);
            n4 = this.getbcd(byArray, n + 22, 6, 23);
            d += (double)(n4 * 3600);
            n4 = this.getbcd(byArray, n + 28, 10, 366);
            d += (double)((n4 - 1) * 86400);
        }
        if (n2 > 48) {
            n4 = this.getbcd(byArray, n + 38, 12, 999);
            d2 += (double)n4 * 0.001;
        }
        if (n2 > 59 && this.is(this.VFT)) {
            n4 = 0;
            for (n3 = 50; n3 <= 60; ++n3) {
                n4 = (n4 << 1) + byArray[n + n3];
            }
            d2 += (double)n4 * 5.0E-9;
        }
        if (n2 > 66 && this.is(this.EXT)) {
            n4 = 0;
            for (n3 = 61; n3 <= 63; ++n3) {
                n4 = (n4 << 1) + (1 - byArray[n + n3]);
            }
            d2 += (double)n4 * 6.25E-10;
            n4 = 0;
            for (n3 = 65; n3 <= 67; ++n3) {
                n4 = (n4 << 1) + (1 - byArray[n + n3]);
            }
            d2 += (double)n4 * 1.024E-5;
        }
        this.time.fromJ1950(d, d2);
    }

    private void setSDN(byte[] byArray, int n, int n2) {
        double d = this.time.getWSec() - this.yis;
        double d2 = this.time.getFSec();
        int n3 = (int)(d / 86400.0);
        int n4 = (int)((d -= (double)(n3 * 86400)) / 3600.0);
        int n5 = (int)((d -= (double)(n4 * 3600)) / 60.0);
        int n6 = (int)(d -= (double)(n5 * 60));
        this.setbcd(byArray, n + 8, 7, n6);
        this.setbcd(byArray, n + 15, 7, n5);
        this.setbcd(byArray, n + 22, 6, n4);
        this.setbcd(byArray, n + 28, 10, ++n3);
        if (n2 < 49) {
            return;
        }
        int n7 = (int)(d2 * 1000.0);
        this.setbcd(byArray, n + 38, 12, n7);
        if (n2 < 60) {
            return;
        }
        int n8 = (int)((d2 - (double)n7 * 0.001) / 5.0E-9);
        int n9 = 50;
        int n10 = 1024;
        while (n9 <= 60) {
            byArray[n + n9] = (n8 & n10) != 0 ? (byte)1 : 0;
            ++n9;
            n10 >>= 1;
        }
        if (n2 < 67 || !this.is(this.EXT)) {
            return;
        }
        for (n9 = 61; n9 <= 63; ++n9) {
            byArray[n + n9] = 1;
        }
        n9 = 65;
        n10 = 8192;
        while (n9 <= 67) {
            byArray[n + n9] = (n8 & n10) != 0 ? (byte)0 : 1;
            ++n9;
            n10 >>= 1;
        }
    }

    private boolean is(int n) {
        return (n & this.tcflags) != 0;
    }

    private int getbcd(byte[] byArray, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 1;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n2) {
            n4 += byArray[n + n8] << n7;
            if (n7 == 3 || n8 == n2 - 1) {
                if (n4 > 9) {
                    throw new MidasException("Bad BCD digit=" + n4 + " at offset=" + (n + n8));
                }
                n6 += n4 * n5;
                n5 *= 10;
                n4 = 0;
                n7 = -1;
            }
            ++n8;
            ++n7;
        }
        if (n6 > n3) {
            throw new MidasException("Bad BCD value=" + n6 + " max=" + n3);
        }
        return n6;
    }

    private void setbcd(byte[] byArray, int n, int n2, int n3) {
        int n4 = 1;
        int n5 = 0;
        while (n5 < n2) {
            int n6 = n3 / n4 % 10;
            if (n5 < n2) {
                byte by = byArray[n + n5] = (n6 & 1) != 0 ? (byte)1 : 0;
            }
            if (++n5 < n2) {
                byte by = byArray[n + n5] = (n6 & 2) != 0 ? (byte)1 : 0;
            }
            if (++n5 < n2) {
                byte by = byArray[n + n5] = (n6 & 4) != 0 ? (byte)1 : 0;
            }
            if (++n5 < n2) {
                byArray[n + n5] = (n6 & 8) != 0 ? (byte)1 : 0;
            }
            ++n5;
            n4 *= 10;
        }
    }

    private void setBits(byte[] byArray, int n, int n2, int n3) {
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = (n3 >> i & 1) != 0 ? (byte)1 : 0;
        }
    }

    public void setFillWords(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n;
            byArray[n4] = (byte)(byArray[n4] | this.fill);
            ++n3;
            n += 2;
        }
    }

    public void setTimeCodeWords(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            byArray[n] = this.buffer[n3] != 0 ? (byte)(byArray[n] | this.fill) : (byte)(byArray[n] & this.mask);
            ++n3;
            n += 2;
        }
    }

    public int findTimeCodeWords(byte[] byArray, int n, int n2) {
        boolean bl;
        boolean bl2 = bl = (this.tcflags & this.TDC) != 0;
        if (this.tcmode == 3) {
            n += 2;
        }
        int n3 = 0;
        while (n3 < n2 - this.tcbits) {
            if (bl) {
                if ((byArray[n + 0] & this.fill) != 0 && (byArray[n + 4] & this.fill) != 0 && (byArray[n + 8] & this.fill) != 0 && (byArray[n + 12] & this.fill) == 0 && (byArray[n + 16] & this.fill) == 0 && (byArray[n + 20] & this.fill) != 0 && (byArray[n + 24] & this.fill) == 0 && n >= 4 && (byArray[n - 4] & this.fill) != 0 && n >= 8 && (byArray[n - 8] & this.fill) != 0 && n >= 12 && (byArray[n - 12] & this.fill) != 0) {
                    this.parseTimeCodeWords(byArray, n, n2 - n3);
                    return n3;
                }
            } else if ((byArray[n + 0] & this.fill) != 0 && (byArray[n + 2] & this.fill) != 0 && (byArray[n + 4] & this.fill) != 0 && (byArray[n + 6] & this.fill) == 0 && (byArray[n + 8] & this.fill) == 0 && (byArray[n + 10] & this.fill) != 0 && (byArray[n + 12] & this.fill) == 0 && n >= 2 && (byArray[n - 2] & this.fill) != 0 && n >= 4 && (byArray[n - 4] & this.fill) != 0 && n >= 6 && (byArray[n - 6] & this.fill) != 0) {
                this.parseTimeCodeWords(byArray, n, n2 - n3);
                return n3;
            }
            ++n3;
            n += 2;
        }
        return -1;
    }

    private void parseTimeCodeWords(byte[] byArray, int n, int n2) {
        int n3 = (this.tcflags & this.TDC) != 0 ? 4 : 2;
        int n4 = 0;
        while (n4 < this.tcbits) {
            this.buffer[n4] = (byArray[n] & this.fill) != 0 ? (byte)1 : 0;
            ++n4;
            n += n3;
        }
        this.getTC();
    }
}

