/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Shell;

public class NetIO {
    public static int RXBUFSIZE = 0x800000;
    public static int TXBUFSIZE = 262080;
    public static String flagsList = "Input,Output,InOut,OutIn,RMIF,HTTP,RTable,UDP,Thread,ThrSlv";
    public static int INPUT = 1;
    public static int OUTPUT = 2;
    public static int INOUT = 4;
    public static int OUTIN = 8;
    public static int RMIF = 16;
    public static int HTTP = 32;
    public static int RTAB = 64;
    public static int UDP = 128;
    public static int THREAD = 256;
    public static int THRSLV = 512;
    public static int MSG = 0;
    public static int SET = 1;
    public static int GET = 2;
    public static int RET = 3;
    public static int ACK = 4;
    public static int MSGR = 5;
    protected int sock;
    protected MulticastSocket ms;
    protected DatagramPacket dp;
    protected boolean useNative;
    protected InetSocketAddress lisa;
    protected InetSocketAddress risa;
    protected InetAddress lia;
    protected InetAddress ria;
    protected static boolean canUseNative = NetIO.load();

    public NetIO(boolean bl) {
        this.useNative = bl && canUseNative;
    }

    public static boolean load() {
        try {
            return Shell.loadLibrary((String)"ice", (String)"lib", (String)"NetIO");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public int open(String string, int n, int n2) {
        if (this.useNative) {
            this.sock = this.nioOpen(string, n, n2);
            return this.sock;
        }
        int n3 = string.indexOf(":", 4);
        int n4 = string.indexOf("/", 4);
        int n5 = string.indexOf(":", n4);
        int n6 = string.length();
        if (n3 < 0 || n3 > n4) {
            n3 = n4;
        }
        if (n5 < 0) {
            n5 = n6;
        }
        String string2 = string.substring(4, n3);
        int n7 = n4 > n3 ? Convert.s2l((String)string.substring(n3 + 1, n4)) : 29495;
        String string3 = string.substring(n4 + 1, n5);
        int n8 = n6 > n5 ? Convert.s2l((String)string.substring(n5 + 1, n6)) : 29495;
        this.lisa = new InetSocketAddress(string2, n7);
        this.lia = this.lisa.getAddress();
        this.risa = new InetSocketAddress(string3, n8);
        this.ria = this.risa.getAddress();
        String string4 = this.lisa.toString().substring(1);
        String string5 = this.risa.toString().substring(1);
        System.out.println("Open local=" + string4 + " remote=" + string5 + " native=" + this.useNative);
        try {
            this.ms = new MulticastSocket(n7);
            this.ms.setInterface(this.lisa.getAddress());
            this.ms.setReuseAddress(true);
            this.ms.setLoopbackMode(false);
            if (n2 > 0) {
                this.ms.setSendBufferSize(TXBUFSIZE);
            } else {
                this.ms.setSoTimeout(1);
                this.ms.setReceiveBufferSize(RXBUFSIZE);
                if (this.ria.isMulticastAddress()) {
                    this.ms.joinGroup(this.ria);
                }
            }
            return 1;
        }
        catch (Exception exception) {
            System.out.println("openErr: " + exception);
            return -1;
        }
    }

    public int send(int n, byte[] byArray, int n2, int n3, int n4) {
        if (this.useNative) {
            return this.nioSendB(this.sock, n, byArray, n2, n3, n4);
        }
        if (this.dp != null) {
            this.dp.setData(byArray, n2, n3);
        } else {
            this.dp = new DatagramPacket(byArray, n2, n3);
        }
        try {
            this.ms.send(this.dp);
            return this.dp.getLength();
        }
        catch (Exception exception) {
            System.out.println("sendErr: " + exception);
            return -1;
        }
    }

    public int recv(int n, byte[] byArray, int n2, int n3, int n4) {
        if (this.useNative) {
            return this.nioRecvB(this.sock, n, byArray, n2, n3, n4);
        }
        if (this.dp != null) {
            this.dp.setData(byArray, n2, n3);
        } else {
            this.dp = new DatagramPacket(byArray, n2, n3);
        }
        try {
            this.ms.receive(this.dp);
            return this.dp.getLength();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return 0;
        }
        catch (Exception exception) {
            System.out.println("recvErr: " + exception);
            return -1;
        }
    }

    public int send(int n, long l, int n2, int n3) {
        if (this.useNative) {
            return this.nioSend(this.sock, n, l, n2, n3);
        }
        return 0;
    }

    public int recv(int n, long l, int n2, int n3) {
        if (this.useNative) {
            return this.nioRecv(this.sock, n, l, n2, n3);
        }
        return 0;
    }

    public int msg(int n, int n2, byte[] byArray, int n3, int n4) {
        if (this.useNative) {
            return this.nioMsg(this.sock, n, n2, byArray, n3, n4);
        }
        return 0;
    }

    public int file(String string, String string2, int n) {
        if (this.useNative) {
            return this.nioFile(this.sock, string, string2, n);
        }
        return 0;
    }

    public int close() {
        if (this.useNative) {
            if (this.sock > 0) {
                this.nioClose(this.sock);
            }
            return this.sock;
        }
        if (this.ms != null) {
            this.ms.close();
        }
        return 1;
    }

    public native int nioOpen(String var1, int var2, int var3);

    public native int nioClose(int var1);

    public native long nioAlloc(int var1);

    public native int nioFree(long var1);

    public native int nioSendBank(int var1, int var2, int var3, long var4, int var6, int var7, long var8, int var10, int var11);

    public native int nioSend(int var1, int var2, long var3, int var5, int var6);

    public native int nioRecv(int var1, int var2, long var3, int var5, int var6);

    public native int nioSendB(int var1, int var2, byte[] var3, int var4, int var5, int var6);

    public native int nioRecvB(int var1, int var2, byte[] var3, int var4, int var5, int var6);

    public native int nioMsg(int var1, int var2, int var3, byte[] var4, int var5, int var6);

    public native int nioFile(int var1, String var2, String var3, int var4);

    public static native int swap2(long var0, long var2, int var4);

    public static native int cvt12to16(long var0, long var2, int var4);

    public static native int cvt16to12(long var0, long var2, int var4);
}

