/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.ice.lib.IceJVM;

public class IcePM
extends IceJVM {
    public static final int CF_SLOTS = 67239944;
    public static final int CF_SNIFF = 0x4020000;
    public static final int CF_XFER = 67239952;
    public static final int CF_RESET = 67239944;
    public static int runMode;
    public static int dcfgA;
    public static int dcfgB;
    public static int delayA;
    public static int delayB;
    public static int dbg1;
    public static int dbg2;
    public static int dbg3;

    public static void run() {
        int n = 30277923;
        IcePM.awMem(-50266116, n);
        IcePM.reset();
        IcePM.resetCmdFifo(1);
        while (true) {
            int n2;
            IcePM.processMessages();
            if (runMode == 2) {
                IcePM.processAlgorithm();
            }
            if ((n2 = IcePM.arBusSync(67239944) & 0xFFF) > 0) {
                int n3 = IcePM.arBus(0x4020000);
                if ((n3 & 0xFFF00000) != 484442112) {
                    IcePM.cleanupCmdFifo();
                } else if (n2 >= (n3 & 0xF)) {
                    IcePM.processCmdFifo();
                }
            }
            IcePM.awMem(-50266116, n);
            ++n;
        }
    }

    public static void wdbg() {
        IcePM.awMem(768, dbg1);
        IcePM.awMem(772, dbg2);
        IcePM.awMem(776, dbg3);
    }

    public static void resetCmdFifo(int n) {
        IcePM.awBus(67239944, n < 0 ? 1 : n);
        IcePM.awBus(67239944, n < 0 ? 0 : n);
    }

    public static void cleanupCmdFifo() {
        int n;
        dbg2 = IcePM.arBus(67239944);
        dbg3 = n = IcePM.arBus(67239952);
        IcePM.wdbg();
    }

    public static void processCmdFifo() {
        int n = IcePM.arBus(67239952);
        int n2 = IcePM.rBus();
        if (n == 484507652) {
            int n3;
            int n4 = IcePM.rBus();
            if (n3 < 4 || n3 > 256) {
                IcePM.cleanupCmdFifo();
                return;
            }
            IcePM.aBus(n2);
            IcePM.awBus(n2, n4);
            for (n3 = IcePM.rBus(); n3 > 4; n3 -= 4) {
                while ((IcePM.arBusSync(67239944) & 0xFFF) == 0) {
                }
                IcePM.awBus(n2, IcePM.arBus(67239952));
            }
        } else if (n == 484573186) {
            IcePM.aBus(n2);
            int n5 = IcePM.arBus(n2);
            IcePM.awBus(67239952, 484638722);
            IcePM.awBus(67239952, n5);
        }
    }

    public static void processWRB(int n) {
        maddr = -50331644;
        saddr = mdata;
        for (int i = n >> 8 & 0xFFFF; i > 0; i -= 4) {
            sdata = mdata;
        }
        maddr = -50331648;
        mdata = -1442840406;
    }

    public static void processMessages() {
        maddr = -50331648;
        int n = mdata;
        if (n >> 24 != 85) {
            return;
        }
        if ((n & 0xFF) == 119) {
            IcePM.processWRB(n);
            return;
        }
        int n2 = mdata;
        int n3 = mdata;
        int n4 = mdata;
        int n5 = n3 & 0x3F;
        int n6 = n3 >> 16;
        int n7 = n6 >> 2;
        int n8 = -50331632;
        switch (n5) {
            case 1: {
                IcePM.busr(n4, n8, n7);
                break;
            }
            case 2: {
                IcePM.busw(n4, n8, n7);
                n6 = 0;
                break;
            }
            case 3: {
                IcePM.memr(n4, n8, n7);
                break;
            }
            case 4: {
                IcePM.memw(n4, n8, n7);
                n6 = 0;
                break;
            }
            case 6: {
                IcePM.initAlgorithm();
                if (n4 != -1) break;
                IcePM.resetCmdFifo(-1);
                break;
            }
            case 7: {
                IcePM.modifyAlgorithm(n8, n7);
                break;
            }
            case 8: 
            case 9: {
                int n9 = n4 & 0xFFFF;
                int n10 = n4 >> 16;
                int n11 = mdata;
                int n12 = mdata;
                int n13 = mdata;
                if (n12 != 0) {
                    IcePM.setupDelay(n12, n13);
                }
                if (n5 == 8) {
                    IcePM.openAlgorithm(n9, n10, n11);
                    break;
                }
                IcePM.closeAlgorithm(n9, n10, n11);
                break;
            }
            case 14: {
                IcePM.busrwm(n4, n8, n7);
                break;
            }
            case 15: {
                IcePM.memi(n8, n7);
                n6 = 0;
            }
        }
        maddr = -50331648;
        mdata = 0xAA0000AA | n6 << 8;
    }

    public static void initAlgorithm() {
        IcePM.resetDMA();
        runMode = 0;
        dcfgA = 0;
        dcfgB = 0;
    }

    public static void openAlgorithm(int n, int n2, int n3) {
        IcePM.awBus(0x1008008, n3);
    }

    public static void processDelays() {
        if (dcfgA != 0) {
            IcePM.processDelay(dcfgA, delayA);
        }
        if (dcfgB != 0) {
            IcePM.processDelay(dcfgB, delayB);
        }
    }

    public static void setupDelay(int n, int n2) {
        int n3 = n >> 8 & 0xF;
        int n4 = n >> 12 & 0xF;
        int n5 = n & 0xFF;
        if ((n3 & 1) == 0) {
            dcfgA = n;
            delayA = n2;
            n5 |= 0x8000000;
        } else {
            dcfgB = n;
            delayB = n2;
        }
        IcePM.setupDMAo(n3, n5, -1);
        IcePM.setupDMAi(n4, n5, -1);
    }

    public static void processDelay(int n, int n2) {
        int n3;
        int n4 = n >> 8 & 0xF;
        int n5 = n >> 12 & 0xF;
        int n6 = 1 << n5 + 24;
        int n7 = IcePM.arBus(0x1008000);
        if ((n7 & n6) != 0) {
            return;
        }
        int n8 = IcePM.arMemSync(-41926848 + (n4 << 3));
        int n9 = n8 - (n3 = IcePM.arMemSync(-41926912 + (n5 << 3)));
        if (n9 < 0) {
            n9 += 0x8000000;
        }
        if ((n9 -= n2) > 4096) {
            n3 = n3 & 0x8000000 | n3 + 4096 & 0x7FFFFFF;
            IcePM.awMem(-41926912 + (n5 << 3) + 4, n3);
            IcePM.awBus(0x1008008, n6);
        }
    }

    public static void processAlgorithm() {
    }

    public static void closeAlgorithm(int n, int n2, int n3) {
        IcePM.awBus(16809996, n3);
        if (IcePM.arBus(0x1008000) == 0) {
            IcePM.resetDMA();
        }
    }

    public static void modifyAlgorithm(int n, int n2) {
    }

    protected static void reset() {
        IcePM.resetDMA();
        runMode = 0;
        IcePM.awMem(-50331648, 0);
    }

    protected static void resetDMA() {
        int n;
        IcePM.awBus(0x1008000, -1);
        IcePM.udelay(20);
        IcePM.awBus(0x1008000, -1);
        for (n = 0; n < 8; ++n) {
            IcePM.setupDMAi(n, 0, 0);
        }
        for (n = 0; n < 8; ++n) {
            IcePM.setupDMAo(n, 0, 0);
        }
        for (n = 0; n < 32; ++n) {
            IcePM.setupDMAt(n, 0);
        }
        IcePM.awBus(16809988, 32);
        IcePM.setupDMAo(2, 2, -1);
        IcePM.setupDMAo(3, 2, -1);
    }

    static void setupDMAno(int n, int n2, int n3) {
        maddr = -41926720 + (n << 3);
        mdata = n2;
        mdata = n3;
    }

    static void setupDMAo(int n, int n2, int n3) {
        maddr = -41926848 + (n << 3);
        mdata = n2;
        mdata = n3;
    }

    static void setupDMAi(int n, int n2, int n3) {
        maddr = -41926912 + (n << 3);
        mdata = n2;
        mdata = n3;
    }

    static void setupDMAt(int n, int n2) {
        maddr = -41943040 + (n << 2);
        mdata = n2;
    }

    protected static int dmaSync(int n) {
        maddr = n;
        int n2 = mdata;
        return n2 -= mdata;
    }

    public static int wait4route(int n) {
        for (int i = 0; i < 4080; ++i) {
            if ((IcePM.arBus(0x1008000) & n) == 0) {
                return i;
            }
            if (i <= 256) continue;
            IcePM.udelay(10);
        }
        IcePM.awBus(16809996, n);
        return -1;
    }
}

