/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.ice.lib.IceHW;
import nxm.ice.lib.IcePM;

public class IceK8M
extends IcePM {
    public static int ftt2;

    public static void initAlgorithm() {
        IceK8M.resetDMA();
        IceHW.FTTStruct fTTStruct = (IceHW.FTTStruct)IceK8M.getObjectAt(1152);
        fTTStruct.stages = 0;
        ftt2 = 0;
        runMode = 0;
    }

    public static void openNet(int n, int n2) {
        int n3 = n2 == 7 ? 4 : 6;
        n3 = n3 - 1 + n;
        IceK8M.setupDMAno(n3, n3 << 20 | 8, -1);
        IceK8M.awBus(0x1008008, 65536);
        IceK8M.setupDMAi(n3, n3 << 20 | 8, -1);
        IceK8M.awBus(0x1008008, 0x1000000 << n3);
    }

    public static void openAlgorithm(int n, int n2, int n3) {
        int n4 = 240;
        int n5 = IceK8M.arBus(16809988);
        IceK8M.awBus(16809988, n5 | n4);
        IceK8M.awBus(0x1008008, n3);
        if (n2 == 9) {
            IceK8M.initTBank(n);
        }
        runMode = 2;
    }

    public static void processAlgorithm() {
        IceHW.FTTStruct fTTStruct = (IceHW.FTTStruct)IceK8M.getObjectAt(1152);
        int n = fTTStruct.stages;
        if (n < 0) {
            n = -n;
        }
        int n2 = fTTStruct.cstage;
        if (n > 1) {
            IceK8M.doTBank(n2, true);
        }
        if (n > 0) {
            IceK8M.doTBank(n - 1, false);
        }
        if (ftt2 > 0) {
            IceK8M.doTBank(4, false);
        }
        if (dcfgA != 0) {
            IceK8M.processDelay(dcfgA, delayA);
        }
        if (dcfgB != 0) {
            IceK8M.processDelay(dcfgB, delayB);
        }
    }

    public static void closeAlgorithm(int n, int n2, int n3) {
        IceK8M.awBus(16809996, n3);
        if (n2 == 9) {
            IceK8M.exitTBank(n);
            IceK8M.udelay(1000);
        }
        runMode = 0;
        if (IceK8M.arBus(0x1008000) == 0) {
            IceK8M.resetDMA();
        }
    }

    public static void modifyAlgorithm(int n, int n2) {
    }

    protected static void initTBank(int n) {
        int n2;
        int n3;
        int n4;
        int n5 = 1152;
        IceHW.FTTStruct fTTStruct = (IceHW.FTTStruct)IceK8M.getObjectAt(n5);
        IceHW.TBStruct tBStruct = null;
        if (n == 2 && fTTStruct.stages == 1) {
            n5 = 1536;
            fTTStruct = (IceHW.FTTStruct)IceK8M.getObjectAt(n5);
            ftt2 = 1;
        }
        int n6 = fTTStruct.active;
        if (n == 3) {
            n = 7;
        }
        int n7 = (n4 = n6 | n) == 2 ? 1 : 0;
        int n8 = fTTStruct.stages;
        fTTStruct.chantop = n7;
        fTTStruct.active = n4;
        for (n3 = 0; n3 < 3; ++n3) {
            n2 = n5 + (n3 > 1 ? 256 : (n3 > 0 ? 176 : 96));
            tBStruct = (IceHW.TBStruct)IceK8M.getObjectAt(n2);
            tBStruct.chan = n7;
            tBStruct.pindx = 0;
            tBStruct.tphase = 0;
            tBStruct.tdphase = 0;
        }
        if (n6 != 0) {
            return;
        }
        fTTStruct.cstage = 0;
        fTTStruct.lstage = -1;
        fTTStruct.busy = -1;
        fTTStruct.dca0 = null;
        fTTStruct.dca1 = null;
        tBStruct = (IceHW.TBStruct)IceK8M.getObjectAt(n5 + 96);
        n3 = tBStruct.nchan;
        n2 = tBStruct.pcfg;
        int n9 = tBStruct.pstrt;
        int n10 = tBStruct.psize;
        int n11 = n8 > 1 ? 2 : 1;
        int n12 = 0;
        int n13 = 0;
        int n14 = n9 | n2;
        while (n12 < n3) {
            IceK8M.setupDMAt(n13, n14 + (fTTStruct.stages < 0 ? (n13 & 0xE) << 7 : 0));
            ++n12;
            n13 += n11;
            n14 += n10;
        }
        fTTStruct.tbctl = IceK8M.arBus(-2142699520);
        if (n8 > 1) {
            IceK8M.ssBank(0);
        }
    }

    protected static void doTBank(int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        boolean bl2;
        int n9;
        int n10 = n == 4 ? 1536 : 1152;
        IceHW.FTTStruct fTTStruct = (IceHW.FTTStruct)IceK8M.getObjectAt(n10);
        IceHW.TBStruct tBStruct = null;
        IceHW.TBStruct tBStruct2 = null;
        if (n == 4) {
            n = 0;
        }
        if ((n9 = fTTStruct.active) == 0) {
            return;
        }
        int n11 = n10 + (bl ? 348 : 344);
        int n12 = IceK8M.arMem(n11);
        if (n12 != 0 && IceK8M.dmaSync(n12) != 0) {
            return;
        }
        int n13 = n10 + (n == 0 ? 96 : (n == 1 ? 176 : 256));
        tBStruct = (IceHW.TBStruct)IceK8M.getObjectAt(n13);
        int n14 = n13 + 80;
        tBStruct2 = (IceHW.TBStruct)IceK8M.getObjectAt(n14);
        int n15 = tBStruct.chan;
        int n16 = fTTStruct.chantop;
        boolean bl3 = bl2 = (n15 & 1) != 0 && n9 != 7;
        int n17 = bl ? 7 : (n8 = bl2 ? fTTStruct.omodb : fTTStruct.omoda);
        if (n == fTTStruct.busy) {
            IceK8M.awBus(16809996, 0x1000000 << n8);
            fTTStruct.busy = -1;
            if (n15 == n16) {
                tBStruct2.pindx = tBStruct2.pindx + tBStruct.prod & tBStruct2.pmask;
            }
            IceK8M.ssBank(0);
        }
        if (bl && fTTStruct.busy >= 0) {
            return;
        }
        if (n == 0) {
            n7 = n15;
            if (bl) {
                n7 <<= 1;
            }
            n6 = IceK8M.arMem(-41943040 + (n7 << 2));
        } else {
            n6 = n15 == n16 ? IceK8M.getBase(tBStruct, n15) : fTTStruct.addr;
        }
        n7 = tBStruct.pmask;
        int n18 = tBStruct.index;
        int n19 = tBStruct.xfer;
        int n20 = tBStruct.psize;
        int n21 = (n6 & n7) - n18;
        if (n21 < 0) {
            n21 += n20;
        }
        if (n21 < n19) {
            if (bl && n15 == n16 && fTTStruct.stages > 2) {
                fTTStruct.cstage = 1 - fTTStruct.cstage;
            }
            return;
        }
        if (bl) {
            int n22;
            IceK8M.ssBank(0);
            if (n15 == n16) {
                fTTStruct.base = IceK8M.getBase(tBStruct2, n15);
            }
            n5 = fTTStruct.base;
            n4 = tBStruct2.psize;
            if (n9 != 7) {
                n4 <<= 1;
            }
            n3 = fTTStruct.lstage;
            n2 = tBStruct2.phinc;
            int n23 = tBStruct2.dphinc;
            int n24 = tBStruct2.tphase;
            int n25 = tBStruct2.tdphase;
            int n26 = n24;
            int n27 = Integer.MIN_VALUE;
            int n28 = 65536;
            int n29 = tBStruct2.mchan << 1;
            for (n22 = 1; n22 < n29; n22 += 2) {
                if (n != n3) {
                    IceK8M.awBus(n27 + 24, -n2);
                }
                if (n15 == n16) {
                    IceK8M.awBus(n27 + 28, -n26);
                }
                n26 += n25;
                IceK8M.setupDMAt(n22, n5);
                n2 += n23;
                n5 += n4;
                n27 += n28;
            }
            if (n15 == n16) {
                tBStruct2.tphase = n24 + tBStruct2.tphinc;
                tBStruct2.tdphase = n25 + tBStruct2.tdphinc;
            }
            if (n9 == 3) {
                n5 = bl2 ? (n5 -= tBStruct2.psize) : fTTStruct.base + tBStruct2.psize;
            }
            n22 = n == 0 && fTTStruct.stages > 2 ? -1 : 1;
            IceK8M.ssBank(n22);
            fTTStruct.lstage = n;
            fTTStruct.busy = n;
            fTTStruct.base = n5;
        }
        n5 = fTTStruct.stages < 0 ? n15 : 0;
        n4 = n18 + ((n5 & 0xE) << 7);
        n3 = n4 + n19 & n7;
        n2 = n6 & ~n7;
        n12 = -41926912 + (n8 << 3);
        IceK8M.awMem(n12 + 0, n2 + n4);
        IceK8M.awMem(n12 + 4, n2 + n3);
        IceK8M.awBus(0x1008008, 0x1000000 << n8);
        if ((n9 & 3) != 3) {
            ++n15;
        }
        if (++n15 >= tBStruct.nchan) {
            n15 = n16;
            tBStruct.index = n18 = n18 + tBStruct.cons & n7;
        }
        if (n > 0) {
            n6 += n20;
            if ((n9 & 3) != 3) {
                n6 += n20;
            }
            fTTStruct.addr = n6;
        }
        tBStruct.chan = n15;
        IceK8M.awMem(n11, n12);
    }

    protected static void exitTBank(int n) {
        int n2;
        IceHW.FTTStruct fTTStruct = (IceHW.FTTStruct)IceK8M.getObjectAt(1152);
        if (n > 2) {
            n = 7;
        }
        if (n == 2) {
            ftt2 = 0;
        }
        fTTStruct.active = n2 = fTTStruct.active & ~n;
        if (n2 != 0) {
            return;
        }
        if (fTTStruct.stages > 1) {
            IceK8M.ssBank(0);
        }
    }

    static int getBase(IceHW.TBStruct tBStruct, int n) {
        return tBStruct.pcfg | tBStruct.pstrt + tBStruct.psize * n + tBStruct.pindx;
    }

    static void ssBank(int n) {
        int n2 = IceK8M.arMem(1504);
        if (n < 0) {
            n2 &= Short.MAX_VALUE;
        }
        if (n == 0) {
            n2 &= 0xFFFFFFFE;
        }
        IceK8M.awBus(-2142699520, n2);
    }
}

