/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import java.io.File;
import nxm.ice.lib.DevIce;
import nxm.ice.lib.FileIO;
import nxm.ice.lib.MDevIce;
import nxm.sys.lib.Convert;
import nxm.sys.lib.IOResource;
import nxm.sys.lib.Native;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;

public class IceBlockResource
extends IOResource {
    private int fb;
    private File file;
    private static int PGSZ = 8192;
    private static int CBSZ = 131072;
    private long paddr = -1L;
    private long psize;
    private long rdaddr;
    private long rdsize;
    private String rdpath;
    public MDevIce pic;
    public DevIce.DmaMap map;
    public int type;
    public int devno;
    public int clen = 0;
    public byte[] cbuf = null;
    public static String typeList = "Raw,Ram,IceFS,PIC,NIC,PAC,IceBlk";
    public static int RAW = 0;
    public static int RAM = 1;
    public static int IFS = 2;
    public static int PIC = 3;
    public static int NIC = 4;
    public static int PAC = 5;
    public static int BLK = 6;
    private long extent = 0xFFFFFFL;
    File lockFile;

    public boolean exists() {
        return this.file.exists();
    }

    public boolean isFile() {
        return true;
    }

    public void setURL(String string) {
        super.setURL(string);
        if (string.startsWith("ramd:")) {
            this.type = RAM;
            string = string.substring(5);
        } else if (string.startsWith("ice:")) {
            this.type = RAM;
            int n = (string = string.substring(4)).indexOf("/icefs");
            if (n > 0) {
                this.type = IFS;
                this.devno = Convert.s2l((String)string.substring(n + 6, n + 7)) - 1;
            }
            if ((n = string.indexOf("/pic")) > 0) {
                this.type = PIC;
                this.devno = Convert.s2l((String)string.substring(n + 4, n + 5)) - 1;
            }
            if ((n = string.indexOf("/nic")) > 0) {
                this.type = NIC;
                this.devno = Convert.s2l((String)string.substring(n + 4, n + 5)) - 1;
            }
        } else if (string.startsWith("file:")) {
            this.type = RAW;
            string = string.substring(5);
        } else {
            this.type = RAW;
        }
        if (this.type == RAW && string.indexOf("/icefs") >= 0) {
            this.type = IFS;
        }
        this.file = new File(string);
    }

    public boolean open() {
        if (this.type == RAM) {
            this.openRAM();
        } else if (this.type == PIC) {
            this.openPIC();
        } else if (this.type == IFS) {
            this.openFIO();
        } else if (this.type == RAW) {
            this.openFIO();
        } else {
            this.M.error("IceBlockResource type=" + this.type + " not handled yet");
        }
        this.offset = 0L;
        return this.isOpen;
    }

    public boolean openRAM() {
        this.isOpen = false;
        String string = null;
        String string2 = null;
        String string3 = this.urlstr.substring(0, this.urlstr.lastIndexOf(47) + 1);
        this.rdpath = string3.substring(4);
        Table table = (Table)this.M.results.get("AUX");
        Table.Iterator iterator = table.iterator();
        while (string2 == null && iterator.getNext()) {
            String string4 = iterator.value.toString();
            if (!string4.startsWith(string3)) continue;
            string2 = string4;
        }
        if (string2 == null) {
            this.M.error("IceBlock AUX entry not found for: " + this.urlstr);
        }
        iterator = new Parser(string2);
        this.rdpath = iterator.get(1).substring(5);
        string = iterator.get(2);
        this.rdaddr = Convert.s2xl((String)iterator.get(3));
        this.rdsize = Convert.s2xl((String)iterator.get(4));
        if (this.urlstr.endsWith("/")) {
            return false;
        }
        this.pic = new MDevIce(this.M, "ICERAM,DEVNO=0");
        long l = this.M.results.getL("ENV.ICE.MAXALLOC", -1);
        if (l > 0L) {
            this.pic.setMaxAlloc(l << 20);
        }
        if (this.rdaddr == 0L && this.rdsize != 0L) {
            this.pic.open();
            this.rdaddr = this.pic.phys2long(this.pic.getKeyL(0, 129));
            this.pic.close();
        }
        byte[] byArray = new byte[16];
        if (this.dir <= 0) {
            int n = Native.fopen((String)this.file.toString(), (int)this.dir);
            Native.freadb((int)n, (Object)byArray, (int)0, (int)16);
            if (n != 0) {
                Native.fclose((int)n);
            }
            this.paddr = Convert.unpackX((byte[])byArray, (int)0);
            this.psize = Convert.unpackX((byte[])byArray, (int)8);
            this.length = Math.min(this.length, this.psize);
        } else {
            this.lockFileAlloc();
            int n = Native.fopen((String)this.file.toString(), (int)this.dir);
            Convert.packX((byte[])byArray, (int)0, (long)-1L);
            Convert.packX((byte[])byArray, (int)8, (long)1L);
            Native.fwriteb((int)n, (Object)byArray, (int)0, (int)16);
            Native.fseek((int)n, (long)0L);
            this.psize = (this.length + (long)PGSZ - 1L) / (long)PGSZ * (long)PGSZ;
            this.getAllocation();
            Convert.packX((byte[])byArray, (int)0, (long)this.paddr);
            Convert.packX((byte[])byArray, (int)8, (long)this.psize);
            Native.fwriteb((int)n, (Object)byArray, (int)0, (int)16);
            if (n != 0) {
                Native.fclose((int)n);
            }
            this.lockFileFree();
        }
        this.map = this.pic.getMap();
        this.map.mode = 2;
        this.map.bytes = this.length;
        this.map.paddr = this.getPhysicalAddress();
        this.map.dev = this.pic;
        this.map.devn = null;
        this.map.setPaged(Shell.ostag.startsWith("lin"));
        this.isOpen = true;
        return this.isOpen;
    }

    public boolean openPIC() {
        this.isOpen = false;
        this.fb = FileIO.fopen("/dev/" + this.file.toString(), this.dir);
        FileIO.fseek(this.fb, this.getPhysicalAddress());
        this.isOpen = this.fb > 0;
        return this.isOpen;
    }

    public boolean openFIO() {
        this.isOpen = false;
        int n = 0;
        boolean bl = this.urlstr.endsWith(".det") && this.dir > 0 && this.type != IFS;
        boolean bl2 = this.urlstr.endsWith(".pkt") && this.dir > 0;
        boolean bl3 = false;
        if (this.qualTable != null) {
            bl = this.qualTable.getState("USEDIRECT", bl);
        }
        if (this.qualTable != null) {
            bl3 = this.qualTable.getState("USETHREADED", bl3);
        }
        if (bl) {
            n |= 4;
        }
        if (bl3) {
            n |= 8;
        }
        this.fb = FileIO.fopen(this.file.toString(), this.dir, n);
        this.isOpen = this.fb > 0;
        this.length = this.file.length();
        if (bl2) {
            this.cbuf = new byte[CBSZ + 4096];
            this.clen = 0;
        }
        return this.isOpen;
    }

    public boolean close() {
        if (this.clen > 0) {
            this.flushCache();
        }
        if (this.isOpen && this.type == PIC) {
            this.pic.close();
        }
        if (!this.isOpen) {
            return false;
        }
        if (this.fb > 0) {
            FileIO.fclose(this.fb);
        }
        if (this.map != null) {
            this.map.close(10);
        }
        this.isOpen = false;
        return true;
    }

    public boolean delete() {
        return this.file.delete();
    }

    public long getLength() {
        return this.length;
    }

    public boolean seek(long l) {
        if (this.clen > 0) {
            this.flushCache();
        }
        if (l == this.offset) {
            return true;
        }
        if (this.fb > 0 && FileIO.fseek(this.fb, l) != l) {
            return false;
        }
        this.offset = l;
        return true;
    }

    public long avail() {
        return this.length - this.offset;
    }

    public int read(byte[] byArray, int n, int n2) {
        n2 = (int)Math.min((long)n2, this.length - this.offset);
        if (this.map != null) {
            long l = this.map.getVirtualAddress(this.offset, n2);
            Native.p2ja((long)l, (int)0, (Object)byArray, (int)n, (int)n2);
        } else {
            n2 = FileIO.freadb(this.fb, byArray, n, n2);
        }
        if (n2 > 0) {
            this.offset += (long)n2;
        }
        return n2;
    }

    private void flushCache() {
        FileIO.fwriteb(this.fb, this.cbuf, 0, this.clen);
        this.clen = 0;
    }

    public int write(byte[] byArray, int n, int n2) {
        if (this.map != null) {
            n2 = (int)Math.min((long)n2, this.length - this.offset);
            long l = this.map.getVirtualAddress(this.offset, n2);
            Native.ja2p((Object)byArray, (int)n, (long)l, (int)0, (int)n2);
        } else if (this.cbuf != null) {
            if (this.clen >= CBSZ) {
                this.flushCache();
            }
            System.arraycopy(byArray, n, this.cbuf, this.clen, n2);
            this.clen += n2;
        } else {
            n2 = FileIO.fwriteb(this.fb, byArray, n, n2);
        }
        if (n2 > 0) {
            this.offset += (long)n2;
        }
        return n2;
    }

    public int read(long l, int n, int n2) {
        n2 = (int)Math.min((long)n2, this.length - this.offset);
        if (this.map != null) {
            long l2 = this.map.getVirtualAddress(this.offset, n2);
            Native.p2p((long)l2, (int)0, (long)l, (int)n, (int)n2);
        } else {
            n2 = FileIO.fread(this.fb, l, n, n2);
        }
        if (n2 > 0) {
            this.offset += (long)n2;
        }
        return n2;
    }

    public int write(long l, int n, int n2) {
        if (this.map != null) {
            n2 = (int)Math.min((long)n2, this.length - this.offset);
            long l2 = this.map.getVirtualAddress(this.offset, n2);
            Native.p2p((long)l, (int)n, (long)l2, (int)0, (int)n2);
        } else {
            n2 = FileIO.fwrite(this.fb, l, n, n2);
        }
        if (n2 > 0) {
            this.offset += (long)n2;
        }
        return n2;
    }

    public String toString() {
        return "IceBlockResource: " + this.getURL();
    }

    private synchronized void getAllocation() {
        long l;
        int n;
        String[] stringArray = this.M.io.listFiles((Object)this.rdpath, "*", "det");
        int n2 = stringArray.length;
        long[] lArray = new long[n2 + 1];
        long[] lArray2 = new long[n2 + 1];
        byte[] byArray = new byte[16];
        for (int i = 0; i < n2; ++i) {
            int n3;
            String string = this.rdpath + stringArray[i];
            n = Native.fopen((String)string, (int)-1);
            Native.freadb((int)n, (Object)byArray, (int)0, (int)16);
            Native.fclose((int)n);
            l = Convert.unpackX((byte[])byArray, (int)0);
            long l2 = Convert.unpackX((byte[])byArray, (int)8);
            for (n3 = 0; n3 < i && l > lArray[n3]; ++n3) {
            }
            for (int j = i - 1; j >= n3; --j) {
                lArray[j + 1] = lArray[j];
                lArray2[j + 1] = lArray2[j];
            }
            lArray[n3] = l;
            lArray2[n3] = l2;
        }
        this.paddr = -1L;
        long l3 = lArray[n2] = this.rdsize;
        for (n = n2 - 1; n >= 0; --n) {
            l = lArray[n + 1] - (lArray[n] + lArray2[n]);
            if (l < this.psize || l > l3) continue;
            this.paddr = lArray[n] + lArray2[n];
            l3 = l;
        }
        if (this.paddr < 0L) {
            this.M.error("Could not allocate IceBlock buffer of " + this.psize + " bytes");
        }
    }

    public int checkAllocation(int n) {
        long l = this.offset + (long)n;
        if (this.length >= l) {
            return n;
        }
        this.length = l;
        if (this.psize >= this.length) {
            return n;
        }
        this.psize = l + (long)n + this.extent & (this.extent ^ 0xFFFFFFFFFFFFFFFFL);
        byte[] byArray = new byte[16];
        Convert.packX((byte[])byArray, (int)0, (long)this.paddr);
        Convert.packX((byte[])byArray, (int)8, (long)this.psize);
        int n2 = Native.fopen((String)this.file.toString(), (int)this.dir);
        Native.fwriteb((int)n2, (Object)byArray, (int)0, (int)16);
        Native.fclose((int)n2);
        return n;
    }

    public long getPhysicalAddress() {
        return this.rdaddr + this.paddr;
    }

    public Table getStatFS() {
        int n;
        int n2;
        if (!this.isOpen) {
            this.open();
        }
        String[] stringArray = this.M.io.listFiles((Object)this.rdpath, "*", "det");
        int n3 = stringArray.length;
        long l = 0L;
        byte[] byArray = new byte[16];
        for (n2 = 0; n2 < n3; ++n2) {
            String string = this.rdpath + stringArray[n2];
            n = Native.fopen((String)string, (int)-1);
            Native.freadb((int)n, (Object)byArray, (int)0, (int)16);
            Native.fclose((int)n);
            long l2 = Convert.unpackX((byte[])byArray, (int)8);
            l += l2;
        }
        n2 = (int)(this.rdsize / 1000000L);
        int n4 = n2 - (int)(l / 1000000L);
        n = 100 - 100 * n4 / n2;
        String string = "{PATH=" + this.rdpath + ",FILES=" + n3 + ",TMBY=" + n2 + ",FMBY=" + n4 + ",USED=" + n + "}";
        return new Table(string);
    }

    private void lockFileAlloc() {
        this.lockFile = new File(this.rdpath + "allocate.LOCK");
        for (int i = 0; i < 100; ++i) {
            try {
                if (this.lockFile.createNewFile()) {
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Time.sleep((double)0.01);
        }
        System.out.println("Overriding stale lock file " + this.lockFile);
    }

    private void lockFileFree() {
        this.lockFile.delete();
    }
}

