/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.sys.inc.MidasReference;
import nxm.sys.inc.PacketHandler;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Time;

public class ICEPacket
implements PacketHandler {
    public static final int ABSC = 1;
    public static final int FIXED = 2;
    public static final int PKHO = 4;
    public static final int headerLength = 64;
    private int mhdrs = 8;
    public byte[] buf = new byte[this.mhdrs * 64];
    private int rhdrs = 0;
    private int whdrs = 0;
    private int count = 0;
    private int fixedSize = 0;
    private int bpa = 1;
    private int ipoff = 0;
    private int flags;
    private double npktoff;
    private byte rep = Shell.rep;
    private boolean pkho = false;
    private static final int ICE_SYNC_1 = 101;
    private static final int ICE_SYNC_2 = 102;
    private static final int ICE_SYNC_3 = 103;

    public ICEPacket() {
        this("SB", 1024, 0);
    }

    public ICEPacket(byte[] byArray, int n) {
        this.setBytes(byArray, n);
    }

    public void setBytes(byte[] byArray, int n) {
        System.arraycopy(byArray, n, this.buf, 0, 64);
        this.rep = this.getRep();
        this.bpa = this.getBPA();
        this.count = this.getCount();
    }

    public ICEPacket(String string, int n, int n2) {
        this.flags = n2;
        this.setRep(Shell.rep);
        this.setKeys((byte)0);
        this.setCount(0);
        if ((n2 & 2) != 0) {
            this.setFixedSize(n);
        } else {
            this.setSize(n);
        }
        this.setUser((short)0);
        this.setChannel(1);
        this.setID((byte)0, (byte)0);
        this.setFormat(string);
        this.setTC(0, 0, 0.0, 0.0, 0.0);
        if ((n2 & 1) != 0) {
            this.setAbscissa(0.0, 1.0);
        }
        if ((n2 & 4) != 0) {
            this.pkho = true;
        }
    }

    public void setKeys(byte by) {
        this.buf[0] = 101;
        this.buf[1] = 102;
        this.buf[2] = 103;
        this.setUserKey(by);
    }

    public void setUserKey(byte by) {
        this.buf[3] = by;
    }

    public byte getUserKey() {
        return this.buf[3];
    }

    public boolean hasSync() {
        return ICEPacket.hasSync(this.buf, 0);
    }

    public static boolean hasSync(byte[] byArray, int n) {
        return byArray[n + 0] == 101 && byArray[n + 1] == 102 && byArray[n + 2] == 103;
    }

    public void setCount(int n) {
        this.count = n;
        Convert.packL((byte[])this.buf, (int)4, (int)n, (byte)this.rep);
    }

    public void upCount() {
        ++this.count;
        Convert.packL((byte[])this.buf, (int)4, (int)this.count, (byte)this.rep);
    }

    public void upCount(int n) {
        this.count += n;
        Convert.packL((byte[])this.buf, (int)4, (int)this.count, (byte)this.rep);
    }

    public void setSize(int n) {
        Convert.packL((byte[])this.buf, (int)8, (int)n, (byte)this.rep);
    }

    public void setUser(short s) {
        Convert.packI((byte[])this.buf, (int)12, (short)s, (byte)this.rep);
    }

    public void setChannel(int n) {
        Convert.packI((byte[])this.buf, (int)14, (short)((short)n), (byte)this.rep);
    }

    public void setID(byte by, byte by2) {
        this.buf[16] = by;
        this.buf[17] = by2;
    }

    public void setRep(byte by) {
        this.buf[18] = by;
    }

    public byte getRep() {
        return this.buf[18];
    }

    public static byte getRep(byte[] byArray, int n) {
        return byArray[n + 18];
    }

    public int getBPA() {
        return this.buf[19];
    }

    public void setBPA(int n) {
        this.buf[19] = (byte)n;
        this.bpa = this.buf[19];
    }

    public void setFormat(String string) {
        this.setBPA(Data.getBPA((String)string));
        this.buf[20] = (byte)string.charAt(0);
        this.buf[21] = (byte)string.charAt(1);
    }

    public void setTC(int n, int n2, double d, double d2, double d3) {
        this.buf[22] = (byte)n;
        this.buf[23] = (byte)n2;
        Convert.packD((byte[])this.buf, (int)24, (double)d, (byte)this.rep);
        Convert.packD((byte[])this.buf, (int)32, (double)d2, (byte)this.rep);
        Convert.packD((byte[])this.buf, (int)40, (double)d3, (byte)this.rep);
    }

    public void setTC(ICEPacket iCEPacket) {
        System.arraycopy(iCEPacket.buf, 22, this.buf, 22, 26);
    }

    public Time getTC() {
        double d = Convert.unpackD((byte[])this.buf, (int)32, (byte)this.rep);
        double d2 = Convert.unpackD((byte[])this.buf, (int)40, (byte)this.rep);
        return new Time(d, d2);
    }

    public byte getTCMode() {
        return this.buf[23];
    }

    public byte getTCStatus() {
        return this.buf[23];
    }

    public double getTCO() {
        return Convert.unpackD((byte[])this.buf, (int)24, (byte)this.rep);
    }

    public void decTCO(int n) {
        double d = Convert.unpackD((byte[])this.buf, (int)24, (byte)this.rep);
        Convert.packD((byte[])this.buf, (int)24, (double)(d - (double)n), (byte)this.rep);
    }

    public int getTC(Time time, double d, double d2) {
        double d3 = Convert.unpackD((byte[])this.buf, (int)32, (byte)this.rep);
        double d4 = Convert.unpackD((byte[])this.buf, (int)40, (byte)this.rep);
        time.fromJ1950(d3, d4);
        double d5 = d - Convert.unpackD((byte[])this.buf, (int)24, (byte)this.rep);
        time.addSec(d5 * d2);
        return this.buf[23];
    }

    public void setUserData(double d, int n) {
        Convert.packD((byte[])this.buf, (int)(48 + 8 * n), (double)d, (byte)this.rep);
    }

    public void setUserData(long l, int n) {
        Convert.packX((byte[])this.buf, (int)(48 + 8 * n), (long)l, (byte)this.rep);
    }

    public void setUserData(float f, int n) {
        Convert.packF((byte[])this.buf, (int)(48 + 4 * n), (float)f, (byte)this.rep);
    }

    public void setUserData(int n, int n2) {
        Convert.packL((byte[])this.buf, (int)(48 + 4 * n2), (int)n, (byte)this.rep);
    }

    public void setUserData(short s, int n) {
        Convert.packI((byte[])this.buf, (int)(48 + 2 * n), (short)s, (byte)this.rep);
    }

    public void setUserData(byte by, int n) {
        this.buf[48 + n] = by;
    }

    public double getUserDataD(int n) {
        return Convert.unpackD((byte[])this.buf, (int)(48 + 8 * n), (byte)this.rep);
    }

    public long getUserDataX(int n) {
        return Convert.unpackX((byte[])this.buf, (int)(48 + 8 * n), (byte)this.rep);
    }

    public float getUserDataF(int n) {
        return Convert.unpackF((byte[])this.buf, (int)(48 + 4 * n), (byte)this.rep);
    }

    public int getUserDataL(int n) {
        return Convert.unpackL((byte[])this.buf, (int)(48 + 4 * n), (byte)this.rep);
    }

    public short getUserDataI(int n) {
        return Convert.unpackI((byte[])this.buf, (int)(48 + 2 * n), (byte)this.rep);
    }

    public byte getUserDataB(int n) {
        return this.buf[48 + n];
    }

    public void setAbscissa(double d, double d2) {
        Convert.packD((byte[])this.buf, (int)48, (double)d, (byte)this.rep);
        Convert.packD((byte[])this.buf, (int)56, (double)d2, (byte)this.rep);
    }

    public void setMode(String string) {
        this.flags = string.equals("ABSC") ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public void setFixedSize(int n) {
        this.fixedSize = n;
        this.setSize(n);
    }

    public int getChannel() {
        return Convert.unpackI((byte[])this.buf, (int)14, (byte)this.rep);
    }

    public int getCount() {
        this.count = Convert.unpackL((byte[])this.buf, (int)4, (byte)this.rep);
        return this.count;
    }

    public String getFormat() {
        return Convert.unpackS((byte[])this.buf, (int)20, (int)2);
    }

    public int getSize() {
        int n = this.fixedSize != 0 ? this.fixedSize : Convert.unpackL((byte[])this.buf, (int)8, (byte)this.rep);
        return n;
    }

    public int getBytes() {
        int n = this.fixedSize;
        if (n == 0) {
            n = Convert.unpackL((byte[])this.buf, (int)8, (byte)this.rep);
        }
        return this.bpa * n;
    }

    public int getFixedSize() {
        return this.fixedSize;
    }

    public void setRBData(int n, int n2) {
        Convert.packL((byte[])this.buf, (int)(48 + n * 4), (int)n2, (byte)this.rep);
    }

    public int getRBData(int n) {
        return Convert.unpackL((byte[])this.buf, (int)(48 + n * 4), (byte)this.rep);
    }

    public String getConfiguration(DataFile dataFile) {
        String string = "ICE";
        if (this.fixedSize != 0) {
            string = string + "/FS=" + this.fixedSize;
        }
        if ((this.flags & 1) != 0) {
            string = string + "/MODE=ABSC";
        }
        if (dataFile.hp != null) {
            string = string + "/DET";
            if (dataFile.hp.aux != null && dataFile.hp.aux.length() > 0) {
                string = string + "=" + dataFile.hp.aux;
            }
        }
        return string;
    }

    public void setFileName(DataFile dataFile, FileName fileName) {
        DataFile dataFile2 = new DataFile();
        dataFile2.init((MidasReference)dataFile.cmd, (Object)fileName, "3000", "NH", dataFile.getPacketHandlerFlags());
        dataFile2.setSubRecords("KEYS|4B,CNT|SL,ELEM|SL,USER|SI,CHAN|SI,SID|2B,REP|SB,BPA|SB,MODE|SB,TYPE|SB,TCM|SB,TCS|SB,TCO|SD,TCWS|SD,TCFS|SD");
        if ((this.flags & 1) != 0) {
            dataFile2.setSubRecords("+XDEL|SD,XSTA|SD");
        } else {
            dataFile2.setSubRecords("+RBST|SL,RBSZ|SL,RBDO|SL,RBDS|SL");
        }
        if (this.fixedSize > 0) {
            dataFile2.setSize((double)((int)(dataFile.getSize() / (double)this.fixedSize)));
        }
        dataFile.hp = dataFile2;
    }

    public double naturalDataOffset(DataFile dataFile, double d) {
        int n = this.fixedSize * this.bpa;
        if (n == 0) {
            n = this.getBytes();
        }
        double d2 = Math.floor(d / (double)n);
        return d2 * (double)n;
    }

    public double dataToPacketOffset(DataFile dataFile, double d) {
        int n = this.fixedSize * this.bpa;
        if (n == 0) {
            n = this.getBytes();
        }
        double d2 = Math.floor(d / (double)n);
        double d3 = d2 * 64.0;
        this.ipoff = (int)(d - d2 * (double)n);
        if (dataFile.hp == null) {
            d += d3;
            if (this.ipoff > 0) {
                d += 64.0;
            }
        } else {
            if (this.ipoff > 0) {
                d2 += 1.0;
            }
            this.npktoff = d2;
        }
        return d;
    }

    public double packetToDataOffset(DataFile dataFile, double d) {
        if (dataFile.hp != null) {
            return d;
        }
        int n = this.fixedSize * this.bpa;
        if (n == 0) {
            n = this.getBytes();
        }
        double d2 = Math.floor(d / (double)(n + 64));
        return d2 * (double)n;
    }

    public void open(DataFile dataFile) {
        this.setFormat(dataFile.getFormat());
        if (dataFile.hp != null) {
            Object object = dataFile.fn.getQualifier("RG");
            if (object != null) {
                dataFile.hp.setQualifier("RG", object);
            }
            dataFile.hp.open();
        }
    }

    public void seek(DataFile dataFile, double d) {
        d = this.dataToPacketOffset(dataFile, d);
        if (dataFile.hp != null) {
            dataFile.hp.seek(this.npktoff);
        }
        if (!this.pkho) {
            dataFile.io.seek((long)(dataFile.getDataStart() + d));
        }
    }

    public int read(DataFile dataFile, byte[] byArray, int n, int n2, long l) {
        int n3;
        int n4 = this.getBytes();
        this.rhdrs = 0;
        for (int i = n2; i > 0; i -= n3) {
            if (this.ipoff == 0) {
                if (this.rhdrs == this.mhdrs) {
                    this.setMaxHeaders(this.mhdrs * 2);
                }
                if (dataFile.hp != null) {
                    dataFile.hp.read(this.buf, this.rhdrs * 64, 64);
                } else {
                    dataFile.io.read(this.buf, this.rhdrs * 64, 64);
                }
                ++this.rhdrs;
            }
            n3 = Math.min(i, n4 - this.ipoff);
            n3 = byArray != null ? dataFile.io.read(byArray, n, n3) : dataFile.io.read(l, n, n3);
            if (n3 <= 0) {
                return n3;
            }
            n += n3;
            this.ipoff += n3;
            if (this.ipoff != n4) continue;
            this.ipoff = 0;
        }
        return n2;
    }

    public int write(DataFile dataFile, byte[] byArray, int n, int n2, long l) {
        int n3;
        int n4 = this.getBytes();
        this.whdrs = 0;
        for (int i = n2; i > 0; i -= n3) {
            if (this.ipoff == 0) {
                if (dataFile.hp != null) {
                    dataFile.hp.write(this.buf, this.whdrs * 64, 64);
                } else if (dataFile.io != null) {
                    dataFile.io.write(this.buf, this.whdrs * 64, 64);
                }
                ++this.whdrs;
            }
            n3 = Math.min(i, n4 - this.ipoff);
            if (!this.pkho) {
                n3 = byArray != null ? dataFile.io.write(byArray, n, n3) : dataFile.io.write(l, n, n3);
            }
            if (n3 < 0) {
                return n3;
            }
            n += n3;
            this.ipoff += n3;
            if (this.ipoff != n4) continue;
            this.ipoff = 0;
        }
        return n2;
    }

    public void close(DataFile dataFile) {
        if (dataFile.hp != null) {
            dataFile.hp.close();
        }
    }

    public boolean hasHeader() {
        return this.rhdrs > 0;
    }

    public String listHeader() {
        String string = "ICE-Packet Count=" + this.getCount() + " Elem=" + this.getSize() + " Chan=" + this.getChannel() + " Form=" + this.getFormat() + " TC=" + this.getTC() + " at " + this.getTCO();
        return string;
    }

    public PacketHandler cloneOf() {
        PacketHandler packetHandler = null;
        try {
            packetHandler = (PacketHandler)this.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return packetHandler;
    }

    public void copyFrom(ICEPacket iCEPacket) {
        this.setBytes(iCEPacket.buf, 0);
    }

    private void setMaxHeaders(int n) {
        byte[] byArray = new byte[n * 64];
        if (this.rhdrs > 0) {
            System.arraycopy(this.buf, 0, byArray, 0, this.rhdrs * 64);
        }
        this.buf = byArray;
        this.mhdrs = n;
    }

    public void setBuffer(byte[] byArray, int n) {
        System.arraycopy(byArray, n, this.buf, 0, 64);
    }
}

