/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.ice.lib.Core;
import nxm.ice.lib.CoreComponent;
import nxm.sys.lib.Data;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;

public class CoreNative
extends Core {
    protected long handle;
    protected String config;
    public static boolean useNative = false;

    public native long alloc();

    public native int config(long var1, int var3, int var4);

    public native int init(long var1);

    public native int setkey(long var1, String var3, char var4, byte[] var5, int var6, int var7);

    public native int getkey(long var1, String var3, char var4, byte[] var5, int var6, int var7);

    public native int work(long var1, long var3, long var5, long var7, long var9);

    public native int free(long var1);

    public native int sysrd(long var1, int var3);

    public native int syswr(long var1, int var3, int var4);

    public static synchronized native int open(long var0);

    public static synchronized native int poll(long var0);

    public static synchronized native int upload(long var0);

    public static native long newStream(int var0, int var1, int var2);

    public static native void freeStream(long var0);

    public static native long loadStreamBuffer(long var0);

    public static native int loadStreamAvail(long var0);

    public static native int loadStreamStatus(long var0, int var2);

    public static native long unloadStreamBuffer(long var0);

    public static native int unloadStreamAvail(long var0);

    public static native int unloadStreamStatus(long var0, int var2);

    public static native int xgetL(long var0, int var2);

    public static native void xwrL(long var0, int var2);

    public static native void fp2fptx(long var0, int var2);

    public static native void fptx2fp(long var0, int var2);

    public CoreNative() {
        useNative |= CoreNative.loadNative("nxm.ice.lib.CoreNative");
        CoreNative.loadNative(this.getClass().getName());
    }

    private static boolean loadNative(String string) {
        boolean bl = Shell.loadLibrary((String)string);
        if (!bl) {
            throw new MidasException("Problem with load of native library: " + string);
        }
        return bl;
    }

    @Override
    public int setFormats(String string, String string2) {
        return this.config(this.handle, 1, CoreNative.getFormats(string, string2));
    }

    @Override
    public int setMCID(int n) {
        return this.config(this.handle, 6, n);
    }

    @Override
    public int setTraceMode(int n) {
        return this.config(this.handle, 4, n << 24);
    }

    @Override
    public int getTraceData(int n) {
        return this.sysrd(this.handle, 4092);
    }

    @Override
    public void allocNative(String string) {
        this.config = string;
        this.handle = this.alloc();
        if (this.handle == 0L) {
            throw new MidasException("Problem with alloc of native config=" + string);
        }
        this.config(this.handle, 3, this.halo.impl);
        this.config(this.handle, 2, this.halo.flow);
        this.config(this.handle, 4, this.halo.flgs);
        this.config(this.handle, 6, this.halo.mcid);
        this.config(this.handle, 7, this.halo.vbpr);
        this.init(this.handle);
    }

    @Override
    public synchronized int set(String string, Data data) {
        int n;
        char c = (char)data.type;
        if (c == 'A') {
            c = 'S';
        }
        if ((n = this.setkey(this.handle, string, c, data.buf, 0, data.size * data.bpe)) >= 0) {
            return n;
        }
        return super.set(string, data);
    }

    @Override
    public synchronized Data get(String string, byte by) {
        byte[] byArray = new byte[256];
        char c = (char)by;
        if (string.length() > 2 && string.charAt(1) == ':') {
            c = string.charAt(0);
            string = string.substring(2);
        }
        int n = this.getkey(this.handle, string, c, byArray, 0, byArray.length);
        if (by == 83) {
            by = (byte)65;
            while (n % 8 != 0) {
                byArray[n++] = 0;
            }
        }
        if (n > 0) {
            return new Data(byArray, 0, n, (int)by, 1);
        }
        return super.get(string, by);
    }

    @Override
    public synchronized int get(String string, Data data) {
        char c = (char)data.type;
        if (string.length() > 2 && string.charAt(1) == ':') {
            c = string.charAt(0);
            string = string.substring(2);
        }
        int n = this.getkey(this.handle, string, c, data.buf, 0, data.buf.length);
        if (data.type == 65) {
            while (n % 8 != 0) {
                data.buf[n++] = 0;
            }
        }
        if (n > 0) {
            return n;
        }
        return super.get(string, data);
    }

    @Override
    public synchronized int get(String string, Data data, int n, int n2) {
        char c = (char)data.type;
        if (string.length() > 2 && string.charAt(1) == ':') {
            c = string.charAt(0);
            string = string.substring(2);
        }
        n2 = this.getkey(this.handle, string, c, data.buf, n, n2);
        if (data.type == 65) {
            while (n2 % 8 != 0) {
                data.buf[n2++] = 0;
            }
        }
        return n2;
    }

    @Override
    public int open() {
        return CoreNative.open(this.handle);
    }

    public synchronized int process(CoreComponent.Stream stream) {
        return this.work(this.handle, 0L, 0L, stream.handle, 0L);
    }

    @Override
    public synchronized int process(CoreComponent.Stream stream, CoreComponent.Stream stream2) {
        return this.work(this.handle, stream.handle, 0L, stream2.handle, 0L);
    }

    @Override
    public synchronized int process(CoreComponent.Buffer buffer, CoreComponent.Buffer buffer2) {
        return this.work(this.handle, buffer.handle, 0L, buffer2.handle, 0L);
    }

    @Override
    public synchronized int process(CoreComponent.Buffer buffer, CoreComponent.Stream stream) {
        return this.work(this.handle, buffer.handle, 0L, stream.handle, 0L);
    }

    @Override
    public synchronized int process(CoreComponent.Buffer buffer, CoreComponent.Stream stream, CoreComponent.Stream stream2, CoreComponent.Stream stream3) {
        return this.work(this.handle, buffer.handle, stream.handle, stream2.handle, stream3.handle);
    }

    @Override
    public int poll() {
        return CoreNative.poll(this.handle);
    }

    @Override
    public int close() {
        return this.free(this.handle);
    }
}

