/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.ice.lib.Archiver;
import nxm.sys.lib.Convert;

public class ArchSFN {
    private String format;
    private String quals;
    private int indx;
    private int indx0;
    private int indxt;
    private int nsf;
    private int xfer = 1;
    private boolean legit;
    private Archiver.ToC toc;
    private Object ref;
    private double clen;
    private double flen;
    private double tlen;
    private double rate = 1.0;
    private double top;
    private double toff;
    private double dur = -1.0;

    public ArchSFN() {
    }

    public ArchSFN(Object object, String string, int n) {
        this.ref = object;
        this.setSize(n);
        this.setSFN(string);
    }

    public boolean setSFN(String string) {
        int n;
        int n2 = -1;
        int n3 = -1;
        int n4 = string.indexOf("%");
        int n5 = string.indexOf("{");
        int n6 = string.indexOf("(");
        if (n6 > 0 && (n6 < n5 || n5 < 0)) {
            n5 = n6;
        }
        if (n5 > 0) {
            this.quals = string.substring(n5);
            string = string.substring(0, n5);
        }
        int n7 = string.lastIndexOf("/") + 1;
        int n8 = 46;
        for (int i = string.length() - 1; i > n7; --i) {
            n = string.charAt(i);
            if (n3 < 0 && this.isDigit((char)n) && this.isDelimit((char)n8)) {
                n3 = i;
            }
            if (n3 > 0 && this.isDigit((char)n)) {
                n2 = i;
            }
            if (n3 > 0 && !this.isDigit((char)n)) break;
            n8 = n;
        }
        int n9 = n = n3 < 0 || n2 < 0 ? 0 : n3 - n2 + 1;
        if (n4 >= 0) {
            this.format = string;
            this.indx0 = 0;
            this.indx = 0;
        } else if (this.nsf == 0 && n > 0) {
            boolean bl = n > 1 && string.charAt(n2) == '0';
            String string2 = bl ? "%0" + n + "d" : "%d";
            this.format = string.substring(0, n2) + string2 + string.substring(n3 + 1);
            this.indx = this.indx0 = Convert.s2l((String)string.substring(n2, n3 + 1));
        } else {
            this.format = string + "_%d";
            this.indx0 = 1;
            this.indx = 1;
            this.toc = new Archiver.ToC(this.ref, string + "_toc", this.nsf, -1.0, 65);
            if (this.toc.isOpen()) {
                this.nsf = this.toc.size();
                this.tlen = this.toc.getLength();
                this.clen = 0.0;
                this.indx = 0;
                this.nextIndex();
                if (this.toc.tocr.getRate() > 0.0) {
                    this.rate = this.toc.tocr.getRate();
                }
                System.out.println("Using TOC file=" + this.toc.df.getURL() + " entries=" + this.nsf + " time=" + this.tlen);
            } else {
                this.toc = null;
            }
        }
        this.indxt = this.indx0;
        this.legit = true;
        return this.legit;
    }

    public int nextIndex() {
        double d;
        double d2;
        do {
            ++this.indx;
            if (this.nsf > 0 && this.indx - this.indx0 >= this.nsf) {
                this.indx = this.indx0;
            }
            if (this.toc == null) break;
            long l = (long)((this.dur - this.clen) * this.rate);
            if (this.dur > 0.0 && l < (long)this.xfer) {
                this.indx = this.indxt;
            }
            if (this.indx == this.indxt) {
                this.clen = 0.0;
            }
            this.toc.read(this.indx - 1);
            d2 = this.toc.tocr.getTime();
            d = this.toc.tocr.getLength();
        } while (this.dur > 0.0 && (d2 + d < this.top || d2 > this.top + this.dur));
        return this.indx;
    }

    public String nextSFN() {
        this.indx = this.nextIndex();
        return this.getSFN();
    }

    public String getSFN() {
        return this.getSFN(this.indx);
    }

    public String getSFN(int n) {
        String string;
        String string2 = string = this.legit ? String.format(this.format, n) : this.format;
        if (string.startsWith("http:")) {
            string = string + ".tmp";
        }
        if (this.toc != null) {
            int n2 = 0;
            int n3 = 0;
            double d = this.toc.tocr.getTime();
            this.flen = this.toc.tocr.getLength();
            if (n == this.indxt) {
                this.flen -= this.toff;
            }
            this.clen += this.flen;
            if (this.toc.tocr.getRate() > 0.0) {
                this.rate = this.toc.tocr.getRate();
            }
            if (n == this.indxt && this.toff > 0.0) {
                n2 = this.xfer * (int)(this.toff * this.rate / (double)this.xfer);
            }
            if (this.dur > 0.0 && this.clen > this.dur) {
                n3 = this.xfer * (int)((this.clen - this.dur) * this.rate / (double)this.xfer);
            }
            if (n2 != 0 || n3 != 0) {
                string = string + "(" + n2 + ":-" + n3 + ")";
            }
        }
        if (this.quals != null) {
            string = string + this.quals;
        }
        return string;
    }

    public void setTL(int n) {
        this.xfer = n;
    }

    public void setTop(double d) {
        this.top = d;
        if (d < 0.0) {
            return;
        }
        int n = 0;
        double d2 = 0.0;
        double d3 = 1.0;
        if (this.toc != null) {
            for (n = 0; n < this.nsf; ++n) {
                this.toc.read(n);
                d2 = this.toc.tocr.getTime();
                d3 = this.toc.tocr.getLength();
                if (d2 <= d && d < d2 + d3) break;
            }
            if (n == this.nsf) {
                System.out.println("ArchSFN top time=" + d2 + " not found. Starting at 1st record.");
                n = 0;
                this.toc.read(n);
            }
            this.indx = this.indxt = n + 1;
            this.clen = 0.0;
            this.toff = d - d2;
        }
    }

    public void setDur(double d) {
        this.dur = d;
    }

    public int getIndex() {
        return this.indx;
    }

    public void setIndex(int n) {
        this.indx = n;
    }

    public int getSize() {
        return this.nsf;
    }

    public void setLast(int n) {
        this.nsf = n - this.indx0 + 1;
    }

    public int getLast() {
        return this.nsf + this.indx0 - 1;
    }

    public void setSize(int n) {
        this.nsf = n;
    }

    public int getIndex0() {
        return this.indx0;
    }

    public void setIndex0(int n) {
        this.indx0 = n;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String string) {
        if (string != null) {
            this.format = string;
        }
    }

    public boolean isLegit() {
        return this.legit;
    }

    public int resetIndex() {
        this.indx = this.indx0;
        return this.indx;
    }

    public boolean isFirst() {
        return this.indx == this.indx0;
    }

    public boolean isTop() {
        return this.indx == this.indxt;
    }

    public int getOffset() {
        return this.indx - this.indx0;
    }

    public double getLength() {
        return this.dur > 0.0 ? this.dur : this.tlen;
    }

    public double getLengthTo(double d) {
        return this.clen - this.flen + d / this.rate;
    }

    public double getTimeTop() {
        return this.top;
    }

    public double getTimeDur() {
        return this.dur > 0.0 ? this.dur : this.tlen;
    }

    private boolean isAlpha(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private boolean isDelimit(char c) {
        return c == '.' || c == '-' || c == '_' || c == '/';
    }
}

