/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.core.DUC;
import nxm.ice.core.Modefs;
import nxm.ice.core.UDAT;
import nxm.ice.lib.Core;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class UDUC
extends CoreFactory {
    public static final int FLOW = 3;
    public static final int SELFPACE = 1;
    public static final int IKR = 16;
    public static final int OKR = 4;
    public static final int BW = 32;
    public static final int MC = 1;
    public static final int SSZ = 2048;

    public static class CORE
    extends Core
    implements Modefs {
        UDAT.CORE udp;
        DUC.CORE duc;
        CoreComponent.Stream sa;
        boolean isAsync;

        @Override
        public int init() {
            this.udp = new UDAT.CORE();
            this.udp.initSub(1, this.halo);
            this.duc = new DUC.CORE();
            this.duc.initSub(2, this.halo);
            return 0;
        }

        @Override
        public int set(String string, CoreComponent.Value value) {
            if (this.udp.set(string, value) != 0 && this.duc.set(string, value) != 0) {
                return super.set(string, value);
            }
            return 0;
        }

        @Override
        public int get(String string, CoreComponent.Value value) {
            if (this.udp.get(string, value) != 0 && this.duc.get(string, value) != 0) {
                return super.get(string, value);
            }
            return 0;
        }

        @Override
        public int open() {
            this.udp.open();
            this.duc.setRateIn(this.udp.getRate());
            this.duc.setCTXF(this.udp.getCTXF());
            this.duc.open();
            this.sa = new CoreComponent.Stream(2048, 32, 32);
            this.isAsync = this.udp.isAsync();
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Buffer buffer, CoreComponent.Stream stream) {
            while ((this.isAsync || buffer.rok) && stream.wok) {
                this.udp.process(buffer, this.sa);
                this.duc.process(this.sa, stream);
            }
            return 0;
        }

        @Override
        public int poll() {
            this.duc.poll();
            return this.udp.poll();
        }

        @Override
        public int close() {
            this.udp.close();
            this.duc.close();
            this.halo.state = 0;
            return 0;
        }
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(3);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(3);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(3);
        }
    }
}

