/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.lib.Core;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class UDAT
extends CoreFactory {
    public static final String pktList = "Auto,None,Noop,ICE,SDDS,VRT,VRTL,VRTW,VRTX,VRTD";
    public static final int PT_AUTO = -1;
    public static final int PT_NONE = 0;
    public static final int PT_NOOP = 1;
    public static final int PT_ICE = 2;
    public static final int PT_SDDS = 3;
    public static final int PT_VRT = 4;
    public static final int PT_VRTL = 5;
    public static final int PT_VRTW = 6;
    public static final int PT_VRTX = 7;
    public static final int PT_VRTD = 8;
    public static final String flgList = "Fill,Time,OUID,SOS,FB3,AnySID,Bypass,CTXF,xSR,xIF,xRF,xGAIN";
    public static final int PF_FILL = 0;
    public static final int PF_TIME = 1;
    public static final int PF_OUID = 2;
    public static final int PF_SOS = 3;
    public static final int PF_FB3 = 4;
    public static final int PF_ANYSID = 5;
    public static final int PF_BYPASS = 6;
    public static final int PF_CTXF = 7;
    public static final int PF_XSR = 8;
    public static final int PF_XIF = 9;
    public static final int PF_XRF = 10;
    public static final int PF_XGAIN = 11;

    public static class CORE
    extends Core {
        public static final int FLOW = 3;
        public static final int SELFPACE = 1;
        public static final int IKR = 16;
        public static final int OKR = 4;
        public static final int OFMT = 5;
        public static final int BW = 32;
        public static final int XFER = 256;
        public static final int OUID = 1068407;
        public static final int DIFI = 6971934;
        public double ctime;
        public double srate;
        public int bits;
        public int ptype;
        public int bpa;
        int pkty;
        int flags;
        int sid;
        int pinc;
        int cwsec;
        int nwsec;
        long cpsec;
        long npsec;
        long mpsec;
        int counts;
        int nseq;
        int swaps;
        int length;
        int ifix;
        int mfix;
        int nfix;
        int pad;
        int pstate;
        int npinc;
        int ouid;
        int pass;
        int vctx;
        int dbps;

        public void setTime(double d) {
            d = this.ctime > 60.0 ? this.ctime : (d += this.ctime);
            this.cwsec = CORE.d2i(CORE.floor(d));
            this.cpsec = CORE.d2l(CORE.frac(d) * 1.0E12);
            this.nwsec = 0;
            this.npsec = 0L;
            this.putVars("cwsec,cpsec,nwsec,npsec");
        }

        public void startup(double d) {
            this.setTime(d);
            this.poll();
            this.pkty = this.ptype;
            this.putVars("pkty");
        }

        public void setPhaseInc(double d) {
            this.npinc = CORE.d2i(CORE.round(1.0E12 / d / (double)this.bpa * 4.0));
        }

        public boolean isAsync() {
            return this.ptype != 1 && CORE.getBit(this.flags, 1);
        }

        public double getRate() {
            return this.srate;
        }

        public boolean getCTXF() {
            return CORE.getBit(this.flags, 7);
        }

        @Override
        public int init() {
            this.pkty = 0;
            this.ptype = 1;
            this.flags = 0;
            this.sid = -1;
            this.ctime = 0.0;
            this.srate = 1.0E7;
            this.bits = -16;
            this.pad = 0;
            this.ouid = 0;
            return 0;
        }

        @Override
        public int set(String string, CoreComponent.Value value) {
            if (this.isMatch(string, "S:PT")) {
                this.ptype = value.toItem(UDAT.pktList);
            } else if (this.isMatch(string, "L:PKTY")) {
                this.ptype = value.toL();
            } else if (this.isMatch(string, "L:SID")) {
                this.sid = value.toL();
            } else if (this.isMatch(string, "L:OUID")) {
                this.ouid = value.toL();
            } else if (this.isMatch(string, "L:BITS")) {
                this.bits = value.toL();
            } else if (this.isMatch(string, "L:PAD")) {
                this.pad = value.toL();
            } else if (this.isMatch(string, "D:CTIME")) {
                this.ctime = value.toD();
            } else if (this.isMatch(string, "D:SRATE")) {
                this.srate = value.toD();
            } else if (this.isMatch(string, "L:VCTX")) {
                this.vctx = value.toL();
            } else if (this.isMatch(string, "L:FLAGS")) {
                this.flags = value.toL();
            } else if (this.isMatch(string, "S:FLAGS")) {
                this.flags = value.toMask(UDAT.flgList);
            } else if (this.isMatch(string, "D:NEXTSRATE")) {
                this.setPhaseInc(value.toD());
                this.putVars("npinc");
            } else if (this.isMatch(string, "D:STARTUP")) {
                this.startup(value.toD());
            } else {
                return super.set(string, value);
            }
            return 0;
        }

        @Override
        public int get(String string, CoreComponent.Value value) {
            if (this.isMatch(string, "L:PKTY")) {
                value.fromL(this.ptype);
            } else if (this.isMatch(string, "L:SID")) {
                value.fromL(this.sid);
            } else if (this.isMatch(string, "L:FLAGS")) {
                value.fromL(this.flags);
            } else if (this.isMatch(string, "D:STARTUP")) {
                value.fromD(this.ctime);
            } else {
                return super.get(string, value);
            }
            return 0;
        }

        @Override
        public int open() {
            this.sid &= 0xFFFF;
            this.bpa = this.bits < 0 ? -this.bits * 2 / 8 : this.bits / 8;
            this.dbps = CORE.iabs(this.bits) - 1;
            this.nseq = 0;
            this.counts = 0;
            this.length = 0;
            this.swaps = 0;
            this.nwsec = 0;
            this.npsec = 0L;
            this.mpsec = CORE.d2l(1.0E12);
            this.pstate = 0;
            if (this.ptype == 1) {
                this.bpa = 4;
                this.pkty = this.ptype;
            }
            if (this.ptype == 8) {
                this.ouid = 6971934;
            }
            this.setTime(CORE.cpuTime());
            if (this.srate < 1000000.0) {
                System.out.printf("Sample Rate=%f too low for UDAT counters\n", this.srate);
            }
            this.setPhaseInc(this.srate);
            this.pinc = this.npinc;
            if (this.srate == 3.0E8 && this.bpa == 3) {
                this.mfix = 8;
                this.nfix = 4;
            }
            if (this.nfix != 0) {
                System.out.printf("Fixup for UDAT fractional pinc=%d nfix=%d mfix=%d\n", this.pinc, this.nfix, this.mfix);
            }
            this.flags = CORE.setBit(this.flags, 4, this.bpa == 3);
            this.flags = CORE.setBit(this.flags, 5, this.sid == 65535);
            this.flags = CORE.setBit(this.flags, 8, CORE.getBit(this.flags, 8) || CORE.getBit(this.vctx, 24));
            this.flags = CORE.setBit(this.flags, 9, CORE.getBit(this.flags, 9) || CORE.getBit(this.vctx, 25));
            this.flags = CORE.setBit(this.flags, 10, CORE.getBit(this.flags, 10) || CORE.getBit(this.vctx, 26));
            this.flags = CORE.setBit(this.flags, 11, CORE.getBit(this.flags, 11) || CORE.getBit(this.vctx, 27));
            this.flags = CORE.setBit(this.flags, 7, CORE.getBit(this.flags, 7) || CORE.getBit(this.flags, 8) || CORE.getBit(this.flags, 9) || CORE.getBit(this.flags, 10) || CORE.getBit(this.flags, 11));
            this.flags = CORE.setBit(this.flags, 2, CORE.getBit(this.flags, 2) && this.ouid >= 0);
            if (this.ouid <= 0) {
                this.ouid = 1068407;
            }
            if ((this.halo.vbpr & 1) != 0) {
                System.out.printf("UDAT pkty=%d:%d srate=%f bits=%d flags=%04x\n", this.ptype, this.pkty, this.srate, this.bits, this.flags);
            }
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Buffer buffer, CoreComponent.Stream stream) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4 = CORE.getBit(this.flags, 0);
            boolean bl5 = CORE.getBit(this.flags, 1);
            boolean bl6 = CORE.getBit(this.flags, 5);
            boolean bl7 = CORE.getBit(this.flags, 4);
            boolean bl8 = CORE.getBit(this.flags, 7);
            boolean bl9 = CORE.getBit(this.flags, 6);
            boolean bl10 = CORE.getBit(this.flags, 2);
            boolean bl11 = CORE.getBit(this.flags, 8);
            boolean bl12 = CORE.getBit(this.flags, 9);
            boolean bl13 = CORE.getBit(this.flags, 10);
            boolean bl14 = CORE.getBit(this.flags, 11);
            boolean bl15 = this.pkty == 0;
            boolean bl16 = this.pkty == 1;
            boolean bl17 = this.pkty == -1 || this.pkty == 2;
            boolean bl18 = this.pkty == 3;
            boolean bl19 = this.pkty == -1 || this.pkty >= 4;
            boolean bl20 = buffer.rok;
            int n = this.pinc;
            boolean bl21 = this.length > 0;
            boolean bl22 = bl3 = this.length < 256;
            int n2 = !bl20 ? 0 : (bl3 ? this.length : 256);
            boolean bl23 = this.nwsec > 0;
            int n3 = this.cwsec - this.nwsec;
            long l = this.cpsec - this.npsec;
            boolean bl24 = n3 > 0;
            boolean bl25 = n3 < 0;
            boolean bl26 = !bl24 && !bl25;
            boolean bl27 = l > (long)(n << 2);
            boolean bl28 = l < (long)(-n);
            boolean bl29 = !bl27 && !bl28;
            boolean bl30 = bl26 && bl29;
            boolean bl31 = bl24 || bl26 && bl27;
            boolean bl32 = bl25 || bl26 && bl28;
            boolean bl33 = bl4 && !bl20;
            boolean bl34 = bl5 && bl23 && bl32;
            boolean bl35 = this.pstate == 4 && bl5 && bl31;
            long l2 = this.cpsec + (long)(this.pinc << 8);
            boolean bl36 = l2 > this.npsec;
            boolean bl37 = l2 > this.mpsec;
            boolean bl38 = (bl33 || bl34 || bl35) && !bl16 && !bl15;
            boolean bl39 = bl2 = bl23 && bl26 && bl36 && !bl33;
            int n4 = bl37 ? CORE.l2i(this.mpsec - this.cpsec) : (bl2 ? CORE.l2i(this.npsec - this.cpsec) : this.pinc << 8);
            l2 = this.pinc << 3;
            this.sid = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            if ((this.halo.vbpr & 2) != 0) {
                System.out.printf("Top  Cur w=%08x p=%012x  Nxt w=%08x p=%012x  Counts=%x Pad=%x Fill=%x Drop=%x rOk=%x wOk=%x cnt=%d\n", this.cwsec, this.cpsec, this.nwsec, this.npsec, this.counts, bl33 ? 1 : 0, bl34 ? 1 : 0, bl35 ? 1 : 0, buffer.rok ? 1 : 0, stream.wok ? 1 : 0, 0);
            }
            if (bl38) {
                this.pstate = 1;
                int n9 = this.pad;
                for (int i = n4; stream.wok && i > 0 || n7 != 0; i -= this.pinc) {
                    this.cpsec += (long)this.pinc;
                    n7 = !bl7 ? 0 : (n7 == 2 ? 0 : n7 + 1);
                    n8 = this.ifix == this.mfix ? n8 + this.nfix : n8;
                    this.ifix = this.ifix == this.mfix ? 0 : this.ifix + 1;
                    stream.wrLCS(n9, (long)i < l2 ? 1 : 0, 0);
                }
                this.counts = CORE.setBits(this.counts, 15, 12, CORE.getBits(this.counts, 15, 12) + 1);
                n9 = 0;
            } else if (bl21) {
                this.pstate = 2;
                int n10 = 0;
                while (stream.wok && n10 < n2) {
                    this.cpsec += (long)this.pinc;
                    n8 = this.ifix == this.mfix ? n8 + this.nfix : n8;
                    this.ifix = this.ifix == this.mfix ? 0 : this.ifix + 1;
                    int n11 = buffer.getL(n10 << 2);
                    stream.wrLCS(n11, this.length < 8 ? 1 : 0, this.swaps);
                    ++n10;
                    --this.length;
                }
                buffer.rnxt(n10 << 2);
            } else if (bl20 && bl16) {
                this.pstate = 3;
                this.length = 256;
            } else if (bl20 && !bl15) {
                int n12;
                boolean bl40;
                this.pstate = 4;
                int n13 = 0;
                int n14 = buffer.getL(0);
                int n15 = buffer.getL(4);
                int n16 = buffer.getL(8);
                boolean bl41 = !bl10 || !CORE.getBit(n14, 3);
                boolean bl42 = CORE.getBit(n14, 3);
                boolean bl43 = CORE.getBits(n14, 6, 5) > 1 ? true : CORE.getBit(n14, 4);
                boolean bl44 = CORE.bswap2(bl43 ? CORE.getBits(n15, 31, 16) : CORE.getBits(n16, 15, 0)) == this.sid;
                boolean bl45 = CORE.getBits(n14, 7, 0) == 28 && (CORE.bswap4(n16) == this.ouid || bl41);
                boolean bl46 = CORE.getBits(n14, 7, 0) == 8 && (CORE.bswap4(n15) == this.ouid || bl41);
                boolean bl47 = CORE.getBits(n14, 7, 0) == 24 && (CORE.bswap4(n16) == 6971934 || bl41);
                boolean bl48 = CORE.getBits(n14, 7, 0) == 73 && (CORE.bswap4(n16) == this.ouid || bl41);
                boolean bl49 = bl17 && n14 == 0x676665;
                boolean bl50 = !(!bl19 || !bl45 && !bl46 && !bl47 || !bl44 && !bl6);
                boolean bl51 = bl40 = bl19 && bl48 && (bl44 || bl6);
                if (bl49) {
                    n12 = 64;
                    n6 = CORE.getBits(n15, 7, 0);
                    int n17 = CORE.getBits(n16, 13, 0);
                    n13 = CORE.getBits(n16, 13, 0);
                    n14 = buffer.getL(12);
                    this.sid = CORE.getBits(n14, 31, 16);
                    n14 = buffer.getL(16);
                    int n18 = CORE.getBits(n14, 27, 24);
                    for (int i = 1; i < n18; ++i) {
                        n13 += n17;
                    }
                } else if (bl50) {
                    int n19;
                    boolean bl52;
                    int n20 = n5 = CORE.getBit(n14, 2) ? 4 : 0;
                    n12 = !bl42 ? 20 : (!bl43 ? 24 : 28);
                    n6 = CORE.getBits(n14, 11, 8);
                    this.nseq &= 0xF;
                    n13 = (CORE.bswap2(CORE.getBits(n14, 31, 16)) << 2) - n12 - n5;
                    n14 = buffer.getL(12);
                    boolean bl53 = bl45 ? CORE.getBit(n14, 22) : (bl52 = bl46 ? CORE.getBit(n16, 22) : true);
                    int n21 = bl45 ? CORE.getBits(n14, 27, 24) : (n19 = bl46 ? CORE.getBits(n16, 27, 24) : this.dbps);
                    if (bl5) {
                        n15 = buffer.getL(n12 - 12);
                        this.nwsec = CORE.bswap4(n15);
                        n15 = buffer.getL(n12 - 8);
                        this.npsec = CORE.setBits(this.npsec, 39, 32, (long)CORE.bswap4(n15));
                        n15 = buffer.getL(n12 - 4);
                        this.npsec = CORE.setBits(this.npsec, 31, 0, (long)CORE.bswap4(n15));
                    }
                    this.swaps = CORE.setBit(this.swaps, 0, n19 == 15 && bl52);
                    this.swaps = CORE.setBit(this.swaps, 1, n19 > 15 && bl52);
                    this.swaps = CORE.setBit(this.swaps, 2, n19 == 11 && bl52);
                    if ((this.halo.vbpr & 2) != 0) {
                        System.out.printf("New Cur w=%08x p=%012x  Nxt w=%08x p=%012x\n", this.cwsec, this.cpsec, this.nwsec, this.npsec);
                    }
                } else if (bl40) {
                    int n22;
                    this.pstate = 5;
                    n12 = CORE.getBits(n14, 31, 24) << 2;
                    int n23 = n22 = bl42 ? 28 : 20;
                    if (bl8) {
                        int n24;
                        n14 = buffer.getL(n22);
                        n14 = CORE.brev4(CORE.bswap4(n14));
                        if ((this.halo.vbpr & 1) != 0) {
                            System.out.printf("UDAT Ctx bx=%08x coff=%d len=%d\n", n14, n22, n12);
                        }
                        stream.wrLCS(n14, 2, 0);
                        n22 += 4 + (CORE.getBits(n14, 2, 2) << 3) + (CORE.getBits(n14, 1, 1) << 2);
                        if (CORE.getBit(n14, 3) && bl12) {
                            n15 = buffer.getL(n22);
                            n16 = buffer.getL(n22 + 4);
                            n24 = CORE.l2i(CORE.ii2l(CORE.bswap4(n15), CORE.bswap4(n16)) >> 20);
                            if ((this.halo.vbpr & 1) != 0) {
                                System.out.printf("UDAT Ctx IF bc=%d\n", n24);
                            }
                            stream.wrLCS(n24, 4, 0);
                        }
                        n22 += CORE.getBits(n14, 3, 3) << 3;
                        if (CORE.getBit(n14, 4) && bl13) {
                            n15 = buffer.getL(n22);
                            n16 = buffer.getL(n22 + 4);
                            n24 = CORE.l2i(CORE.ii2l(CORE.bswap4(n15), CORE.bswap4(n16)) >> 20);
                            if ((this.halo.vbpr & 1) != 0) {
                                System.out.printf("UDAT Ctx RF bc=%d\n", n24);
                            }
                            stream.wrLCS(n24, 4, 0);
                        }
                        n22 += (CORE.getBits(n14, 4, 4) + CORE.getBits(n14, 5, 5) + CORE.getBits(n14, 6, 6) << 3) + (CORE.getBits(n14, 7, 7) << 2);
                        if (CORE.getBit(n14, 8) && bl14) {
                            n15 = buffer.getL(n22);
                            n24 = CORE.bswap4(n15) >> 7;
                            if ((this.halo.vbpr & 1) != 0) {
                                System.out.printf("UDAT Ctx GAIN bc=%d\n", n24);
                            }
                            stream.wrLCS(n24, 8, 0);
                        }
                        n22 += CORE.getBits(n14, 8, 8) + CORE.getBits(n14, 9, 9) << 2;
                        if (CORE.getBit(n14, 10) && bl11) {
                            n15 = buffer.getL(n22);
                            n16 = buffer.getL(n22 + 4);
                            n24 = CORE.l2i(CORE.ii2l(CORE.bswap4(n15), CORE.bswap4(n16)) >> 20);
                            if ((this.halo.vbpr & 1) != 0) {
                                System.out.printf("UDAT Ctx SR bc=%d\n", n24);
                            }
                            stream.wrLCS(n24, 10, 0);
                        }
                        stream.wrLCS(n14, 2, 0);
                        stream.setC(0);
                    }
                    this.counts = CORE.setBits(this.counts, 23, 20, CORE.getBits(this.counts, 23, 20) + 1);
                } else {
                    n12 = 4;
                    this.counts = CORE.setBits(this.counts, 30, 24, CORE.getBits(this.counts, 30, 24) + 1);
                }
                buffer.rnxt(n12);
                if (n13 > 0) {
                    this.length = n13 >> 2;
                    this.counts = CORE.setBits(this.counts, 3, 0, CORE.getBits(this.counts, 3, 0) + 1);
                    if (n6 != this.nseq) {
                        this.counts = CORE.setBits(this.counts, 7, 4, CORE.getBits(this.counts, 7, 4) + 1);
                    }
                    this.nseq = n6 + 1;
                    stream.setC(0);
                }
            }
            if (bl35) {
                this.counts = CORE.setBits(this.counts, 11, 8, CORE.getBits(this.counts, 11, 8) + 1);
                buffer.rnxt(n2 << 2);
                this.length -= n2;
                if (this.length > 0) {
                    this.pstate = 4;
                }
            }
            this.counts = CORE.setBits(this.counts, 19, 16, this.length > 15 ? 15 : CORE.getBits(this.length, 3, 0));
            this.counts = CORE.setBit(this.counts, 31, bl20);
            this.cpsec += (long)n8;
            boolean bl54 = bl = this.cpsec >= this.mpsec;
            if (bl) {
                this.cpsec -= this.mpsec;
                ++this.cwsec;
            }
            if (this.pass == 0) {
                this.counts = this.counts;
                this.cwsec = this.cwsec;
                this.cpsec = this.cpsec;
                this.nwsec = this.nwsec;
                this.npsec = this.npsec;
                if ((this.halo.vbpr & 2) != 0) {
                    System.out.printf("Upd  Counts=%x   Nxt w=%08x p=%012x   Cur w=%08x p=%012x   pstate=%d cnt=%d pass=%d\n", this.counts, this.nwsec, this.npsec, this.cwsec, this.cpsec, this.pstate, 0, this.pass);
                }
            }
            this.pass = this.pass >= 14 ? 0 : this.pass + 1;
            buffer.rokLen(1024);
            return 0;
        }

        @Override
        public int close() {
            this.halo.state = 0;
            return 0;
        }

        @Override
        public int poll() {
            double d = CORE.cpuTime();
            int n = CORE.d2i(CORE.floor(d));
            long l = CORE.d2l(CORE.frac(d) * 1.0E12);
            if (this.ptype <= 1) {
                return 0;
            }
            if (CORE.getBit(this.flags, 1)) {
                this.getVars("cwsec,cpsec,nwsec,npsec,counts");
                System.out.printf("Poll EECLFDSU=%08x  Cpu=%08x:%012x  Nxt=%08x:%012x  Cur=%08x:%012x\n", this.counts, n, l, this.nwsec, this.npsec, this.cwsec, this.cpsec);
            }
            return 5;
        }
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(3);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(3);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(3);
        }
    }
}

