/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.core.Filters;
import nxm.ice.lib.Core;
import nxm.ice.lib.CoreCommon;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class DUC2
extends CoreFactory {
    public static final int FLOW = 1;
    public static final int ONP = 1;
    public static final int NP = 2;
    public static final int SIBW = 32;
    public static final int SOBW = 64;
    public static final int OTAP = 4;
    public static final int NTAP = 16;
    public static final int SHF = 8;

    public static class CORE
    extends Core {
        public double fbwf;
        public double fbwn;
        int ntap;
        int nrpt;
        int quad;
        int dquad;
        float[] fta;
        float[] ftb;
        float[] ftc;
        CoreComponent.CxTapBuf vd;
        CoreComponent.Value vo;

        @Override
        public int init() {
            this.fbwf = 1.0;
            this.fbwn = 1.0;
            this.ntap = -1;
            return 0;
        }

        @Override
        public int set(String string, CoreComponent.Value value) {
            if (this.isMatch(string, "L:NTAP")) {
                this.ntap = value.toL();
            } else if (this.isMatch(string, "L:FCNY")) {
                this.dquad = value.toL() % 4;
            } else if (this.isMatch(string, "D:FBWF")) {
                this.fbwf = value.toD();
            } else {
                return super.set(string, value);
            }
            return 0;
        }

        @Override
        public int get(String string, CoreComponent.Value value) {
            if (!this.isMatch(string, "D:XDIO")) {
                return super.get(string, value);
            }
            value.fromD(0.5);
            return 0;
        }

        public void genFilt() {
            int n = this.nrpt * this.ntap;
            double d = this.fbwn * this.fbwf;
            float f = (float)this.nrpt * CORE.mulfp2(1.0f, 8);
            float[] fArray = new float[n * 2];
            Filters.genFirKais(1, d / (double)this.nrpt, 0.0, 0.05 / (double)this.nrpt, 90.0, fArray, n);
            int n2 = 0;
            int n3 = 0;
            while (n2 < this.ntap) {
                this.fta[n2] = fArray[n3 + 0] * f;
                this.ftb[n2] = fArray[n3 + 2] * f;
                ++n2;
                n3 += 4;
            }
            for (n3 = 0; n3 < n; ++n3) {
                this.ftc[n3] = fArray[n3 + n3] * f;
            }
        }

        @Override
        public int open() {
            if (this.ntap <= 0) {
                this.ntap = 16;
            }
            if (this.ntap > 16) {
                System.out.printf("Warn ntap=%d limited to ntap=%d for this compile\n", this.ntap, 16);
                this.ntap = 16;
            }
            this.vd = new CoreComponent.CxTapBuf(4, 1, 16, -1);
            this.vd.setLength(this.ntap);
            this.fta = new float[16];
            this.ftb = new float[16];
            this.ftc = new float[32];
            this.vo = new CoreComponent.Value("CI", 2);
            this.nrpt = 2;
            this.genFilt();
            this.quad = 0;
            if ((this.halo.vbpr & 1) != 0) {
                System.out.printf("DUC2 fbwn=%f fbwf=%f ntap=%d NP=%d\n", this.fbwn, this.fbwf, this.ntap, 2);
            }
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Stream stream, CoreComponent.Stream stream2) {
            CoreCommon.CxFloat cxFloat = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cxFloat2 = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cxFloat3 = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cxFloat4 = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cxFloat5 = CoreCommon.CxFloat.stk();
            while (stream.rok && stream2.wok) {
                stream.rdCIF(cxFloat);
                this.vd.load(cxFloat);
                cxFloat2.x = 0.0f;
                cxFloat2.y = 0.0f;
                cxFloat3.x = 0.0f;
                cxFloat3.y = 0.0f;
                for (int i = 0; i < this.ntap; ++i) {
                    CoreCommon.CxFloat cxFloat6 = CoreCommon.CxFloat.stk();
                    CoreCommon.CxFloat cxFloat7 = CoreCommon.CxFloat.stk();
                    CoreCommon.CxFloat cxFloat8 = CoreCommon.CxFloat.stk();
                    this.vd.get(i, cxFloat6);
                    cxFloat7 = cxFloat6;
                    cxFloat8 = cxFloat6;
                    float f = this.fta[i];
                    float f2 = this.ftb[i];
                    cxFloat2.x += f * cxFloat7.x;
                    cxFloat3.x += f2 * cxFloat8.x;
                    cxFloat2.y += f * cxFloat7.y;
                    cxFloat3.y += f2 * cxFloat8.y;
                }
                CORE.qrotcc(cxFloat2, this.quad, cxFloat4);
                CORE.qrotcc(cxFloat3, this.quad + this.dquad, cxFloat5);
                this.quad = this.quad + this.dquad + this.dquad & 3;
                this.vo.setCFIS2(-8, cxFloat4, cxFloat5);
                stream2.wr(this.vo);
            }
            return 0;
        }

        @Override
        public int close() {
            this.halo.state = 0;
            return 0;
        }
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(1);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(1);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(1);
        }
    }
}

