/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.core.Filters;
import nxm.ice.lib.Core;
import nxm.ice.lib.CoreCommon;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class DUC
extends CoreFactory {
    public static final int NP = 1;
    public static final int BW = 32;
    public static final int FLOW = 1;
    public static final int OTAP = 5;
    public static final int RTAP = 32;
    public static final int PTAP = 16;
    public static final int OFILT = 7;
    public static final int NFILT = 128;
    public static final int FPS = 15;
    public static final int MAXMON = 1048575;
    public static final int MAXCR = 250000000;
    public static final int IKR = 8;
    public static final int OKR = 4;
    public static final String flgList = "Bypass,CTXF,Debug";
    public static final int PF_BYPASS = 0;
    public static final int PF_CTXF = 1;
    public static final int PF_DEBUG = 2;

    public static class CORE
    extends Core {
        public double fS;
        public double fSi;
        public double tOff;
        public double fbwf;
        public double fbwn;
        public double fC;
        public int ups;
        public int bups;
        public boolean mute;
        public boolean isFPGA;
        double ps;
        double dps;
        double p;
        double dp;
        float fscl;
        float lfps;
        int ntap;
        int nrpt;
        int mrpt;
        CoreComponent.CxTapBuf vd;
        CoreComponent.RomF2Di rft;
        int imon;
        int mmon;
        int ovsr;
        int cper;
        int cperi;
        int cups;
        int ifS;
        int flags;
        int upds;

        public int findMoN(double d) {
            if (d < 1.0E-4) {
                return 0;
            }
            for (int i = 2; i < 524288; ++i) {
                double d2 = d * (double)i;
                double d3 = CORE.fabs(d2 - CORE.round(d2));
                if (!(d3 < 1.0E-12)) continue;
                return i;
            }
            return 0;
        }

        public void setDPS() {
            double d = this.dps;
            double d2 = this.dps * this.fS / (double)this.ovsr;
            if ((this.halo.vbpr & 2) != 0) {
                System.out.printf("DUC fs=%f mon=%d\n", this.fS, this.findMoN(d));
            }
            this.mmon = 0;
            this.dps = CORE.dptx2d(CORE.d2dptx(this.dps));
            this.fSi = this.dps * this.fS / (double)this.ovsr;
            if (this.fSi != d2) {
                this.mmon = this.findMoN(d);
                if (this.mmon > 1) {
                    double d3 = CORE.frac(this.dps * (double)this.mmon);
                    if (d3 > 0.5) {
                        this.dps = CORE.dptx2d(CORE.d2dptx(this.dps) + 4L);
                        d3 = CORE.frac(this.dps * (double)this.mmon);
                        this.fSi = this.dps * this.fS / (double)this.ovsr;
                    }
                    if (d3 > 0.001 && this.fSi != d2) {
                        System.out.printf("DUC fS=%18.9f fSi=%18.9f fActual=%18.9f MoN=%d perr=%8.6f\n", this.fS, d2, this.fSi, this.mmon, d3);
                    }
                    this.fSi = d * this.fS / (double)this.ovsr;
                } else {
                    System.out.printf("DUC fS=%18.9f fSi=%18.9f fActual=%18.9f\n", this.fS, d2, this.fSi);
                }
            }
            this.mmon = this.mmon == 0 ? 0 : this.mmon - 1;
            this.putVars("dps,mmon");
        }

        public void setRate(double d) {
            if (d > 5.0E8) {
                System.out.printf("Desired sample rate = %f limited to max supported rate of %d\n", d, 500000000);
                d = 5.0E8;
            }
            this.ups = d > 2.5E8 ? 2 : 1;
            this.fS = d / (double)this.ups;
        }

        public void setRateIn(double d) {
            this.fSi = d;
        }

        public void setCUPS(int n) {
            this.cups = n >= 0 ? n : (this.mute ? 0 : this.bups + 2);
            this.putVars("cups");
        }

        public void setMute(int n) {
            this.mute = n != 0;
            this.setCUPS(-1);
        }

        public void setFcny(double d) {
            this.bups = 0;
            this.dp = d;
            if (this.ups == 2) {
                if (d < -0.125) {
                    this.bups = -1;
                    this.dp = (d + 0.25) * (double)this.ups;
                } else if (d < 0.125) {
                    this.bups = 0;
                    this.dp = (d - 0.0) * (double)this.ups;
                } else {
                    this.bups = 1;
                    this.dp = (d - 0.25) * (double)this.ups;
                }
            }
            if (d < -0.5 || d > 0.5) {
                this.bups = 0;
            }
            if (this.isFPGA) {
                this.dp = CORE.dptx2d(CORE.d2dptx(this.dp));
            }
            this.cups = this.mute ? 0 : this.bups + 2;
            this.fC = (this.dp / (double)this.ups + (double)this.bups * 0.25) * this.fS * (double)this.ups;
            this.putVars("dp,cups");
        }

        public void setFreq(double d) {
            this.setFcny(d / (this.fS * (double)this.ups));
        }

        public void setGain(double d) {
            this.fscl = CORE.d2f(CORE.pow(2.0, d / 6.0) * this.fbwf / 15.0);
            this.putVars("fscl");
        }

        public void setCTXF(boolean bl) {
            this.flags = CORE.setBit(this.flags, 1, bl);
        }

        public void setFilterWidth(double d) {
            this.fbwn = d;
        }

        public void setFeedRate(double d) {
            this.fSi = d;
        }

        public void genFilt() {
            int n = this.nrpt * this.ntap;
            double d = this.fbwn * this.fbwf;
            float f = CORE.d2f((double)(this.nrpt * 15) / d);
            float[] fArray = new float[n * 2];
            Filters.genFirKais(1, d / (double)this.nrpt, 0.0, 0.05 / (double)this.nrpt, 90.0, fArray, n);
            int n2 = 0;
            for (int i = 0; i < this.ntap; ++i) {
                int n3 = 0;
                while (n3 < this.nrpt) {
                    this.rft.set(n3, i, fArray[n2] * f);
                    ++n3;
                    n2 += 2;
                }
            }
        }

        @Override
        public int init() {
            this.ups = 1;
            this.fbwf = 1.0;
            this.fbwn = 1.0;
            this.fS = -1.0;
            this.dp = 0.0;
            this.dps = 0.25;
            this.tOff = 0.0;
            this.fscl = -1.0f;
            this.ntap = -1;
            this.ovsr = 1;
            this.fSi = -1.0;
            this.isFPGA = this.halo.impl >= 5;
            return 0;
        }

        @Override
        public int set(String string, CoreComponent.Value value) {
            if (this.isMatch(string, "D:FS")) {
                this.setRate(value.toD());
            } else if (this.isMatch(string, "D:FSO")) {
                this.setRate(value.toD());
            } else if (this.isMatch(string, "D:FREQ")) {
                this.setFreq(value.toD());
            } else if (this.isMatch(string, "D:COFF")) {
                this.setFreq(value.toD());
            } else if (this.isMatch(string, "D:FCNY")) {
                this.setFcny(value.toD());
            } else if (this.isMatch(string, "D:FSI")) {
                this.setRateIn(value.toD());
            } else if (this.isMatch(string, "D:FSYM")) {
                this.setRateIn(value.toD());
            } else if (this.isMatch(string, "D:BAUD")) {
                this.setRateIn(value.toD());
            } else if (this.isMatch(string, "D:FBWF")) {
                this.fbwf = value.toD();
            } else if (this.isMatch(string, "D:TOFF")) {
                this.tOff = value.toD();
            } else if (this.isMatch(string, "L:NTAP")) {
                this.ntap = value.toL();
            } else if (this.isMatch(string, "D:GAIN")) {
                this.setGain(value.toD());
            } else if (this.isMatch(string, "L:GAIN")) {
                this.setGain(value.toD());
            } else if (this.isMatch(string, "L:CUPS")) {
                this.setCUPS(value.toL());
            } else if (this.isMatch(string, "L:MUTE")) {
                this.setMute(value.toL());
            } else {
                return super.set(string, value);
            }
            return 0;
        }

        @Override
        public int get(String string, CoreComponent.Value value) {
            if (this.isMatch(string, "D:FS")) {
                value.fromD(this.fS);
            } else if (this.isMatch(string, "D:FSO")) {
                value.fromD(this.fS);
            } else if (this.isMatch(string, "D:FSI")) {
                value.fromD(this.fSi);
            } else if (this.isMatch(string, "D:FSYM")) {
                value.fromD(this.fSi);
            } else if (this.isMatch(string, "D:FREQ")) {
                value.fromD(this.dp * this.fS);
            } else if (this.isMatch(string, "D:XDO")) {
                value.fromD(1.0 / this.fS);
            } else {
                return super.get(string, value);
            }
            return 0;
        }

        @Override
        public int open() {
            if (this.fSi < 0.0) {
                this.fSi = 1000000.0;
            }
            if (this.fS < 0.0) {
                this.fS = this.fSi;
            }
            this.dps = this.fSi * (double)this.ovsr / this.fS;
            this.setDPS();
            this.cper = CORE.imax(1, CORE.imin(2, CORE.d2i(2.5E8 / this.fS)));
            if (this.ntap <= 0) {
                this.ntap = CORE.imin(32, 16 * this.cper);
            }
            if (this.ntap > 32) {
                System.out.printf("Warn ntap=%d limited to ntap=%d for this compile\n", this.ntap, 32);
                this.ntap = 32;
            }
            this.cper = (this.ntap + 16 - 1) / 16;
            if (this.fS > (double)(250000000 / this.cper)) {
                System.out.printf("Number taps=%d at fS=%f too large for FPGA load NP=%d PTAP=%d RTAP=%d\n", this.ntap, this.fS, 1, 16, 32);
            }
            int n = 16 * this.cper;
            this.cperi = this.cper;
            if (this.fscl < 0.0f) {
                this.setGain(-3.0);
            }
            this.nrpt = 128;
            this.mrpt = this.nrpt - 1;
            this.vd = new CoreComponent.CxTapBuf(5, 1, 16, 0);
            this.vd.setLength(this.ntap);
            this.rft = new CoreComponent.RomF2Di(7, 5, 16);
            this.genFilt();
            this.lfps = 1.0f;
            this.ps = 0.0;
            this.p = 0.0;
            this.imon = 1;
            this.ifS = CORE.d2i(this.fS);
            this.flags = CORE.setBit(this.flags, 0, this.dps == 1.0);
            if ((this.halo.vbpr & 1) != 0) {
                System.out.printf("DUC fSi=%f fS=%f fbwn=%f fbwf=%f fscl=%f mmon=%d ntap=%d cper=%d ups=%d flags=%x NP=%d\n", this.fSi, this.fS, this.fbwn, this.fbwf, Float.valueOf(this.fscl), this.mmon, this.ntap, this.cper, this.ups, this.flags, 1);
            }
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Stream stream, CoreComponent.Stream stream2) {
            CoreCommon.CxFloat cxFloat = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cxFloat2 = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cxFloat3 = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cxFloat4 = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cxFloat5 = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cxFloat6 = CoreCommon.CxFloat.stk();
            boolean bl = CORE.getBit(this.flags, 0) && !CORE.getBit(this.flags, 1);
            boolean bl2 = CORE.getBit(this.flags, 1);
            boolean bl3 = this.mmon == 1048575;
            boolean bl4 = this.mmon > 0;
            stream2.setC(this.cups);
            if (bl) {
                while (stream.rok && stream2.wok) {
                    int n = stream.rdL();
                    stream2.wrL(n);
                }
            } else {
                while (stream.rok && stream2.wok && (!bl2 || stream.getC() <= 1)) {
                    float f = CORE.fracf(CORE.d2f(this.ps));
                    this.ps = bl4 && this.imon == 0 ? 0.0 : CORE.frac(this.ps + this.dps);
                    int n = this.imon = this.imon >= this.mmon ? 0 : this.imon + 1;
                    this.mmon = this.mmon != 1048575 ? this.mmon : (this.imon >= 1048575 ? 0 : (this.imon > 2 && CORE.d2dptx(this.ps) < 8L ? this.imon - 2 : this.mmon));
                    boolean bl5 = f <= this.lfps;
                    this.lfps = f;
                    if (bl5) {
                        stream.rdCIF(cxFloat3);
                        this.vd.load(cxFloat3);
                    }
                    float f2 = this.lfps;
                    cxFloat2.x = 0.0f;
                    cxFloat2.y = 0.0f;
                    for (int i = 0; i < this.ntap; ++i) {
                        float f3;
                        CoreCommon.CxFloat cxFloat7 = CoreCommon.CxFloat.stk();
                        CoreCommon.CxFloat cxFloat8 = CoreCommon.CxFloat.stk();
                        float f4 = f3 = this.rft.getrN(f2, i);
                        this.vd.get(i, cxFloat8);
                        cxFloat7 = cxFloat8;
                        cxFloat2.x += f4 * cxFloat7.x;
                        cxFloat2.y += f4 * cxFloat7.y;
                    }
                    cxFloat4 = cxFloat2;
                    float f5 = CORE.d2f(this.p);
                    this.p = CORE.frac(this.p + this.dp);
                    CORE.sincoscf(f5, cxFloat);
                    CORE.mulcc(cxFloat4, cxFloat, cxFloat5);
                    CORE.mulcf(cxFloat5, this.fscl, cxFloat6);
                    stream2.wrCFI(cxFloat6);
                }
                while (stream.rok && bl2 && stream.getC() > 1) {
                    int n = stream.getC();
                    int n2 = stream.rdL();
                    System.out.printf("Got chn=%d dat=%d at %d\n", n, n2, 0);
                    if (n == 3 || n == 4 || n == 10) {
                        double d = CORE.divii(n2, this.ifS);
                        if (n == 3) {
                            this.dp = d;
                            if ((this.halo.vbpr & 1) != 0) {
                                System.out.printf("DUC  Ctx chn=%d IF=%d dp=%x\n", n, n2, CORE.d2x(d));
                            }
                        }
                        if (n == 4) {
                            this.dp = d;
                            if ((this.halo.vbpr & 1) != 0) {
                                System.out.printf("DUC  Ctx chn=%d RF=%d dp=%x\n", n, n2, CORE.d2x(d));
                            }
                        }
                        if (n == 10) {
                            this.dps = CORE.dptx2d(CORE.d2dptx(d) + 1L);
                            this.mmon = 1048575;
                            this.imon = 0;
                            if ((this.halo.vbpr & 1) != 0) {
                                System.out.printf("DUC  Ctx chn=%d SR=%d dp=%x\n", n, n2, CORE.d2x(d));
                            }
                        }
                    }
                    if (n == 8 && (this.halo.vbpr & 1) != 0) {
                        System.out.printf("DUC  Ctx chn=%d GAIN=%d fscl=%x\n", n, n2, CORE.f2x(this.fscl));
                    }
                    this.upds = CORE.setBits(this.upds, 15, 0, CORE.getBits(this.upds, 15, 0) + 1);
                    if (n > 2) {
                        this.upds = CORE.setBits(this.upds, 31, 16, n);
                    }
                    this.upds = this.upds;
                }
            }
            return 0;
        }

        @Override
        public int close() {
            this.halo.state = 0;
            return 0;
        }

        @Override
        public int poll() {
            this.getVars("upds");
            if ((this.halo.vbpr & 2) != 0) {
                System.out.printf("DUC upds=%08x\n", this.upds);
            }
            return 1;
        }
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(1);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(1);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(1);
        }
    }
}

