/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.lib.Core;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class AU2C
extends CoreFactory {

    public static class CORE
    extends Core {
        public static final int FLOW = 2;
        public static final int BW = 64;
        public static final int RW = 12;
        public static final int CW = 6;
        public static final int NHDR = 64;
        public static final int NPKT = 2432;
        public static final int NPKTI = 2432;
        public static final int NCFG = 64;
        public static final int NOVR = 4000;
        public static final int NRAM = 4096;
        public static final int MRAM = 4095;
        public static final int NCRP = 270;
        public static final int NCRV = 260;
        public static final int NROW = 9;
        public static final int NVRC = 783;
        public static final int NOUT = 2340;
        public static final int NTOT = 2496;
        public static final int NTOTI = 2496;
        public static final int SFIL = 2400;
        public static final int SOVH = 2416;
        public static final int MAXDMAI = 272;
        public static final int MAXDMAO = 264;
        public int func;
        public int dec;
        public int chn;
        public int imd;
        public byte pkt;
        public byte tag;
        public byte ntag;
        public byte mtag;
        public int nfpp;
        public int itag;
        public int ncfg;
        public int itl;
        public int otl;
        public int ofs;
        public int dfs;
        public int ipkt;
        public int opkt;
        public int novh;
        static final int[] NCRPS = new int[]{270, 1080, 4320, 17280};
        static final int[] NCRVS = new int[]{260, 1040, 4160, 16640};
        static final int[] DMINS = new int[]{120, 120, 160, 640};
        ChannelState[] csa;
        CoreComponent.RamRWC ram;
        CoreComponent.RamRWC rov;
        CoreComponent.RamRWC rop;
        CoreComponent.Dma dmar;
        CoreComponent.Dma dmaw;

        @Override
        public int init() {
            this.itl = 2496;
            this.otl = 4992;
            this.ofs = 2496;
            this.dec = 1;
            return 0;
        }

        public void setFunction(CoreComponent.Value value) {
        }

        public void setConfigFile(CoreComponent.Value value) {
        }

        @Override
        public int set(String string, CoreComponent.Value value) {
            if (this.isMatch(string, "S:FUNCTION")) {
                this.setFunction(value);
            } else if (this.isMatch(string, "L:CONFIG")) {
                this.setConfigFile(value);
            } else if (this.isMatch(string, "L:CHN")) {
                this.chn = value.toL();
            } else if (this.isMatch(string, "L:FLAGS")) {
                this.halo.flag = value.toL();
            } else {
                return super.set(string, value);
            }
            return 0;
        }

        @Override
        public int get(String string, CoreComponent.Value value) {
            if (this.isMatch(string, "L:NCFG")) {
                value.fromL(this.ncfg);
            } else if (this.isMatch(string, "L:ITL")) {
                value.fromL(this.itl);
            } else if (this.isMatch(string, "L:OTL")) {
                value.fromL(this.otl);
            } else if (this.isMatch(string, "L:OFS")) {
                value.fromL(this.ofs);
            } else if (this.isMatch(string, "L:DEC")) {
                value.fromL(this.dec);
            } else {
                return super.get(string, value);
            }
            return 0;
        }

        @Override
        public int open() {
            this.csa = new ChannelState[64];
            for (int i = 0; i < 64; ++i) {
                this.csa[i] = new ChannelState();
            }
            this.ram = new CoreComponent.RamRWC(12, 64, 64, 6);
            this.rov = new CoreComponent.RamRWC(4, 64, 8, 6);
            this.rop = new CoreComponent.RamRWC(12, 64, 64, 1);
            this.dmar = new CoreComponent.Dma(12, 64);
            this.dmaw = new CoreComponent.Dma(12, 64);
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Buffer buffer, CoreComponent.Buffer buffer2) {
            boolean bl;
            int n = 0;
            int n2 = 0;
            int n3 = this.halo.flag;
            long l = buffer.getX(n2);
            this.ipkt = CORE.getBits(l, 63, 32);
            l = CORE.setBits(l, 63, 32, (long)this.opkt);
            buffer2.setX(n2, l);
            l = buffer.getX(n2 += 8);
            buffer2.setX(n2, l);
            long l2 = l;
            n2 += 8;
            int n4 = CORE.getBits(l, 39, 32);
            int n5 = CORE.getBits(l, 53, 48);
            int n6 = CORE.getBits(l, 59, 56);
            int n7 = CORE.getBits(l, 63, 60);
            int n8 = n6 - 1;
            boolean bl2 = n7 == 0 || n7 == 2 || CORE.getBits(n3, 4, 4) != 0;
            boolean bl3 = bl = this.novh >= 2340;
            while (n2 < 64) {
                l = buffer.getX(n2);
                buffer2.setX(n2, l);
                n2 += 8;
            }
            boolean bl4 = true;
            boolean bl5 = false;
            if (bl2) {
                while (n2 < 2496) {
                    l = buffer.getX(n2);
                    buffer2.setX(n2, l);
                    n2 += 8;
                }
                bl5 = true;
            } else if (bl) {
                l2 = CORE.setBits(l2, 63, 32, -1879048192L);
                buffer2.setX(8, l2);
                this.dmaw.r2b(this.rop, 0, buffer2, 64, 2432);
                this.novh = 0;
                bl4 = false;
                bl5 = true;
            } else if (n7 != 1) {
                boolean bl6;
                boolean bl7;
                this.ram.setC(n5);
                this.rov.setC(n5);
                int n9 = n8 << 1;
                int n10 = 1 << n9;
                int n11 = n10 - 1;
                int n12 = n4 & n11;
                int n13 = 3 << n9;
                ChannelState channelState = this.csa[n5];
                int n14 = channelState.oram;
                int n15 = channelState.iram;
                int n16 = channelState.olen;
                int n17 = channelState.ilen;
                int n18 = channelState.orow;
                int n19 = channelState.irow;
                int n20 = channelState.ptr;
                int n21 = channelState.cnt;
                int n22 = channelState.smd;
                CoreComponent.Dma.addReader(buffer);
                CoreComponent.Dma.addReader(this.ram);
                int n23 = NCRPS[n8];
                int n24 = NCRVS[n8];
                int n25 = DMINS[n8] + 264;
                int n26 = n15 - n14;
                bl5 = n26 > n25 && n26 < 4096;
                int n27 = 192;
                int n28 = 64;
                int n29 = 2496;
                if (n12 == 0) {
                    n19 = 0;
                    n17 = 0;
                }
                if (n12 == 57 && n8 == 3) {
                    n28 += n27;
                }
                if (n12 == n11) {
                    n29 -= 2 << n9;
                }
                int n30 = 64;
                int n31 = 2404;
                l = 0L;
                for (n2 = 2400; n2 < 2496; n2 += 8) {
                    buffer2.setX(n2, l);
                }
                do {
                    boolean bl8 = bl7 = n28 < n29;
                    if (n17 > 0 && bl7) {
                        n27 = n29 - n28;
                        if (n17 < n27) {
                            n27 = n17;
                        }
                        if (n27 > 272) {
                            n27 = 272;
                        }
                        if ((this.halo.vbpr & 1) != 0) {
                            System.out.printf("DMAi chn=%d row=%d adr=%x ram=%x xfer=%d smd=%d\n", n5, n19, n28, n15, n27, n22);
                        }
                        if (n22 > 1) {
                            CORE cORE = this;
                            cORE.dmar.sync();
                            this.dmar.b2r(buffer, n28, this.ram, n15, n27);
                            n15 += n27;
                        }
                        n28 += n27;
                        n17 -= n27;
                    }
                    bl7 = n28 < n29;
                    int n32 = n31 - n30;
                    if (n16 > 0 && n32 > 0 && bl5) {
                        if (n16 < n32) {
                            n32 = n16;
                        }
                        if (n32 > 264) {
                            n32 = 264;
                        }
                        if ((this.halo.vbpr & 1) != 0) {
                            System.out.printf("DMAo chn=%d row=%d adr=%x ram=%x olen=%d xfer=%d\n", n5, n18, n30, n14, n16, n32);
                        }
                        CORE cORE = this;
                        cORE.dmaw.sync();
                        this.dmaw.r2b(this.ram, n14, buffer2, n30, n32);
                        n14 += n32;
                        n30 += n32;
                        n16 -= n32;
                    }
                    if (n17 == 0 && bl7) {
                        int n33 = 9;
                        if (n19 == 3) {
                            boolean bl9 = false;
                            int n34 = n28 + n13;
                            byte by = buffer.getB(n28);
                            n = CORE.setBits(n, 9, 8, (int)by);
                            int n35 = CORE.getBits(by, 7, 4);
                            by = buffer.getB(n34);
                            n = CORE.setBits(n, 7, 0, (int)by);
                            int n36 = n ^ n20;
                            int n37 = CORE.getBits(n36, 0, 0) + CORE.getBits(n36, 2, 2) + CORE.getBits(n36, 4, 4) + CORE.getBits(n36, 6, 6) + CORE.getBits(n36, 8, 8);
                            int n38 = CORE.getBits(n36, 1, 1) + CORE.getBits(n36, 3, 3) + CORE.getBits(n36, 5, 5) + CORE.getBits(n36, 7, 7) + CORE.getBits(n36, 9, 9);
                            if (n36 == 0) {
                                if (n22 < 5) {
                                    ++n22;
                                }
                                bl9 = n22 == 2;
                            } else if (n35 == 9) {
                                if (n22 > 2) {
                                    n22 = 2;
                                }
                                n20 = n;
                                bl9 = true;
                            } else if (n22 < 2) {
                                n20 = n;
                            } else if (n38 > 2) {
                                n33 = 12;
                                if (++n20 == 783) {
                                    n20 = 0;
                                }
                            } else if (n37 > 2) {
                                n33 = 6;
                                n20 = n20 == 0 ? 782 : --n20;
                            } else if (n22 > 0) {
                                if (--n22 == 2) {
                                    n22 = 0;
                                }
                                if (n22 == 0) {
                                    bl9 = true;
                                }
                            }
                            int n39 = n20 * n13;
                            if ((this.halo.vbpr & 1) != 0) {
                                System.out.printf("pMode=%x nPtr=%x Ptr=%x chn=%d typ=%d smd=%d iadr=%x\n", n35, n, n20, n5, n7, n22, n28);
                            }
                            if (bl9) {
                                bl5 = false;
                                n15 = 0;
                                n14 = n39;
                                n18 = 0;
                                n21 = 0;
                                n16 = 0;
                            }
                        }
                        int n40 = 270 - n33;
                        n28 += n33 << n9;
                        ++n19;
                        n17 = n40 << n9;
                    }
                    boolean bl10 = bl6 = n30 < n31 && bl5;
                    if (n16 != 0 || !bl6) continue;
                    byte by = this.ram.rdB(n14);
                    n14 += n10;
                    n16 = n24;
                    this.rov.wrB(++n18, by);
                } while (bl7 || bl6);
                if (bl5) {
                    CORE cORE = this;
                    cORE.dmaw.sync();
                    l2 = CORE.setBits(l2, 47, 32, (long)n21);
                    buffer2.setX(8, l2);
                    n21 = n21 + 1 & n11;
                    if (n21 == 0) {
                        this.rov.wrB(0, n5);
                        this.dmaw.r2b(this.rov, 1, buffer2, 2416, 9);
                        CORE cORE2 = this;
                        cORE2.dmaw.sync();
                        this.dmaw.r2r(this.rov, 0, this.rop, this.novh, 10);
                        this.novh += 10;
                        n18 = 0;
                    }
                }
                channelState.oram = n14;
                channelState.iram = n15;
                channelState.olen = n16;
                channelState.ilen = n17;
                channelState.orow = n18;
                channelState.irow = n19;
                channelState.ptr = n20;
                channelState.cnt = n21;
                channelState.smd = n22;
                this.csa[n5] = channelState;
            }
            CORE cORE = this;
            cORE.dmar.sync();
            if (bl4) {
                buffer.rnxt(2496);
            }
            CORE cORE3 = this;
            cORE3.dmaw.sync();
            if (bl5) {
                buffer2.wnxt(2496);
                ++this.opkt;
            }
            return 0;
        }

        @Override
        public int close() {
            this.halo.state = 0;
            return 0;
        }
    }

    public static class ChannelState
    extends CoreFactory.TypeDef {
        int smd;
        int cnt;
        int ptr;
        int irow;
        int orow;
        int ilen;
        int olen;
        int iram;
        int oram;
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(2);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(2);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(2);
        }
    }
}

