/*
 * Decompiled with CFR 0.152.
 */
package nxm.dsp.test;

import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;

@ProvisionalUseOnly(value="This has been minimally tested and verified against reliable data. It is currently primarily intended for educational purposes")
public class raisedcos
extends Primitive {
    public static final int MAXTAPS = 131071;
    public static final int DEFTAPS = 1025;
    private DataFile ho;
    private Data data;
    private int ntap;
    private boolean debug;
    private int symbolLength;
    private int span;
    private double rollOff;
    private boolean normalize;
    transient double pi_invT;

    public int open() {
        this.debug = this.MA.getState("/DEBUG");
        this.ho = this.MA.getDataFile("OUT", "1000", "SF", 0);
        this.ho.open(2);
        this.rollOff = this.MA.getD("ROLLOFF", this.MA.getD("BETA"));
        this.symbolLength = this.MA.getL("SYMBOLLENGTH", this.MA.getL("T", 1));
        this.span = this.MA.getL("SPAN", 1);
        this.ntap = this.symbolLength * this.span + 1;
        this.normalize = !this.MA.isPresent("/NONORM");
        this.data = new Data("SF", this.ntap);
        if (this.debug) {
            System.out.println("ntap: " + this.ntap);
            System.out.println("rollOff: " + this.rollOff);
            System.out.println("symbol length: " + this.symbolLength);
        }
        this.pi_invT = Math.PI / (double)this.symbolLength;
        this.raisedCos();
        this.ho.setSize((double)this.ntap);
        this.ho.write(this.data, this.ntap);
        this.ho.close();
        return 9;
    }

    private void raisedCos() {
        float[] outbuf = this.data.castF(false);
        double rollOffPIinvT = this.rollOff * this.pi_invT;
        double invT = 1.0 / (double)this.symbolLength;
        double twoRollOffInvT_squared = Math.pow(2.0 * this.rollOff * invT, 2.0);
        double specialCaseValue = raisedcos.specialRaisedCosCase(this.rollOff, this.symbolLength);
        int center = this.ntap / 2;
        double sum = 0.0;
        for (int n = 0; n < this.ntap; ++n) {
            int shiftedN = n - center;
            double divisor = 1.0 - (double)(shiftedN * shiftedN) * twoRollOffInvT_squared;
            if (Math.abs(divisor) > 1.0E-6) {
                double cosComponent = Math.cos((double)shiftedN * rollOffPIinvT);
                double sincComponent = this.sincT(shiftedN);
                outbuf[n] = (float)(invT * sincComponent * cosComponent / divisor);
                if (this.debug) {
                    this.showAllPartsOfCalc(n, shiftedN, invT, cosComponent, divisor, sincComponent, outbuf[n]);
                }
            } else {
                outbuf[n] = (float)specialCaseValue;
            }
            sum += (double)outbuf[n];
        }
        if (this.normalize) {
            int i = 0;
            while (i < this.ntap) {
                int n = i++;
                outbuf[n] = (float)((double)outbuf[n] / sum);
            }
        }
        this.data.uncast(outbuf, true);
    }

    private double sincT(int n) {
        if (Math.abs((double)n / (double)this.symbolLength) < 1.0E-6) {
            return 1.0;
        }
        double sinc = Math.sin((double)n * this.pi_invT) / ((double)n * this.pi_invT);
        return sinc;
    }

    private static double sinc(double t) {
        if (t < 1.0E-7) {
            return 1.0;
        }
        double sinc = Math.sin(t * Math.PI) / (t * Math.PI);
        return sinc;
    }

    private static double specialRaisedCosCase(double rollOff, int T) {
        return Math.PI / (double)(4 * T) * raisedcos.sinc(1.0 / (2.0 * rollOff));
    }

    private void showAllPartsOfCalc(int n, int shiftedN, double invT, double cosComponent, double divisor, double sincComponent, float tap) {
        System.out.println("n:" + n + " shiftedN:" + shiftedN + " raisedCos = ((1/T) * sinc((n-center)/T) * cos(PI*rollOff*(n-center)/T) / (1-(2*rollOff*(n-center)/T)");
        System.out.println("sinc component:" + sincComponent);
        System.out.println("cos component:" + cosComponent);
        System.out.println("numerator = " + invT + " * " + sincComponent + " * " + cosComponent + " = " + invT * sincComponent * cosComponent);
        System.out.println("divisor:" + divisor);
        System.out.println("tap value:" + tap);
    }
}

