/*
 * Decompiled with CFR 0.152.
 */
package nxm.dsp.test;

import java.util.Arrays;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;

@ProvisionalUseOnly(value="This was created for educational purposes and has been minimally tested")
public class movingaverage
extends Primitive {
    private DataFile inFile;
    private DataFile outFile;
    private Data dataBuffer;
    private Data outBuffer;
    private int length;
    private float[] previous;
    private float savedOutput;
    private int previousToFill;
    private boolean debug;

    public int open() {
        this.inFile = this.MA.getDataFile("IN", "1000", "S#", 0);
        this.inFile.open();
        this.outFile = this.MA.getDataFile("OUT", this.inFile, 0);
        this.outFile.open();
        this.length = this.MA.getL("LENGTH", 101);
        this.previous = new float[this.length];
        this.previousToFill = this.length - 1;
        int xfer = this.MA.getL("/TL", 1024);
        this.dataBuffer = this.inFile.getDataBuffer(xfer, (byte)68);
        this.outBuffer = this.outFile.getDataBuffer(xfer, (byte)68);
        this.debug = this.MA.find("/DEBUG");
        return 0;
    }

    public int process() {
        int status = 0;
        int numRead = this.inFile.read(this.dataBuffer);
        if (numRead < 0) {
            status = 9;
        } else if (numRead == 0) {
            status = -1;
        } else {
            int numOutput = this.performMovingAverage(numRead);
            if (numOutput > 0) {
                this.outFile.write(this.outBuffer, numOutput);
            }
        }
        return status;
    }

    private int performMovingAverage(int numRead) {
        int i;
        float[] fbuf = this.dataBuffer.castF(true);
        float[] outBuf = this.outBuffer.castF(false);
        int numOutput = numRead;
        int numFilling = Math.min(numRead, this.previousToFill);
        if (!(this.previousToFill <= 0 || this.fillInitialPreviousBuffer(fbuf, numFilling) && (numOutput -= this.previousToFill) != 0)) {
            return 0;
        }
        outBuf[0] = this.savedOutput + (fbuf[numFilling] - this.previous[0]) / (float)this.length;
        if (this.debug) {
            System.out.println("first output:" + outBuf[0] + "= savedOutput:" + this.savedOutput + " + (fbuf[" + numFilling + "] - previous[0]) / length:" + this.length);
        }
        int numPreviousToUse = Math.min(this.length, numOutput);
        for (i = 1; i < numPreviousToUse; ++i) {
            outBuf[i] = outBuf[i - 1] + (fbuf[i + numFilling] - this.previous[i]) / (float)this.length;
        }
        for (i = this.length; i < numOutput; ++i) {
            outBuf[i] = outBuf[i - 1] + (fbuf[i + numFilling] - fbuf[i - this.length + numFilling]) / (float)this.length;
        }
        this.savedOutput = outBuf[numOutput - 1];
        int numPreviousUnused = this.length - numPreviousToUse;
        if (numPreviousUnused > 0) {
            System.arraycopy(this.previous, numPreviousToUse, this.previous, 0, numPreviousUnused);
        }
        System.arraycopy(fbuf, numRead - (this.length - numPreviousUnused), this.previous, numPreviousUnused, numPreviousToUse);
        this.outBuffer.uncast(outBuf, true);
        return numOutput;
    }

    private boolean fillInitialPreviousBuffer(float[] fbuf, int numFilling) {
        int i;
        boolean filled = false;
        int startFillIndex = this.length - this.previousToFill;
        int fbufIdx = 0;
        for (i = startFillIndex; i < numFilling + startFillIndex; ++i) {
            this.previous[i] = fbuf[fbufIdx++];
        }
        startFillIndex += numFilling;
        this.previousToFill -= numFilling;
        if (this.previousToFill == 0) {
            this.savedOutput = 0.0f;
            for (i = 1; i < this.length; ++i) {
                this.savedOutput += this.previous[i];
            }
            this.savedOutput /= (float)this.length;
            filled = true;
            if (this.debug) {
                System.out.println("previous buffer initialized - saved output:" + this.savedOutput + " previous:" + Arrays.toString(this.previous));
            }
        }
        return filled;
    }

    public int close() {
        this.inFile.close();
        this.outFile.close();
        return 0;
    }
}

