/*
 * Decompiled with CFR 0.152.
 */
package nxm.dsp.test;

import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;
import nxm.sys.libm.Window;

@ProvisionalUseOnly(value="Created for educational purposed and minimally tested")
public class firsinc
extends Primitive {
    public static final String typeList = "LowPass,HighPass,BandPass";
    public static final int LOW = 1;
    public static final int HIGH = 2;
    public static final int BAND = 3;
    public static final int MAXTAPS = 131071;
    public static final int DEFTAPS = 1025;
    private DataFile ho;
    private Data dbw;
    private int type;
    private int ntap;
    boolean debug;
    boolean inref;
    boolean cmplx;
    private double freqCutoff;
    private double bandwidth;
    private String windowName;
    private float[] window;
    private boolean normalize;

    public int open() {
        this.debug = this.MA.getState("/DEBUG");
        this.freqCutoff = this.MA.getD("FREQ");
        this.ho = this.MA.getDataFile("OUT", "1000", "SF", 0);
        this.ho.open(2);
        if (this.MA.isPresent("NTAPS") || !this.MA.isPresent("/BW")) {
            this.ntap = this.MA.getL("NTAPS", 1025);
            if (this.ntap > 131071) {
                this.M.warning((CharSequence)"Maximum number of taps exceeded. Using default maximum of 131071");
                this.ntap = 131071;
            } else if (this.ntap % 2 == 0) {
                ++this.ntap;
                this.M.info((CharSequence)("Adjusting number of taps to odd number:" + this.ntap));
            }
        } else {
            this.bandwidth = this.MA.getD("/BW", 0.003902439024390244);
            this.ntap = (int)(4.0 / this.bandwidth + 1.0);
            if (this.ntap % 2 == 0) {
                ++this.ntap;
            }
        }
        this.windowName = this.MA.getS("WIND", "BLAC");
        this.window = Window.get((String)this.windowName, (int)this.ntap, (double)1.0);
        this.normalize = !this.MA.isPresent("/NONORM");
        this.dbw = new Data("SF", this.ntap);
        if (this.debug) {
            System.out.println("ntap: " + this.ntap);
            System.out.println("type: " + this.type);
            System.out.println("freqC: " + this.freqCutoff);
            System.out.println("bandW: " + this.bandwidth);
        }
        this.sincwin(this.dbw, this.freqCutoff, this.ntap);
        this.ho.setSize((double)this.ntap);
        this.ho.write(this.dbw, this.ntap);
        this.ho.close();
        return 9;
    }

    private void sincwin(Data odata, double freqCutoff, int ntaps) {
        int i;
        float[] outbuf = odata.castF(false);
        double twoPI = Math.PI * 2;
        int center = (ntaps - 1) / 2;
        double twoPITimesFreqC = twoPI * freqCutoff;
        double sum = 0.0;
        for (i = 0; i < ntaps; ++i) {
            outbuf[i] = i != center ? (float)(Math.sin(twoPITimesFreqC * (double)(i - center)) / (double)(i - center) * (double)this.window[i]) : (float)twoPITimesFreqC;
            sum += (double)outbuf[i];
        }
        if (this.normalize) {
            i = 0;
            while (i < ntaps) {
                int n = i++;
                outbuf[n] = (float)((double)outbuf[n] / sum);
            }
        }
        odata.uncast(outbuf, true);
        this.ntap = ntaps;
    }
}

