/*
 * Decompiled with CFR 0.152.
 */
package nxm.dsp.prim;

import nxm.sys.inc.Chainable;
import nxm.sys.lib.Args;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.MPULib;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Primitive;

public class demod
extends Primitive
implements Chainable {
    public String modeList;
    public String algList;
    private int mode;
    private int alg;
    private int tl = 4096;
    private DataFile hi;
    private DataFile ho;
    private DataFile hlut;
    private Data dbi;
    private Data dbo;
    private MPULib dm;

    public int open() {
        this.hi = this.MA.getDataFile("IN", "1000", "C#", 0);
        this.hi.open();
        this.ho = this.MA.getDataFile("OUT", this.hi, 0);
        this.ho.setFormatMode((byte)83);
        this.ho.open();
        this.dm = MPULib.forName((String)"Demod", (Args)this.MA);
        this.modeList = this.dm.getS("MODULATIONS");
        this.mode = this.MA.getChoice("MODE", this.modeList, 0);
        this.dm.set("MODULATION", this.mode);
        this.hlut = this.MA.getDataFile("/LUT", "2000", "SI", 0);
        this.hlut.open(64);
        boolean lut = this.hlut.isOpen();
        if (lut) {
            int nlut = (int)this.hlut.size;
            int flags = this.hlut.keywords.getL("FLAGS", 0);
            Data dlut = this.hlut.getDataBuffer(nlut);
            this.hlut.read(dlut);
            this.dm.set("LUT", dlut);
            this.dm.set("LUTFLAGS", flags);
            this.hlut.close();
        } else {
            this.algList = this.dm.getS("ALGORITHMS");
            this.alg = this.MA.getChoice("/ALG", this.algList, 0);
            this.dm.set("ALGORITHM", this.alg);
            lut = this.alg > 1;
        }
        double fullScale = 1.0;
        if (this.ho.getFormatType() == 73) {
            fullScale = 65536.0;
        } else if (this.ho.getFormatType() == 76) {
            fullScale = 4.294967296E9;
        }
        if (this.MA.getState("/FREQOUT")) {
            if (this.hi.getFormatType() == 70 || this.hi.getFormatType() == 68) {
                fullScale *= 1.0 / this.hi.getXDelta();
            } else {
                this.M.warning((CharSequence)"Can not use frequency scale for non-Float data types");
            }
        }
        this.dm.set("FULLSCALE", fullScale);
        this.dm.open();
        this.tl = this.MA.getL("/TL", this.tl);
        byte dtype = lut ? (byte)73 : 70;
        this.dbi = this.hi.getDataBuffer(this.tl, dtype);
        this.dbo = this.ho.getDataBuffer(this.tl, dtype);
        return 0;
    }

    public int process() {
        int n = this.hi.read(this.dbi);
        if (n < 0) {
            return 9;
        }
        n = this.dm.process(this.dbi.buf, n, this.dbo.buf, this.tl);
        this.ho.write(this.dbo, n);
        return 0;
    }

    public int close() {
        this.dm.close();
        this.hi.close();
        this.ho.close();
        return 0;
    }

    public void setMode(String value) {
        this.setMode(Parser.find((String)this.modeList, (String)value, (int)this.mode));
    }

    public String getMode() {
        return Parser.get((String)this.modeList, (int)this.mode);
    }

    private void setMode(int mode) {
        this.mode = mode;
        this.dm.set("MODULATION", mode);
    }

    public Object getNextLink() {
        return this.dm;
    }

    public Object getPrevLink() {
        return null;
    }
}

