!******************************************************************************!
! displays current version of Midas or a Midas option tree
! @version: $Id: version.mm,v 1.17 2012/08/17 13:09:44 ntn Exp $
!******************************************************************************!
startmacro u:option["ALL"]
switch ALL     showVersionTxt get DEF=false SDEF=true
switch CHECK   doCheck        get DEF=false SDEF=true
switch OPTINFO showOptInfo    get DEF=false SDEF=true
switch VERBOSE doVerbose      get DEF=false SDEF=true
! remove verbose switch so it does not propagate to INVOKE, etc. (since 3.3.0)
switch VERBOSE ,, DEL  /quiet

if doVerbose then
  ! 2012-08-16 NTN: even though we deleted the /VERBOSE switch. Intrinsic commands (e.g. CALC)
  !   have already loaded and gone through it's checkin() so unless it checks for /VERBOSE
  !   in open(), Command.verbose is true.
  say "Use of /VERBOSE for version has been deprecated. Use /ALL instead."
  set showVersionTxt true
endif

if option eqs "ALL" then
  foreach option inlist opt.path
    call listopt option
    call getOptInfo option
  endfor
else
  call listopt option
  call getOptInfo option
endif

endmacro

!******************************************************************************!
procedure listopt s:option
  fname vfname "" version txt ^option
  if vfname nfexists then
    say "Opt=^option No version file found"
    return
  endif
  file open vfile vfname

  if showVersionTxt or doCheck then
    file read vfile vtext

    ! Indicates compatibility:
    !   compat = "NULL"  - No compatibility specified.
    !   compat = "TRUE"  - Is compatible.
    !   compat = "FALSE" - Not compatible.
    res compat "NULL"
    SEDIT "^ENV.NMVERSION" thisVer "GSUBS" "." "" ! e.g. 191
    res altVer   "^{thisVer.substring(0,2)}X"     ! e.g. 19X

    if option EQS "SYS" then
      res compat "TRUE"   ! SYS is always compatible.

      if showVersionTxt then
        ! Output the top line for the SYS version information
        set verStr "NeXtMidas Version ^{ENV.NMVERSION}"

        if ENV.NmPreRelease then set verStr "^{verStr} (PreRelease)"

        sedit verStr verStr padboth 80
        say ""
        say verStr
      endif
    endif

    while vtext neqs "NULL"
      res text vtext.toUpperCase()

      if text.length() gt 7 AND text EQSS "#VCOMP:" then
        if compat neqss "TRUE" then
          res verComp text.substring(7)
          res verComp verComp.trim()
          res verComp verComp.toUppercase()

          if verComp.indexof(".") LT 0 then
            ! Old version numbers (19X)
            if verComp EQS thisVer then
              res compat "TRUE"
            elseif verComp EQSS altVer then
              res compat "TRUE"
            elseif compat EQS "NULL" then
              res compat "FALSE"
            endif

          else
            set plus verComp.endswith("+")

            ! New version numbers (1.9.X)
            if plus then
              calc lverComp verComp.length() 1 -
              set verComp  verComp.substring(0,^lverComp)
            endif

            invoke comp nxm.sys.lib.StringUtil.compareVersions(ENV.NMVERSION,verComp)

            if comp eq 0 then
              res compat "TRUE"
            elseif comp gt 0 and plus then
              res compat "TRUE"
            elseif compat EQS "NULL" then
              res compat "FALSE"
            endif
          endif
        endif
      elseif text EQSS "#" then
        ! lines starting with # are comments and should NOT be displayed
        ! since NeXtMidas 3.3.0: as documented in explain file since 1.9.2
      elseif showVersionTxt then
        say "^vtext"
      endif

      file read vfile vtext
    endwhile

    if doCheck then
      if compat EQS "NULL"
        say "Opt=^option Compatibility not specified"
      elseif compat then
        say "Opt=^option Compatibility check passed"
      else
        warn "Opt=^option Compatibility check failed"
      endif

    endif
  else
    file read vfile vtext
    if vtext eqss "*****"
      file read vfile vtext
    endif
    say "Opt=^option ^vtext"
  endif
  file close vfile

return

!******************************************************************************!
! Get Option Tree's information (such as parsed version and required option trees).
! since NeXtMidas 3.3.0
procedure getOptInfo s:option
  if showOptInfo then
    invoke  ^{option}_OPT_INFO nxm.sys.lib.OptionTree.getInfo(option,this.M,this.verbose,true)
    res/all ^{option}_OPT_INFO
  endif
return
