!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Macro to checkout out a command from one option to another with 
! the ability to rename the command in the target option tree.
!
!  @author  Jay Hallam
!  @version $Id: checkout.mm,v 1.5 2007/04/06 21:09:59 jph Exp $
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
startmacro u:sourcename U:optto U:targetname
!
! INPUTS:
!	sourcename	- Name of command to be checked out
!	optto		- Option tree where <sourcename> is to go
!	targetname	- New command name (same as <sourcename> if blank)
!
result OK 1

parse ^sourcename thesupport fullsourcename optfrom
if targetname EQS "" then
  result targetname fullsourcename
endif

if optfrom EQS " " then 
  result optfrom "SYS"
endif

if optfrom EQS optto then
  ! beep
  say "^fullsourcename is already in the ^optto option."
  ask yes_no "Do you want to refresh it from the SYS option? [Y] "
  if yes_no neqss "Y" then
    stop
  else
    result optfrom sys
  endif
endif

if     "P" subs thesupport then
  result extensions "java,html,c"
  result Subdir "prim"

elseif "M" subs thesupport then
  result Extensions "mm,set,mmp"
  result SubDir     "mcr"

else
  result OK 0
  error "You cannot check out a command that has only '^thesupport' support"
endif

if OK EQ 1 then
  ! How many extensions do I have?
  call scount "^extensions" "," NumExts

  ! Copy the files with same name but different extension from the source
  ! option to the target option
  do fnum 1 NumExts 1
    sedit "^extensions" ext PARSE fnum
    fname source ^SubDir ^fullsourcename ^ext ^optfrom
    if source fexists then
      fname target ^SubDir ^targetname ^ext ^optto
      file "COPY/F" "^source" "^target" 
    else
      if fnum EQ 1 then
        result OK 0
        error "Could not find ^source"
        BREAK
      endif
    endif
  enddo

  if OK EQ 1 then
    ! All commands MAY have and explain file
    fname source exp ^fullsourcename exp ^optfrom
    if source fexists then
      fname target exp ^targetname exp ^optto
      file "COPY/F" "^source" "^target" 
    else
      say "WARNING: no explain file found for ^fullsourcename"
    endif

    update/auto/quiet NAME=^targetname OPT=^optto SUPPORT=^thesupport
    menu NAME=^fullsourcename FUNC=LIST SUP=^thesupport
    say "^fullsourcename/s=^thesupport checked out from the ^optfrom &
        area into the ^optto area."
    say "WARN Don't forget to change the package name and make sure &
         commands.cnf default names match source code."
  endif
endif

endmacro
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
procedure scount S:str s:sym U:count
!
! Count the number of items in a string
!
res tmp1 str
sedit tmp1 tmp2 GSUB "^sym" ""

calc/quiet tmp ^tmp1.length ^tmp2.length - 1 +
res ^count tmp

return














