!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! HW control macro
!
! Version $Id: hw.mm,v 1.10 2008/05/30 17:41:22 jgs Exp $
! $Modtime:   15 Feb 1996 14:57:50  $
!
startmacro q:string

sedit string verb parse 1

if verb eqss "HELP" then
  explain hw

elseif verb eqss "SET" or verb eqss "CONNECT" or verb eqss "DISCONNECT" then
  hwdriver ^string

elseif verb eqs "FILE" then
  sedit string name parse 2
  if name eqs "" then ask q:name "Name of Hardware Configuration File [^env.hwfile]: "
  if name neqs "" then set/force s:env.hwfile name

elseif verb eqs "INIT" then
  fname env.hwfile dat hwconfig ,, sys

elseif verb eqss "SHOW" then
  sedit string name parse 2
  sedit string target parse 3
  if name eqss "ALIAS" and target eqs "" then
    say "Hardware Alias Definitions:"
    key env.hwfile list /scope=tag=alias
  elseif name eqss "ALIAS" and "*" subs target then
    say "Hardware Alias Definitions:"
    key env.hwfile list target /scope=tag=alias 
  elseif name eqss "ALIAS" or name eqss "FULL"
    key env.hwfile get "^target" alias /scope=tag=alias 
    if alias eqs "NULL" then
      say "Hardware Alias ^target not found."
    else
      say "Hardware Alias ^target = ^alias"
      sedit alias device parse 1 trim ,, "-"
      say "Hardware Commands for alias=^target, device=^device:"
      if name eqss "FULL" then
        key env.hwfile /scope=tag-=^device
      else
        foreach kw "INKW" env.hwfile /scope=tag-=^device
          sedit kw.value value trim "COM="
          say "^kw.name = ^value"
        endfor
      endif
    endif
  elseif name eqss "DEVICES" then 
    say "Hardware Configurable Devices:"
    key env.hwfile tget devices /scope=tag-=alias
    res devices.getlist
  elseif name eqss "INPUTS"  
    say "Hardware Switch Inputs:"
    key env.hwfile tget inputs /scope=tag-=switchin
    res inputs.getlist
  elseif name eqss "OUTPUTS"  
    say "Hardware Switch Outputs:"
    key env.hwfile tget outputs /scope=tag-=switchout
    res outputs.getlist
  elseif name eqss "CONNECTIONS" or name eqss "STATUS" then
    say "Hardware Switch Connections:"
  else
    warn "Unknown SHOW target: ^name"
  endif

elseif verb eqss "CFG" then
  header/create env.hwfile sr=(IN/2A,OUT/2A)
  key env.hwfile fset
  file save env.hwfile

else
  warn "Unrecognized HW function: ^verb"

endif

endmacro
