/*
   Special RAM setup for ICE-PIC driver

   Author: Jeff Schoen
*/

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#if _UNIX
#include <unistd.h>
#include <sys/ioctl.h>
short fd;
#if _SOL
#include <sys/ioccom.h>
#endif
#elif _WIN
#include <windef.h>
#include <windows.h>
#include <winioctl.h>
HANDLE fd;
#endif
#include "iceioctl.h"

int main (int argc, char *argv[])
{
  PICIOCTL pio;
  int status, ram_start=-1, ram_sized=-1, ram_sizem=-1, outbytes;

  if (argc == 1);
  else if (argc != 4) { 
    printf ("Usage: setram RAM_START RAM_SIZED RAM_SIZEM  (in Mbytes)\n"); 
    exit(1); 
  } else {
    ram_start = atoi(argv[1]); 
    ram_sized = atoi(argv[2]); 
    ram_sizem = atoi(argv[3]); 
  }

  printf ("setram RAM_START=%d RAM_SIZED=%d RAM_SIZEM=%d  Mbytes\n",
	ram_start,ram_sized,ram_sizem); 

  pio.function = IOCTL_RALLOC;
  pio.offset = ram_start;
  pio.bufaddr = (void *)(long)ram_sized;
  pio.bytes = ram_sizem;

#if _UNIX
  fd = open("/dev/iceram",O_RDWR,0);
  if (fd==0) { printf ("Device does not exist.\n"); exit(1); }
#if _SOL
  status = ioctl(fd,_IOWR('f',0x1,sizeof(PICIOCTL)),&pio);
#else
  status = ioctl(fd,_IOR('f',0x1,PICIOCTL),&pio);
#endif
  close (fd);

#elif _WIN
  fd = CreateFile ("\\\\.\\Icepic0",0,0,NULL,OPEN_EXISTING,0,NULL);
  if (fd==(void *)-1) { printf ("Device does not exist.\n"); exit(1); }
  status = DeviceIoControl (fd, 
	(ULONG)CTL_CODE(ICEPIC_DEVICE_TYPE,0x800,METHOD_BUFFERED,FILE_ANY_ACCESS), 
		&pio,sizeof(PICIOCTL), NULL,0, (PULONG)(&outbytes),NULL);
  CloseHandle (fd);
#else
  status = -1;
#endif
  if (status!=0) printf ("Cannot allocate specified RAM\n");

  return 0;
}

