/*
   File Compression routine
   Author: Jeff Schoen
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "../lib/huffman.c"

int main (int argc, char *argv[])
{
  FILE *fi,*fo;
  int ilen=0,olen=0;
  char *bi=NULL,*bo=NULL;
  int *lval,noop;

  fi = fopen(argv[1],"r");
  fo = fopen(argv[2],"w");
  noop = (argv[3]!=NULL)? 1 : 0;

  if (fi==NULL) { printf("No input file=%s\n",argv[1]); goto DONE; }
  if (fo==NULL) { printf("No output file=%s\n",argv[2]); goto DONE; }

  fseek(fi,0L,SEEK_END);
  ilen = ftell(fi);
  fseek(fi,0L,SEEK_SET);

  bi = malloc(ilen+16);
  fread(bi,ilen,1,fi);
  lval = (int*)bi;

  if (lval[0]==0x46465548) {		// Uncompress
    ilen -= 16;
    if (ilen!=lval[1]) { printf("Uncompress Err: input length does not match header"); goto DONEI; }
    olen = lval[2];
    printf("UnCompress fi=%s len=%d to fo=%s len=%d\n",argv[1],ilen,argv[2],olen);
    bo = malloc(olen+16);
    Huffman_Uncompress(bi+16,bo,ilen,olen);
    fwrite(bo,olen,1,fo);
  }
  else if (lval[0]==0x504F4F4E) {	// Noop
    ilen -= 16; olen=ilen;
    printf("UnNoop fi=%s len=%d to fo=%s len=%d\n",argv[1],ilen,argv[2],olen);
    fwrite(bi+16,olen,1,fo);
  }
  else {				// Compress
    bo = malloc(ilen+16);
    if (noop) { olen=ilen; memcpy(bo+16,bi,ilen); }
    else olen = Huffman_Compress(bi,bo+16,ilen);
    printf("Compress fi=%s len=%d to fo=%s len=%d\n",argv[1],ilen,argv[2],olen);
    lval = (int*)bo;
    lval[0] = noop? 0x504F4F4E : 0x46465548;
    lval[1] = olen;
    lval[2] = ilen;
    lval[3] = 0;
    fwrite(bo,olen+16,1,fo);
  }

  if (bi!=NULL) free(bi);
  if (bo!=NULL) free(bo);

  DONEO:
  fclose(fo);
  DONEI:
  fclose(fi);
  DONE:
  exit(0);
}

