/*
   File Compression routine
   Author: Jeff Schoen
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "../lib/huffman.c"

int main (int argc, char *argv[])
{
  FILE *fi,*fh,*fo;
  char line[128],name[40],hfn[40];
  int i,n,stat,coff=0,zero=0,soff=0,moff,len,xby,ioff;
  long mbase,moff1,moff2;
  int *bi;

  if (argv[3]!=NULL) soff = strtol(argv[3],NULL,0);
  strcpy(hfn,"/tmp/elf2bin.hdr");
  sprintf(line,"objdump -h %s > %s",argv[1],hfn);
  stat = system(line);
  printf("Run=[%s] Stat=%d Soff=%x\n",line,stat,soff);

  fh = fopen("/tmp/elf2bin.hdr","r");
  fi = fopen(argv[1],"r");
  fo = fopen(argv[2],"w");

  if (fh==NULL) { printf("No header file=%s\n",hfn); goto DONE; }
  if (fi==NULL) { printf("No input file=%s\n",argv[2]); goto DONE; }
  if (fo==NULL) { printf("No output file=%s\n",argv[3]); goto DONE; }

  while (fgets(line,128,fh)!=NULL) {
    stat=sscanf(line,"%d %s %x %lx %lx %x ",&n,&name,&len,&moff1,&moff2,&ioff);
    if (stat!=6) continue;
    if (n==0) mbase=moff1;
    xby = len&0x3; if (xby>0) len += (4-xby);
    moff = (int)(moff1-mbase);
    if (strcmp(name,".heap")==0) continue;
    if (strcmp(name,".stack")==0) continue;
    if (strcmp(name,".comment")==0) continue;
    if (strncmp(name,".debug",6)==0) continue;
    printf("Stat=%d Section=%d %s %x %lx %lx ilen=%x    len=%d off=%08x fill=%d\n",stat, n,name,len,moff1,moff2,ioff, len,moff,moff-coff);
    while (coff<moff) { fwrite((char*)(&zero),4,1,fo); coff+=4; }
    if (strcmp(name,".bss")==0) {
      for (i=0; i<len; i+=4) fwrite((char*)(&zero),4,1,fo); 
    } else {
      bi = malloc(len);
      fseek(fi,(long)ioff,SEEK_SET);
      fread(bi,len,1,fi);
      if (n==0 && soff!=0) bi[2] = 0x1c000000 + (soff>>2);
      fwrite(bi,len,1,fo);
      free(bi);
    }
    coff += len;
  }
  len = 0xd000;
  xby = coff&0xFFF; if (xby>0) len += (0x1000-xby);
  for (i=0; i<len; i+=4) fwrite((char*)(&zero),4,1,fo); 

  fclose(fo);
  fclose(fi);
  fclose(fh);
  DONE:
  exit(0);
}

