!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Event handler for JB snapshotter
!   msg=message sam=snapAppMacro
!
! This macro is an event handler called by the jb.tbl snapapp table.
!
! Notes:
!
! The D2RF playback signal is always running but is normally muted.
! Use the Event Mode=PB button to unMute the Brubaker PlayBack signal
! The Mode=Wait checks once per second to see if it is time to start a 
!   new collect based on the Event Period and Offset settings for the Event.
! Once the Event Mode=SNAP or Mode=PB, it will poll until the Event
!   Duration is reached to reset the graphical widget. 
! An Event can be retriggered at any time by a message or button click.
! An Event trigger during a snapshot will produce overlapped snapshots each 
!   with the Duration setting when it is started.  Please limit this behavior
!   to less than 3 overlapped snapshots.
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

startmacro o:msg o:sam

set l:aaux 11	! archive aux
set l:amax 90	! archive aux max percent full
!set l:amax 10	! archive aux max percent full - for tests
set l:mdel 6	! max files deleted per pass - dont bog down system

set gc sam.controls

if msg.name eqs "GTIME" then		! comes once per second

  timex msg.data soy=l:time
  if gc.EV1MOD.v neqs "WAIT"
    set gc.EV1CUR.v gc.EV1CUR.v+1
    if gc.EV1CUR.v ge gc.EV1DUR.v
      set gc.EV1MOD.action "WAIT"
    endif
  elseif calc(time,gc.EV1PER.v,mod) eq gc.EV1OFF.v 
    set gc.EV1MOD.action "SNAP"
  endif

  if gc.EV2MOD.v neqs "WAIT"
    set gc.EV2CUR.v gc.EV2CUR.v+1
    if gc.EV2CUR.v ge gc.EV2DUR.v
      set gc.EV2MOD.action "WAIT"
    endif
  elseif calc(time,gc.EV2PER.v,mod) eq gc.EV2OFF.v 
    set gc.EV2MOD.action "SNAP"
  endif

elseif msg.name eqs "EV1MOD" then	! comes per MODE button
  call doMode 1 msg.data

elseif msg.name eqs "EV2MOD" then	! comes per MODE button
  call doMode 2 msg.data

endif

endmacro

procedure doMode l:event s:mode
if mode eqs "SNAP"
  call dosnap event
elseif mode eqs "PB"
  set sam.reg.snap4.res.gc.rfopts.action "-MUTE" 
  call dosnap event
elseif mode eqs "WAIT"
  set sam.reg.snap4.res.gc.rfopts.action "+MUTE" 
endif
return

procedure dosnap l:evn
set chns gc.EV^{evn}CHN.v
set dur gc.EV^{evn}DUR.v
set gc.EV^{evn}CUR.v 0
set gc.EV^{evn}CUR.max dur
timex gc.GTIME.v curtime
set fileroot "arch_^{curtime.tofilename}"
if "1" subs chns then call dofile sam.reg.snap1.res.ramfile ^{fileroot}_e^{evn}c1{aux=^aaux} dur
if "2" subs chns then call dofile sam.reg.snap2.res.ramfile ^{fileroot}_e^{evn}c2{aux=^aaux} dur
if "3" subs chns then call dofile sam.reg.snap3.res.ramfile ^{fileroot}_e^{evn}c3{aux=^aaux} dur
if "4" subs chns then call dofile sam.reg.snap4.res.ramfile ^{fileroot}_e^{evn}c4{aux=^aaux} dur
call doclean
return

procedure dofile s:fname s:aname d:dur
set l:sz file(fname).rate*dur
say "Archiving ^fname to ^aname of ^sz samples"
sourceice/bg/xgpw/source=rtfile fname aname /maxout=sz
return

procedure doclean
system disk dsktbl
set used dsktbl.disk_^{aaux}.used
set gc.APPDSK.v used
if used lt amax return
files/f arch* aux=^aaux
header files sr=(name/xa)
sort files sfiles +name	! oldest to newest
calc ndel mdel file(sfiles).size min
foreach ii insize ndel 
  erase/quiet=n file(sfiles).data(ii)
endfor
return
