!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! TRACER - Trace debug plotter macro for ICE-PIC DSP cards !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
startmacro/msgid=main/gc=config s:card s:flags t:config 

if config isnull then
 if "^env.home/tracset.tbl" fexists then
  info "Loading ~/tracset.tbl from a previous session"
  set t:tracset "^env.home/tracset.tbl"
 endif
 if tracset nrexists set t:tracset {card=PIC1AUTO,core=0}
 set config tracset     ! need above for prespecs
 if card neqs "PIC" then set config.card card
endif
switch "AFLAGS" flags get flags

pipe on
panel/setup/controls=gc

gcontrol choice "MODE"   "Oper" "Setup,ReConfig,Process,Exit" "Process" 
gcontrol choice "CARD"   "Card" "PIC1,PIC2,PIC3,PIC1AUTO,PIC2AUTO,PIC3AUTO" card /input
gcontrol choice "CORE"   "Core" "0,1,2,3,4,8,9" "0"
gcontrol choice "TBIT"   "Trig" "0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15" "0" /nc=2
gcontrol choice "OPTS"   "Opts" "Raw,Gate,Tinv" "|" /toggle
gcontrol prompt "FILE"   "Src" "tracecfg.v"
gcontrol button "ACT"    "Action" "Arm,Dump" /tleft 

call conf
plot ,, layer={LT="nxm.ice.libg.LayerTV",TC="^vcfg"}
sendto "MAIN" "MODE" gc.MODE.v

pipe off

! save off settings
foreach item intable gc
  if item eqs "MODE" continue
  set tracset.^item gc.^{item}.value
endfor
table tracset SAVE "^env.home/tracset.tbl"

endmacro

procedure processMessage m:msg

if msg.name eqs "MODE" then
  if msg.data eqs "SETUP" then
    set gc.ACT.show 0
  elseif msg.data eqs "RECONFIG" then
    call conf
  elseif msg.data eqs "PROCESS" then
    set gc.ACT.show 1
  elseif msg.data eqs "EXIT" then
    pipe stop
  endif

elseif msg.name eqs "ACT" then
  if msg.data eqs "ARM" then
    call conf
    call arm
  elseif msg.data eqs "DUMP" then
    call conf
    call proc
  endif

elseif msg.name eqs "TBIT" then
  !res gc.TBIT.v
  !res gc.TBIT.ii
endif

return 

procedure conf
  set l:core ^gc.CORE.v
  set l:opts ^gc.OPTS.ii
  set card ^gc.CARD.v
  set cfg gc.FILE.v

  if core eq 0 res core 8	! base card tracer

  if /mc then
    sedit flags flags "APPEND" ",MCS=-99"
    set cfg "^iceroot/code/soc/lib/mcengine.v"
  endif

  res vcfg "{b15,b14,b13,b12,b11,b10,b9,b8,b7,b6,b5,b4,b3,b2,b1,b0}"		! default trigger bit list
  if "{" subs cfg then
    sedit cfg vcfg "GSUB" " " ""
  elseif cfg fexists then
    foreach line intf cfg
      if ( "assign" subs line or "wire" subs line ) and "trace" subs line
	sedit line vcfg "TRIM" "=" ";" "STRIM" "GSUB" " " "" "GSUB" "`" ""
      endif
    endfor
  endif
  set wcfg ""
  sedit vcfg gc.TBIT.items "TRIM" "{" "}"
  set l:i0 0
  foreach/rev item inlist gc.TBIT.items				! order trigger bit list
    if i0 ge 16 continue
    if ":" subs item then
      sedit item l:i2 "TRIM" "[" ":"
      sedit item l:i1 "TRIM" ":" "]"
      sedit item item "TRIM" "" "["
      do l:ix i1 i2
        sedit wcfg wcfg "APPEND" "," "APPEND" ^i0 "APPEND" "-" "APPEND" item "APPEND" "[^ix]" 
	set l:i0 i0+1
        if i0 ge 16 break
      enddo
    else
        sedit wcfg wcfg "APPEND" "," "APPEND" ^i0 "APPEND" "-" "APPEND" item 
	set l:i0 i0+1
    endif
  endfor
  sedit wcfg wcfg "TRIM" "," ""
  set gc.TBIT.items wcfg
  
return

procedure arm
  sedit gc.TBIT.v l:tbit "TRIM" "" "-"
  picd "TRACEARM" ^card trace /core=^core /bit=tbit /opts=opts /flags=(^flags) 
return

procedure proc
  picd "TRACEDUMP" ^card trace /core=^core /opts=opts /flags=(^flags) 
!  data/hex/nc=8 trace 0 64
  sendto "PLOT" "OPENFILE" trace info=-1
return

