!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!  TAPPER Test Point Signal tap macro for ICE cards
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
startmacro/msgid=main/mlog/stats=1 u:card u:cflags t:config

global hwalias
if config neqs "NULL" then
 res t:tapset config
else
 global tapset 
endif
call handleTheme
call makeTemplate


switch "AFLAGS" flags get cflags
set autoarchive 0

! init settings
if tapset nrexists then
  set tapset {port=MODULE,umode=USB2LS,format=SB,rate=60,clock=N,length=1.0,dec=1,&
	psdr=25,frame=2K,wave=none,afname="archive"}
else
  if tapset.card rexists then set s:card tapset.card
  if tapset.flags rexists then sedit flags flags "APPEND" "|" "APPEND" tapset.flags
  if flags eqss "|" sedit flags flags "TRIM" "|"
endif
call prespecs

! init menus, plot list, and client macro switches
set ports "Module,Core,Stream"
set plist "_CB1|_CB2"
set function "Acquire"
set modes "Setup,Monitor,OneShot,Archive,Analyze,Exit"
set afuncs "Protocol,DataList,TD-Line,TD-Raster1,TD-Raster2,Histogram,Tracer1,Tracer2,CardReset,ForceReset,EyeScan,Status"
switch "MODES" modes get modes
switch "AAUX"  s:aux0 get aux.write
switch "AAUX1" s:aux1 get aux0
switch "AAUX2" s:aux2 get aux0
sedit aux.read auxes gsubs "|" ","

! menu lists
set formats "SB,SI,SL"
set rates   "1,2,5,10,25,50,60,100,250,500,600,1000,1200"
set lengths "0.1,0.25,0.5,1.0,2.0,5.0,10.0,20.0"
set clocks  "N-NoMuxClk"
set frames  "256,500,512,1000,1024,2048,4096,8192,16384"
set psdrs   "1,2,5,10,25,50"
set affts   "1K,4K,8K,16K,32K,64K,128K,256k,1M"
set umodes  "USB31,USB32,DP1,DP2,USB2,AUX,TGBE,PCIE,USB2LS,USB2FS,USB2HS"
!set pmodes  "RAW,USB2,USB3,DP,PCIe,AUX,TGbE"
invoke pmodes=nxm.ice.prim.icepa.protocolList


! local state variables
set s:rclock "Z"	! clock at reset
set s:lmode "NULL"	! last mode setting
set l:ptl 64k		! practical transfer length
set d:scale 128		! this must be adjusted before data reaches the time plotter
calc fscale scale log 10 *

timex now sec=timecode

pipe on

panel/setup/controls=gc/logger
plot/id=tdlp _cb1{cl=4}|_cb2{cl=4} type=line y1=-scale y2=scale

  gcontrol label  "FUNC"   function
  gcontrol button "MODE"   "Mode" modes "Setup" /nc=2 /toff
  gcontrol tval   "TIME"   "TC" timecode 1 -1 1  /edit=f /mon=reg.sp.time.sec
  gcontrol file   "AFNAME" "File" tapset.afname ,, raux

  gcontrol label  "CFG"    "Port Config" 1
  gcontrol prompt "CARD"   "Card  "  card 
  gcontrol choice "UMODE"  "IOMode"  umodes tapset.umode 
  gcontrol choice "PORT"   "Port  "  ports tapset.port /input
  gcontrol choice "FORMAT" "Format"  formats tapset.format
  gcontrol choice "RATE"   "Rate  "  rates s:tapset.rate /units="MHz" /input
  gcontrol choice "LENGTH" "Length"  lengths s:tapset.length /units="sec" /input
  gcontrol choice "MODS"   "Mods  "  "Thru,Trim,Clip" "Thru" /toggle

  gcontrol label  "DISP"   "Displays" 0
  gcontrol choice "FRAME"  "Frame Size" frames s:tapset.frame /input
  gcontrol choice "PSDR"   "Disp Rate " psdrs s:tapset.psdr /units="Hz" /input
  gcontrol dval   "SCALE"  "Max Scale " 0 1 1e19 128 
  gcontrol choice "MONM"   "Monitor   " "Off,Async,Info,Full" "Async"

  gcontrol label  "ANAL"   "Analysis" 1
  gcontrol choice "AFUNC"  "Function" afuncs "Protocol"
!  gcontrol choice "PMODE"  "Protocol" pmodes /index=1
  gcontrol choice "AMODE"  "Source  " "Ram,Disk,DownLoad,ReadAfterWrite" "Ram"
  gcontrol choice "AFFT"   "FftSize " affts "4K" /input
  gcontrol dval   "APGR"   "Progress" 0 0 1 .1 /gauge 

  gcontrol label  "OPTS"   "Options" 0
  gcontrol choice "HDR"    "Headers" "Attached,Detached" "Det"
  gcontrol prompt "FLAGS"  "Flags  " flags
  gcontrol lval   "STATS"  "Stats  " /stats 0 60 1

  gcontrol label  "SYS"    "System" 0
  gcontrol choice "AUX1"   "Disk Aux-1 " auxes aux1 /edit=n
  gcontrol choice "AUX2"   "Disk Aux-2 " auxes aux2 /edit=n
  gcontrol lval   "AUX1U"  "Disk Used-1" 0 0 100 1 /gauge /edit=n
  gcontrol lval   "AUX2U"  "Disk Used-2" 0 0 100 1 /gauge /edit=n
  gcontrol lval   "FULL"   "DiskFullAt " 98 0 100 1 /gauge
  gcontrol dval   "MAXFS"  "MaxFileSize" 2000G 1M 64T 1M /units="by"
  gcontrol lval   "CPU"    "Total CPU  " 0 0 100 1 /gauge
  gcontrol lval   "LOST"   "LostBuffers" 0 1 -1 1  /edit=f
  gcontrol lval   "CYCLE"  "CurrCycle" 0 1 -1 1  /edit=f /mon=reg.sp.cycle
  gcontrol pipe   "PMON"   "Pipes" 

call picspecs
call checkafname 1

pipe off

! save off settings
foreach item intable tapset
  if item eqs "AFLAGS" or item eqs "MODE" or item eqs "ACTION" continue
  if gc.^item rexists set tapset.^item gc.^{item}.value
endfor

! clean up tasks
call cleanlist

endmacro

procedure open
if gc.MODE.v neqs "SETUP" then
  set gc.MODE.action gc.MODE.v
endif
if /client isfalse then
  set this.timers 2
  set this.timer(0) 1
  set this.timer(1) 10
  sendto main "TIMER" info=1
endif
return

procedure close
call picstop
while reg.noop rexists
  warning "Waiting on NOOP process"
  pause 1
endwhile
return

procedure processMessage m:msg

if msg.name eqs "TIME" then return
!say "Got message ^msg.name = ^msg.data from ^msg.fid"

if msg.name eqs "CYCLE" then
  if msg.data eq 1 and "ONE" subs gc.MODE.v then 
    set regsp reg.sp
    while regsp rexists and regsp.replay neqs "STOPPED"
      pause 0.1
    endwhile
    if autoarchive gt 0 then
      set gc.MODE.action "ARCHIVE"
    else
      set gc.MODE.action "SETUP"
    endif
  endif

elseif msg.name eqs "TIMER" then 
 if msg.info eq 0		! 1 sec
 elseif msg.info eq 1 then	! 10 sec
  report flush
 endif

elseif msg.fid eqss "FDLP" or msg.fid eqss "FDRP" or msg.fid eqss "TDLP" or msg.fid eqss "TDRP" then
  ! forget marrying windows for now

elseif msg.name eqs "EXIT"
  pipe stop

elseif msg.name eqs "APLOT" or msg.name eqs "OPLOT"

elseif msg.fid eqs "APLOT"
  ! ignore messages from analysis plots

elseif msg.name eqs "SCALE"
  call updateScale

elseif msg.name eqs "AFUNC" 
  call analyze

elseif msg.name eqs "MODE"
  set afn "NULL"
  set lafn gc.AFNAME.v
  timex now curtime
  if gc.ATAG.v eqss "DATE" set lafn "^{lafn}_^curtime.tofilename"
  if gc.ATAG.v eqss "MJS" set lafn "^{lafn}_^l:curtime.getmjs"
  if "MS" subs gc.ATAG.v 
    calc l:msec curtime.sec 1 mod 1000 * round
    set lafn "^{lafn}_^msec"
  endif
  set l:wrp test(gc.WRAP.v,eqs,"ON")
  set l:mon test("MEM",subs,msg.data,or,"MON",subs,msg.data)
  if msg.data eqs "SETUP" or msg.data eqs "STOP" then
    call picstop
    set gc.MODE.v "SETUP"
  elseif msg.data eqs "EXIT"
    pipe stop
  elseif "ONESH" subs msg.data then
    call picstop
    call picsetup
    call picstart "ONE"
    set gc.AMODE.v "RAM"
  elseif msg.data eqs "ARCHIVE" 
    info "Archiving ^ramfile1 to ^{lafn}_1"
    noop/gpw ramfile1 ^{lafn}_1{AUX=^AUX1,DET=^gc.HDR.item-1}
    info "Archiving ^ramfile2 to ^{lafn}_2"
    noop/gpw ramfile2 ^{lafn}_2{AUX=^AUX2,DET=^gc.HDR.item-1}
    set gc.MODE.v lmode
    set gc.AMODE.v "DISK"
  elseif msg.data eqs "ANALYZE" 
    call analyze
    set gc.MODE.v lmode
  elseif msg.data eqss "MON" then
    call picstop
    set gc.MODE.v "MON"
    set gc.AMODE.v "RAM"
    call picsetup
    call picstart "CONT"
  endif
  set lmode gc.MODE.v

elseif msg.name eqs "ANALYZE"
  say "Got an abort message"

elseif msg.name eqs "PORT"
  call picrestart 1

elseif msg.name eqs "UMODE"
  call setumode
  call picrestart 1

elseif msg.name eqs "CARD"
  res rclock "Z"	! trigger reset
  call picrestart 1

elseif msg.name eqs "FLAGS"
  set flags gc.FLAGS.v
  res rclock "Z"	! trigger reset
  call picrestart 1

elseif msg.name eqs "LENGTH"
  call picrestart

elseif msg.name eqs "FRAME" or msg.name eqs "PSDR" then
  call picrestart 1

elseif msg.name eqs "FORMAT" then 
  call picrestart

elseif msg.name eqs "RATE"
  call picrestart

elseif msg.name eqs "REPLAY"
  set reg.sp.replay msg.data

elseif msg.name eqs "STATS"
  if reg.sp  rexists set reg.sp.stats msg.data
  if reg.sps rexists set reg.sps.stats msg.data

elseif msg.name eqs "MONM"
  if reg.sp  rexists set reg.sp.monitor msg.data
  if reg.sps rexists set reg.sps.monitor msg.data

elseif msg.name eqs "AFNAME"
  call checkafname 0

else
  ! the rest need no other action
  !say "Unhandled message ^msg.name"
endif
return

procedure prespecs
set l:dec  1
set d:rate tapset.RATE
set d:freq 0
set d:gain 0
set d:psdr tapset.PSDR
set l:psda 1
set s:port tapset.PORT
set l:nfft 8k
set l:frame tapset.FRAME
set s:format tapset.FORMAT
set d:length tapset.LENGTH
set s:wave "NONE"
set s:clock "N"
calc drate rate 1e6 * dec /
sedit "MUXCLK=^clock|" flg "APPEND" flags
iceutil "CARETS" flg flg
return

procedure picspecs
set s:umode gc.UMODE.value
set d:rate gc.RATE.value
set d:psdr gc.PSDR.value
set s:card gc.CARD.value
set s:port gc.PORT.value
set s:monm gc.MONM.value
set l:frame gc.FRAME.value
set s:format gc.FORMAT.value
set d:length gc.LENGTH.value
sedit card card "UPCASE"
invoke bpa nxm.sys.lib.Data.getBPA(format)
sedit "MUXCLK=^clock|UPACMODE=^umode" flg "APPEND" flags
if port eqss "STREAM" then
 sedit flg flg "APPEND" "|RXRAWBITS=0x34|PKT2DATFLAGS=0x204|BLOCK=1K|NIO=ETH"
endif
if "Thru" nsubs gc.MODS.v sedit flg flg "APPEND" "|THRU=0"
if "Clip" subs gc.MODS.v sedit flg flg "APPEND" "|CLIP"
if "Trim" subs gc.MODS.v sedit flg flg "APPEND" "|TRIM"
iceutil "CARETS" flg flg
if rate le 0 set rate 1
if bpa lt 0 set bpa -bpa/8
set s:port1 ^{port}1
set s:port2 ^{port}2
set l:nfs frame
set l:nfft frame
calc drate rate 1e6 *
calc l:skip drate nfs / psdr / round 1 max
if "L" subs format calc scale 2G
if "I" subs format calc scale 32k
if "B" subs format calc scale 128
switch "FIXSCALE" scale get scale
! now evaluate carets with as many current variables as possible
if "^" subs flg then iceutil "CARETS" flg flg
return

procedure picsetup
call picspecs
trap on setuperror y
! handle reset of card before CBUFSZ queries
if /noreset le 0 and clock neqs rclock 
  info "Resetting ^card ... "
  picd/flags=flg reset ^card 
  if /rereset le 0 res rclock clock
endif
picd get card "TYPE" ctype
set gc.SCALE.action scale
res l:pps 128k
res l:ntbc 1
res d:tbcs -1
if reg.tdlp rexists
  calc xend frame drate /
  set reg.tdlp.setOuterLimits("X2") xend
endif
calc l:pps nfs*bpa*2 pps max
if /atl le 0 then
  calc l:atl nfs*skip
endif
if /skiponcard then
  res l:atl nfs
endif
res l:ptl atl*bpa	! ptl is in bytes
switch "EXACT" exact get 0
if exact gt 0 then
  set filesize exact 
elseif /skiponcard then
  calc filesize drate*length/skip round
else
  calc filesize drate*length round
endif
call cleanlist
if ramfile1 rexists erase/warn=off ramfile1 ramfile2
switch "RAMFILE1" ramfile1 get "^{card}_^{port1}"
switch "RAMFILE2" ramfile2 get "^{card}_^{port2}"
call add2list ramfile1
call add2list ramfile2
pic/round=ptl/multi=^ntbc/exact=exact create ramfile1 ^format filesize drate zero
pic/round=ptl/multi=^ntbc/exact=exact create ramfile2 ^format filesize drate zero
call preparch "RAMFILE1" "ARCHFILE1" ^{AFN}_1 ^AUX1
call preparch "RAMFILE2" "ARCHFILE2" ^{AFN}_2 ^AUX2
if tapset.extsetup rexists then
 run tapset.extsetup
endif

pipe init	! move back to pipe initialization mode
trap on initerror y

sourcepic/id=sp ramfile1{fs=nfs} _cb1{ps=pps} card 1 0 0 /master=sps /port=port1 &
      /tl=1 /flags=flg /skip=skip /replay=0 /flush /tc=cpu /monitor=monm /arch=archfile1 /archtl=atl
sourcepic/id=sps ramfile2{fs=nfs} _cb2{ps=pps} card 1 0 0 /slave=slv /port=port2 &
      /tl=1 /flags=flg /skip=skip /replay=0 /flush /tc=cpu /monitor=monm /arch=archfile2 /archtl=atl

label trappedinit
pipe run	! move into pipe run mode
label trappedsetup
trap off
return

label setuperror
say "Got setup error: ^emsg.data"
goto trappedsetup
return

label initerror
say "Got init error: ^emsg.data"
pause 1
goto trappedinit
return

procedure picstart s:replay
if reg.sp nrexists then
  set gc.MODE.v "SETUP"
  return
endif
pause 0.25 	! wait for plotters to reconnect
call picreplay replay
return

procedure picreplay s:replay
if reg.sp rexists set reg.sp.replay replay
return

procedure picwait l:count
if card eqs "NONE" return
while reg.sp rexists and reg.sp.dmamode eq 0 and count gt 0
  pause 0.1
  set l:count count-1
endwhile
return

procedure picstop 
call picreplay "ABORT"
set l:count 300 ! 30 second timeout
while count gt 0 and reg.sp rexists 
  pause 0.1
  set l:count count-1
  if calc(count,10,mod) eq 0 warning "Waiting for card stop or archive flush"
endwhile
if count le 0 warning "Problem stopping cards or flushing archive"
return

procedure picrestart l:nofilex
res gc.MODE.value
if gc.MODE.value neqss "MON" then
  call picspecs
else
  call picstop
  call picsetup
  call picstart "CONT"
endif
return 

procedure preparch u:ramtag u:archtag cs:archname u:auxi
set afqual gc.AFQUAL.v
set ^archtag "NULL"
set ans "NULL"
set atfn "^{archname}{AUX=^auxi}"
set atfn_toc "^{archname}_toc"
if afn eqs "NULL" return
  if atfn fexists or atfn_toc fexists then
    switch "OVERLAY" ans get gc.AOVER.value
    if ans eqs "ASK" then
      sedit gc.AOVER.items ans "TRIM" "Ask,"
      gc/tmp/wait menu ans "File: ^atfn exists ..." "^ans" "Leave" /tleft
    endif
  else
    set ans "NEW"
  endif
  set l:det ^gc.HDR.item-1
  res nflags ""
  if cfl gt 0 res nflags "^nflags|+FLUSH"
  if ans eqs "APPEND" res nflags "^nflags|+APPEND"
  if ans eqss "LEAVE" then
    set afn "NULL"
    set gc.MODE.value "MON"
  elseif ans eqs "ABORT" then
    set afn "NULL"
    set gc.MODE.value "SETUP"
  else
    if ans eqs "ERASE" erase/verbose atfn
  endif
  if /archsf gt 0 and "APPEND" nsubs nflags then res nflags "^nflags|+APPEND"
  set ^archtag "^{archname}{AUX=^auxi,DET=^det,CFL=^cfl,FLAGS=^nflags,^afqual}"
return

procedure updateScale
set d:scale gc.SCALE.v
if reg.tdlp rexists then
 set reg.tdlp.y1 -scale
 set reg.tdlp.y2 scale
endif
return

procedure analyze 
set afunc gc.AFUNC.v
set nfs gc.FRAME.v
if gc.AMODE.v eqs "RAM" then
  set afn1 ramfile1
  set afn2 ramfile2
elseif gc.AMODE.v eqs "DISK" or gc.AMODE.v eqs "READAFTERWRITE" then
  if afn eqs "NULL" 
    set afn0 gc.AFNAME.v
  else
    set afn0 afn
  endif
  set afn1 ^{afn0}_1
  set afn2 ^{afn0}_2
endif
if "RESET" subs afunc
  set flgs flg
  if "FORCE" subs msg.data sedit flgs flgs "APPEND" "|FORCE"
  info "Resetting card with flags: ^flgs"
  picd/flags=flgs reset ^card 
elseif afunc eqs "STATUS"
  pic/flags=flg STATUS card
elseif afunc eqs "DMAC"
  picd/flags=flg DMAC card
elseif afunc eqs "DMACX"
  pic/flags=flg DMACX card
elseif afunc eqs "DUALDIFF"
  icediff afn1 afn2 
else
  if reg.AFP rexists reg "FINISH" AFP 2
  if reg.LST rexists reg "FINISH" LST 2
if     afunc eqs "TRACER1" then
  plot/bg/id=afp afn1 layer={LT="nxm.ice.libg.LayerTV",TC="{rsv,rx_recv,rx_dm,rx_dp,intr,tx_se0,tx_data,tx_ena}"}
elseif afunc eqs "TRACER2" then
  plot/bg/id=afp afn2 layer={LT="nxm.ice.libg.LayerTV",TC="{rsv,rx_recv,rx_dm,rx_dp,intr,tx_se0,tx_data,tx_ena}"}
elseif afunc eqs "TD-LINE"
  plot/bg/id=afp afn1|afn2 y1=0 y2=128 /all
elseif afunc eqs "TD-RASTER1"
  plot/bg/id=afp afn1{fs=^nfs} z1=0 z2=128 /all
elseif afunc eqs "TD-RASTER2"
  plot/bg/id=afp afn2{fs=^nfs} z1=0 z2=128 /all
elseif afunc eqs "DATALIST"
  if "CLIP" subs gc.MODS.v then
    info "DataLising ^afn1"
    datalist/hex afn1{fs=64}
    info "DataLising ^afn2"
    datalist/hex afn2{fs=64}
  else
    info "DataLising ^afn1"
    datalist/hex afn1
    info "DataLising ^afn2"
    datalist/hex afn2
  endif
elseif afunc eqs "PROTOCOL"
  icepa/gpw afn1 pout gc.UMODE.v
  plot/bg/id=afp afn1 y1=0 y2=128 /all
  view/bg/id=lst pout icepa_tmpl
elseif afunc eqs "EYESCAN"
  picd "EYESCAN" ^card eyeout /node=10 /flags=gen=2
  plot/bg/wpos=(100,100,300,650) eyeout z1=0 z2=48k
endif
endif
return

procedure checkafname l:init
if gc.AFNAME.v eqs "NONE" or gc.AFNAME.v eqs "NULL" then
  return
else
  set afname "^{gc.AFNAME.v}_1{AUX=^AUX1}"
endif
return

procedure add2list s:fname
set ramtbl.^fname "OK"
return

procedure cleanlist
if ramtbl rexists and /clean neq 0 then
  foreach item intable ramtbl 
    erase/warn=off ^item
  endfor
endif
set t:ramtbl {}
return

! USB31,USB32,DP1,DP2,USB2,AUX,TGBE,PCIE,USB2LS,USB2FS,USB2HS
procedure setumode 
set umode gc.UMODE.v
if umode eqss "USB2" then
  set gc.RATE.v 60
elseif umode eqss "USB3" then
  set gc.RATE.v 500
elseif umode eqss "TGBE" then
  set gc.RATE.v 1000
elseif umode eqss "PCIE" then
  set gc.RATE.v 500
elseif umode eqss "DP" then
  set gc.RATE.v 1000
elseif umode eqss "AUX" then
  set gc.RATE.v 1
endif
return

procedure handleTheme
switch "THEME" theme get env.theme
if theme eqs "GEAR2" or theme eqs "GEAR3" then
  set textcolor "0xc88020"
else
  set textcolor "0x909090"
endif
if theme eqss "GEAR" then
  set plotopts "+contrast"
else
  set plotopts "-contrast"
endif
return

subroutine makeTemplate
file open/t/n tpl icepa_tmpl.key
foreach line intf nxm.ice.cfg.icepa_tmpl.key
  sedit line line "SUBS" "$COLOR" "^textcolor"
  file write tpl line
endfor
file close tpl
header/create icepa_tmpl
key icepa_tmpl fput
return

