!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! SPICEGUI - Signal Processing on ICE Development GUI
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
startmacro/msgid=main/mlog/gc=spiceset s:action cs:cname 

import "NMROOT" nmroot
import "ICEROOT" iceroot
fname/fncase=keepcase homedir home ,,, aux
fname/fncase=keepcase srcdir home spice ,, aux

if action eqs "MAKE" and /vhs isfalse then
 do nn 2 this.args.nargs
  call setCoreName "^this.args.gets(nn)"
  call makeSoft
 enddo
 stop
endif

global spiceset
if spiceset nrexists or spiceset.getsize eq 0 then
  set t:spiceset {}
  if "^env.home/spiceset.tbl" fexists and action neqs "MAKE" then
    ask ans "Use previous spiceset ? [Y]/N: "
    if ans eqss "Y" set t:spiceset "^env.home/spiceset.tbl"
  endif
else
  set corei spiceset.core^{spiceset.csel}
endif
switch "GCX" t:gcx get
if gcx nisnull then table spiceset merge spiceset gcx


if ^srcdir ndexists then
  call makeSPICE
endif
if "SPICE" nsubs opt.path
  opt spice "^env.home/spice/"
  path add spice
endif

switch "SERVER" port get 0
!switch "MLOG" s:logfn get "OFF" logfn
!if logfn neqs "OFF" then report on logfn
invoke waves=nxm.ice.prim.icewave.shapeList
invoke imod=nxm.ice.prim.icewave.CW

set ctypes "JVM:Core.jv,JVM:Core.java,CPU:Core.c,---,VHS:Core.sv,VHS:Core.v,---,ICE:Core.sv,ICE:Core.v,---,SrvIce,IOGraph" 

set lfn "nxm.ice.docs.help.ice_hlp_cores.html"
set t:coreparams {}
switch "CITL" citl get 1K
switch "COTL" cotl get 8K
switch "MAXP" mparams get 16
switch "MAXC" mcores get 4
switch "CPITEMS" cpitems get "-16,-1,0,1,2,4,8,16,32,64,1K,4K,1e6,4e6,10e6,100e6,1e-6,1e-5"
switch "COPTS" copts get "spice,ice"
set lact "Idle"

switch "PATH" path get "^opt.path"
set t:opts {SPICE="^srcdir/core/"}
foreach copt inlist path
  fname coptdir core ,,, ^copt
  if coptdir dexists then set opts.^copt coptdir
endfor

call getCoreNames

if action eqss "MAKE" then
  sedit cnames cnames "APPEND" "," "APPEND" lnames
  set dmode "ICON"
else
  set dmode "FRONT"
endif

pipe on

panel/controls=gc/logger/setup/display=^dmode

if port gt 0
  icermif/id=rmif/http ^port
endif

gcontrol label  "APP"    "Application"
gcontrol choice "ACTION" "Action " "Run,Poll,Pull,Idle,Refresh,Exit,...,MakeSoft,MakeIFUD,MakeFPGA,StopFPGA,...,Update,Help" "Idle" /nc=1
gcontrol dval   "PROG"   "Progress" 0 0 1 0.01 /gauge /mon=reg.inp.progress
gcontrol choice "CFG"    "Config  " "Current,New,Save,Load" "Current"
gcontrol choice "DOCU"   "Display " "Help-Cores,Help-ICE,Help-NXM,Help-JVCC,Core-Source,Core-VLog" "Core-Source"

gcontrol label  "ILAB"   "Input Config"
gcontrol choice "IPORT"  "Source" "File,IceWave,Network,Module1,Module2" "IceWave"
gcontrol file   "IFN"    "File  " "testin"
gcontrol choice "WAVE"   "Shape " "None,^waves" "QPSK" /input
gcontrol choice "IFMT"   "Format" "SB,CB,SI,CI,SL,CL,SF,CF,CJ,CK" "CI"
gcontrol choice "RATE"   "Rate  " "10,25,50,100,250,500,750,1000" "10" /units="MHz" /input
gcontrol dval   "FREQ"   "Freq  " 0 -.5*gc.RATE.v gc.RATE.v 1 /fmt="#0.000" /units="MHz" /slider
gcontrol dval   "BAUD"   "Baud  " 1 0 1000 1 /fmt="#0.000" /units="MHz" 
gcontrol lval   "GAIN"   "Gain  " -3 -100 10 1 /units="dB"
gcontrol choice "ELEM"   "Elem  " "4K,16K,64K,256K,1M,4M,16M,64M" "64K" /input /units="samp" 

if /noise pexists then
gcontrol lval   "NFGAIN" "NFGain" -100 -100 0 1 /units="dB"
endif
if /filter pexists then
gcontrol file   "IFILT"  "Filter" "^/filter"
endif

gcontrol label  "KLAB"   "Packet Config" "Closed"
gcontrol choice "IPKT"   "PktTyp" "None,ICE,SDDS,VRT,VRTL,VRTW,VRTX,VRTD" "None" /input
gcontrol choice "NPKT"   "PktLen" "256,384,512,768,1K,1432,2K,4K,8K" "1K" /units="by" /input
gcontrol choice "PKTOPT" "PktOpt" "PktFile,UdpFile,EthFile" "Pkt" 

gcontrol label  "OLAB"   "Output Config"
gcontrol choice "OPORT"  "Sink  " "None,File,Network,Module1,Module2" "File"
gcontrol file   "OFN"    "File  " "testout"
gcontrol choice "OFMT"   "Format" "SB,CB,SI,CI,SL,CL,SF,CF,CJ,CK" "CI"

gcontrol label  "PLAB"   "Plotter Config"
gcontrol choice "IPLOT"  "Input Plot  " "None,FD-Line,FD-Raster,TD-Line,XY-Point,XY-Dot" "FD-Line"
gcontrol choice "OPLOT"  "Output Plot " "None,FD-Line,FD-Raster,TD-Line,XY-Point,XY-Dot,Same" "Same"
gcontrol choice "CPLOT"  "Cut Plot    " "None,FD-Line,FD-Raster,TD-Line,XY-Point,XY-Dot,Same" "Same"
gcontrol choice "CFMT"   "Cut Format  " "SB,CB,SI,CI,SL,CL,SF,CF,CJ,CK" "CI"
gcontrol choice "IFRAME" "Input Frame " "256,512,1K,2K,4K" 512 /input
gcontrol choice "OFRAME" "Output Frame" "256,512,1K,2K,4K" 512 /input
gcontrol choice "NFFT"   "FFT Size    " "1K,2K,4K,8K,16K" 4K /input
gcontrol choice "NAVG"   "FFT Avg     " "1,2,5,10,25,50" 5 /input

gcontrol label  "ALAB"   "Analysis"
gcontrol choice "TMOD"   "Trace Mode" "OneShot,Sample,Gated,Invert" /idef=0 /Toggle
gcontrol choice "TBIT"   "TriggerBit" "0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15" 0 /nc=2 
gcontrol choice "ANAL"   "Function  " "None,I/O-Diff,O-Save,O-Diff,UseOutAsIn,I-Status,I-Data,O-Status,O-Data,O-Plot,O|I-Plot,O|S-Plot,TracePlot" 

gcontrol label  "BLAB"   "Card Config"
gcontrol choice "FPGA"   "Target    " "K8M,K8P,PIC8,PAC8,nPAC8,sPAC8,uPAC8,U50,U250" "K8M"
gcontrol prompt "CSIG"   "Signature " "u1"
gcontrol choice "CCLK"   "ClockSpeed" "100,125,133,150,166,200,225,250,266,300,320,400" "125" /input
gcontrol choice "CARD"   "Card Name " "PIC1Auto,PIC2Auto,PIC3Auto" "PIC1Auto" /input
gcontrol choice "PMOD"   "Card PMod " "PM0-XBar,PM1-PMod1,PM2-PMod2,PM3-PMod1&2,PM4-IOMod" "PM1" 

gcontrol label  "CLAB"   "Core Config"
gcontrol prompt "COPTS"  "Core Opts "  copts
gcontrol choice "ROUTE"  "Core Route"  "I~Core1~O,I~Core2~O,I~Core3~O,I~Core4~O,I~Core1~Core2~O,I~Core2~Core1~O" "I~Core1~O"
do l:nc 1 mcores
  gcontrol prompt "CORE^nc"  "Core^nc" "Noop;ICE"  /edit=f
enddo
gcontrol prompt "COREL"  "CoreL" ""  /edit=f

gcontrol button "CACT"   "Act" "Run,Poll,Pull,Idle" /tleft
gcontrol label  "ELAB"   "Core Parameters"
gcontrol button "CSEL"   "Core# "  "1,2,3,4,L" "1" /nc=5 /tleft
gcontrol choice "CTYPE"  "Core Type" ctypes "JVM" /nc=1
gcontrol choice "CNAME"  "Core Name" cnames "" /input /flags=+CS
gcontrol prompt "CFLAG"  "Core Flgs" "" /input 
do l:nn 1 mparams
  gcontrol choice "CP_^nn" "unused" cpitems /input /flags=+CS
enddo

browse/id=bw "^lfn"

pipe run

if cname neqs "" then 
  if ";" nsubs cname set cname "^cname;"
elseif gc.CNAME.v neqs "" then 
  set cname gc.CNAME.v
else
  set cname "Noop;ICE"
endif

if/cs cname eqs gc.CNAME.v then
  call setCore
else
  set gc.CNAME.v cname
  call setCore 1
endif

if action neqs "IDLE" then
  if gc.CNAME.v eqss "NOTFOUND" set action "EXIT"
  set gc.ACTION.action action
endif

pipe off

if logfn neqs "OFF" then report off
set gc.ACTION.v "Idle"
set gc.DOCU.v "Core-Source"
if gc.CSEL.v eqs "L" set gc.CSEL.v "1"
if action eqs "IDLE" then
  call makeSpiceSet
endif

endmacro


procedure makeSpiceSet
foreach gcn intable gc
  set spiceset.^gcn gc.^{gcn}.v
endfor
table spiceset SAVE "^env.home/spiceset.tbl"
return


procedure open
set this.timers 2
set this.timer(0) 0.25
set this.timer(1) 10
sendto main "TIMER" info=1
return

procedure close
return


procedure processMessage m:msg

if msg.name eqs "TIMER" then 
 if msg.info eq 0		! 0.25 sec
   if gc.ACTION.v eqss "RUN" and reg.COR nrexists then
     info "Finished core=^cname impl=^cimpl"
     set gc.ACTION.v "Idle"
     set lact gc.ACTION.v 
     do l:nn 1 mparams
       set key gc.CP_^{nn}.title
       if key neqs "" and sparams.^key eqs "" set gc.CP_^{nn}.v "^coreparams.^key"
     enddo
     if gc.ANAL.v neqs "NONE" then set gc.ANAL.action gc.ANAL.v
   endif
 elseif msg.info eq 1 then	! 10 sec
  report flush
 endif
 if gc.ACTION.v eqs "IDLE" and action neqs "IDLE" then
  pipe stop
 endif

elseif msg.name eqs "CSEL" then 
  set gc.ELAB.title "Core ^gc.CSEL.v Parameters"
  set corei gc.CORE^{gc.CSEL.v}.v
  sedit corei gc.CNAME.v "TRIM" "" "," 
  if "^gc.CSEL.v" eqs "L" then
    set gc.CNAME.items lnames
  else
    set gc.CNAME.items cnames
    if "^{gc.CSEL.v}" nsubs gc.ROUTE.v then
      set gc.ROUTE.v "I~Core^{gc.CSEL.v}"
    endif
  endif
  call setCore

elseif msg.name eqs "CACT" then 
  if msg.data eqs "POLL" then
  elseif msg.data eqs "PULL" then
    call pullCoreParams
  else
    set gc.ACTION.action msg.data
  endif
  set gc.CACT.v " "

elseif msg.name eqs "ACTION" then 
 if msg.data eqss "UPDATE" then
  call makeSPICE 1
 elseif msg.data eqss "REFRESH" then
  call getCoreNames
 elseif msg.data eqss "RUN" then
  call stopCore
  call startCore
  set lact gc.ACTION.v
 elseif msg.data eqs "IDLE" then
  call stopCore
 elseif msg.data eqs "MAKESOFT" then
  call makeSoft
 elseif msg.data eqs "MAKEIFUD" then
  call makeIFUD
  info "Run Vivado at ~/spice/run.sh ..."
 elseif msg.data eqs "MAKEFPGA" then
  call makeIFUD
  call makeFPGA
 elseif msg.data eqs "STOPFPGA" then
  warn "StopFPGA not implemented yet"
 elseif msg.data eqs "EXIT" then
  pipe stop
 elseif msg.data eqs "HELP" then
  browse/bg "nxm.ice.docs.help.ice_hlp_cores.html"
 endif
 set gc.ACTION.v lact

elseif msg.name eqs "ANAL" then 

 if msg.data eqs "TRACEPLOT" then
  if cfn nends ".v" and cfn nends ".sv" then
    warn "Source file is not a verilog file. Set Core Type to Core.sv or Core.v."
    return
  endif
  set vcfv "{byte3[7:0],byte2[7:0],byte1[7:0],byte0[7:0]}"
  foreach line intf "^cfn"
    if ( "assign" subs line or "wire" subs line ) and "tracer" subs line
      sedit line vcfg "TRIM" "=" ";" "STRIM" "GSUB" " " ""
    endif
  endfor
  plot/bg trace layer={LT="nxm.ice.libg.LayerTV",TC="^vcfg"}

 elseif msg.data eqs "O-PLOT" then
  plot/all/bg ^{gc.OFN.v} cm=rni
  set gc.ANAL.v "None" 

 elseif msg.data eqs "O|I-PLOT" then
  plot/all/bg ^{gc.OFN.v}|^{gc.IFN.v} cm=rni
  set gc.ANAL.v "None" 

 elseif msg.data eqs "O|S-PLOT" then
  plot/all/bg ^{gc.OFN.v}|^{gc.OFN.v}_save cm=rni
  set gc.ANAL.v "None" 

 elseif msg.data eqs "USEOUTASIN" then
   noop gc.OFN.v gc.IFN.v
   set gc.IPORT.v "File"
   set gc.ANAL.v "None"

 elseif msg.data eqs "I-STATUS" then
   status gc.IFN.v
 elseif msg.data eqs "O-STATUS" then
   status gc.OFN.v

 elseif msg.data eqs "I-DATA" then
   datalist/hex gc.IFN.v
   datalist/hex gc.IFN.v -32
 elseif msg.data eqs "O-DATA" then
   datalist/hex gc.OFN.v
   datalist/hex gc.OFN.v -32

 elseif msg.data eqs "I/O-DIFF" then
   info "Diff ^gc.OFN.v with ^gc.IFN.v"
   icediff gc.OFN.v gc.IFN.v

 elseif msg.data eqs "O-SAVE" then
   info "Saving ^gc.OFN.v to ^{gc.OFN.v}_save"
   noop gc.OFN.v ^{gc.OFN.v}_save
   set gc.ANAL.v "O-DIFF"

 elseif msg.data eqs "O-DIFF" then
   info "Diff ^gc.OFN.v with ^{gc.OFN.v}_save"
   icediff gc.OFN.v ^{gc.OFN.v}_save
 endif

elseif msg.name eqs "IPORT" then 
  if msg.data neqs "File" then
    set gc.IFN.v "testin"
  endif

elseif msg.name eqs "CFG" then 
  if msg.data eqs "NEW" then
  elseif msg.data eqs "SAVE" then
    gcontrol/temp file   "SAVEAS" "File  " "spiceset_last"
  elseif msg.data eqs "LOAD" then
    gcontrol/temp file   "LOADAS" "File  " "spiceset_last"
  endif
  set gc.CFG.v "Current"

elseif msg.name eqs "SAVEAS" then 
  set cfgname "^env.home/^{msg.data}.tbl"
  info "Saving configuration as "^cfgname"
  table spiceset SAVE "^cfgname"

elseif msg.name eqs "LOADAS" then 

elseif msg.name eqs "WAVE" then 
  if gc.WAVE.itemindex lt imod and gc.FREQ.v eq 0 then set gc.FREQ.v 1

elseif msg.name eqs "PORT" then 
  ! sedit gc.PORT.v iport "TRIM" "CORE"

elseif msg.name eqs "CNAME" then 
  call setCore 1
  call getCoreParams

elseif msg.name eqs "CTYPE" then 
  if msg.data eqs "---" set gc.CTYPE.v "JVM:Core.jv"
  call setCore 

elseif msg.name eqs "DOCU" then 
  if msg.data eqs "HELP-CORES" then
    sendto bw "OPENFILE" "nxm.ice.docs.help.ice_hlp_cores.html"
  elseif msg.data eqs "HELP-ICE" then
    sendto bw "OPENFILE" "nxm.ice.docs.help.index.html"
  elseif msg.data eqs "HELP-NXM" then
    sendto bw "OPENFILE" "^nmroot/htdocs/help/index.html"
  elseif msg.data eqs "HELP-JVCC" then
    sendto bw "OPENFILE" "nxm.ice.docs.help.ice_hlp_jvcc.html"
  elseif msg.data eqs "CORE-VLOG" then
    sendto bw "OPENFILE" "nxm.ice.code.soc.k8m.k8m_rru1.logs"
  elseif msg.data eqss "CORE-SOURCE" then
    call setCore 
  endif

elseif msg.name eqss "CP_" then 
  set name gc.^{msg.name}.title
  set value msg.data
  if gc.ACTION.v eqs "RUN" and reg.cor rexists then
    set reg.cor.^name ^value
  endif
  call getCoreParams
endif

return


procedure makeSPICE l:upd
info "Creating SPICE user directory as ^srcdir"
if upd gt 0 then
  if ^srcdir/spice dexists
    say "Move your files from ^srcdir/spice/ to ^srcdir/core/ and remove the ^srcdir/spice dir.
  endif
  os rm -rf ^homedir/spice/nxm
endif
os cp -r ^iceroot/code/soc/spice ^homedir/
os ln -sfn ^iceroot/inc ^srcdir/inc/cores
os ln -sfn ^iceroot/lib/DevIce_lin64.so ^srcdir/core/libAll$ICE_lin64.so
return

procedure makeIFUD
set gc.ACTION.v "Generating IFUD ..."
info "Generating ICE FPGA User Directory at ^srcdir"
file open/t/n mf  "^srcdir/run.sh"
file open/t/n mfd "^srcdir/mdefs_user.h"
file write mf "#!/bin/sh"
file write mf "export IFUD=^srcdir"
file write mfd "`define SYS_CLKF ^gc.CCLK.v"
set copts gc.COPTS.v
do l:nc mcores 0 -1
  if nc eq 0
    set cnamei "^gc.CNAME.v"
    set eng "ENGINE"
  else
    sedit "^gc.CORE^{nc}.v" cnamei "TRIM" "" ","
    set eng "ENGINE^nc"
  endif
  call setCoreName "^cnamei"
  if copt nsubs copts then set copts "^copt,^copts"
  if cext eqs "v" then
    file write mfd "`define ^eng ^{cname}_engine"
  else
    file write mfd "`define ^eng ^{cname}_core"
  endif
  if defines rexists and defines neqs "NULL" and "!=" nsubs defines then
    sedit defines list "TRIM" "{" "}"
    foreach item inlist list
      sedit item item "SUBS" "=" " "
      file write mfd "`define ^item"
    endfor
  endif
  if params rexists and params neqs "NULL" and "!=" nsubs params then
    sedit params list "TRIM" "{" "}"
    set items ""
    foreach item inlist list
      sedit items items "APPEND" "defparam core^{nc}.^{item}; "
      sedit item item "SUBS" "=" " "
      file write mfd "`define ENGINE^{nc}DP ^items"
    endfor
  endif
enddo
if /dbg then
  sedit "make/v/c/d ^gc.FPGA.v rr^gc.CSIG.v ^copt ^gc.CSIG.v" args "LOCASE"
else
  sedit "make/v/c ^gc.FPGA.v rr^gc.CSIG.v ^copt ^gc.CSIG.v" args "LOCASE"
endif
file write mf "cd $IFUD"
file write mf "if [ "$1" == "sim" ]; then"
file write mf "  ^iceroot/code/soc/xilinx make sim ^cname ^copt"
file write mf "else "
file write mf "  ^iceroot/code/soc/xilinx ^args  | tee ^srcdir/run.log"
file write mf "fi "
file close mf
file close mfd
if defines rexists and "CORE_VERILOG_ONLY" subs defines then
  set extlist ",v,vhd,vhdl,dcp,"
else
  set extlist ",v,sv,vhd,vhdl,dcp,"
endif
os chmod +x ^srcdir/run.sh
set copt0 copt
file open/t/n mfta "^srcdir/topx.args"
file open/t/n mftp "^srcdir/topx.prj"
foreach copt inlist copts
  if copt eqs "none" continue
  set coptdir opts.^copt
  os mkdir -p ^srcdir/^copt
  if "/spice/" subs coptdir then
    info "Assuming opt ^copt at ^coptdir"
    set needcopy 0
  else
    info "Found midas opt ^copt at ^coptdir. Copying to ^srcdir/^copt"
    set needcopy 1
  endif
  files/f ^coptdir *
  if copt eqs "spice" set copt "core"
  foreach fn infile files
    fname/parse "^{fn}{fncase=keepcase}" fpath fname fext
    if ",^fext," subs extlist then
      if ",^fext," subs ",v,sv," then
	file write mfta "-v ^copt/^{fname}.^fext"
      endif
      file write mftp "verilog work \"^copt/^{fname}.^fext\""
      if needcopy then 
	os cp ^fn ^srcdir/^copt/
      endif
    endif
  endfor
endfor
file close mfta
file close mftp
set copt copt0
set gc.ACTION.v "Idle"
set gc.COPTS.v copts
return

procedure makeSoft
sedit cfn cfnl "BSEARCH" "."
sedit cfn cfnt "BETWEEN" 0 cfnl-1
if cext neqs "v" and /nojv isfalse then
  info "Translating ^cfn ..."
  icejvcc/verbose ^cfnt /obf /opt=copt
endif
if gc.CP_1.title neqs "NOCORE" and /vhs istrue then
  call makeIFUD
  info "Verilating ^cfn ..."
  os ^srcdir/run.sh sim
endif
info "Compiling ^cfn ..."
if cext eqs "v" then
  bld HOC core ice
else
  bld/verbose ^cname core ^copt
endif
return


procedure makeFPGA
if action eqss "MAKE" then
  info "Starting task ~/spice/run.sh to run Vivado"
  os ^srcdir/run.sh 
else
  info "Background task ~/spice/run.sh to run Vivado"
  os/bg ^srcdir/run.sh 
endif
return


procedure setCoreName s:name
set s:cname name
if cname eqs "None" then
  set copt "ice"
elseif ";" subs cname then
  sedit cname copt "TRIM" ";" "" "LOCASE"
  sedit cname cname "TRIM" "" ";"
elseif "^{iceroot}/core/^{cname}.jv" fexists then
  set copt "ice"
else
  set copt "spice"
endif
if "." subs cname then
  sedit cname cext "TRIM" "."
  sedit cname cname "TRIM" "" "."
else
  set cext "jv"
endif

if action eqs "MAKE" then
  set cfn "nxm.^{copt}.core.^{cname}.^{cext}" 
  set dfn "nxm.^{copt}.core.^{cname}.jv" 
  goto makelab
endif

if cext eqs "v" and ".v" nsubs gc.CTYPE.v then
  set gc.CTYPE.v "VHS:Core.v"
elseif cext neqs "v" and ".v" subs gc.CTYPE.v then
  set gc.CTYPE.v "JVM:Core.jv"
endif
sedit gc.CTYPE.v cimpl "TRIM" "" ":"
if "Core." subs gc.CTYPE.v then
  sedit gc.CTYPE.v cext "TRIM" "CORE." "" "LOCASE"
endif

set coptdir opts.^copt
if "Core." subs gc.CTYPE.v then
 if "/spice/" subs coptdir then
   set cfn "^{coptdir}^{cname}.^{cext}" 
   set dfn "^{coptdir}^{cname}.jv" 
 else
   set cfn "nxm.^{copt}.core.^{cname}.^{cext}" 
   set dfn "nxm.^{copt}.core.^{cname}.jv" 
 endif
elseif gc.CTYPE.v eqss "SrvIce" then
  set cfn "nxm.^{copt}.srv.^{cname}.srv"
  set dfn cfn
endif

label makelab
if "^dfn" nfexists then set dfn cfn
if "^dfn" fexists then
  iceutil grep "defaultKeys" "^dfn" keys
  iceutil grep "defaultDefines" "^dfn" defines
  iceutil grep "defaultParams" "^dfn" params
  iceutil grep "defaultFlags" "^dfn" cflags
elseif gc.CNAME.v rexists
  info "Core ^gc.CNAME.v not found at ^dfn"
  set gc.CNAME.v "NotFound"
endif

return


procedure setCore l:init
call setCoreName "^gc.CNAME.v"
if gc.CNAME.v eqs "NOTFOUND" return
if gc.DOCU.v eqss "CORE-SOURCE" then
  sendto bw "OPENFILE" "^cfn"
endif
sedit cflags gc.CFLAG.v "TRIM" "{" "}"
set s:sparam ""
iceutil reptbl coreparams {}
if keys neqs "NULL" sedit keys sparam "TRIM" "{" "}"
set l:nn 1
foreach item inlist sparam
  if "=" nsubs item then sedit item item "APPEND" "="
  sedit item key "TRIM" "" "="
  sedit item vals "TRIM" "=" 
  sedit item sval "TRIM" "=" "?"
  set gc.CP_^{nn}.title "^key"
  if vals starts "|" then
    set gc.CP_^{nn}.flags "+Toggle"
  else
    set gc.CP_^{nn}.flags "-Toggle"
  endif
  set gc.CP_^{nn}.items cpitems
  if "?" subs vals then
    if "?$" subs vals then	! choices from a core variable
      sedit vals vals "TRIM" "?$"
      if "." nsubs vals sedit vals vals "PREPEND" "^{cname}$CORE."
      if vals neqss "nxm." sedit vals vals "PREPEND" "nxm.ice.core."
      invoke vals=^vals
    else			! choices from an inline list 
      sedit vals vals "SUBS" "?" ","
    endif
    set gc.CP_^{nn}.items vals
  endif
  if sval eqs ""
    set gc.CP_^{nn}.value " "
  elseif init gt 0 then
    set gc.CP_^{nn}.value sval
  elseif ",^key=" subs corei
    sedit corei sval "TRIM" ",^key=" ","
    set gc.CP_^{nn}.value sval
  else
    set sval ^gc.CP_^{nn}.value 
  endif
  set coreparams.^key ^sval
  set l:nn nn+1
  if nn gt mparams break
endfor
do l:nn nn mparams
  set gc.CP_^{nn}.title ""
  set gc.CP_^{nn}.value " "
enddo
return

procedure getCoreParams
set corei "^gc.CNAME.v"
do l:nn 1 mparams
  set key gc.CP_^{nn}.title
  set val gc.CP_^{nn}.value
  if key neqs "" sedit corei corei "APPEND" ",^key=^val"
enddo
set gc.CORE^{gc.CSEL.v}.v corei
return

procedure pullCoreParams
do l:nn 1 mparams
  set key gc.CP_^{nn}.title
  if key nends "?" continue
  if reg.cor rexists then
    sedit key key "TRIM" "" "?"
    res reg.cor.^key /res=var
    set gc.CP_^{nn}.value "^var"
  endif
enddo
return

procedure getCoreNames
set cnames "None"
set lnames "None"
foreach copt intable opts
  set coptdir opts.^copt
  files/f=cfiles/nameonly "^{coptdir}*.jv"
  foreach cfn infile cfiles
    iceutil grep "defaultKeys" "^{coptdir}^cfn" keys
    sedit cfn cfn "TRIM" "" "."
    if "NOSPICE" subs keys then
    elseif "NOCORE" subs keys then
      sedit lnames lnames "APPEND" ",^cfn;^copt"
    else
      sedit cnames cnames "APPEND" ",^cfn;^copt"
    endif
  endfor
  files/f=cfiles/nameonly "^{coptdir}*.v"
  foreach cfn infile cfiles
    sedit cfn cfn "TRIM" "" 
    if "^cfn;^copt" subs cnames continue
    sedit cnames cnames "APPEND" ",^cfn;^copt"
  endfor
endfor
switch "CNAMES" cnames get cnames
switch "LNAMES" lnames get lnames
if gc.CSEL.v eqs "L" then
  if gc.CNAME rexists then set gc.CNAME.items lnames
else
  if gc.CNAME rexists then set gc.CNAME.items cnames
endif
return


procedure startCore

! close old plots
if reg.ipl rexists then reg finish ipl
if reg.opl rexists then reg finish opl

if cimpl eqs "ICE" then
  sedit gc.PMOD.v cpmod  "TRIM" "PM" "-"
  set port "core^{cpmod}^{gc.CSEL.v}"
  info "Resetting card=^gc.CARD.v with sig=^gc.CSIG.v"
  picd reset ^gc.CARD.v /flags=PMFPGA=^gc.CSIG.v
  picd/str get ^gc.CARD.v core+0x7E0 csig /port=^port
  info "Query card=^gc.CARD.v port=^port core=^csig"
endif

timex "NOW" tcs

pipe init

set l:tm 0
if gc.TMOD.itemindex neq 0 then
  ! configure trace mode (tbit<<4)|mode
  calc l:tm ^gc.TBIT.v 16 * gc.TMOD.itemindex +
endif

if gc.IPKT.v neqs "NONE" then
  calc elem gc.ELEM.v gc.NPKT.v / round gc.NPKT.v *
else
  set elem gc.ELEM.v
endif

! implement fast bypass of bypassed components using pipe name substitution

if gc.IPORT.v eqss "FILE" then
  noop/id=inp gc.IFN.v _isig
elseif gc.IPORT.v eqss "ICEWAVE" then
  icewave/id=inp/wrap _isig shape=gc.WAVE.v form=gc.IFMT.v rate=gc.RATE.v*1e6 freq=gc.FREQ.v*1e6 baud=gc.BAUD.v*1e6 gain=gc.GAIN.v elem=elem
endif
set icor "_isig"

if gc.IFILT rexists and gc.IFILT.v neqs "" then
  fdfilter icor ^gc.IFILT.v _isigf{form=^gc.IFMT.v} 
  set icor "_isigf"
endif

if gc.NFGAIN rexists and gc.NFGAIN.v gt -100 then
  icewave/id=inf/wrap _inf shape=NFLOOR form=gc.IFMT.v rate=gc.RATE.v*1e6 gain=gc.NFGAIN.v elem=elem
  fcalc _isigt{form=^gc.IFMT.v} icor _inf +
  set icor "_isigt"
endif

header icor time=tcs

if gc.IPKT.v neqs "NONE" then
  sinkice/id=ipk/sink=^gc.PKTOPT.v/pt=^gc.IPKT.v/pktlen=gc.NPKT.v/tc=cpu/freq=gc.FREQ.v*1e6/gain=gc.GAIN.v icor _isigp 
  set icor "_isigp"
endif

if gc.IPORT.v neqss "FILE" and gc.IFN.v nisnull then
  noop/id=ifn icor gc.IFN.v	! create for diff analysis
endif

if gc.IPKT.v neqss "NONE" then
  set l:cpkt 2*gc.NPKT.v
  switch "CITL" citl get cpkt
  switch "CCTL" cotl get cpkt
endif

if "CORE." subs gc.CTYPE.v then
  sedit gc.PMOD.v cpmod  "TRIM" "PM" "-"
  set cdev "NOTPRESENT"
  set cflg gc.CFLAG.v
  if "CORE1~CORE2" subs gc.ROUTE.v then
    sedit gc.CORE1.v acname "TRIM" "" ","
    iceutil reptbl coreparams {NAME=^gc.CORE1.v}
    if cimpl eqss "ICE" then set cdev "^gc.CARD.v:^{cpmod}1"
    icecore/id=cor/core=cimpl icor _ccor ^acname /cfg=coreparams /ifmt=gc.IFMT.v /ofmt=gc.CFMT.v /itl=citl /otl=cotl /coredev=^cdev /coreflg=^cflg /mrt
    sedit gc.CORE2.v acname "TRIM" "" ","
    iceutil reptbl coreparams {NAME=^gc.CORE2.v}
    if cimpl eqss "ICE" then set cdev "^gc.CARD.v:^{cpmod}2"
    icecore/id=cut/core=cimpl _ccor _ocor ^acname /cfg=coreparams /ifmt=gc.CFMT.v /ofmt=gc.OFMT.v /itl=citl /otl=cotl /coredev=^cdev /coreflg=^cflg /mrt
  elseif "CORE2~CORE1" subs gc.ROUTE.v then
    sedit gc.CORE2.v acname "TRIM" "" ","
    iceutil reptbl coreparams {NAME=^gc.CORE2.v}
    if cimpl eqss "ICE" then set cdev "^gc.CARD.v:^{cpmod}2"
    icecore/id=cor/core=cimpl icor _ccor ^acname /cfg=coreparams /ifmt=gc.IFMT.v /ofmt=gc.CFMT.v /itl=citl /otl=cotl /coredev=^cdev /coreflg=^cflg /mrt
    sedit gc.CORE1.v acname "TRIM" "" ","
    iceutil reptbl coreparams {NAME=^gc.CORE1.v}
    if cimpl eqss "ICE" then set cdev "^gc.CARD.v:^{cpmod}1"
    icecore/id=cut/core=cimpl _ccor _ocor ^acname /cfg=coreparams /ifmt=gc.CFMT.v /ofmt=gc.OFMT.v /itl=citl /otl=cotl /coredev=^cdev /coreflg=^cflg /mrt
  else
    set acname gc.CNAME.v
    if cext eqs "v" set acname "HOC;ICE"
    if corei nrexists call getCoreParams
    iceutil reptbl coreparams {NAME=^corei}
    if cimpl eqss "ICE" then set cdev "^gc.CARD.v:^{cpmod}^{gc.CSEL.v}|VERBOSE=0"
    icecore/id=cor/core=cimpl icor _ocor ^acname /cfg=coreparams /ifmt=gc.IFMT.v /ofmt=gc.OFMT.v /itl=citl /otl=cotl /mrtx &
			/trace=tm /tracefn=trace /tracesz=0x1000 /coredev=^cdev /coreflg=^cflg /tcs=tcs
  endif
endif

if gc.OFN.v nisnull
  noop/id=ofn _ocor gc.OFN.v
endif

set pform gc.IFMT.v
set ptype gc.IPLOT.v
call startPlot "i"

set pform gc.OFMT.v
if gc.OPLOT.v neqs "SAME" then set ptype gc.OPLOT.v
call startPlot "o"

set pform gc.CFMT.v
if gc.CPLOT.v neqs "SAME" then set ptype gc.CPLOT.v
call startPlot "c"

pipe run
info "Starting core=^corei"
return


procedure stopCore
if reg.inp rexists then reg "FINISH" "INP"
pause 1
if reg.cor rexists then reg "FINISH" "COR"
return

procedure startPlot cs:pdir 
sedit "xpl"   xpl  "SUB" "x" "^pdir"
sedit "_xcor" xcor "SUB" "x" "^pdir"
sedit "_xfft" xfft "SUB" "x" "^pdir"
if pdir eqs "i" set xcor icor
if "F" subs pform then
  set scale^pdir 2
elseif "L" subs pform then
  set scale^pdir 1g
elseif "B" subs pform then
  set scale^pdir 128
else
  set scale^pdir 32k
endif
if reg.^xpl rexists reg finish ^xpl
if ram.^xcor nrexists then return
if ptype eqs "NONE" then return
if ptype eqs "TD-LINE" then
  plot/id=^xpl ^xcor{fs=^gc.^{pdir}FRAME.v,cl=8} type="line" y1=-scale^pdir y2=scale^pdir cm=rni /tl=1k
elseif ptype eqs "FD-LINE" then
  fft/log ^xcor ^xfft nfft=gc.NFFT.v navg=gc.NAVG.v
  plot/id=^xpl ^xfft type="line"
elseif ptype eqs "FD-RASTER" then
  fft/log ^xcor ^xfft nfft=gc.NFFT.v navg=gc.NAVG.v
  plot/id=^xpl ^xfft type="raster"
elseif ptype eqs "XY-POINT" then
  plot/id=^xpl ^xcor cm=rvi type="point" x1=-scale^pdir x2=scale^pdir y1=-scale^pdir y2=scale^pdir
elseif ptype eqs "XY-DOT" then
  plot/id=^xpl ^xcor cm=rvi type="dot" x1=-scale^pdir x2=scale^pdir y1=-scale^pdir y2=scale^pdir
endif
return

procedure autoConf
info "Resetting card=^gc.CARD.v with sig=^gc.CSIG.v"
picd reset ^gc.CARD.v /flags=PMFPGA=^gc.CSIG.v
sedit gc.PMOD.v cpmod  "TRIM" "PM" "-"
do ii 1 4
  set port "core^{cpmod}^ii"
  picd/str get ^gc.CARD.v core+0x7E0 csig /port=^port
  info "Query card=^gc.CARD.v port=^port core=^csig"
  set gc.CSEL.v ii
  set gc.CNAME.v csig
  call setCore 1
  call getCoreParams
enddo
set gc.CSEL.action "1"
return
