!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! PACKER - MultiChannel to/from Network Packet Macro for a single ICE Card
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
startmacro/msgid=main/mlog/stats=0/gc=config s:card s:cflags t:config cs:cfgfn

fname ipmice "test" "ipmice" ,, ice	! for XCVR control

global hwalias
invoke parent=this.M.parent.getMacro()
invoke vctxlist=nxm.ice.lib.DevIce.vctxList
if parent nisnull set parent parent.name

switch "SERVER" server get 0

if config isnull then
 global packset
 if packset nrexists and parent isnull and "^env.home/packset.tbl" fexists then
  ask ans "Found ~/packset.tbl from a previous session. Load it ? Y/[N]: "
  if ans eqss "Y" then set t:packset "^env.home/packset.tbl"
 endif
 if packset nrexists table t:packset "CREATE" "{card=PIC1AUTO,rate=480,cfgfn=packcfg_def}"
 set config packset     ! need above for prespecs
else
 if config.cfgfn isnull set config.cfgfn "packcfg_def"
endif
if cfgfn pexists then 
  if cfgfn neqss "packcfg_" then sedit cfgfn cfgfn "PREPEND" "packcfg_"
  set config.cfgfn cfgfn
else
  set cfgfn config.cfgfn
endif
if card pexists then
  set config.card card
else
  set card config.card 
endif
switch "AFLAGS" cflags get cflags       ! cflags are immutable, flags are not
switch "SRATES" srates get "50,64,100,200,240,250,300,360,400,480,500,600,750,1000"

! handle card=design
if card eqss "PICxAUTO" then
  set cardi "PIC1AUTO"
  set cardo "PIC2AUTO"
  set isTray 1
else
  set cardi card
  set cardo card
  set isTray 0
endif

! get test loop modes
switch "TESTLOOP" testloop get 0 1

! setup the TimeCode mode
set aflags ""
switch "PKTTEST" pktst get 0
sedit card cname "LOCASE"

timex now time

set rffreq 1000
set rfgain 12
set nbgain 8
set srate  480

set l:mcf  256	! multicore frame size in samples
set l:pps  256K	! multicore pipe size in bytes
set cfilt "All"
switch "MFPP" mfpp get 8 	! maximum features per plot
set packcfg "packcfg_^cname"	! packcfg is the working config file
call loadcfg cfgfn

set lmode "SETUP"
set runmode lmode
set l:selectedrow 0
set l:hasrun 0
invoke waves=nxm.ice.prim.icewave.shapeList

!report on packer

pipe on

if server gt 0 then icermif/id=rmif/http server _CBW1|_CBW2|_CBN

panel/setup/controls=gc/logger/menubar/options=+lockcontrols

gcontrol label	"FUNC"   "Function"
gcontrol choice	"MODE"   "Operation  " "Setup,Process,Exit" lmode  /nc=1
gcontrol choice	"AGCM"   "AGC Mode   " "Off,WB,NB,WB+NB" "WB+NB"
gcontrol choice	"XCVR"   "Xcvr Status" "Locked,Fault,None,ReCenterIF,Status" "None"
gcontrol dval	"QFREQ"  "MrkFreq" 0 1 -1 1 /fmt="#0.000" /units="MHz" /edit=f
gcontrol lval   "CHAN"   "Chan"  0 0 ntc 1

gcontrol label  "MON1"   "Monitor-1"
gcontrol choice	"MSEL1"  "Select " "None" "None"
gcontrol lval	"MPWR1"  "RF Pwr " 0 1 -1 1 /units="dBm"
gcontrol lval	"GAIN1"  "IF Gain" rfgain -33 30 1 /units="dB"
gcontrol lval	"ADLM1"  "Loading" -48 -48 0 1  /edit=f /vumeter 

gcontrol label  "MON2"   "Monitor-2"
gcontrol choice	"MSEL2"  "Select " "None" "None"
gcontrol lval	"MPWR2"  "RF Pwr " 0 1 -1 1 /units="dBm"
gcontrol lval	"GAIN2"  "IF Gain" rfgain -33 30 1 /units="dB"
gcontrol lval	"ADLM2"  "Loading" -48 -48 0 1  /edit=f /vumeter 

gcontrol label	"STATS"  "Statistics" 
gcontrol button	"QMODE"  "Stats Mode" "Off,Clr,Cur,Rpt" "Off" /toff 
gcontrol choice	"QSELX"  "Pkt Stats" "SFP-1,SFP-2,SFP-3,SFP-4,SFP-5,SFP-6,SFP-7,SFP-8" "SFP-1"
gcontrol prompt "ADDRX"  "SFP Addr" "" /edit=n
gcontrol prompt "ADDRS"  "Str Addr" "" /edit=n
gcontrol prompt "ICNTX"  "iPkt Cnt" "" /edit=n
gcontrol prompt "OCNTX"  "oPkt Cnt" "" /edit=n
gcontrol prompt "IARPX"  "iARP Cnt" "" /edit=n
gcontrol choice	"QSELY"  "Rate Stats" "None,QSFP-1 Rx,QSFP-1 Tx,QSFP-2 Rx,QSFP-2 Tx" "None"
gcontrol fval	"QRATE"  "Data Rate" 0 1 -1 1 /units="MBPS" /edit=n

gcontrol label	"CONF"   "Configuration" 
gcontrol choice	"CARD"   "Card Alias " "PIC1AUTO,PIC2AUTO,PICxAUTO" card /input
gcontrol choice	"CLOCK"  "Clock Src  " "P,PX" "P"
gcontrol dval	"LENGTH" "Buffer Len " 1.0 0.1 10 1
gcontrol choice	"PKTTYP" "Packet Type" "None,UDP,ICE,SDDS,VRT,VRTL,VRTW,VRTX,VRTD" "VRTL"
gcontrol choice	"PKTLEN" "Packet Size" "768,1000,1K,1536,2K,3K,4K,6K,8K" "1K"
gcontrol choice "PKTPORT" "Packet Port" "7000,800#,90#0,0x7337,29495" "7000" /input
gcontrol choice	"OUID"   "Vita OUID  " "-1=Any,0=Default,0x101D77=Ice,0x6A621E=DiFi" "0=Def" /input
gcontrol choice	"VCTX"   "Vita CTX   " vctxlist "None" /toggle
gcontrol choice	"VFCMA"  "Vita FCMA  " "None,+0.0.0.1,+0.0.1.0,+0.1.0.0,+1.0.0.0" "None" /input
gcontrol lval	"AGCL"   "IFLoading  " -9 -21 -3 1 /units="dB"
gcontrol lval	"MING"   "MinIFGain  " -18 1 -1 1  /units="dB"
gcontrol lval	"MAXG"   "MaxIFGain  " 30 1 -1 1  /units="dB"
gcontrol lval	"AGCLN"  "NBLoading  " -30 -60 -3 1 /units="dB"
gcontrol lval	"MINGN"  "MinNBGain  " -30 1 -1 1  /units="dB"
gcontrol lval	"MAXGN"  "MaxNBGain  " 30 1 -1 1  /units="dB"
gcontrol dval	"AGCW"   "Hysteresis " 1 0 6 1   /units="dB"
gcontrol choice "WAVE"   "WaveGen    " waves "TWOT" /input
gcontrol choice	"CONFIG" "Configure  " "Done,Save,Load,Reload,Trim,Def,Tray,RfPac" "Done" /nc=3
gcontrol file   "CFGFN"  "CfgFn" cfgfn "packcfg_*.txt"

gcontrol label	"DISP"   "Displays" 0
gcontrol choice	"NFFT"   "Fft Size  " "1K,2K,4K,8K,16K" "4K" /input
gcontrol choice	"PSDR"   "Disp Rate " "5,10,25,50,100" "25" /units="Hz" /input
gcontrol choice	"PSDA"   "Disp Avg  " "1,5,10,20" "5" /units="Frames" /input
gcontrol lval	"EXPA"   "Expn Avg  " 5 0 100 1 /units="Frames"
gcontrol lval	"WBSCL"  "WB PSD Scale" 20 -80 100 10 /units="dB"
gcontrol lval	"WBRNG"  "WB PSD Range" 80  30 120 10 /units="dB"
gcontrol lval	"NBSCL"  "NB PSD Scale" 20 -80 100 10 /units="dB"
gcontrol lval	"NBRNG"  "NB PSD Range" 100 30 120 10 /units="dB"

gcontrol label	"SYS"    "System" 0
gcontrol prompt	"FLAGS"  "Flags " ""
gcontrol prompt	"AFLAGS" "aFlags" aflags

gcontrol choice	"ACTION" "Action" "Monitor,Process,Rec/PB,Stop,Config,Exit,ExitNow" 
gcontrol pipe	"PMON"   "Pipes" 

set fscale gc.NBSCL.v frange gc.NBRNG.v
set gscale gc.WBSCL.v grange gc.WBRNG.v

view/id=list packcfg nxm.ice.cfg.packlist.tbl 
view/id=tree cfgt 

plot/id=wbp1 _cbwf1 type=line axis=tframe ymax=gscale ymin=gscale-grange mimic=wrp1 /xmult=6 
plot/id=wrp1 _cbwf1 type=rast axis=frame zmax=gscale zmin=gscale-grange mimic=wbp1 /xmult=6
plot/id=wbp2 _cbwf2 type=line axis=tframe ymax=gscale ymin=gscale-grange mimic=wrp2 /xmult=6
plot/id=wrp2 _cbwf2 type=rast axis=frame zmax=gscale zmin=gscale-grange mimic=wbp2 /xmult=6

plot/id=nbp1 _cbnf1{fs=nfft} type=line axis=tframe ymax=fscale ymin=fscale-frange mimic=nrp1 /readout=-date
plot/id=nrp1 _cbnf1{fs=nfft} type=rast axis=frame zmax=fscale zmin=fscale-frange mimic=nbp1 /readout=-date
plot/id=nbp2 _cbnf2{fs=nfft} type=line axis=tframe ymax=fscale ymin=fscale-frange mimic=nrp2 /readout=-date
plot/id=nrp2 _cbnf2{fs=nfft} type=rast axis=frame zmax=fscale zmin=fscale-frange mimic=nbp2 /readout=-date

do im 1 2
 do ic 1 mfpp
  feature ,, i^{im}c^{ic} {NAME=C^{ic},TYPE=VLINE|IPLOT|BTAG,COLOR=#C0C080} wbp^im
 enddo
 feature ,, ff^im {NAME=FF^im,TYPE=VLINE|DATA,COLOR=#0080A0} wbp^im
enddo

call setlocals
set running 0
call setMact 1
if testloop gt 0 then
  set fscale 4k frange 8k
  set reg.panel.borders "+right"
  set gc.AGCM.v "Off"
  set gc.VCTX.v "OnSec|RF|GAIN"
  if /tc eqss "CPU" then set gc.CLOCK.v "PX"
  sendto "MAIN" "CONFIG" "TRIM"
endif

pipe run

if /mode pexists and parent neqs "SNAPAPP" then set gc.MODE.action "^/mode"
if /action pexists and parent neqs "SNAPAPP" then set gc.ACTION.action "^/action"
info "Packer starting. Use Shift-Drag and Shift-Click in WideBand PSDs to set NarrowBand Tuners."

pipe off

! save off settings
if packset rexists then
foreach item intable gc
  if item eqs "AFLAGS" or item eqs "MODE" or item eqs "ACTION" continue
  set packset.^item gc.^{item}.value
endfor
table packset SAVE "^env.home/packset.tbl"
endif

file close cfg 
call cleanram
report off

endmacro

procedure cleanram
foreach chn inlist chns
  sedit cname ramfile "APPEND" "_" "APPEND" chn "LOCASE"
  sedit ramfile ramfilex "APPEND" "x" 
  erase/warn=off ramfile ramfilex
endfor
return

procedure open
set this.timers 2
set this.timer(0) 1
set this.timer(1) 10
sendto main "TIMER" info=1
return

procedure close
return

procedure setlocals
  set runmode gc.MODE.v
  set l:nfft ^gc.NFFT.v
  set l:nexp ^gc.EXPA.v
  set l:psdr ^gc.PSDR.v
  set l:psda ^gc.PSDA.v
  set d:len gc.LENGTH.v
  set d:lenx gc.LENGTH.v
  set l:nmen 0 l:nten 0 l:ntben 0	! number of modules, tuners, and tbanks enabled
  set chns "" iom1 "None" iom2 "None" iot1 "None" iot2 "None"
return

procedure picsetup
  call cleanram
  call setlocals
  set l:frnd 8k 
  set ramqual "{CTG=1,AUX=^{ENV.RAMAUX},DET=1}"
  set gc.MSEL1.items ioms
  set gc.MSEL2.items ioms
  set l:vcmax 1

  ! define global flags                                                                                                         
  set flg "MBITS=-16|MUXCLK=^gc.CLOCK.v"                                                                                     
  if cflags neqs "" then sedit flg flg "APPEND" "|" "APPEND" cflags
  if gc.FLAGS.v neqs "" then sedit flg flg "APPEND" "|" "APPEND" gc.FLAGS.v
  res flgo flg	! specific to output channels
  set l:ituns1 0 l:ituns2 0 l:otuns1 0 l:otuns2 0 nioflg1 "" nioflg2 ""
  do nn 1 ntc
    call getRow nn 
    if chn eqss "OMOD" and rate gt 150 and "|VHS" nsubs flgo then sedit flgo flgo "APPEND" "|VHS"
    if chn eqss "OMOD" and rate gt 225 and "|QDRX" nsubs flgo then sedit flgo flgo "APPEND" "|QDRX"
    if chn eqss "ITUN" and ena gt 0 then calc l:ituns^im ituns^im itc max
    if chn eqss "OTUN" and ena gt 0 then calc l:otuns^im otuns^im itc max
    if chn eqss "ITUN" then sedit nioflg^im nioflg^im "APPEND" "|NIOA^itc=^qsfp/^addr|SR^itc=^rate|RF^itc=^freq|SID^itc=^sid"
    if enable eqss "PKT" and iv gt vcmax then set l:vcmax iv
  enddo
  sedit nioflg1 nioflg1 "PREPEND" "|NIOC=^ituns1"
  sedit nioflg2 nioflg2 "PREPEND" "|NIOC=^ituns2"
  sedit flg flg "APPEND" "|PMFPGA=n"
  if /noreset then
    ! must have been set up previously
  elseif cardo neqs cardi then
    info "Configuring card=^cardi with flags=^flg"
    picd reset cardi /flags=flg
    info "Configuring card=^cardo with flags=^flgo"
    picd reset cardo /flags=flgo
  else
    info "Configuring card=^card with flags=^flgo"
    picd reset card /flags=flgo
  endif
  switch "LENX" lenx get loop+2
  picd get cardo "CNAME" tsig /port=core1	! default name for tsig
  switch "TSIG" tsig get tsig
  sedit gc.OUID.v l:ouid "TRIM" "" "="

  pipe init

  do nn 1 ntc
    call getRow nn 
    if ena le 0 continue
    sedit cname ramfile "APPEND" "_" "APPEND" chn "LOCASE"
    sedit ramfile ramfilex "APPEND" "x" 
    if form eqs "CJ" and chn eqss "OMOD" and rate lt 300 then
      warn "Output of CJ data type only supported >= 300MHz. Setting form to CI"
      set form "CI"
    endif
    calc l:pktlen ^gc.PKTLEN.v 
    invoke bpa nxm.sys.lib.Data.getBPA(form)
    if bpa eq 3 then calc l:pktlen pktlen/1024 round 7 min 1152 *	! round for 3 by data type
    calc d:pktrnd (pktlen+24) 256 * bpa /

    set tcflg "" acflg "" pktflg ""
    if /tc eqss "CPU" then
      if chn eqss "oMod" and /sap then set tcflg "MTGO|MTGOOFF=0"
      if chn eqss "oTun" and /sap then set tcflg "MTGO|MTGOOFF=0"
      if chn eqss "iMod" then set tcflg "MTGO|NOTCUP|CTIME=^loop"
      if chn eqss "iTun" then set tcflg "MTGO|NOTCUP|CTIME=^loop"
    endif
    sedit "PKTY=^gc.PKTTYP.v|PKTPORT=^port,VCMAX=^vcmax" pktflg "GSUB" "#" "^iv"
    if chn eqss "O" then sedit pktflg pktflg "APPEND" "|PKTASIS|PKTTEST=^pktst|IGMPTIMER=60"	! all output modes now need UDAT 
    set uflags "OUID|FILL"
    if /dbg then sedit uflags uflags "APPEND" "|DBG"
    if /sap then sedit uflags uflags "APPEND" "|TIME"
    set nioflg "PKTLEN=^pktlen"
    if enable eqss "PKT" and gc.PKTTYP.v neqs "NONE" then
      if chn eqss "I" sedit nioflg nioflg "APPEND" "|NIO=^gc.PKTTYP.v"
      if gc.PKTTYP.v eqss "VRT" then sedit nioflg nioflg "APPEND" "|OUID=^ouid|VCTX=^gc.VCTX.ii"
      if gc.PKTTYP.v eqss "VRT" and gc.VFCMA.v neqs "NONE" then sedit nioflg nioflg "APPEND" "|VFCMA=^gc.VFCMA.v"
      if chn neqss "ITUN"  then sedit nioflg nioflg "APPEND" "|NIOA=^qsfp/^addr|SR=^rate|RF=^freq|SID=^sid"
      if enable eqs "PKT2" then sedit nioflg nioflg "APPEND" "|MUXGBE=2"
      if enable eqs "PKT4" then sedit nioflg nioflg "APPEND" "|MUXGBE=4"
    endif
    if "MOD" subs chn then
      if iom2 eqs "None" and iom1 neqs "None" then set iom2 chn
      if iom1 eqs "None" then set iom1 chn
      set l:nmen nmen+1 
      set cfgt.c2p.^chn "^nmen"
    elseif "ITUN" subs chn then
      calc l:tdec srate/rate/2 round
      set l:nten nten+1 
      set cfgt.c2p.^chn "^nten"
    elseif "OTUN" subs chn then
      calc l:tdec orate/rate/2 round
!      set l:nten nten+1 
!      set cfgt.c2p.^chn "^nten"
    endif
    set l:ntun 0

    calc d:mrate rate*1e6
    calc l:npsec mrate ! 1 second
    calc l:skip mrate nfft / psdr / round
    calc l:fszx mrate*lenx nfft / round nfft * 
    calc l:fszy mrate*lenx pktrnd / round pktrnd * 
    calc l:fsz mrate*len skip / nfft / round nfft * 
    set l:soc test(enable,nsubs,"TST,GEN",and,testloop,le,0)	! skip on card ?
    if soc eq 0 calc l:fsz npsec

    if chn eqss "IMOD" then
      set d:srate rate d:rffreq freq
      picd/nopipe/exact create ramfile form fsz mrate
      set wbflg "RFFREQ=^freq|RFGAIN=^gain|RFATTN=^xatn|^flg|^tcflg|^pktflg|^nioflg|XCVR=^xcvr"
      if soc eq 1 then sedit wbflg wbflg "APPEND" "|HXFD|BLOCK=8K"
      if reg.IMOD1 rexists then sedit wbflg wbflg "APPEND" "|SGO"
      set wbswi "replay=0/tl=1/skip=^skip/skiponcard=^soc/tcpp=8/rtfile"
      if form eqs "CJ" then 
	sourcepic/id=^chn/port=module^ic/^wbswi ramfile{fs=nfft} _jb^nmen cardi 1 0 0 /flags=wbflg 
	noop _jb^nmen _cb^nmen{form=CI}
      else
	sourcepic/id=^chn/port=module^ic/^wbswi ramfile{fs=nfft} _cb^nmen cardi 1 0 0 /flags=wbflg 
      endif
      if testloop gt 0 then sourceice/id=x^chn/tl=nfft/cl=npsec ramfile _cbnf^ic form npsec /source=rtfile

    elseif chn eqss "ITUN" then
      if reg.ibot^im nrexists then
	set chnt "iBoT^im" l:ntun ituns^im l:ntben ntben+1
        sedit cname ramfilet "APPEND" "_" "APPEND" chnt "LOCASE"
	calc l:nbskip srate*1e6/8 mcf / psdr / round
	picd/nopipe/exact create ramfilet form fsz srate*1e6/16
	set nbflg "MCS=^ntun|ITDEC|^flg|RGO|^nioflg|^nioflg^im|^tcflg|^pktflg"
	set nbswi "replay=0/tl=1/skip=^nbskip/skiponcard/nchn=ntun/dfreq=0/packet=ICET/timeout=0"
	sourcepic/id=^chnt/port=pm0tbank^im/^nbswi ramfilet{fs=mcf} _cbt^ntben{ps=pps} cardi 8 0 -3 /flags=nbflg
      endif
      if reg.ibot^im rexists then
	set rtun reg.ibot^im
	set rtun.chan itc rtun.fbwf bw/rate rtun.nybw mrate rtun.freq (freq-rffreq)*1e6 rtun.gain gain rtun.enable ena rtun.chan 0
      endif

    elseif chn eqss "OMOD" then
      set d:orate rate l:ntun otuns^im l:iic im+2
      set wbflg "RFFREQ=^freq|RFGAIN=^gain|RFATTN=^xatn|^flgo|^tcflg|XCVR=^xcvr"
      if form eqs "CJ" then sedit wbflg wbflg "APPEND" "|UP12"
      set wbswi "replay=0/tl=1/skip=^skip/tcpp=8"
      set acflg "CORE=(NAME=UDUC,S:PT=^gc.PKTTYP.v,L:OUID=^ouid,L:VCTX=^gc.VCTX.ii,D:SRATE=C_RATE,L:BITS=C_BITS,D:CTIME=0,S:FLAGS=^uflags)"
      if ntun gt 0 then	! must only be an output BoT
	set chnt "oBoT^im" l:ntben ntben+0
	picd/nopipe/exact create ramfile form fsz orate*1e6
	sourcepic/id=x^chn/port=module^im/^wbswi/skiponcard ramfile{fs=nfft} _cb^nmen cardo 1 0 0 /flags=HXFD|BLOCK=8K /timeout=-1
	sinkpic/id=^chn/port=CORE^iic/replay=0/tl=1 ramfile ramfile cardo ,,, ^gain /flags=^wbflg|MCS=^ntun|MCI=0|ICSEL /master=x^chn /timeout=-1
	if enable neqss "On" then warn "Setting OMOD Ena=On for use by OTUN Channels"
      elseif enable eqss "Gen" then	 ! rate in MHz makes stagoff=1uS
        calc cfreq 1e6 0 test(^gc.WAVE.v,eqss,TWO) ?:
	icewave/wrap/nopipe/stag=0/stagoff=^rate ramfile^ramqual shape=^gc.WAVE.v form=^form elem=^fsz rate=^orate*1e6 gain=-3 freq=cfreq baud=^bw*1e6
	sinkpic/id=^chn/port=module^ic/^wbswi ramfile ramfile(fs=nfft) cardo 1 0 ^gain /mon=_cb^nmen /flags=wbflg
      elseif tsig neqs "UDUC" then
        warn "Card ^cardo must be loaded with UDUC core to support Pkt->Analog modes"
      elseif enable eqss "Pkt" and isTray then
	picd/nopipe/exact create ramfile form fsz orate*1e6
	picd/nopipe/exact create ramfilex form fszy orate*1e6
	sourcepic/id=x^chn/port=stream^iq/rtfile/replay=0 ramfilex ,, cardi 1 0 0 /flags="MUXCLK=N|^pktflg|^nioflg|^gc.FLAGS.v" /timeout=-1 
	sinkpic/id=^chn/port=core^ic/rtfile/throttle=ondemand/^wbswi ramfilex ramfilex(fs=nfft) cardo 1 0 0 /flags=^wbflg|^acflg|noprefill /master=x^chn /timeout=-1
	sourcepic/id=xx^chn/port=module^ic/tl=1/skip=^skip/skiponcard ramfile{fs=nfft} _cb^nmen cardo 1 0 0 /flags="MUXCLK=N" /timeout=-1 
      elseif enable eqss "Pkt" then
	picd/nopipe/exact create ramfile form fsz orate*1e6
	sinkpic/id=^chn/port=module^ic/^wbswi ramfile ramfile(fs=nfft) cardo 1 0 0 /mon=_cb^nmen /flags=^wbflg|BLOCK=8K
      endif

    elseif chn eqss "OTUN" then
      calc nbskip mrate mcf / psdr / round
      set l:mfreq (freq-rffreq)*1e6
      if enable eqs "Gen" then
	set acflg "CORE=(NAME=UDUC,S:PT=NOOP,D:SRATE=^mrate,D:FS=C_RATE,D:FREQ=^mfreq,L:MAXFER=64)"
	info "Generating file=^ramfile shape=^gc.WAVE.v at freq=^freq with bw=^bw"
	icewave/wrap/nopipe/stag=0/stagoff=^rate ramfile^ramqual shape=^gc.WAVE.v form=^form elem=^fsz rate=mrate gain=^gain freq=0 baud=^bw*1e6
	sinkpic/id=^chn/port=mcore^ic/xmon=_cbt^ntben ramfile ramfile cardo -1 0 ^gain /srate=orate*1e6 /flags=^flgo|^acflg|TSIG=^tsig|RGO
      elseif enable eqs "Gen" then
	info "Generating file=^ramfile shape=^gc.WAVE.v at freq=^freq with bw=^bw"
	icewave/wrap/nopipe/stag=0/stagoff=^rate ramfile^ramqual shape=^gc.WAVE.v form=^form elem=^fsz rate=mrate gain=^gain freq=0 baud=^bw*1e6
	sinkpic/id=^chn/port=tuner^ic/xmon=_cbt^ntben ramfile ramfile cardo -1 mfreq gain /srate=orate*1e6 /flags=^flgo|TSIG=^tsig|RGO
      elseif tsig neqs "UDUC" then
        warn "Card ^cardo must be loaded with UDUC core to support Pkt->Analog modes"
      elseif enable eqss "Pkt" and isTray then
	picd/nopipe/exact create ramfile form fsz mrate
	picd/nopipe/exact create ramfilex form fszy mrate
	set acflg "CORE=(NAME=UDUC,S:PT=^gc.PKTTYP.v,L:OUID=^ouid,L:VCTX=^gc.VCTX.ii,D:SRATE=^mrate,D:FS=C_RATE,D:FREQ=^mfreq,L:BITS=C_BITS,D:CTIME=0,S:FLAGS=^uflags,L:MAXFER=64)"
	sourcepic/id=x^chn/port=stream^iq/rtfile/replay=0 ramfilex ,, cardi 1 0 0 /flags="MUXCLK=N|^pktflg|^nioflg|^gc.FLAGS.v" /timeout=-1 
	sinkpic/id=^chn/port=mcore^ic/rtfile/throttle=ondemand ramfilex ramfilex cardo -1 0 0 /srate=orate*1e6 /flags=^flgo|TSIG=^tsig|RGO|^acflg|^tcflg|noprefill /master=x^chn /timeout=-1
      elseif enable eqss "Pkt" then
	picd/nopipe/exact create ramfile form fsz mrate
	sinkpic/id=^chn/port=mcore^ic ramfile ramfile cardo -1 0 0 /srate=orate*1e6 /flags=^flgo|TSIG=^tsig|RGO|^pktflg|^acflg|noprefill /timeout=-1
      endif
    endif

    if chn neqss "ITUN" then sedit chns chns "APPEND" ",^chn"
    if ntun gt 0 then sedit chns chns "APPEND" ",^chnt"
  enddo
  sedit chns chns "TRIM" ","  

  if nmen gt 0 then
    picfanin/id=pf1/strip _cbw1 _cb nmen /select=0 
    fft/id=fftw1/psd/log _cbw1 _cbwf1 nfft HANN 0 psda
    picfanin/id=pf2/strip _cbw2 _cb nmen /select=0 
    fft/id=fftw2/psd/log _cbw2 _cbwf2 nfft HANN 0 psda
  endif

  if nten gt 0 and testloop le 0 then
    picfanin/id=pg1/strip/renumi _cbn1 _cbt ntben /select=0 
    fft/id=fftn1/psd/log _cbn1 _cbnf1 nfft HANN 0 psda
    picfanin/id=pg2/strip/renumi _cbn2 _cbt ntben /select=0 
    fft/id=fftn2/psd/log _cbn2 _cbnf2 nfft HANN 0 psda
  endif

  pipe run
  sendto "TREE" "FILES" "REREAD"
return

procedure loadfc l:nn l:init
  call getRow nn 
  if chn neqss "iTun" then return
  calc fbw cfg.data(nm,"BW") 
  calc fsr cfg.data(nm,"RATE") 
  set I^{im}C^{ic}.dx fbw*1e6
  ! create initial tuner filters
  if reg.spn^im rexists then
    set reg.spn^{im}.chan ic
    set reg.spn^{im}.fbwf (fbw/fsr)
    set reg.spn^{im}.nybw fsr*1e6
  endif
  call setEnable nn
  info "Loadfc nn=^nn init=^init sr=^fsr bw=^fbw"
return

procedure setEnable l:nn
  call getRow nn
  if reg.^chn rexists then set reg.^{chn}.enable ena
  if ic gt mfpp continue
  set  i^{im}c^{ic}.enable ^ena
  set color "#C0C080"
  set  i^{im}c^{ic}.color color
return

procedure picstart
  call setMx 1 iom1
  call setMx 2 iom2
  call setTx 1 "None"
  call setTx 2 "None"
  call setAGC
  if /tc eqss "CPU" then
    timex now fsec=ftmp
    say "Waiting on 1 PPS at ^ftmp"
    while ftmp lt 0.025 or ftmp gt 0.1
      pause 0.025
      timex now fsec=ftmp
    endwhile
    say "Waiting on 1 PPS done at ^ftmp"
  endif
  info "Starting ids = ^chns"
  foreach/rev id inlist chns
    if reg.^id rexists then set reg.^{id}.replay "CONT"
  endfor
  set running 1
  timex now timestart
return

procedure picstop
  if lmode eqs "SETUP" return
  if reg.pf1 nrexists and reg.pf2 nrexists then return
  info "Stopping ids = ^chns"
  foreach id inlist chns
    if reg.^id rexists set reg.^{id}.replay "FINISH"
  endfor
  foreach id inlist "PF1,PF2,PG1,PG2"
    if reg.^id rexists reg "FINISH" "^id"
  endfor
  foreach id intable reg
    if ^id eqss "X" reg "FINISH" "^id"
  endfor
  set runmode "SETUP"
  set running 0
return

procedure setFreq l:nn
  call setFeature nn
  if runmode eqss "SETUP" return
  call getRow nn
  if "MOD" subs chn and reg.^chn rexists then 
    set reg.^{chn}.rffreq freq
    if chn eqs iom1 then call setMx 1 chn
    if chn eqs iom2 then call setMx 2 chn
  elseif "ITUN" subs chn and reg.ibot^im rexists then 
    set l:ni ^cfgt.c2r.IMOD^im
    set d:rffreq cfg.data(ni-1,"FREQ")
    set rtun reg.ibot^im
    set rtun.chan itc rtun.freq (freq-rffreq)*1e6 rtun.chan 0
  elseif "OTUN" subs chn and reg.^chn rexists then 
    set l:ni ^cfgt.c2r.OMOD^im
    calc d:tfreq freq cfg.data(ni-1,"FREQ") - 1e6 *
    set reg.^{chn}.table {CORE=1,D:FREQ=^tfreq}
  else
    warn "Channel ^chn not running"
  endif 
  ! info "set CHN=^chn IOM=^im FREQ=^freq RFFREQ=^rffreq"
return

procedure setBW l:nn 
  call setFeature nn
!  if "Tun" subs cfg.data(nn-1,"CHN") then call setRate nn
return

procedure setGain l:nn 
  call getRow nn
  if "MOD" subs chn and reg.^chn rexists then set reg.^{chn}.rfgain gain
  if "OTUN" subs chn and reg.^chn rexists then set reg.^{chn}.gain gain
  if "ITUN" subs chn and reg.ibot^im rexists then 
    set rtun reg.ibot^im
    set rtun.chan itc rtun.gain gain rtun.chan 0
  endif
return

procedure setAttn l:nn 
  call getRow nn
  if reg.^chn nrexists return
  if "MOD" subs chn then set reg.^{chn}.rfattn xatn
return

procedure genRateList s:mchn
do nn 1 ntc
  if cfg.data(nn-1,"CHN") eqs mchn set d:srate ^cfg.data(nn-1,"RATE")
enddo
! build tuner rates menu
set trates "NONE"
do ii 2 256 2
  if calc(ii,4,mod) neq 0 and ii gt 6 then continue
  calc s:trate srate round ii /
  sedit trate ll "LENGTH"
  if ll le 5 sedit trates trates append "," append trate 
enddo
sedit trates trates "TRIM" "NONE,"
switch "TRATES" xrates get "AUTO"
if xrates neqs "AUTO" sedit xrates trates "SUB" "AUTO" "^trates"
sedit trates tratem "PARSE" 1	! first entry should be the max
return

procedure setRate l:nn l:force
  ! find minimum necesary sample rate
  call getRow
 if chn eqss "IMOD" then
   call genRateList
 elseif chn eqss "OMOD" then
 else
if force isfalse
  set fbw cfg.data(nn-1,"BW") 
  sedit trates trate "PARSE" 1
  foreach irate inlist trates
    if irate gt fbw*1.2 then set trate irate
  endfor
  set cfg.data(nn-1,"RATE") trate
endif
  call loadfc nn -1
 endif
return

procedure clickSelect l:ims d:f0
set gc.QFREQ.v f0
do nn 1 ntc 
  call getRow nn
  call findFeatureIn ims chn im
  if found eq 0 continue
  set hbw bw/2 f1 freq-hbw f2 freq+hbw
  if f0 gt f1 and f0 lt f2 then
    call selectrow nn
    break
  endif
enddo
return

procedure clickTune l:mode d:f1 d:f2
  set d:freq f1*1e-6
  set l:nn selectedrow
  if nn gt 0 and mode eq 2 then
    calc fbw (f2-f1) 1e-6 *
    calc freq (f2+f1)/2 1e-6 *
    set cfg.data(nn-1,"BW") fbw*1.2
!    call setBW nn
  endif
  if msg.fid ends "2" then 
    set gc.QFREQ.v freq
    set ff2.x freq*1e6
  else
    set gc.QFREQ.v freq
    set ff1.x freq*1e6
  endif
  if nn gt 0 and mode ge 0 then
    set cfg.data(nn-1,"FREQ") freq
    call setFreq nn 
  endif
  sendto "LIST" "FILES" "REREAD"
return

procedure setAGC
set t:agcwb {LEVEL=^gc.AGCL.v,WIDTH=^gc.AGCW.v,MINGAIN=^gc.MING.v,MAXGAIN=^gc.MAXG.v,PERIOD=0.5}
if "WB" nsubs gc.AGCM.v set agcwb.period 0
set t:agcnb {LEVEL=^gc.AGCLN.v,WIDTH=^gc.AGCW.v,MINGAIN=^gc.MINGN.v,MAXGAIN=^gc.MAXGN.v,PERIOD=0.5}
if "NB" nsubs gc.AGCM.v set agcnb.period 0
foreach chn inlist chns
  if chn eqss "IMOD" and reg.^chn rexists then
    set reg.^{chn}.agc agcwb
  elseif chn eqss "IB" and reg.^chn rexists then
    set reg.^{chn}.agc agcnb
  endif
endfor
return

procedure selectrow l:nn l:upd
  if reg.list rexists then
    sendto list "SELECTROW" x:nn
  endif
  if selectedrow neq 0 then
    set ff1.x 0 ff1.dx 0  ff2.x 0 ff2.dx 0 
  endif
  set selectedrow nn
  set gc.CHAN.v nn
  if nn eq 0 return
  call getRow nn
  if "MOD" subs chn then
    if iom^mact neqs chn then call setMx mact chn
    set reg.panel.borders "-right"
    return
  else
    if iot^mact neqs chn then call setTx mact chn
    set reg.panel.borders "+right"
  endif
  do jm 1 2
    call findFeatureIn jm chn im
    if found eq 0 continue
    set ff^{jm}.dx rate*1e6
    set ff^{jm}.x freq*1e6
  enddo
return


procedure doCfgMsg s:name o:value
  sedit name col "TRIM" "_" "-" "UPCASE"
  sedit name row "TRIM" "-"
  if row eqs "0" then
    set row1 1 
    set row2 ntc
  else
    set l:row1 ^row
    set l:row2 ^row
    rem row
  endif
  do nn row1 row2
    call getRow nn
    if row nrexists or cfilt eqs "ALL" then
    elseif cfilt eqs "ODD" then
      if calc(im,2,mod) eq 0 continue
    elseif cfilt eqs "EVEN" then
      if calc(im,2,mod) eq 1 continue
    elseif cfilt nsubs chn then 
      continue	! bail if column header selected and not in column filter
    endif
    if col subs "CHN,ENA,QSFP,ADDR,SID,FMT" then
      ! sub in for the the different IOM|CHN|index symbols
      sedit "A,B,C" side "PARSE" im
      sedit "^value" svalue "GSUB" "#" "^nn" "GSUB" "IDX" "^ic" "GSUB" "IOM" "^im" "GSUB" "AB" "^side" "GSUB" "QSFP" "^qsfp" "GSUB" "|" ""
      set cfg.data(nm,"^col") "^svalue"
    elseif col eqs "XCVR" then
      sedit "^value" cfg.data(nm,"XCVR") "GSUB" "  " " " "SUBS" " LO=" ":" "SUBS" " IF=" ":" "TRIM" "" " " "SUBS" "Clear" ""
      if value eqss "LNB" then
        sedit cfg.data(nm,"XCVR") d:rf1 "TRIM" "LO=" " " 
        sedit cfg.data(nm,"XCVR") d:rf2 "TRIM" "(" "-" 
        if rf2 gt rf1 sedit value value "APPEND" ">"
        if rf2 le rf1 sedit value value "APPEND" "<"
      endif
    else
      set cfg.data(nm,"^col") ^value
    endif
    if col eqs "FREQ" then call setFreq nn
    if col eqs "ENA"  then call setEnable nn
    if col eqs "BW"   then call setBW nn
    if col eqs "GAIN" then call setGain nn
    if col eqs "XATN" then call setAttn nn
    if nn eq selectedrow then call selectrow nn
  enddo
return

procedure processMessage m:msg

!if msg.name neqss "TIME" then say "Got message n=^msg.name i=^msg.info d=^msg.data from ^msg.fid"
if msg.name eqs "TIME" then return

if msg.name eqs "TIMER" then 
 if runmode eqss "SETUP" then 	
  ! only service in RUN modes
 elseif msg.info eq 0		! 1 sec
  do nn 1 ntc
   set l:nm nn-1
   set chn cfg.data(nm,"CHN")
   if "MOD" subs chn and reg.^chn rexists then
    set gain reg.^{chn}.rfgain rfpwr reg.^{chn}.rfpwr adlm reg.^{chn}.adlm
    if chn eqss "IMOD" then set cfg.data(nm,"GAIN") gain
   elseif chn eqss "ITUN" and "NB" subs gc.AGCM.v and reg.^chn rexists then
    set cfg.data(nm,"GAIN") reg.^{chn}.gain
   endif
   if chn eqs iom1 then set gc.ADLM1.v adlm gc.GAIN1.v gain gc.MPWR1.v rfpwr
   if chn eqs iom2 then set gc.ADLM2.v adlm gc.GAIN2.v gain gc.MPWR2.v rfpwr
  enddo
  timex now time
  if runmode eqss "REC" and time-timestart gt gc.MAXL.v then
    info "Max record time=^gc.MAXL.v sec reached. Stopping."
    set gc.MODE.action "Setup"
  endif
  sendto "LIST" "FILES" "REREAD"
  if gc.QMODE.v eqs "RPT" call doStats "CUR"
 elseif msg.info eq 1 then	! 10 sec
  call checkxcvr
  report flush
 endif

elseif msg.name eqs "QMODE"
  call doStats "^msg.data"

elseif msg.name eqs "GETLOG"
  set msg.data reg.logger.getLast

elseif msg.name eqs "GETCFG"
  set nm msg.info-1
  set msg.data cfg.getDataTable(nm)

elseif msg.name eqs "SETCFG"
  set l:rr msg.info
  set t:cc ^msg.data
  if rr lt 0 set rr ^cfgt.c2r.^{cc.chn}
  foreach key intbl cc
    if key eqs "CHN" then continue
    call doCfgMsg "CFG_^key-^rr" cc.^key
  endfor
  sendto "LIST" "FILES" "REREAD"

elseif msg.name eqs "MODE"
  call selectrow 0
  if msg.data eqs "PROCESS" then
    if running then
      call picstop
      pause 2
    endif
    call picsetup
    call picstart
    set hasrun 1
  elseif msg.data eqs "SETUP" then
    call picstop
  elseif msg.data eqs "STATUS" then
    picd get cardi status
    set gc.MODE.v lmode
  elseif msg.data eqs "EXIT" and lmode neqss "SET" and msg.quals.actiontype eq 0 then
    gc/temp menu "EXITOK" "Exit?" "Yes,No" "No"
    set gc.MODE.v lmode
  elseif msg.data eqs "EXIT" then
    call picstop
    pipe stop
  else
    warn "Option ^msg.data not available yet on this devICE"
    gc/temp/timeout=2 alert ,,, "Option ^msg.data not available yet on this devICE"
    set gc.MODE.v lmode
  endif
  set lmode gc.MODE.v
  if lmode subs "SETUP,EXIT" then
    set gc.FUNC.title "Function"
  else
    set gc.FUNC.title "Op=^lmode"
  endif

elseif msg.name eqs "EXITOK"
  if msg.data eqs "Yes" then
    call picstop
    pipe stop
  endif

elseif msg.name eqs "ACTION"
  if msg.data eqss "START" then
    call picstart
  elseif msg.data eqss "MON" then
    call picstop
    set gc.MODE.v "PROCESS"
    call picsetup
    if msg.info ge 0 call picstart
  elseif msg.data eqss "REC" then
    call picstop
    set gc.MODE.v "PROCESS"
    call picsetup
    if msg.info ge 0 call picstart
  elseif msg.data eqss "STOP" then
    call picstop
    set gc.MODE.v "SETUP"
  elseif msg.data eqss "EXIT" then
    call picstop
    pipe stop
  endif
  set lmode gc.MODE.v

elseif msg.name eqs "AGCM" or msg.name eqs "AGCW" &
    or msg.name eqs "AGCL" or msg.name eqs "AGCLN" &
    or msg.name eqs "MING" or msg.name eqs "MINGN" &
    or msg.name eqs "MAXG" or msg.name eqs "MAXGN" then
  call setAGC

elseif msg.name eqs "EXPA"
  set l:nexp gc.EXPA.v
  if reg.fftw1 rexists then set reg.FFTW1.nexp nexp
  if reg.fftw2 rexists then set reg.FFTW2.nexp nexp

elseif msg.name eqs "NFFT" or msg.name eqs "PSDR" or msg.name eqs "PSDA" 
  warn "ReStart PROCESS again to enable this change"

elseif msg.name eqs "GAIN1" then
  if reg.^iom1 rexists set reg.^{iom1}.gain gc.GAIN1.v
elseif msg.name eqs "GAIN2" then
  if reg.^iom2 rexists set reg.^{iom2}.gain gc.GAIN2.v

elseif msg.name eqs "WBSCL" or msg.name eqs "WBRNG" then
  set gscale gc.WBSCL.v
  set grange gc.WBRNG.v
  set smax gc.WBSCL.v
  set smin gc.WBSCL.v-gc.WBRNG.v
  invoke reg.wbp1.setY(smax,smin)
  invoke reg.wbp2.setY(smax,smin)
  invoke reg.wrp1.setZ(smax,smin)
  invoke reg.wrp2.setZ(smax,smin)

elseif msg.name eqs "NBSCL" or msg.name eqs "NBRNG" then
  set fscale gc.NBSCL.v
  set frange gc.NBRNG.v
  set smax gc.NBSCL.v
  set smin gc.NBSCL.v-gc.NBRNG.v
  invoke reg.nbp1.setY(smax,smin)
  invoke reg.nbp2.setY(smax,smin)
  invoke reg.nrp1.setZ(smax,smin)
  invoke reg.nrp2.setZ(smax,smin)

elseif msg.name eqss "MSEL" then
  sedit msg.name ii "TRIM" "MSEL" 
  call setMx ^ii msg.data

elseif msg.name eqs "MARK" then
  if msg.fid eqss "WBP" or msg.fid eqss "WRP" then
    sedit msg.fid ii "TRIM" "WBP" "" "TRIM" "WRP"
    call setMact ^ii
    if msg.info eq 101 then
      call clickTune 1 msg.data.x
    elseif msg.info eq 1 then
      call clickSelect ^ii msg.data.x/1e6 
    endif
  endif

elseif msg.name eqs "DRAGBOX" then
  if msg.fid eqss "WBP" or msg.fid eqss "WRP" then
    if msg.info eq 101 then
      call clickTune 2 msg.data.xmin msg.data.xmax
    endif
  endif

elseif msg.name eqs "CHAN" then
  call selectrow ^msg.data 1

elseif msg.fid eqs "LIST" then
  !say "Got a LIST message ^msg.name = ^msg.data"
  if msg.name eqs "SELECT" then
    !say "Got a LIST select message ^msg.data"
    set col msg.data.name
    if msg.data.TYPE eqss "COL" then 
      set row 0
      set value ^cfg.data(0,"^col") 
      set chn "ALL"
    else
      set row msg.data.ROW
      set value msg.data.VALUE
      set chn ^cfg.data(row-1,"CHN") 
      set im ^cfg.data(row-1,"IOM") 
    endif
    if msg.data.TYPE eqs "ROW" then
      if selectedrow gt 0 and row eq selectedrow then set row 0
      call selectrow row
    elseif col subs "IOM,CHN" then
      warn "Configuration of ^col is not editable"
    elseif col eqs "ENA" then
      gc/temp menu CFG_ENA-^row "Enable" "Off,On,Pkt,Pkt2,Pkt4,Psd,Gen,Tst" /cs
    elseif col eqs "FREQ" then
      gc/temp dval CFG_FREQ-^row "Freq (MHz) " ^value 1 -1 1 /fmt="#0.000"
    elseif col eqs "BW" then
      gc/temp dval CFG_BW-^row "Filter BandWidth (MHz) " ^value 0 800 .5
    elseif col eqs "GAIN" then
      gc/temp lval CFG_GAIN-^row "Gain " ^value -100 100 1
    elseif col eqs "XATN" then
      gc/temp lval CFG_XATN-^row "Xcvr Attn " ^value 0 30 1
    elseif col eqs "RATE" then
     set rates srates rate srate xfilt cfilt
     if row gt 0 then set xfilt chn rate cfg.data(row-1,"RATE")
     if "Tun" subs xfilt then 
      sedit xfilt xfilt "TRIM" "" "TUN" "APPEND" "MOD^im"
      call genRateList xfilt
      set rates trates
     endif
     gc/temp menu CFG_RATE-^row "Sample Rate" "^rates,Input" /nc=2
    elseif gc.MODE.v neqs "SETUP" then
      warn "Configuration of ^col only editable from SETUP mode"
    elseif col eqs "ADDR" and row eq 0 then
      gc/temp menu CFG_ADDR-^row "Stream Address " "255.255.255.255,225.0.0.#,225.0.#.1,225.#.0.1,225.0.#|0.1,225.0.IoM.Idx,225.0.QSFP,10.0.1.0:800#,Input"  
    elseif col eqs "ADDR" and row gt 0 then
      gc/temp prompt CFG_ADDR-^row "Stream Address " value 16
    elseif col eqs "SID" and row eq 0 then
      gc/temp menu CFG_SID-^row "Stream ID " "#,10|#,IoM|0|Idx,10|AB,10|Idx|AB,Input" 
    elseif col eqs "SID" and row gt 0 then
      gc/temp prompt CFG_SID-^row "Stream ID " ^value 8
    elseif col eqs "FMT" then
      gc/temp menu CFG_FMT-^row "Format" "CB,CJ,CI" 
    elseif col eqs "QSFP" and row eq 0 then
      gc/temp menu CFG_QSFP-^row "QSFP Routing " "IoM.Idx,Input" 
    elseif col eqs "QSFP" and row gt 0 then
      gc/temp prompt CFG_QSFP-^row "QSFP Routing " ^value 8
    elseif col eqs "XCVR" then
      call makeRfIns
      gc/temp menu "CFG_XCVR-^row"  "RF Dev" rfins /cs
    elseif row eq 0
      warn "Configuration of ^col not editable by column"
    else
      warn "Configuration of ^col not editable by cell"
    endif
  elseif msg.name eqs "DESELECT" then
    if msg.data.TYPE eqs "ROW" then
      call selectrow 0
    endif
  endif

elseif msg.name eqss "CFG_IOM-" then
  sedit msg.name l:ims "TRIM" "-"
  call setMx ims msg.data

elseif msg.name eqss "CFG_IOT-" then
  sedit msg.name l:ims "TRIM" "-"
  call setTx ims msg.data

elseif msg.name eqss "CFG_ADDR" and msg.data eqs "INPUT" then
  gc/temp prompt ^msg.name "Stream Address " ^value 16
elseif msg.name eqss "CFG_SID" and msg.data eqs "INPUT" then
  gc/temp prompt ^msg.name "Stream ID " ^value 8
elseif msg.name eqss "CFG_QSFP" and msg.data eqs "INPUT" then
  gc/temp prompt ^msg.name "QSFP Routing " ^value 8
elseif msg.name eqss "CFG_RATE" and msg.data eqs "INPUT" then
  gc/temp dval ^msg.name "Sample Rate (MHz) " ^value 1 -1 1 /fmt="#0.000"

elseif msg.name eqss "CFG_" then
!  say "Got a msg ^col ^row from ^msg.fid"
  call doCfgMsg msg.name msg.data
  sendto "LIST" "FILES" "REREAD"

elseif msg.name eqs "ICONCLICKED" then
  if msg.data.pane eqs "LIST" then
    if msg.data.icon starts "CFG" then
      gc/temp menu "CONFIG" "Configure" "Reload,Trim,Save"
    elseif msg.data.icon starts "CF=" then
      gc/temp menu CFILT "Column Filter" "All,Odd,Even,None,iMod,oMod,iTun,oTun,Mod,Tun" /nc=2 /cs
    endif
  elseif msg.data.pane eqss "WBP" then
    sedit msg.data.pane l:ims "TRIM" "WBP"
    gc/temp menu CFG_IOM-^ims "Chn" ioms
  elseif msg.data.pane eqss "NBP" then
    sedit msg.data.pane l:ims "TRIM" "NBP"
    gc/temp menu CFG_IOT-^ims "Chn" iots
  endif

elseif msg.name eqss "QSEL" then
  call doStats gc.QMODE.v

elseif msg.name eqss "CFILT" then
  sedit msg.data cfilt "TRIM" "=" "" 
  call setMact ^mact

elseif msg.name eqss "CFGFN" then
  set cfgfn gc.CFGFN.v

elseif msg.name eqss "CONFIG" then
  if msg.data eqs "~SHOW" then
    set reg.panel.toggleborders 0x4
  elseif msg.data eqs "REREAD" then
  elseif msg.data eqs "SAVE" then
    call savecfg cfgfn
    info "Saved confiuration to ^cfgfn"
  elseif gc.MODE.v neqs "SETUP" then
    warn "Must be in SETUP mode to use this configuration option"
  elseif msg.data eqs "TRIM" then
    call tmp2txt cfgfn 1
    call loadcfg cfgfn 
  elseif msg.data eqs "LOAD" then
    call loadcfg cfgfn
    keyword/scope=main packer_cfg get "NTC" gc.NTC.action "NDC" gc.NDC.action 
    info "Loaded configuration from ^cfgfn"
  elseif msg.data eqs "RELOAD" then
    if "nxm.ice.cfg.^{cfgfn}.txt" fexists then
      erase/all "^{cfgfn}.txt" "^{cfgfn}.tmp"
      call loadcfg cfgfn
    elseif "^{cfgfn}.txt" fexists then
      call loadcfg cfgfn 
    else
      warn "Config file ^{cfgfn}.txt not found"
    endif
  else
    sedit msg.data cfgfn "LOCASE"
    set gc.CFGFN.v cfgfn
    call loadcfg cfgfn
  endif
  sendto "LIST" "FILES" "REREAD"
  set gc.CONFIG.v "Done"

elseif msg.fid eqs "RMIF" then		! handle server/client messaging
  if msg.name eqs "OPEN"
    info "Got open ^msg.data from ^msg.fid"
  elseif msg.name eqs "OPENED"
    info "Got opened ^msg.data from ^msg.fid"
    pause 0.5  ! make sure plots are up
    set gc.COMP.action "PLOT"
  elseif msg.name eqs "CLOSE"
    info "Got close ^msg.data from ^msg.fid"
  elseif msg.name eqs "CLOSED"
    info "Got closed ^msg.data from ^msg.fid"
  endif

elseif msg.name eqs "GET" then		! server side
  set t:sets msg.data
  foreach key intable sets
    if gc.^key rexists then
      set sets.^key gc.^{key}.value
    else
      set sets.^key ^key
    endif
  endfor
  message send "REPLY" msg "RET" ,, sets

elseif msg.name eqs "RET" then		! client side
  set t:sets msg.data
  foreach key intable sets
    set gc.^{key}.value "^sets.^key"
  endfor

elseif msg.name eqs "SET" then		! server side
  set t:sets msg.data
  foreach key intable sets
    set gc.^{key}.action "^sets.^key"
  endfor
  message send "REPLY" msg "ACK" ,, sets

elseif msg.name eqs "ACK" then		! client side
  set t:sets msg.data
  foreach key intable sets
    set gc.^{key}.value "^sets.^key"
  endfor

elseif msg.name eqs "EXIT"
  pipe stop

else
  ! the rest need no other action
  !say "Unhandled message ^msg.name"
endif
return


procedure getRow l:nn 
  set l:nm nn-1
  set chn cfg.data(nm,"CHN") enable cfg.data(nm,"ENA") l:im ^cfg.data(nm,"IOM")
  sedit chn l:ic "UPCASE" "TRIM" "MOD" "" "TRIM" "TUN" ""
  set l:ena test(enable,neqs,"Off") qsfp cfg.data(nm,"QSFP") addr cfg.data(nm,"ADDR") d:rate cfg.data(nm,"RATE") form cfg.data(nm,"FMT")
  set d:freq cfg.data(nm,"FREQ") l:gain cfg.data(nm,"GAIN") d:bw cfg.data(nm,"BW") l:xatn cfg.data(nm,"XATN") xcvr cfg.data(nm,"XCVR") 
  sedit qsfp l:iq "TRIM" "" "."
  sedit qsfp l:iv "TRIM" "." ""
  if ":" subs addr then
    sedit addr port "TRIM" ":" ""
    sedit addr addr "TRIM" "" ":"
  else
    set port gc.PKTPORT.v
  endif
  calc l:itc ic-1 2 / fix 1 +
  set sid cfg.data(nm,"SID") 
return

procedure txt2tmp s:filename
convert/parse filename T2B filename "A8|A8|A8|A8|A16|A8|A8|F8|F8|F8|I8|I8|A16" 1
header filename sr(1)="(CHN,)" sr(2)="(ENA,)" sr(3)="(IOM,)" sr(4)="(QSFP,)" sr(5)="(ADDR,)" sr(6)="(SID,)" sr(7)="(FMT,)" sr(8)="(RATE,)" sr(9)="(FREQ,)" sr(10)="(BW,)" sr(11)="(GAIN,)" sr(12)="(XATN,)" sr(13)="(XCVR,)" 
status filename size=len
switch "NTC" l:ntc get len	! number total channels
if ntc neq len header filename size=ntc
set ioms "None" iots "None" 
table cfgt "CREATE" "{IMS={},OMS={},ITS={},OTS={},C2R={None=0},C2P={None=0}}"
do nn 1 ntc
  set chn file(filename).data(nn-1,"CHN")
  sedit chn l:ic "UPCASE" "TRIM" "MOD" "" "TRIM" "TUN" ""
  if "TUN" subs chn then sedit iots iots "APPEND" ",^chn"
  if "MOD" subs chn then sedit ioms ioms "APPEND" ",^chn"
  set tbl file(filename).dataTable(nn-1)
  if chn eqss "iM" then set cfgt.ims.^chn tbl
  if chn eqss "oM" then set cfgt.oms.^chn tbl
  if chn eqss "iT" then set cfgt.its.^chn tbl
  if chn eqss "oT" then set cfgt.ots.^chn tbl
  set cfgt.c2r.^chn "^nn"
enddo
return

procedure tmp2txt s:filename l:trim
remove CHN ENA IOM QSFP ADDR SID FMT RATE FREQ BW GAIN XATN XCVR
file open/t/n tf "^{filename}.txt"
file write tf "CHN\tENA\tIOM\tQSFP\tADDR\t\tSID\tFMT\tRATE\tFREQ\tBW\tGAIN\tXATN\tXCVR"
foreach nn insize ntc
  if trim gt 0 and cfg.data(nn,"ENA") eqs "OFF" then continue
  file write tf "^cfg.data(nn,CHN)\t^cfg.data(nn,ENA)\t^cfg.data(nn,IOM)\t^cfg.data(nn,QSFP)\t^cfg.data(nn,ADDR)\t^cfg.data(nn,SID)\t^cfg.data(nn,FMT)\t&
    ^cfg.data(nn,RATE)\t^cfg.data(nn,FREQ)\t^cfg.data(nn,BW)\t^cfg.data(nn,GAIN)\t^cfg.data(nn,XATN)\t^cfg.data(nn,XCVR)"
endfor
file close tf
return

procedure loadcfg cs:filename
if cfg rexists file close cfg
if filename nends ".txt" then sedit filename filename "APPEND" ".txt"
if filename fexists then
  file copy/f filename ^{packcfg}.txt{aux=^aux.write}
elseif "nxm.ice.cfg.^filename" fexists then
  info "Pulling config from file=nxm.ice.cfg.^filename. Localizing template."
  file copy/f "nxm.ice.cfg.^filename" ^{packcfg}.txt{aux=^aux.write}
else
  info "Config file=^filename not found. Loading default template."
  file copy/f "nxm.ice.cfg.packcfg_def.txt" ^{packcfg}.txt{aux=^aux.write}
endif
set l:loop 0
call txt2tmp packcfg
file open/w cfg packcfg
if testloop gt 0 call testcfg
if /qsfploop then call flipqsfp
if /unicast then call makeuni
call genRateList "iMod1"
switch "LOOP" loop get loop
if reg.list rexists sendto "LIST" "OPENFILE" packcfg
return

procedure testcfg
set l:nmt -1 l:nmg -1 l:loop 3
switch "TESTRATE" testrate get testloop*100
do nn 1 ntc
  call getRow nn
  if chn eqss "iM" and testloop eq  ic then set cfg.data(nm,"ENA") "Tst" cfg.data(nm,"RATE") testrate cfg.data(nm,"GAIN") 25
  if chn eqss "iM" and testloop neq ic then set cfg.data(nm,"ENA") "Pkt" cfg.data(nm,"RATE") testrate cfg.data(nm,"GAIN") 12 nmt nm
  if chn eqss "oM" and testloop neq ic then set cfg.data(nm,"ENA") "Gen" cfg.data(nm,"RATE") testrate cfg.data(nm,"GAIN") 15 cfg.data(nm,"BW") ic*10 
  if chn eqss "oM" and testloop eq  ic then set cfg.data(nm,"ENA") "Pkt" cfg.data(nm,"RATE") testrate cfg.data(nm,"GAIN") 15 nmg nm &
    cfg.data(nm,"QSFP") cfg.data(nmt,"QSFP") cfg.data(nm,"ADDR") cfg.data(nmt,"ADDR") cfg.data(nm,"SID") cfg.data(nmt,"SID") 
  if "Tun" subs chn then set cfg.data(nm,"ENA") "Off"
enddo
return

procedure makeuni
  call getRow nmg+1
  set cfg.data(nmt,"ADDR") hwalias.nic^{iq}.addr
  set cfg.data(nmg,"ADDR") hwalias.nic^{iq}.addr
return

procedure flipqsfp
  do nm 0 ntc-1
    if cfg.data(nm,"CHN") eqss "I" continue	! only flip the outputs
    set qsfp cfg.data(nm,"QSFP") 
    sedit qsfp qsfp "GSUB" "." ":" 
    sedit qsfp qsfp "SUB" "1:" "5." "SUB" "2:" "6." "SUB" "3:" "7." "SUB" "4:" "8."
    sedit qsfp qsfp "SUB" "5:" "1." "SUB" "6:" "2." "SUB" "7:" "3." "SUB" "8:" "4."
    set cfg.data(nm,"QSFP") qsfp
  enddo
return

procedure savecfg s:filename
call tmp2txt filename
return

procedure setMact l:ims 
set mact ims
set reg.panel.panes.list.setIconBar "Cfg,CF=^cfilt,Mon=^mact"
return

procedure setMx l:ims s:chn
set iom^ims chn
set gc.MSEL^{ims}.v chn
set reg.panel.panes.wbp^{ims}.setIconBar "Chn=^chn"
if reg.pf^ims nrexists then
  ! ok nothing
elseif cfgt.c2p.^chn nrexists then
  warn "Channel ^chn not active"
  set reg.pf^{ims}.select 0
else
  set reg.pf^{ims}.select ^cfgt.c2p.^chn
endif
if reg.wbp^ims nrexists return
sendto wbp^ims "CLOSEFILE" "*"
sendto wrp^ims "CLOSEFILE" "*"
set ff^{ims}.x 0
do ic 1 mfpp
  set i^{ims}c^{ic}.x 0
enddo
if chn eqs "None" return
set l:nn ^cfgt.c2r.^chn
call getRow nn
calc xd rate/nfft 1e6 *
calc xs freq rate/2 - 1e6 *
do nn 1 ntc
  call setFeature nn
enddo
if reg.FFTW^{ims} nrexists return
if running then
  set reg.FFTW^{ims}.nexp 0
  pause 0.2
endif
set reg.FFTW^{ims}.nexp nexp
if _cbwf^ims nfexists return
header _cbwf^ims xd=xd xs=xs
sendto wbp^ims "OPENFILE" "_cbwf^ims"
sendto wrp^ims "OPENFILE" "_cbwf^ims"
return

procedure findFeatureIn l:jm s:chn l:ii
  set found 0
  if "TUN" nsubs chn return
  if iom^jm nrexists return
  set mchn iom^jm
  if mchn eqs "None" return
  sedit mchn l:mii "UPCASE" "TRIM" "MOD" ""
  if mchn starts "I" and chn starts "O" return
  if mchn starts "O" and chn starts "I" return
  if mii neq ii return
  set found 1
return

procedure setFeature l:nn
set fchn cfg.data(nn-1,"CHN") l:fii ^cfg.data(nn-1,"IOM") 
if "TUN" nsubs chn return
sedit fchn l:jc "UPCASE" "TRIM" "TUN" ""
do jm 1 2
  call findFeatureIn jm fchn fii
  if found eq 0 continue
  set freq cfg.data(nn-1,"FREQ") bw cfg.data(nn-1,"BW")
  set i^{jm}c^{jc}.dx bw*1e6
  set i^{jm}c^{jc}.x freq*1e6
enddo
return

procedure setTx l:ims s:chn
if testloop gt 0 return
set iot^ims chn
set reg.panel.panes.nbp^{ims}.setIconBar "Chn=^chn"
if reg.nbp^ims nrexists return
sendto nbp^ims "CLOSEFILE" "*"
sendto nrp^ims "CLOSEFILE" "*"
if chn eqs "None" return
if nten le 0 return
if reg.pg^ims nrexists return
set reg.pg^{ims}.select 0
set l:nn ^cfgt.c2r.^chn
call getRow nn
calc l:select ic-1 3-ntben / fix 1 +
set reg.pg^{ims}.select select
calc xd rate/nfft 1e6 *
calc xs freq rate/2 - 1e6 *
header _cbnf^ims xd=xd xs=xs
sendto nbp^ims "OPENFILE" "_cbnf^ims"
sendto nrp^ims "OPENFILE" "_cbnf^ims"
return
 
procedure makeRFins
set rfins "Clear,Bypass"
foreach id intf nxm.ice.cfg.rfinputs.txt
  sedit rfins rfins "APPEND" "," "APPEND" id
endfor 
return

procedure checkxcvr
return

procedure doStats s:action
if action eqs "CUR" then
  sedit gc.QSELX.v isfp "TRIM" "-"
  picd get cardi "QSTAT" qstat /dmac=^isfp /str
  sedit qstat gc.ADDRX.v "TRIM" "myip=" " "
  sedit qstat gc.ADDRS.v "TRIM" "xip=" " "
  sedit qstat gc.ICNTX.v "TRIM" "ipkt=" " "
  sedit qstat gc.OCNTX.v "TRIM" "opkt=" " "
  sedit qstat gc.IARPX.v "TRIM" "arp="  " "
  if gc.QSELY.v eqs "None" return
  sedit gc.QSELY.v i:ii "TRIM" "-" " " "APPEND" "00"
  if "Rx" subs gc.QSELY.v then
    set ii ii+10
  else
    set ii ii+26
  endif
  picd get cardi "SPEEDS" speed /dmac=0 /flags=SPEEDNODE=^ii
  set gc.QRATE.v (speed*1e-6)
elseif action eqs "CLR" then
  picd set cardi "NIOS" 0
  set gc.ADDRX.v "" gc.ADDRS.v "" gc.ICNTX.v "" gc.OCNTX.v "" gc.IARPX.v ""
endif
return

