!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
! ICE - Utility macro for ICE software/hardware development
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
startmacro u:function u:p1 u:p2 u:p3 u:p4 u:p5 u:p6 u:p7

global/readall 

if reg.handlers.packet.ice eqss "nxm.sys" then
  set reg.handlers.packet.ice "nxm.ice.lib.ICEPacket"
  set reg.handlers.packet.vrt "nxm.ice.lib.VRTPacket"
endif

fname afn home iceauto tbl aux
if "HWALIAS" nrexists and afn fexists then set/global T:HWALIAS ^afn

if "/THEME=" subs function
  sedit function theme trim "/THEME="
  sedit function function trim "" "/THEME="
  env set "THEME" "^theme"
endif

if function eqs "NET" then
  icenet,^p1,^p2,^p3,^p4,^p5,^p6

elseif function eqs "PIC" then
  pic,^p1,^p2,^p3,^p4,^p5,^p6

elseif function eqs "SYS" then
  invoke nxm.ice.lib.System.query("^p1")

elseif function eqss "APP" or function eqs "SNAPAPP" then
  set macro "SNAPAPP"
  if "/TBL=" subs function then
    sedit function tblfile "TRIM" "/TBL=" "/" "APPEND" ".TBL" "LOCASE"
    if tblfile nfexists then set tblfile "nxm.ice.tbl.^tblfile"
    if tblfile fexists then
      set t:cfg tblfile
      if cfg.server_defaults.macro rexists then
        set macro  cfg.server_defaults.macro
      endif
      if "/MACRO" subs cfg.applist.^p1 
        sedit cfg.applist.^p1 macro "TRIM" "/MACRO="
        if "$$" subs macro then
	  sedit function dd "TRIM" "APP" "/TBL=" "LOCASE"
	  sedit macro macro "SUBS" "$$" "^dd"
        endif
      endif
    endif
  endif
  if macro eqs "SNAPAPP" then
    snapapp/^function,^p1,^p2,^p3,^p4,^p5,^p6,^p7
  else
    run macro
  endif

elseif function eqss "SNAP" then
  snapper/^function,^p1,^p2

elseif function eqs "SIGGEN" then
  siggen,^p1,^p2,^p3

elseif function eqs "SENSOR" then
  snapapp/tbl=sensors freya

elseif function eqs "AUDIO" then
  iceaudio/dual

elseif function eqs "ARCHIVE" then
  icearchive ^p1 "^p2" ^p3 ^p4 "^p5"

elseif function eqs "AUTOCONFIG" or function eqs "AUTO" then
  iceauto

elseif function eqs "BUILD" then
  bld ^p1 ^p2 ^p3

elseif function eqs "CLEAN" then
  pic clean ^p1

elseif function eqs "DETECT" then
  picd detect

elseif function eqs "DIFF" then
  icediff ^p1 ^p2

elseif function eqs "DIR" then
  pic dir

elseif function eqs "DRIVER" then
  os cat /proc/driver/icepic

elseif function eqs "EDIT" then
  if p1 eqss "APPS"
    edit snapapp.tbl tbl ice
  elseif p1 eqss "LIB"
    edit icelib.c lib ice
  elseif p1 eqss "HWF"
    edit hwconfig.key dat ice
    hw cfg
  else
    warn "Unrecognized edit target: ^p1"
  endif

elseif function eqss "EXP" then
  explain ice

elseif function eqs "FILES" then
  files

elseif "FLASH" subs function then
  pic ^function ^p1 ^p2

elseif function eqss "HELP" then
  if p1 eqs "" res p1 "MAINHELP"
  if /gen then
    env get nmroot nmr
    file name icedoc (^nmr,htdocs,index) segments gen
    if icedoc nfexists help/index
  endif
  run ^function ^p1,ice

elseif function eqs "HOME" then
  fname icefat fat ,,, ice
  homepath icefat

elseif function eqs "INSTALL" then
  error "This function must be run from outside the Midas shell"

elseif function eqs "MAKE" then
  icemake,^p1,^p2,^p3

elseif function eqs "PFAT" then
  pic pfat ^p1 /nox

elseif function eqs "PLOT" then
  plot ^p1

elseif function eqs "RESET" then
  picdriver reset ^p1

elseif function eqs "RESETRAM" then
  import "ICEROOT" iceroot
  os ^iceroot/test/setram -1 -1 -1

elseif function eqss "SHELL" then
  shellgui

elseif function eqss "STAT" then
  pic status ^p1

elseif function eqss "SERVER" then
  iceserver/^function,^p1,^p2,^p3,^p4

elseif function eqss "CONSOLE" then
  iceconsole,^p1

elseif function eqss "MKFS" then
  sedit p1 p1 "LOCASE"
  icefs "MKFS" "^p1" ^p2

elseif function eqss "TEST" then
  icetest/^function,^p1,^p2

elseif function eqss "UTIL" then
  iceutil ^p1,^p2,^p3,^p4,^p5

elseif function eqss "IMPORT" then
  sedit p1 root "ROOT"
  res p1
  res root
  if root fexists then 
    header root det=0
    erase root
  endif
  import/f ^p1 ,, form=sl
  if file(root).data(0) eq 0x00676665 then
    set elem file(root).data(2)
    set form file(root).data(5)
    calc/type=l fmode form 0xFF BAND
    calc/type=l ftype form 256 / 0xFF BAND
    header root formattype=ftype formatmode=fmode 
    keyword root set "PACKET" "ICE/FS=^elem" /scope=main
  endif

elseif function eqs "UNPACK" then
  error "This function must be run from outside the Midas shell"
elseif function eqs "VERSION" then
  option ice /info=tbl
  info ^tbl.version
else
  warn "Unsupported ICE function: ^function
endif

endmacro
