! ----------------------------------------------------------------
!  Macro to build the ICE option tree
!
!  @author  Jeff Schoen
!  @version $Id: buildopt.mm,v 1.3 2003/12/16 20:47:43 jgs Exp $
! ----------------------------------------------------------------

startmacro u:option

import NMROOT nmroot
import ICEROOT iceroot

if /nc isFalse then
  say "--> Building Java/C/Fortran Sources for ^option <--"
  if env.ostype eqs "UNIX" then ! create links for CORE library linking
    set suffix "^{reg.shell.getLibrarySuffix}^{reg.shell.getLibraryExt}"
    os ln -sf ../lib/DevIce^suffix ^ICEROOT/core/libAll$ICE^suffix
    os ln -sf ../lib/DevIce^suffix ^ICEROOT/core/libAll$VHS^suffix
    os rm -f ^ICEROOT/lib/iceutil.class
  endif
  build/verbose all all ^option
  if /ncore isFalse then
    build/verbose all core ^option
  endif
endif

if /nh isfalse then
  say "--> Building Help for ^option <--"
  archive/echo=off on helpout.txt
  help/build ,, ^option 
  archive off
  say "--> Building Local Help for ^option <--"
  archive/echo=off on helpout.txt
  help/build ,, ^option /local
  archive off
  fname file1 docs/help ice_tree_index html ice
  fname file2 docs/help index html ice
  file copy/f file1 file2
!  if env.ostype eqs "UNIX" then 
!    os cp ^nmroot/htdocs/index.html ^iceroot/docs/
!    os cp -r ^nmroot/htdocs/index ^iceroot/docs/
!  endif
endif

if /nj isFalse then
  say "--> Building WebStart Jars for ^option <--"
  sedit "-code/&|-core/&|-drv/&|-xfer/&|-nxm/&|-dat/ice*.prm" ffilter gsub "&" "*" ! get around multiline comment parsing error
  generate/verbose/ffilt=ffilter jars ^option jars
endif

endmacro

