/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
#define TGV_NUM_PRG_BITS    32
#define TGV_USRMEM_ADR      0x00010040
#define TGV_MEMTOT_SZ       64
#define TGV_MODMEM_SZ       16 
#define TGV_MODULE_OFFSET   16
#define TGV_MAXJOIN_ADR     8
#define TGV_JOINADR_OFFSET  0x00000000 
#define TGV_VLAN_OFFSET     0x00000008
#define TGV_MODIPA_OFFSET   0x00000009

/*--------------------------------------------------------------*/
static void flip_endian(int_u4 *data, int numlword)
{
  int ii;
  for(ii=0;ii<numlword;ii++)
    data[ii]  = ((data[ii] >> 24) & 0x000000FF) |
                ((data[ii] >>  8) & 0x0000FF00) |
                ((data[ii] <<  8) & 0x00FF0000) |
                ((data[ii] << 24) & 0xFF000000);
   
}
/*--------------------------------------------------------------*/
int_4 tgvita_join_leave_pkt (PICSTRUCT *p, int_4 mport, int_4 joinleave, int_u4 groupaddr)
{  
   int_u2 txadr_offset = 0x00AE;  /* Join Address Offset */
   int ii;   
   int_u4 mjtrdval,modaddr;
   int_u4 txopreg; 
   int_u4 vlan;
   
   int_u2 igmp_frame_nv[32] = {0x0001,
                               0x075E,
                               0x0908,
                               0x6000,
                               0xF408,
                               0xF9E4,
                               0x0008,
                               0x0045,
                               0x1C00,
                               0x1200,
                               0x0000,
                               0x0201,
                               0x0000,
                               0x0081,
                               0x0200,
                               0x07E0,
                               0x0908,
                               0x0016,
                               0x0000,
                               0x07E0,
                               0x0908,
                               0x0000,
                               0x0000,0x0000,                           
                               0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000};
   int_u2 igmp_frame_v[32] =  {0x0001,
                               0x015E,
                               0x0302,
                               0x6000,
                               0xF408,
                               0xF9E4,
                               0x0081, 
                               0x0200,
                               0x0008,
                               0x0045,
                               0x1C00,
                               0x1200,
                               0x0000,
                               0x0201,
                               0x0000,
                               0x0081,
                               0x0200,
                               0x01E0,
                               0x0302,
                               0x0016,
                               0x0000,
                               0x01E0,
                               0x0302,
                               0x0000,
                               0x0000,0x0000,                           
                               0x0000,0x0000,0x0000,0x0000,0x0000,0x0000};  
   int_u4 *igmp_framelw; 
   

  /* Retrieve Vlan Of Module       */
   pic_rmodreg(p,mport,TGV_USRMEM_ADR+mport*TGV_MODULE_OFFSET+TGV_VLAN_OFFSET,&vlan,TGV_NUM_PRG_BITS); 

  /* Retrieve IP Address of Module */
   pic_rmodreg(p,mport,TGV_USRMEM_ADR+mport*TGV_MODULE_OFFSET+TGV_MODIPA_OFFSET,&modaddr,TGV_NUM_PRG_BITS);

  /* Setup Hdr Values */
  /* Setup VLAN Addr  */
   igmp_frame_v[7]   = vlan;
  
  /* Setup Mac Addr   */      
   igmp_frame_nv[0]  = 0x0001;                                   /* Dest Mac Address-Non-VLAN */                        
   igmp_frame_nv[1]  =  (int_u2) ((groupaddr & 0x7f00)|0x005E);           
   igmp_frame_nv[2]  =  (int_u2) (groupaddr >> 16);

   igmp_frame_v[0]   = 0x0001;                                   /* Des Mac Address-VLAN      */
   igmp_frame_v[1]   =  (int_u2) ((groupaddr & 0x7f00)|0x005E);           
   igmp_frame_v[2]   =  (int_u2) (groupaddr >> 16);  

   igmp_frame_nv[3]  =  0x6000;                                  /* Src MAC Address-Non-VLAN  */
   igmp_frame_nv[4]  =  (int_u2) modaddr;
   igmp_frame_nv[5]  =  (int_u2) (modaddr >> 16);
   igmp_frame_v[3]   =  0x6000;                                  /* Src MAC Address-VLAN      */
   igmp_frame_v[4]   =  (int_u2) modaddr;
   igmp_frame_v[5]   =  (int_u2) (modaddr >> 16);

  /* Setup IP Addr    */  
   igmp_frame_nv[13] =  (int_u2) modaddr;                        /* Src IP Address-VLAN       */ 
   igmp_frame_nv[14] =  (int_u2) (modaddr >> 16);
   igmp_frame_v[15]  =  (int_u2) modaddr;                        /* Src IP Address-VLAN       */
   igmp_frame_v[16]  =  (int_u2) (modaddr >> 16);

   igmp_frame_nv[15] =  (int_u2) groupaddr;                      /* Dest IP Address-VLAN      */ 
   igmp_frame_nv[16] =  (int_u2) (groupaddr >> 16);
   igmp_frame_v[17]  =  (int_u2) groupaddr;                      /* Dest IP Address-VLAN      */
   igmp_frame_v[18]  =  (int_u2) (groupaddr >> 16);

  /* Setup IGMP Addr   */  
   igmp_frame_nv[19] =  (int_u2) groupaddr;                      /* Dest IGMP Address-VLAN    */ 
   igmp_frame_nv[20] =  (int_u2) (groupaddr >> 16);
   igmp_frame_v[21]  =  (int_u2) groupaddr;                      /* Dest IGMP Address-VLAN    */
   igmp_frame_v[22]  =  (int_u2) (groupaddr >> 16);

  /* Join or Leave     */
   if (joinleave < 0)
     {
       igmp_frame_nv[17] =  0x0017;
       igmp_frame_v[19]  =  0x0017;
     }
   else
     {
       igmp_frame_nv[17] =  0x0016;
       igmp_frame_v[19]  =  0x0016;
     }
  
  /* Setup Checksums   */ 
   igmp_frame_nv[12] = sdds_compute_checksum (10,igmp_frame_nv+7);  /* IP Header CheckSum-Non-VLAN   */
   igmp_frame_nv[18] = sdds_compute_checksum (4,igmp_frame_nv+17);  /* IGMP Header Checksum-Non-VLAN */

   igmp_frame_v[14]  = sdds_compute_checksum (10,igmp_frame_v+9);   /* IP Header CheckSum-VLAN       */
   igmp_frame_v[20]  = sdds_compute_checksum (4,igmp_frame_v+19);   /* IGMP Header Checksum-VLAN     */
  
   pic_rmodreg(p,mport,0x00010001,&mjtrdval,32);
   pic_wmodreg(p,mport,0x00010001,mjtrdval | 0x04000000,TGV_NUM_PRG_BITS); /* Bit 26 Turn On IGMP Mode */

   if (vlan == 0)
     {
       pic_wmodreg(p,mport,0x00010181,0x26000040,TGV_NUM_PRG_BITS);            /* Wr Ctrl Word To Page 6 */
       pic_wmodreg(p,mport,0x00010081,0x24000040,TGV_NUM_PRG_BITS);            /* Wr Ctrl Word To Page 2 */
 
       igmp_framelw = (int_u4*) igmp_frame_nv;
     } 
   else
     {
       pic_wmodreg(p,mport,0x00010181,0x2E000040,TGV_NUM_PRG_BITS);            /* Wr Ctrl Word To Page 6 */
       pic_wmodreg(p,mport,0x00010081,0x2C000040,TGV_NUM_PRG_BITS);            /* Wr Ctrl Word To Page 2 */

       igmp_framelw = (int_u4*) igmp_frame_v;
     }

   flip_endian(igmp_framelw,16);   /* Endian Convert */
   
  /* Write Packet Data */  
   for (ii=0;ii<16;ii++)
     {    
       pic_wmodreg(p,mport,0x00010082+ii,igmp_framelw[ii],TGV_NUM_PRG_BITS);
       pic_wmodreg(p,mport,0x00010182+ii,igmp_framelw[ii],TGV_NUM_PRG_BITS);
     }
   pic_wmodreg(p,mport,0x0000000A,0x0000000A,TGV_NUM_PRG_BITS); 


   return(0);    
}
/*--------------------------------------------------------------*/
static int tgvita_add_mcgroup(PICSTRUCT *p, int_4 mport, int_u4 ip_addr)
{
  int ii;
  int_u4 mjtrdval;

 /* If Dest IP Adr = Multicast, Setup Multicast HW Adr */ 
  if (((ip_addr & 0x000000ff) <= 223) || ((ip_addr & 0x000000ff) >= 240))
    {                 
      printf("Error: User Must Specify Valid Multicast Addres For Join!\n");
      printf("Error: Address Range 224.xx.yy.zz To 239.xx.yy.zz\n");
      return(-1);
    }
    
 /* Check For Open Mem Location */
  for(ii=0;ii<TGV_MAXJOIN_ADR;ii++)       
    {       
      pic_rmodreg(p,mport,TGV_USRMEM_ADR+(mport*TGV_MODULE_OFFSET)+TGV_JOINADR_OFFSET+ii,&mjtrdval,32);
      if (mjtrdval == 0)
        { 
          pic_wmodreg(p,mport,TGV_USRMEM_ADR+(mport*TGV_MODULE_OFFSET)+TGV_JOINADR_OFFSET+ii,ip_addr,32); /* Store Join Addr */    
          return(0);
        }  
    } 

  printf("Error: Join Request Ignored, Join Requests Limited To Maximum of %d\n",TGV_MAXJOIN_ADR);
  return(-1); 
}
/*--------------------------------------------------------------*/
static int tgvita_delete_mcgroup(PICSTRUCT *p, int_4 mport, int_u4 ip_addr)
{
  int ii;
  int_u4 mjtrdval;
  
 /* If Dest IP Adr = Multicast, Setup Multicast HW Adr */ 
  if (((ip_addr & 0x000000ff) <= 223) || ((ip_addr & 0x000000ff) >= 240))
    {                 
      printf("Error: User Must Specify Valid Multicast Address For Leave!\n");
      printf("Error: Address Range 224.xx.yy.zz To 239.xx.yy.zz\n");
      return(-1);
    }
    
 /* Check For Open Mem Location */
  for(ii=0;ii<TGV_MAXJOIN_ADR;ii++)       
    {       
      pic_rmodreg(p,mport,TGV_USRMEM_ADR+(mport*TGV_MODULE_OFFSET)+TGV_JOINADR_OFFSET+ii,&mjtrdval,32);
      if (mjtrdval == ip_addr)
        { 
          pic_wmodreg(p,mport,TGV_USRMEM_ADR+(mport*TGV_MODULE_OFFSET)+TGV_JOINADR_OFFSET+ii,0,32); /* Remove Current Join Addr */    
          return(0);
        }  
    } 

  printf("Warn: Leave Request Ignored, Module Not Joined To Requested Leave Address\n");
  return(0); 
}
/*--------------------------------------------------------------*/
static int tgvita_join_all(PICSTRUCT *p, int_4 mport)
{ 
  int ii;
  int_u4 mjtrdval;

 /* Check Mem Locations For Addresses To Join */
  for(ii=0;ii<TGV_MAXJOIN_ADR;ii++)       
    {       
      pic_rmodreg(p,mport,TGV_USRMEM_ADR+(mport*TGV_MODULE_OFFSET)+TGV_JOINADR_OFFSET+ii,&mjtrdval,32);
      if (mjtrdval != 0)
        tgvita_join_leave_pkt(p,mport,1,mjtrdval); 
    } 
  return(0);
}
/*--------------------------------------------------------------*/
static int tgvita_leave_all(PICSTRUCT *p, int_4 mport)
{ 
  int ii;
  int_u4 mjtrdval;     

 /* Check Mem Locations For Addresses To Join */
  for(ii=0;ii<TGV_MAXJOIN_ADR;ii++)       
    {       
      pic_rmodreg(p,mport,TGV_USRMEM_ADR+(mport*TGV_MODULE_OFFSET)+TGV_JOINADR_OFFSET+ii,&mjtrdval,32);
      if (mjtrdval != 0)
        {
          tgvita_delete_mcgroup(p,mport,mjtrdval);
          tgvita_join_leave_pkt(p,mport,-1,mjtrdval);   /* Send Leave Twice */   
          tgvita_join_leave_pkt(p,mport,-1,mjtrdval);     
        } 
    } 
  return(0);
}
/*--------------------------------------------------------------*/
int_4 vita_join_leave_group (PICSTRUCT *p, int_4 mport, int_4 joinleave, int_u4 groupaddr, int_u2 running)
{
 /* Port 2 Not Enabled Yet                */
  if (mport == 2)
    return(0);
  
  if (joinleave < 0)  /* Leave */
    {     
      if (tgvita_delete_mcgroup(p,mport,groupaddr) < 0)
        return(0);
      if (running > 0)
        {          
          tgvita_join_leave_pkt(p,mport,-1,groupaddr); /* Send Leave Twice */ 
          tgvita_join_leave_pkt(p,mport,-1,groupaddr);
        }  
      return(0);
    }
  else                /* Join  */
    {
      if (tgvita_add_mcgroup(p,mport,groupaddr) != -1)
        {
           if (running > 0)
             return(tgvita_join_leave_pkt(p,mport,1,groupaddr));
           else
             return(0); 
        }
    }

  return(-1); 
}
/*--------------------------------------------------------------*/
int_4 pic_tgvxdr1_dump(PICSTRUCT *p, int_4 mport, int_u4 flag)
{
   int_u4 dat,ii;
   int jj;
   int temp_sense_active = 0;
   int new_line_flag = 0;

/*
   if (findflag("TGVDBG",p->config) < 0)
     {       
       for (ii=0;ii<40;ii++)
         {
           pic_rmodreg(p,mport,ii,&dat,32);
           printf("\tAddress = %x\tData = %08lx\n",ii,dat);
         }
     }
*/

   if (findflag("TGVDBG",p->config) < 0)						/* oixd_vita register dump, content formatting, */
     {											/* added by Mark Davis, 04-23-13 */
       printf("\n\toixd_vita FPGA Register Dump:\n\n");
       for (ii=1;ii<40;ii+=2)
         {
           switch (ii) {
             case 1:									/* address 1 and 2 */
               pic_rmodreg(p,mport,ii,&dat,32);
               printf("\tGlobal Config Register          = %08x",dat);
               pic_rmodreg(p,mport,ii+1,&dat,32);
               printf("\t\tGlobal Status Register        = %08x\n",dat);
               break;
             case 3:									/* address 3, 4, and 14 */
               pic_rmodreg(p,mport,ii,&dat,32);
               printf("\tInternal Error Register Zero    = %08x",dat);
               if (dat != 0)
                 {
                   printf(" *");
                 } 
               pic_rmodreg(p,mport,ii+1,&dat,32);
               printf("\t\tInternal Error Register One   = %08x",dat);
               if (dat != 0)
                 {
                   printf(" *");
                 } 
               printf("\n");
               pic_rmodreg(p,mport,ii+11,&dat,32);
               printf("\tInternal Error Register Two     = %08x",dat);
               if (dat != 0)
                 {
                   printf(" *");
                 } 
               break;
             case 5:									/* address 5 and 6 */
               pic_rmodreg(p,mport,ii,&dat,32);
               printf("\t\tOperational Err Register Zero = %08x",dat);
               if (dat != 0)
                 {
                   printf(" *");
                 } 
               printf("\n");
               pic_rmodreg(p,mport,ii+1,&dat,32);
               printf("\tOperational Error Register One  = %08x",dat);
               if (dat != 0)
                 {
                   printf(" *");
                 } 
               printf("\n");
               break;
             case 7:									/* address 7 */
               pic_rmodreg(p,mport,ii,&dat,32);
               printf("\tPacket Size Config Register     = %08x",dat);
               break;
             case 11:									/* address b and c */
               pic_rmodreg(p,mport,ii,&dat,32);
               printf("\t\tFPGA Build Number             = %02d / %02xh\n",dat,dat);
               pic_rmodreg(p,mport,ii+1,&dat,32);
               printf("\tDebug Config Register           = %08x",dat);
               if (dat == 0)								/* if debug config is clear (not in use) */
                 {
                   pic_wmodreg(p,mport,ii+1,0x00030000,32);				/* then issue a temp sense command */
                   temp_sense_active = 1;
                 } 
               break;
             case 13:									/* address d, 38, and f */
               pic_rmodreg(p,mport,ii,&dat,32);
               printf("\t\tDebug Status Register         = %08x\n",dat);
               if (temp_sense_active != 0)						/* if we're doing a temp sense, */
                 {
                   pic_wmodreg(p,mport,12,0x00010000,32);				/* then deassert the temp sense reset (start temp reading) */
                 } 
               pic_rmodreg(p,mport,ii+43,&dat,32);
               printf("\tXmt MCast Address Mod Mask      = %08x",dat);
               pic_rmodreg(p,mport,ii+2,&dat,32);
               printf("\t\tRcv IP Gap Measurement Config = %08x\n\n",dat);
               break;
             case 15:									/* address 11 and 10, first stat counters */
               pic_rmodreg(p,mport,ii+2,&dat,32);
               printf("\tTransmit Path, Packet Count     = %08x",dat);
               pic_rmodreg(p,mport,ii+1,&dat,32);
               printf("\t\tTransmit Path A, PDU Rcvd Cnt = %08x\n",dat);
               break;
             case 17:									/* address 12 and 16 */
               pic_rmodreg(p,mport,ii+1,&dat,32);
               printf("\tReceive Path, Packet Count      = %08x",dat);
               pic_rmodreg(p,mport,ii+5,&dat,32);
               printf("\t\tTransmit Path B, PDU Rcvd Cnt = %08x\n",dat);
               break;
             case 19:									/* address 15, 14, 13, and 17 */
               pic_rmodreg(p,mport,ii+2,&dat,32);
               printf("\tRcv Path, Discards, Bufs Full   = %08x",dat);
               pic_rmodreg(p,mport,ii+1,&dat,32);
               printf("\t\tReceive Path A, PDU Xmt Count = %08x\n",dat);
               pic_rmodreg(p,mport,ii,&dat,32);
               printf("\tReceive Path, Errored Packets   = %08x",dat);
               pic_rmodreg(p,mport,ii+4,&dat,32);
               printf("\t\tReceive Path B, PDU Xmt Count = %08x\n",dat);
               break;
             case 23:									/* address 18 */
               pic_rmodreg(p,mport,ii+1,&dat,32);
               printf("\tRcv Class. IGMP Pckts Received  = %08x",dat);
               break;
             case 25:									/* address 19 and 1a */
               pic_rmodreg(p,mport,ii,&dat,32);
               printf("\t\tRcv Class. Non-IP Pckt Discrd = %08x\n",dat);
               pic_rmodreg(p,mport,ii+1,&dat,32);
               printf("\tIP, Non-UDP / Non-IGMP Discards = %08x",dat);
               break;
             case 27:									/* address 1b and 1c */
               pic_rmodreg(p,mport,ii,&dat,32);
               printf("\t\tRcv Class. ARP Ping Packets   = %08x\n",dat);
               pic_rmodreg(p,mport,ii+1,&dat,32);
               printf("\tRcv Class, ICMP Ping Packets    = %08x",dat);
               break;
             case 29:									/* address 1d and 1e */
               pic_rmodreg(p,mport,ii,&dat,32);
               printf("\t\tRcv Class. UDP Out-of-Group   = %08x\n",dat);
               pic_rmodreg(p,mport,ii+1,&dat,32);
               printf("\tRcv Class, Discards on Error    = %08x",dat);
               break;
             case 31:									/* address 1f and 20 */
               pic_rmodreg(p,mport,ii,&dat,32);
               printf("\t\tRcv Class. Discards N/Forward = %08x\n",dat);
               pic_rmodreg(p,mport,ii+1,&dat,32);
               printf("\tRcv Class, UDP Filtered         = %08x",dat);
               break;
             case 33:									/* address 21 and 22 */
               pic_rmodreg(p,mport,ii,&dat,32);
               printf("\t\tRcv Reorder Discard Fills     = %08x\n",dat);
               pic_rmodreg(p,mport,ii+1,&dat,32);
               printf("\tRcv Reorder, Recovery           = %08x",dat);
               break;
             case 35:									/* address 23 and 24 */
               pic_rmodreg(p,mport,ii,&dat,32);
               printf("\t\tRcv IP Gap Measurement Low    = %08x\n",dat);
               pic_rmodreg(p,mport,ii+1,&dat,32);
               printf("\tRcv IP Gap Measurement Med      = %08x",dat);
               break;
             case 37:									/* address 25 and 26 */
               pic_rmodreg(p,mport,ii,&dat,32);
               printf("\t\tRcv IP Gap Measurement High   = %08x\n",dat);
               pic_rmodreg(p,mport,ii+1,&dat,32);
               printf("\tRcv Length Errors               = %08x\n",dat);
               break;
             case 39:
               printf("\n");
               break;
             default:
               break;
           }
         }
       pic_rmodreg(p,mport,0x000101c0,&dat,32);						/* output IGMP group info if it's valid */
       if (dat != 0)
         {
           printf("\tIGMP Group Zero Control word    = %08x",dat);
           pic_rmodreg(p,mport,0x000101c1,&dat,32);
           printf("\t\tIGMP Group Zero Address       = %08x\n",dat);
           new_line_flag = 1;
         } 
       pic_rmodreg(p,mport,0x000101c2,&dat,32);
       if (dat != 0)
         {
           printf("\tIGMP Group One Control word     = %08x",dat);
           pic_rmodreg(p,mport,0x000101c3,&dat,32);
           printf("\t\tIGMP Group One Address        = %08x\n",dat);
           new_line_flag = 1;
         } 
       pic_rmodreg(p,mport,0x000101c4,&dat,32);
       if (dat != 0)
         {
           printf("\tIGMP Group Two Control word     = %08x",dat);
           pic_rmodreg(p,mport,0x000101c5,&dat,32);
           printf("\t\tIGMP Group Two Address        = %08x\n",dat);
           new_line_flag = 1;
         } 
       pic_rmodreg(p,mport,0x000101c6,&dat,32);
       if (dat != 0)
         {
           printf("\tIGMP Group Three Control word   = %08x",dat);
           pic_rmodreg(p,mport,0x000101c7,&dat,32);
           printf("\t\tIGMP Group Three Address      = %08x\n",dat);
           new_line_flag = 1;
         } 
       pic_rmodreg(p,mport,0x000101c8,&dat,32);
       if (dat != 0)
         {
           printf("\tIGMP Group Four Control word    = %08x",dat);
           pic_rmodreg(p,mport,0x000101c9,&dat,32);
           printf("\t\tIGMP Group Four Address       = %08x\n",dat);
           new_line_flag = 1;
         } 
       pic_rmodreg(p,mport,0x000101ca,&dat,32);
       if (dat != 0)
         {
           printf("\tIGMP Group Five Control word    = %08x",dat);
           pic_rmodreg(p,mport,0x000101cb,&dat,32);
           printf("\t\tIGMP Group Five Address       = %08x\n",dat);
           new_line_flag = 1;
         } 
       pic_rmodreg(p,mport,0x000101cc,&dat,32);
       if (dat != 0)
         {
           printf("\tIGMP Group Six Control word     = %08x",dat);
           pic_rmodreg(p,mport,0x000101cd,&dat,32);
           printf("\t\tIGMP Group Six Address        = %08x\n",dat);
           new_line_flag = 1;
         } 
       pic_rmodreg(p,mport,0x000101ce,&dat,32);
       if (dat != 0)
         {
           printf("\tIGMP Group Seven Control word   = %08x",dat);
           pic_rmodreg(p,mport,0x000101cf,&dat,32);
           printf("\t\tIGMP Group Seven Address      = %08x\n",dat);
           new_line_flag = 1;
         } 
       if (new_line_flag != 0)
         {
           printf("\n");
         }
       if (temp_sense_active != 0)							/* if we're doing a temp sense, */
         {
           pic_rmodreg(p,mport,13,&dat,32);						/* then read the debug status (get the temp data) */
           dat = ((dat >> 16) & 0x000000ff);
           dat = (dat - 128);								/* (convert to deg c */
           printf("\t-- Measured oixd_vita FPGA Die Temperature = %d deg C --\n",dat);	/* display it */
           pic_wmodreg(p,mport,12,0,32);						/* clear the debug config word (return to it's orig value */
         } 
       printf("\n");
     }											/* (end of oixd_vita fpga register dump) */


   if (findflag("TGVDBG",p->config) >= 0)
     { 
       jj = findintflag("WRAMODDUMP",p->config);
       if (jj >= 0)
         {
           ii = (int_u4)findintflag("WRDMODDUMP",p->config);
           pic_wmodreg(p,mport,jj,ii,32);                  /* Write Module Register */
         }
       else
         {
           jj = findintflag("RDAMODDUMP",p->config);      
           pic_rmodreg(p,mport,jj,&dat,32);                /* Read  Module Register */ 
           printf("Read Value = %08x\n",dat);
         }
      } 
   
 
 
   return(0);
}
/*--------------------------------------------------------------*/
int_4 pic_enable_tgvitar1(PICSTRUCT *p, int_4 mport,int_4 dis_enable)
{
  int_u4 mjtrdval;
  
 /* Port 2 Not Enabled Yet                */
  if (mport == 2)
    return(0);
  
  pic_rmodreg(p,mport,0x00000001,&mjtrdval,32);  /* Read Global Config Reg */  

  if (dis_enable == 0)
    {       
       tgvita_leave_all(p,mport);
       pic_wmodreg(p,mport,0x00000001,mjtrdval & 0xFFFFFFFC,TGV_NUM_PRG_BITS);   /* Output-Dual  ICE LVDS Ports */
    }
  else
    {  
       pic_wmodreg(p,mport,0x00000001,mjtrdval | 0x00000001,TGV_NUM_PRG_BITS);   /* Output-Dual  ICE LVDS Ports */
       tgvita_join_all(p,mport);  /* Join All MC Addresses */ 
    }
  return(0);
}

/*--------------------------------------------------------------*/
int_4 tgvita_synclk_cfg (PICSTRUCT *p, int_4 mport, int_u4 maddr, int_u4 value)
{   
  int_u4 mjtrdval;

   pic_wmodreg(p,mport,maddr,((value >> 8) & 0x000000FF),TGV_NUM_PRG_BITS);         /* Set Register Address To Write */
   udelay(500);

   pic_wmodreg(p,mport,maddr,(value & 0x000000FF) | 0x00004000,TGV_NUM_PRG_BITS);   /* Write Data To Register        */ 
   udelay(500);

   return(0);    
}
/*--------------------------------------------------------------*/
int_4 pic_setup_tgvita_clks(PICSTRUCT *p) 
{
#define TGVXDR1_PHYRATE   644531250.0   /* Predefines For 644.53125 MHz Out Clk1 and Clk2 */

   Si5326_Reg_Obj Si5326_Reg; 
   int ii;
   int_u4 jj;
   float fcrate,bitmult; 
   int_u4 mjtrdval;

   int_u4 encfgval[2]  = {0,0};
   int_u4 enopval[2]   = {0,0};
   int_u4 cbcfgval[2]  = {0,0};
   int_u4 rstcfgval[2] = {0,0};
   int_u4 altport      = 0;
 
   Si5326_Reg.debuglevel = -1;
   Si5326_Reg.fref       =  10000000.0;        
   Si5326_Reg.dclk1      = TGVXDR1_PHYRATE;
   Si5326_Reg.dclk2      = TGVXDR1_PHYRATE;       
   Si5326_Reg.dwght1     = 1.0;
   Si5326_Reg.dwght2     = 1.0;   
   ii = si5326_regcfg_init(&Si5326_Reg,SI5326_REGCFG_MT_TGSPHY);
   ii = si5326_regcfg_bwsel(&Si5326_Reg,7);             
   ii = si5326_regcfg_clkin(&Si5326_Reg,SI5326_REGCFG_CLKIN_2);           
   ii = si5326_regcfg_dividers(&Si5326_Reg);
   if (ii != 0)
     printf("TGVITA Warning: TGVITA PHY rate not possible. Using %f\n",Si5326_Reg.fclk2);
   si5326_regcfg_debug(&Si5326_Reg);
   for(ii=0; ii<Si5326_Reg.numreg; ii++) 
     {
       if ((Si5326_Reg.regval[ii] & 0x0000FF00) == 0x00000600)    /* Change To LVDS */
             Si5326_Reg.regval[ii] = 0x0000063F;
                      
           tgvita_synclk_cfg(p,1,0x00000008,Si5326_Reg.regval[ii]);                       
           udelay(1000);
         }
      
   /* printf("Finished AnyRate Clock Setup\n"); */ 
   sleep(1);
                   
   for (jj=1;jj<=2;jj++)                                             /* Remove Xcvr Reset Both Module Sites  */                     
     {      
       /** Phy Configuration          **/           
        pic_rmodreg(p,jj,0x00000001,&mjtrdval,TGV_NUM_PRG_BITS);     /* Remove Hard Reset To PHY Device      */
        pic_wmodreg(p,jj,0x00000001,mjtrdval & 0xFFFFFEFF,TGV_NUM_PRG_BITS);                                
                
       /* Assert Rx & Tx Resets in PHY */
        pic_wmodreg(p,jj,0x000D0044,0x0000000E,TGV_NUM_PRG_BITS); 
       
       /* Remove Global Xcvr Powerdown */
        pic_rmodreg(p,jj,0x00000001,&mjtrdval,32);
        pic_wmodreg(p,jj,0x00000001,mjtrdval & 0xFFFFF7FF,TGV_NUM_PRG_BITS);
        udelay(4000);
               
       /* Remove PLL Powerdown         */
        pic_rmodreg(p,jj,0x00000001,&mjtrdval,32);
        pic_wmodreg(p,jj,0x00000001,mjtrdval & 0xFFFFFBFF,TGV_NUM_PRG_BITS);
        udelay(4000);
               
       /* Remove Global Cal Powerdown  */
        pic_rmodreg(p,jj,0x00000001,&mjtrdval,32);
        pic_wmodreg(p,jj,0x00000001,mjtrdval & 0xFFFFFDFF,TGV_NUM_PRG_BITS);
        udelay(4000);
               
       /* Remove Rx & Tx Resets in PHY  */
        pic_wmodreg(p,jj,0x000D0044,0x00000000,TGV_NUM_PRG_BITS); 

       
       /**MAC Configuration           **/
        pic_rmodreg(p,jj,0x00000001,&mjtrdval,32);                   /* Remove MAC Cfg Reset                 */
        pic_wmodreg(p,jj,0x00000001,((mjtrdval & 0xFFFFEFFF)|0x00020000),TGV_NUM_PRG_BITS);       
        
        pic_rmodreg(p,jj,0x00000001,&mjtrdval,32);                   /* Remove MAC Tx & RX Reset             */      
        pic_wmodreg(p,jj,0x00000001,mjtrdval & 0xFFFF9FFF,TGV_NUM_PRG_BITS);
       /* printf("Finished MAC\n");  */                                                                                                                       
     }                    
      

  return(0);
}
/*--------------------------------------------------------------*/
int_4 pic_init_tgvita (PICSTRUCT *p) 
{
  int_u4 mjtrdval=0;
  sleep(1);
  int ii;
  
  pic_setup_tgvita_clks(p);

 /* Initialize Module Software Memory     */
  for(ii=0;ii<TGV_MEMTOT_SZ;ii++)
    pic_wmodreg(p,1,TGV_USRMEM_ADR+ii,0,TGV_NUM_PRG_BITS);
   
 
  return 0;
}

/*--------------------------------------------------------------*/
int_4 pic_config_tgvita(PICSTRUCT *p, int_4 mport, int_u4 streamid,int_u4 streammask, 
                                                   int_u4 oui,     int_u4 ouimask, 
                                                   int_u4 iccpcc,  int_u4 iccpccmask, 
                                                   int_u4 pktsz)
{
#define MINVITAPKTSZ   256
#define MAXVITAPKTSZ  1472
#define IPPKTLENOFF      8
#define IPCHKSUMOFF     12
#define UDPPKTLENOFF    19 
   
  int_u2 *ipudphdr;
  int_u4 ipudphdrlw[12];
  int_u4 vlan;
  int_u4 voffset = 0;
  int_u4 ii;

  if (mport == 2)
    return(0);

 /* Write the vita packet filtering config data to the oixd_vita fpga.... */
 /* pic_wmodreg(p,mport,0x000101e0,streamid,TGV_NUM_PRG_BITS);
  pic_wmodreg(p,mport,0x000101e1,streammask,TGV_NUM_PRG_BITS);
  pic_wmodreg(p,mport,0x000101e2,oui,TGV_NUM_PRG_BITS);
  pic_wmodreg(p,mport,0x000101e3,ouimask,TGV_NUM_PRG_BITS);
  pic_wmodreg(p,mport,0x000101e4,iccpcc,TGV_NUM_PRG_BITS);
  pic_wmodreg(p,mport,0x000101e5,iccpccmask,TGV_NUM_PRG_BITS);
 */

  pic_wmodreg(p,mport,0x000101e0,0,TGV_NUM_PRG_BITS);
  pic_wmodreg(p,mport,0x000101e1,0,TGV_NUM_PRG_BITS);
  pic_wmodreg(p,mport,0x000101e2,0,TGV_NUM_PRG_BITS);
  pic_wmodreg(p,mport,0x000101e3,0,TGV_NUM_PRG_BITS);
  pic_wmodreg(p,mport,0x000101e4,0,TGV_NUM_PRG_BITS);
  pic_wmodreg(p,mport,0x000101e5,0,TGV_NUM_PRG_BITS);

  if ((pktsz < MINVITAPKTSZ) || (pktsz > MAXVITAPKTSZ))
    {
      printf("Error: Vita Pkt Size Range %d <= pkt size <= %d\n",MINVITAPKTSZ,MAXVITAPKTSZ);
      printf("Error: Requested Vita Packet Size %d Out Of Range\n",pktsz); 
      return(-1);
    } 

 /* Retrieve Vlan Of Module       */
  pic_rmodreg(p,mport,TGV_USRMEM_ADR+mport*TGV_MODULE_OFFSET+TGV_VLAN_OFFSET,&vlan,TGV_NUM_PRG_BITS); 

  if (vlan != 0)
    voffset = 2; 

 /* Read MAC, IP, and UDP Header                  */
  for (ii=0;ii<((22+voffset)/2);ii++)
    pic_rmodreg(p,mport,0x00010002+ii,ipudphdrlw+ii,TGV_NUM_PRG_BITS);

 /* Reformat To Little Endian */
  flip_endian(ipudphdrlw,12);

  ipudphdr = (int_u2 *) ipudphdrlw;
  
 /* Vita Pkt Size + IP Hdr + UDP Hdr    */
  ipudphdr[IPPKTLENOFF+voffset]  = (((pktsz + 28) >> 8) & 0x000000FF) | (((pktsz + 28) << 8) & 0x0000FF00);  
 /* Reset IP Chksum =0, For Chksum Calc */
  ipudphdr[IPCHKSUMOFF+voffset]  = 0;                            
 /* Vita Pkt Size + UDP Hdr             */                                            
  ipudphdr[UDPPKTLENOFF+voffset] = (((pktsz + 8) >> 8) & 0x000000FF) | (((pktsz + 8) << 8) & 0x0000FF00);   

 /* IP Header CheckSum                  */
  ipudphdr[IPCHKSUMOFF+voffset]  = sdds_compute_checksum(10,ipudphdr+7+voffset);    

 /* Reformat To Big Endian    */
  flip_endian(ipudphdrlw,12); 

 /* Set Up MAC, IP, and UDP Header                  */
  for (ii=0;ii<((22+voffset)/2);ii++)
    pic_wmodreg(p,mport,0x00010002+ii,ipudphdrlw[ii],TGV_NUM_PRG_BITS);                                          

 /* Pkt Sz-PDU 256, VITA PKT 1472-Data, Hdr & Trlr  */ 
  pic_wmodreg(p,mport,0x00000007,0x00040000 + pktsz,TGV_NUM_PRG_BITS);  

  return(0);      
}

/*--------------------------------------------------------------*/
int_4 pic_setup_tgvita(PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 bits, int_4 ports) 
{
 int_u4 mjtrdval;
 int_u2 mac_hdr[7]   = {0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000}; 
 int_u2 ip_hdr[10]   = {0x0045, 0x5404, 0x0000, 0x0080, 0x1140, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000};
 int_u2 udp_hdr[4]   = {0x0000, 0x0000, 0x0000, 0x0000};
 int_u4 vita_mac_hdr[12]; 

 int_u2 vita_mac_hdr_nv[24] = {0xFFFF,0xFFFF,0xFFFF,
                               0x6000,0xF408,0xF9E4,
                               0x0008,
                               0x0045,                  /* Type of Service, Version, Hdr Len */
                               0xDC05,                  /* Pkt Total Length                  */
                               0x9856,                  /* ID                                */   
                               0x0000,                  /* Fragment                          */
                               0x1140,                  /* Protocol=17,UDP,Time To Live=32   */
                               0x0000,                  /* IP Hdr Checksum                   */ 
                               0x0081, 0x0200,          /* Source IP Address                 */
                               0x0081, 0x0100,          /* Destingation Ip Address           */
                               0x0000,                  /* Source Port                       */
                               0x3773,                  /* Detination Port                   */
                               0xC805,                  /* UPD Pkt Len-Data + 8 Byte Hdr     */
                               0x0000,                  /* Chksum, 0 When Not Computed       */
                               0x0000,0x0000,0x0000};   /* Extra For 4 Byte Alignment        */

 int_u2 vita_mac_hdr_v[24]  = {0xFFFF,0xFFFF,0xFFFF,
                               0x6000,0xF408,0xF9E4,
                               0x0081,                  /* VLAN Constant                     */
                               0x0000,                  /* VLAN Number                       */
                               0x0008,
                               0x0045,                  /* Type of Service, Version, Hdr Len */
                               0xDC05,                  /* Pkt Total Length                  */
                               0x9856,                  /* ID                                */   
                               0x0000,                  /* Fragment                          */
                               0x1140,                  /* Protocol=17,UDP,Time To Live=32   */
                               0x0000,                  /* IP Hdr Checksum                   */  
                               0x0081, 0x0200,          /* Source IP Address                 */
                               0x0081, 0x0100,          /* Destination Ip Address            */
                               0x0000,                  /* Source Port                       */
                               0x3773,                  /* Detination Port                   */
                               0xC805,                  /* UPD Pkt Len-Data + 8 Byte Hdr     */
                               0x0000,                  /* Chksum, 0 When Not Computed       */
                               0x0000};                 /* Extra For 4 Byte Alignment        */



  int ii,status;
  int vlan = -1;
  Si5326_Reg_Obj Si5326_Reg; 
  int_u4 jj;
  float  fcrate,bitmult;
  int    voffset    = 0; 
  int_u4 modaddr = 0;
  char   flgname[20];
  int_u2 portnum; 
  int_u4 ip_addr = 0;

 /* Port 2 Not Enabled Yet                */
  if (mport == 2)
    return(0);  

 /* Initialize Module Software Memory     */
  for(ii=0;ii<TGV_MODMEM_SZ;ii++)
    pic_wmodreg(p,mport,TGV_USRMEM_ADR+mport*TGV_MODULE_OFFSET+ii,0,TGV_NUM_PRG_BITS); 
      
 /* Determine Module IP Address From User */
  if (mport == 1)   
    modaddr = convert_ip_addr2("IPADDR1","IPADDR",p->config);
  else    
    modaddr = convert_ip_addr2("IPADDR2","IPADDR",p->config);
   
  if (modaddr == 0) modaddr = SDDS_DEFAULT_MODULE_IP_ADDR;


 /* Store IP Address of Module */
  pic_wmodreg(p,mport,TGV_USRMEM_ADR+mport*TGV_MODULE_OFFSET+TGV_MODIPA_OFFSET,modaddr,TGV_NUM_PRG_BITS);

 /* Setup Hdr Values */
 /* Setup Mac Addr   */      
  vita_mac_hdr_nv[3]  =  0x6000;            /* Src MAC Address-Non-VLAN */
  vita_mac_hdr_nv[4]  =  modaddr;
  vita_mac_hdr_nv[5]  =  (modaddr >> 16);
  vita_mac_hdr_v[3]   =  0x6000;            /* Src MAC Address-VLAN     */
  vita_mac_hdr_v[4]   =  modaddr;
  vita_mac_hdr_v[5]   =  (modaddr >> 16);

 /* Setup IP Addr    */  
  vita_mac_hdr_nv[13] =  modaddr;           /* Src IP Address-VLAN      */ 
  vita_mac_hdr_nv[14] =  (modaddr >> 16);
  vita_mac_hdr_v[15]  =  modaddr;           /* Src IP Address-VLAN      */
  vita_mac_hdr_v[16]  =  (modaddr >> 16);

 
 /* Check For Vlan   */
  vlan = sdds_vlan(p,mport);
  if (vlan != -1)  
    { 
      voffset = 2;             
      vita_mac_hdr_v[7]  =  ((vlan << 8) & 0xFF00) | ((vlan >> 8) & 0x00FF);        /* Set VLAN Number                             */        
      pic_wmodreg(p,mport,0x00010001, 0x08000000 |0x1000002E,TGV_NUM_PRG_BITS);  /* VLAN-Increase HDR Size, Add VLAN Enable Bit */ 
      pic_wmodreg(p,mport,TGV_USRMEM_ADR+mport*TGV_MODULE_OFFSET+TGV_VLAN_OFFSET,vita_mac_hdr_v[7],TGV_NUM_PRG_BITS);           
    } 
  else
    {
      pic_wmodreg(p,mport,0x00010001,0x1000002A,TGV_NUM_PRG_BITS);               /* Non-VLAN */
      pic_wmodreg(p,mport,TGV_USRMEM_ADR+mport*TGV_MODULE_OFFSET+TGV_VLAN_OFFSET,0,TGV_NUM_PRG_BITS);
    }    

  if (dir > 0)
    { 
      sprintf (flgname,"TXDESTIP%d",mport);
      if (findflag(flgname,p->config) < 0) sprintf (flgname,"IPDEST%d",mport);
      if (findflag(flgname,p->config) < 0)
        {
          printf("For Raw Output, Flag %s Must Be Set To Dest IP Address\n",flgname);
          return(-1);
        }
      ip_addr = convert_ip_addr(flgname,p->config);  /* Find Address From Cfg String-Network Byte Ordered */
      portnum = convert_ip_port(flgname,p->config);  /* Find Port From Cfg String-Network Byte Ordered */
      if (portnum>0)
        {           
           portnum = (int_u2) (((portnum >> 8) & 0x00FF) | ((portnum << 8) & 0xFF00));  /* Big Endian */
           vita_mac_hdr_nv[18]  =  portnum;   /* Non-VLAN */ 
           vita_mac_hdr_v[20]   =  portnum;   /* VLAN     */       
        }

     /* Setup Destination Address In IP Hdr */
      vita_mac_hdr_nv[15]       = (int_u2) ip_addr;
      vita_mac_hdr_nv[16]       = (int_u2) (ip_addr >> 16);
           
      vita_mac_hdr_v[17]        = (int_u2) ip_addr;
      vita_mac_hdr_v[18]        = (int_u2) (ip_addr >> 16);
          
     /* If Dest IP Adr = Multicast, Setup Multicast HW Adr */ 
      if (((ip_addr & 0x000000ff) > 223) && ((ip_addr & 0x000000ff) < 240))
        {         
         
          vita_mac_hdr_nv[0] = 0x0001;    
          vita_mac_hdr_nv[1] =  (int_u2) ((ip_addr & 0x7f00)|0x005E);           
          vita_mac_hdr_nv[2] =  (int_u2) (ip_addr >> 16);

          vita_mac_hdr_v[0]  = 0x0001;    
          vita_mac_hdr_v[1]  =  (int_u2) ((ip_addr & 0x7f00)|0x005E);           
          vita_mac_hdr_v[2]  =  (int_u2) (ip_addr >> 16); 
        }
      else     /* Not Multicast Adr, Error */
        {
          printf("Error: User Must Specify Valid Multicast Address For Transmit!\n");
          return(-1);  
       }
    }

  vita_mac_hdr_nv[12] = sdds_compute_checksum(10,vita_mac_hdr_nv+7);   /* IP Header CheckSum-NON-VLAN   */
  vita_mac_hdr_v[14]  = sdds_compute_checksum(10,vita_mac_hdr_v+9);    /* IP Header CheckSum VLAN       */

 /* Copy VLAN or Non-VLAN To Global Structure */
  if (vlan != -1)  
    memcpy((unsigned char *)vita_mac_hdr,(unsigned char *)vita_mac_hdr_v,48 * sizeof(unsigned char));   
  else
    memcpy((unsigned char *)vita_mac_hdr,(unsigned char *)vita_mac_hdr_nv,48 * sizeof(unsigned char));
    

 /* Reformat To Big Endian */
  flip_endian(vita_mac_hdr,12);

 /* Set Up MAC, IP, and UDP Header                  */
  for (ii=0;ii<((22+voffset)/2);ii++)
    pic_wmodreg(p,mport,0x00010002+ii,vita_mac_hdr[ii],TGV_NUM_PRG_BITS);                      
    
  pic_wmodreg(p,mport,0x00010000,0,TGV_NUM_PRG_BITS); 
                     
 /* Pkt Sz-PDU 256, VITA PKT 1472-Data, Hdr & Trlr  */ 
  pic_wmodreg(p,mport,0x00000007,0x00040000 + 1472,TGV_NUM_PRG_BITS);   
   
 /* Disable                                         */
  pic_rmodreg(p,mport,0x00000001,&mjtrdval,32);
  pic_wmodreg(p,mport,0x00000001,(mjtrdval | 0x12000000) & 0xFFFFFFF0,TGV_NUM_PRG_BITS);  
   

 /* Enable                                          */
  pic_rmodreg(p,mport,0x00000001,&mjtrdval,32);  

  if (dir > 0)        
    {

     /* 
       if ((rate < TGSDDS_MINOUT_FREQ) || (rate > TGSDDS_MAXOUT_FREQ))                     
         {
           printf("\n\nERR: TGSDDS PLL Freq Out of Range!!!\n");
           printf(" Valid Range = %d Mhz To %d MHz\n",(int_u4)((TGSDDS_MINOUT_FREQ*8)/1e6),(int_u4)((TGSDDS_MAXOUT_FREQ*8)/1e6));                              
           return(-1);             
         }     
     */  
    
      /* Output Clock Synthesizer */
      /* Compute Rate Of AnyRate Freq                              */  
      /* Find Bit Divide (Multiply) And 8 Byte Wide Path Frequency */ 
       bitmult =  (float)(64.0/((float)bits));
       fcrate  =  ((float) ((float)rate)/bitmult);
       jj      = (int_u4) fcrate;        /* int Value Of Frequency */                       

      /* Get Alternate Port */      
     /*  altport = mport % 2;  */   /* Alternate Port = 0 When Port 2 Current Port, Alternate Port = 1, When Port 1 Current Port */
      
      /* Check Alt Port Active And In Output Mode */ 
   /*    if ((enopval[altport] != 0) && ((rstcfgval[altport] & TGSYS_ACQUIRE_BIT) == 0))
         {     
            pic_rmodreg (p,2,TGSDDS_MEMRDSEL|TGMEM_OCLKFREQ_ADR,&mjtrdval,TGV_NUM_PRG_BITS); 
            if (mjtrdval != 0)
              {                   
                if (mjtrdval != jj)
                  {
                    printf("ERR: Alternate Port In Use As Output With Different Clock Rate\n");
                    printf("ERR: Dual Outputs Must Be Run At The Same Rate\n");
                    return(-1);
                  }
                else
                  return(0); 
              }
         } 
   */          
      /* Store In Mem Freq Of AnyRate Part */  
      /* pic_wmodreg(p,2,TGSDDS_HOSTMEMREG_ADR|TGMEM_OCLKFREQ_ADR,jj,TGV_NUM_PRG_BITS); */
               
       Si5326_Reg.debuglevel = -1;
       Si5326_Reg.fref   =  10000000.0;
       Si5326_Reg.dclk1  = ((real_8) fcrate);
       Si5326_Reg.dclk2  = ((real_8) fcrate);
       Si5326_Reg.dwght1 = 1.0;
       Si5326_Reg.dwght2 = 1.0;   
       ii = si5326_regcfg_init(&Si5326_Reg,SI5326_REGCFG_MT_TGSDAT);
       ii = si5326_regcfg_bwsel(&Si5326_Reg,7); 
       if (findflag("PREFX",p->config) >= 0)     
         ii = si5326_regcfg_clkin(&Si5326_Reg,SI5326_REGCFG_CLKIN_1);
       else
         ii = si5326_regcfg_clkin(&Si5326_Reg,SI5326_REGCFG_CLKIN_2);            
       ii = si5326_regcfg_dividers(&Si5326_Reg);
       if (ii != 0)
         printf("TGVITA Warning: TGVITA Output rate %f not possible. Using %f\n",fcrate*bitmult, Si5326_Reg.fclk2*bitmult);
       si5326_regcfg_debug(&Si5326_Reg);
       for(ii=0; ii<Si5326_Reg.numreg; ii++) 
         {
           tgvita_synclk_cfg(p,1,0x00000009,Si5326_Reg.regval[ii]);           
           udelay(1000);
         }
           
      udelay(5000);

      if (ports==3)               
        pic_wmodreg(p,mport,0x00000001,mjtrdval | 0x12000032 | 0x00080000,TGV_NUM_PRG_BITS);   /* Output-Dual  ICE LVDS Ports, Turn On Pkt Edit (Chksum) */
      else
        pic_wmodreg(p,mport,0x00000001,mjtrdval | 0x12000030 | 0x00080000,TGV_NUM_PRG_BITS);   /* Output-Dual  ICE LVDS Ports, Turn On Pkt Edit (Chksum) */
      
      pic_rmodreg(p,mport,0x00010001,&mjtrdval,32);
      pic_wmodreg(p,mport,0x00010001,mjtrdval & 0xFBFFFFFF,TGV_NUM_PRG_BITS);     /* Bit 26 Turn Off IGMP Mode   */   

    }
  else
    {
      if (ports==3)
        pic_wmodreg(p,mport,0x00000001,(mjtrdval | 0x12000016) & 0xFFF7FFFF,TGV_NUM_PRG_BITS);   /* Input-Dual   ICE LVDS Ports, Turn Off Tx Pkt Edit  */
      else
        pic_wmodreg(p,mport,0x00000001,(mjtrdval | 0x12000014) & 0xFFF7FFFF,TGV_NUM_PRG_BITS);   /* Input-Single ICE LVDS Ports, Turn Off Tx Pkt Edit  */
      
      /* Look For Initial Join Address                      */             
      if ((mport==1) && ((findflag("IPCONN1",p->config) >=0) || (findflag("JOIN1",p->config) >=0)))           
        status = tgvita_add_mcgroup(p,mport,convert_ip_addr2("IPCONN1","JOIN1",p->config));
      else if ((mport==2) && ((findflag("IPCONN2",p->config) >=0) || (findflag("JOIN2",p->config) >=0)))           
        status = tgvita_add_mcgroup(p,mport,convert_ip_addr2("IPCONN1","JOIN1",p->config));
      else if ((findflag("IPCONN",p->config) >=0) || (findflag("JOIN",p->config) >=0))           
        status = tgvita_add_mcgroup(p,mport,convert_ip_addr2("IPCONN1","JOIN1",p->config));

      if (status < 0)
        return(-1);
    }


 /* Flush the Error Registers                          */
  pic_rmodreg(p,mport,0x00000003,&mjtrdval,32);  
  pic_rmodreg(p,mport,0x00000004,&mjtrdval,32);  
  pic_rmodreg(p,mport,0x00000005,&mjtrdval,32);  
  pic_rmodreg(p,mport,0x00000006,&mjtrdval,32);  
  pic_rmodreg(p,mport,0x0000000e,&mjtrdval,32);  
 
  return(ports);
}

/*--------------------------------------------------------------*/
int_u4 pic_getkey_tgvita(PICSTRUCT *p, int_4 mport, int_u4 addr)
 {

 #include <sys/time.h>
 
 int ii;
 int_u4 value = 0;
 int_u4 value_saved = 0;

 switch (addr) {							/* retrieve the specified data from hardware, based on the passed key value.... */
        case 0:								
          pic_rmodreg (p, mport, 0x00000002, &value, 32);		/* key = 0, global status register */
          break;
        case 1:
          pic_rmodreg (p, mport, 0x00000003, &value, 32);		/* key = 1, internal error status register zero */
          break;
        case 2:
          pic_rmodreg (p, mport, 0x00000004, &value, 32);		/* key = 2, internal error status register one */
          break;
        case 3:
          pic_rmodreg (p, mport, 0x0000000e, &value, 32);		/* key = 3, internal error status register two */
          break;
        case 4:
          pic_rmodreg (p, mport, 0x00000005, &value, 32);		/* key = 4, operational error status register zero */
          break;
        case 5:
          pic_rmodreg (p, mport, 0x00000006, &value, 32);		/* key = 5, operational error status register one */
          break;

        case 6:
          pic_rmodreg (p, mport, 0x0000000b, &value, 32);		/* key = 6, oixd_vita fpga build number */
          break;

        case 7:
          pic_rmodreg (p, mport, 0x00000011, &value, 32);		/* key = 7, transmit path packet count */
          break;
        case 8:
          pic_rmodreg (p, mport, 0x00000012, &value, 32);		/* key = 8, receive path packet count */
          break;

        case 9:
          pic_rmodreg (p, mport, 0x000e0c06, &value, 32);		/* key = 9, receive path CRC-errored packets (ls 32 bits) */
          break;
        case 10:
          pic_rmodreg (p, mport, 0x000e0c07, &value, 32);		/* key = 10, receive path CRC-errored packets (ms 4 bits) */
          break;
        case 11:
          pic_rmodreg (p, mport, 0x0000001e, &value, 32);		/* key = 11, receive path packet discards, general error */
          break;
        case 12:
          pic_rmodreg (p, mport, 0x00000026, &value, 32);		/* key = 12, receive path packet discards, length error */
          break;

        case 13:
          pic_rmodreg (p, mport, 0x0000001d, &value, 32);		/* key = 13, receive path UDP packet discards, IGMP out-of-group */
          break;
        case 14:
          pic_rmodreg (p, mport, 0x00000020, &value, 32);		/* key = 14, receive path UDP packet discards, vita header filtered */
          break;

        case 15:
          pic_rmodreg (p, mport, 0x00000022, &value, 32);		/* key = 15, receive path vita packet reordering events */
          break;
        case 16:
          pic_rmodreg (p, mport, 0x00000021, &value, 32);		/* key = 16, receive path vita missing packet fill events */
          break;

        case 17:
          pic_rmodreg (p, mport, 0x00000023, &value, 32);		/* key = 17, receive path interpacket gap in bytes, low threshold */
          break;
        case 18:
          pic_rmodreg (p, mport, 0x00000024, &value, 32);		/* key = 18, receive path interpacket gap in bytes, medium threshold */
          break;
        case 19:
          pic_rmodreg (p, mport, 0x00000025, &value, 32);		/* key = 19, receive path interpacket gap in bytes, high threshold */
          break;

        case 20:
          pic_rmodreg (p, mport, 0x000101c0, &value, 32);		/* key = 20, IGMP group 0, control word */
          break;
        case 21:
          pic_rmodreg (p, mport, 0x000101c1, &value, 32);		/* key = 21, IGMP group 0, group multicast address */
          break;
        case 22:
          pic_rmodreg (p, mport, 0x000101c2, &value, 32);		/* key = 22, IGMP group 1, control word */
          break;
        case 23:
          pic_rmodreg (p, mport, 0x000101c3, &value, 32);		/* key = 23, IGMP group 1, group multicast address */
          break;
        case 24:
          pic_rmodreg (p, mport, 0x000101c4, &value, 32);		/* key = 24, IGMP group 2, control word */
          break;
        case 25:
          pic_rmodreg (p, mport, 0x000101c5, &value, 32);		/* key = 25, IGMP group 2, group multicast address */
          break;
        case 26:
          pic_rmodreg (p, mport, 0x000101c6, &value, 32);		/* key = 26, IGMP group 3, control word */
          break;
        case 27:
          pic_rmodreg (p, mport, 0x000101c7, &value, 32);		/* key = 27, IGMP group 3, group multicast address */
          break;
        case 28:
          pic_rmodreg (p, mport, 0x000101c8, &value, 32);		/* key = 28, IGMP group 4, control word */
          break;
        case 29:
          pic_rmodreg (p, mport, 0x000101c9, &value, 32);		/* key = 29, IGMP group 4, group multicast address */
          break;
        case 30:
          pic_rmodreg (p, mport, 0x000101ca, &value, 32);		/* key = 30, IGMP group 5, control word */
          break;
        case 31:
          pic_rmodreg (p, mport, 0x000101cb, &value, 32);		/* key = 31, IGMP group 5, group multicast address */
          break;
        case 32:
          pic_rmodreg (p, mport, 0x000101cc, &value, 32);		/* key = 32, IGMP group 6, control word */
          break;
        case 33:
          pic_rmodreg (p, mport, 0x000101cd, &value, 32);		/* key = 33, IGMP group 6, group multicast address */
          break;
        case 34:
          pic_rmodreg (p, mport, 0x000101ce, &value, 32);		/* key = 34, IGMP group 7, control word */
          break;
        case 35:
          pic_rmodreg (p, mport, 0x000101cf, &value, 32);		/* key = 35, IGMP group 7, group multicast address */
          break;
        case 50:							/* key = 50, extract and display received packet contents (first 128 bytes) */
          pic_wmodreg (p, mport, 0x00010201, 0, 32);			/* (clear the extract buffer control word) */
          pic_wmodreg (p, mport, 12, 0x00000010, 32);			/* (write the debug command to extract the packet) */
          for (ii=0;ii<100;ii++)
            {    
              pic_rmodreg (p, mport, 0x00010201, &value, 32);		/* (poll the control word location, waiting for a packet....) */
              if (value != 0)
                {
                  value_saved = value;					/* (latch control word value if there's something there) */
                  {break;}
                }
              fprintf(stderr, "%d",ii);
              usleep(250000);						/* 250 mS */
           }
          if (((value_saved & 0x00400000) != 0) && ((value_saved & 0x000000ff) != 0))
            {								/* if a packet was extracted (control word looks good) */
              printf("\nExtracted Packet Data (first 64 bytes): \n");	/* then retrieve first 64 bytes and display it */
              pic_rmodreg (p, mport, 0x00010202, &value, 32);
              printf("\n\t%08x  ",value);
              pic_rmodreg (p, mport, 0x00010203, &value, 32);
              printf("%08x  ",value);
              pic_rmodreg (p, mport, 0x00010204, &value, 32);
              printf("%08x  ",value);
              pic_rmodreg (p, mport, 0x00010205, &value, 32);
              printf("%08x  ",value);
              pic_rmodreg (p, mport, 0x00010206, &value, 32);
              printf("%08x  ",value);
              pic_rmodreg (p, mport, 0x00010207, &value, 32);
              printf("%08x  ",value);
              pic_rmodreg (p, mport, 0x00010208, &value, 32);
              printf("%08x  ",value);
              pic_rmodreg (p, mport, 0x00010209, &value, 32);
              printf("%08x",value);

              pic_rmodreg (p, mport, 0x0001020a, &value, 32);
              printf("\n\t%08x  ",value);
              pic_rmodreg (p, mport, 0x0001020b, &value, 32);
              printf("%08x  ",value);
              pic_rmodreg (p, mport, 0x0001020c, &value, 32);
              printf("%08x  ",value);
              pic_rmodreg (p, mport, 0x0001020d, &value, 32);
              printf("%08x  ",value);
              pic_rmodreg (p, mport, 0x0001020e, &value, 32);
              printf("%08x  ",value);
              pic_rmodreg (p, mport, 0x0001020f, &value, 32);
              printf("%08x  ",value);
              pic_rmodreg (p, mport, 0x00010210, &value, 32);
              printf("%08x  ",value);
              pic_rmodreg (p, mport, 0x00010211, &value, 32);
              printf("%08x",value);
            }
          else
            {								/* else if control word indicates that extract did not occur, */
              printf("\n >>> Packet Extraction Failed (empty or invalid control word) <<< \n");	/* then output error msg */
            }
          printf("\n\n");
          value = 0;
          break;
        default:          
          printf("\n >>> Unsupported key value supplied <<<\n\n");
          break;
      }
   
   return(value);
}

/*--------------------------------------------------------------*/
int_4 pic_setkey_tgvita(PICSTRUCT *p, int_4 mport, int_u4 addr)
 {
    if (addr >= 0x00001C00)                                 /* Write Address Range 0x1C00 to 0x1FFF */
      pic_wmodreg (p, mport, 0x000E0C00, 0x00000001, 32);
    return(0);
 }


