#define  SONET_NUM_PRG_BITS                32
#define  SONET_MODRESET_REMOVE     0x00000001  /* Must Be Used For Module To Come Out Of Reset               */
#define  SONET_ENABLE_ERROR_DETECT 0x00000002  /* Enable Frame Errors Detection, Only Collect Good Frames    */
#define  SONET_DISABLE_SCRAMBLING  0x00000004  /* Turn Off Fiber Optic Descrambling (Rx) or Scrambling (Tx)  */
#define  SONET_OC12ENABLE          0x00000008  /* Use If Line Rate Is 622MBits/Sec, Don't Use For 155 MBits  */
#define  SONET_OC3FROMOC12_ENABLE  0x00000010  /* Pull Out OC3 Signal From OC12 Input, Bits Below Choose OC3 */ 
#define  SONET_OC3_0_FROMOC12      0x00000000  /* Choose OC3 #0 From OC12 For Acquisition                    */
#define  SONET_OC3_1_FROMOC12      0x00000020  /* Choose OC3 #1 From OC12 For Acquisition                    */
#define  SONET_OC3_2_FROMOC12      0x00000040  /* Choose OC3 #2 From OC12 For Acquisition                    */
#define  SONET_OC3_3_FROMOC12      0x00000060  /* Choose OC3 #3 From OC12 For Acquisition                    */
#define  SONET_INPUT_ENABLE        0x00000080  /* Enable Module For Input                                    */
#define  SONET_RXCLKFORTX          0x00000100  /* Use Rx Recovered Clock Instead Of Ref Clk For Tx Output    */
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 pic_reset_sonetr1 (PICSTRUCT *p, int_4 mport)
{
  /* This Puts Module Into Reset By Setting All Config Bits = 0 */
   pic_wmodreg(p,mport,0,0,SONET_NUM_PRG_BITS); 
   return 0;
}
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 pic_setup_sonet (PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 gain) 
{
   int_4 i; int_u4 sonet_cfg_bits = 0;

   /* This Puts Module Into Reset By Setting All Config Bits = 0 */                       
   pic_wmodreg(p,mport,0,sonet_cfg_bits,SONET_NUM_PRG_BITS); 
   
   /* To Configure the module for operation 'bit wise or' in configuration values                    */
   /* This Line Must Always Be Here, It Take the module out of reset mode and starts Data Acquistion */
   sonet_cfg_bits = sonet_cfg_bits | SONET_MODRESET_REMOVE; 

   /* Turn Off Scrambling/ Descrambling         */
    if (findflag("SCRAMOFF",p->config) >= 0)
       sonet_cfg_bits = sonet_cfg_bits | SONET_DISABLE_SCRAMBLING;

   /* Check For OC12 Data In Open String        */
    if (findflag("OC12",p->config) >= 0)
       sonet_cfg_bits = sonet_cfg_bits | SONET_OC12ENABLE;
            
   /* Check For OC3 Remove From OC12            */
    if ((findflag("OC3FROMOC12",p->config) >= 0) || (findflag("OC3FROMOCX",p->config) >= 0))
      {
        sonet_cfg_bits = sonet_cfg_bits | SONET_OC3FROMOC12_ENABLE;
        if ((i=findflag("OC3NUM",p->config)) >= 0)
          {
            if (p->config[i+6] != '=')    sonet_cfg_bits = sonet_cfg_bits | SONET_OC3_0_FROMOC12;
            else if (p->config[i+7]=='1') sonet_cfg_bits = sonet_cfg_bits | SONET_OC3_1_FROMOC12;
            else if (p->config[i+7]=='2') sonet_cfg_bits = sonet_cfg_bits | SONET_OC3_2_FROMOC12;
            else if (p->config[i+7]=='3') sonet_cfg_bits = sonet_cfg_bits | SONET_OC3_3_FROMOC12;
            else                          sonet_cfg_bits = sonet_cfg_bits | SONET_OC3_0_FROMOC12;
          }  
      } 
 
  
   /* Set Module For Acquisition If Desired     */
    if (dir <= 0)
      {
        sonet_cfg_bits = sonet_cfg_bits | SONET_INPUT_ENABLE;
        sonet_cfg_bits = sonet_cfg_bits | SONET_RXCLKFORTX; /* Autotmatic For Rx Data To Loop To Tx */
      } 
    else if (findflag("RXCLKFORTX",p->config) >= 0)
      sonet_cfg_bits = sonet_cfg_bits | SONET_RXCLKFORTX; 

   /* Error Check Configuration Setup */
    if ((sonet_cfg_bits & SONET_OC3FROMOC12_ENABLE) != 0) {
      if ((sonet_cfg_bits & SONET_OC12ENABLE) == 0) {
         printf("icelib.c, pic_setup_sonet():OC12 Must Be Enabled For OC3 Removal");
        }
      } 
         
   vprint("Setup SONET port=%d cfgbits=%d\n",mport,sonet_cfg_bits);
   /* Download Bit Wise ORed Bits To Module  */
   pic_wmodreg(p,mport,0,sonet_cfg_bits,SONET_NUM_PRG_BITS);  
   return 0;
}
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
#define  SR2_NUM_PRG_BITS                32
#define  SR2_MODRESET_REMOVE     0x00000001  /* Must Be Used For Module To Come Out Of Reset               */
#define  SR2_ENABLE_ERROR_DETECT 0x00000002  /* Enable Frame Errors Detection, Only Collect Good Frames    */
#define  SR2_DISABLE_SCRAMBLING  0x00000004  /* Turn Off Fiber Optic Descrambling (Rx) or Scrambling (Tx)  */
#define  SR2_INPUT_ENABLE        0x00000008  /* Enable Module For Input                                    */
#define  SR2_RXCLKFORTX          0x00000010  /* Use Rx Recovered Clock Instead Of Ref Clk For Tx Output    */
#define  SR2_OC3ENABLE           0x00000020  /* Use If Line Rate Of 155 MBits                              */
#define  SR2_OC12ENABLE          0x00000040  /* Use If Line Rate Is 622MBits/Sec                           */
#define  SR2_OC24ENABLE          0x00000080  /* Use If Line Rate Is 1244MBits/Sec                          */
#define  SR2_OC48ENABLE          0x00000100  /* Use If Line Rate Is 2488MBits/Sec                          */
#define  SR2_DEMUXENABLE         0x00000200  /* Enable Realtime Demux Of Incoming Signal                   */
#define  SR2_OC3FROMOCX_ENABLE   0x00000400  /* Pull Out OC3  Signal From OCx  Input                       */ 
#define  SR2_OC12FROMOCX_ENABLE  0x00008000  /* Pull Out OC12 Signal From OCx  Input                       */
#define  SR2_OC24FROMOCX_ENABLE  0x00040000  /* Pull Out OC24 Signal From OC48 Input                       */
#define  SR2_SLAVE_ENABLE        0x00100000  /* First Frame Of Slave Module Is Demux #0 Channel            */
#define  SR2_MUXCFG_ENABLE       0x00100000  /* Mux Cfg Info From Port 0 To Port 1 - For SlimPIC           */
#define  SR2_MUXOUT_ENABLE       0x00200000  /* Mux Ouput From Port 1 To Port 0 - For SlimPIC              */

#define  SR2_DISABLE_FRAMING     0x00200000  /* Disable Frame Detection                                    */
#define  SR2_FEC_ENABLE          0x00400000  /* Use FEC Oscillator As Reference                            */
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 pic_reset_sonetr2 (PICSTRUCT *p, int_4 mport)
{
  /* This Puts Module Into Reset By Setting All Config Bits = 0 */                       
   pic_wmodreg(p,mport,0,0,SR2_NUM_PRG_BITS); 
   return 0;
}
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 pic_setup_sonetr2 (PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 gain) 
{
   int_4 i; int_u4 sonet_cfg_bits = 0;

   /* This Puts Module Into Reset By Setting All Config Bits = 0 */                       
   pic_wmodreg(p,mport,0,sonet_cfg_bits,SR2_NUM_PRG_BITS); 
   
   /* To Configure the module for operation 'bit wise or' in configuration values                    */
   /* This Line Must Always Be Here, It Take the module out of reset mode and starts Data Acquistion */
   sonet_cfg_bits = sonet_cfg_bits | SR2_MODRESET_REMOVE; 

   /* Mux Config And Output Data To Port 1 */
    if (p->type == ICESLIC3)
      sonet_cfg_bits = sonet_cfg_bits | SR2_MUXCFG_ENABLE | SR2_MUXOUT_ENABLE;

   /* Turn ON Error Detect-Only Acquire Valid Frames             */
    if (findflag("ERRDETON",p->config) >= 0)
       sonet_cfg_bits = sonet_cfg_bits | SR2_ENABLE_ERROR_DETECT; 
 
    if (findflag("FRAMINGOFF",p->config) >= 0)
       sonet_cfg_bits = sonet_cfg_bits | SR2_DISABLE_SCRAMBLING | SR2_DISABLE_FRAMING; 

    if (findflag("FECENABLE",p->config) >= 0)
       sonet_cfg_bits = sonet_cfg_bits | SR2_FEC_ENABLE;

   /* Turn Off Scrambling/ Descrambling         */
    if (findflag("SCRAMOFF",p->config) >= 0)
       sonet_cfg_bits = sonet_cfg_bits | SR2_DISABLE_SCRAMBLING;

   /* Setup Type Of Signal To Acquire/Playback  */
    if      (findflag("OC12",p->config) >= 0)  /* Check For OC12 Data In Open String        */
       sonet_cfg_bits = sonet_cfg_bits | SR2_OC12ENABLE;
    else if (findflag("OC24",p->config) >= 0)  /* Check For OC24 Data In Open String        */
       sonet_cfg_bits = sonet_cfg_bits | SR2_OC24ENABLE;
    else if (findflag("OC48",p->config) >= 0)  /* Check For OC48 Data In Open String        */
       sonet_cfg_bits = sonet_cfg_bits | SR2_OC48ENABLE;
    else
       sonet_cfg_bits = sonet_cfg_bits | SR2_OC3ENABLE;
 /*  
   if (mport == 1) {
       if (((sonet_cfg_bits & SR2_OC48ENABLE) != 0) || ((sonet_cfg_bits & SR2_OC24ENABLE) != 0)) {
           printf("OC48 and OC24 Supported On Module Port #2 Only!\n");
           return(-1);
         }  
     }
 */           
   /* Check For OC3 Remove From OCx            */
    if ((findflag("OC3FROMOCX",p->config) >= 0) || (findflag("OC3FROMOC12",p->config) >= 0))
       { 
        /* Enable Demux Operation              */
        sonet_cfg_bits = sonet_cfg_bits | SR2_DEMUXENABLE;  

        /* Error Check OC3 Removal Operation   */
        if ((sonet_cfg_bits & SR2_OC3ENABLE) != 0) {
            printf("\n Error-OC12 or OC24 or OC48 Must Be Enabled For OC3 Removal\n");             
            return(-1); 
          }

        i=findintflag("OC3NUM",p->config); 
          
        if (i < 0) { /* Did Not Find Flag, Assume Zero */ 
            printf("\n Warning-OC3 Number For Removal Not Specified-Assuming OC3NUM=0\n");
            i = 0; 
          }
        if ((i >= 4) && ((sonet_cfg_bits & SR2_OC12ENABLE) != 0)) {
            printf("\n Error-OC3 Number For Removal Out Of Range For OC12 Input; Valid Values 0 to 3\n");
            return(-1); 
          }
        if ((i >= 8) && ((sonet_cfg_bits & SR2_OC24ENABLE) != 0)) {
            printf("\n Error-OC3 Number For Removal Out Of Range For OC24 Input; Valid Values 0 to 7\n");
            return(-1); 
          }
        if ((i >= 16) && ((sonet_cfg_bits & SR2_OC48ENABLE) != 0)) {
            printf("\n Error-OC3 Number For Removal Out Of Range For OC48 Input; Valid Values 0 to 15\n");
            return(-1); 
          }
        sonet_cfg_bits = sonet_cfg_bits | SR2_OC3FROMOCX_ENABLE;
        sonet_cfg_bits = sonet_cfg_bits | ((i << 11) & 0x00007800);            
      } 
 
      /* Check For OC12 Remove From OCx            */
    if (findflag("OC12FROMOCX",p->config) >= 0) { 
        /* Error Check OC12 Removal Operation      */
        if (((sonet_cfg_bits & SR2_OC3ENABLE) != 0) || ((sonet_cfg_bits & SR2_OC12ENABLE) != 0)) {
            printf("\n Error-OC24 or OC48 Must Be Enabled For OC12 Removal\n");             
            return(-1); 
          }     
        /* Error Check For More Than 1 Demux Op   */
        if ((sonet_cfg_bits & SR2_DEMUXENABLE) != 0) {
            printf("\n Error-Only 1 Demux Operation Allowed\n");             
            return(-1);  
          }        
        else
          sonet_cfg_bits = sonet_cfg_bits | SR2_DEMUXENABLE;          

        i=findintflag("OC12NUM",p->config);
          
        if (i < 0) { /* Did Not Find Flag, Assume Zero */
            printf("\n Warning-OC12 Number For Removal Not Specified-Assuming OC12NUM=0\n");
            i = 0; 
          }

        if ((i >= 2) && ((sonet_cfg_bits & SR2_OC24ENABLE) != 0)) {
            printf("\n Error-OC12 Number For Removal Out Of Range For OC24 Input; Valid Values 0 to 1\n");
            return(-1); 
          }

        if ((i >= 4) && ((sonet_cfg_bits & SR2_OC48ENABLE) != 0)) {
            printf("\n Error-OC12 Number For Removal Out Of Range For OC48 Input; Valid Values 0 to 3\n");
            return(-1); 
          }
            
        sonet_cfg_bits = sonet_cfg_bits | SR2_OC12FROMOCX_ENABLE;
        sonet_cfg_bits = sonet_cfg_bits | ((i << 16) & 0x00030000);         
      } 
  
    /* Check For OC24 Remove From OC48            */
    if (findflag("OC24FROMOCX",p->config) >= 0) {
        /* Error Check OC24 Removal Operation   */
        if ((sonet_cfg_bits & SR2_OC48ENABLE) == 0) {
            printf("\n Error-OC48 Must Be Enabled For OC24 Removal\n");             
            return(-1); 
          }     
        /* Error Check For More Than 1 Demux Op   */
        if ((sonet_cfg_bits & SR2_DEMUXENABLE) != 0) {
            printf("\n Error-Only 1 Demux Operation Allowed\n");             
            return(-1);  
          }        
        else
          sonet_cfg_bits = sonet_cfg_bits | SR2_DEMUXENABLE; 

        i=findintflag("OC24NUM",p->config);
          
        if (i < 0) { /* Flag Not Found Assume 0 */
            printf("\n Warning-OC24 Number For Removal Not Specified-Assuming OC24NUM=0\n");
            i = 0;
          }
        if (i >= 2) { 
            printf("\n Error-OC24 Number For Removal Out Of Range For OC48 Input; Valid Values 0 to 1\n");
            return(-1); 
          }            
        sonet_cfg_bits = sonet_cfg_bits | SR2_OC24FROMOCX_ENABLE;
        sonet_cfg_bits = sonet_cfg_bits | ((i << 19) & 0x00080000);            
      } 

    if ((p->type==ICEPIC4) && ((sonet_cfg_bits & SR2_OC48ENABLE) != 0) && ((sonet_cfg_bits & SR2_DEMUXENABLE) == 0)) {
        printf("\n Error-Raw OC48 Acquire/Playback Rates (320 MB/Sec) Too High For ICE-PIC4T!\n");
        printf("For Raw OC48 Acquire/Playback ICE-PIC5 Series Or Higher PCI Card Needed\n");  
        return(-1);  
      }
 
    if ((findflag("SLVENABLE",p->config) >= 0) && ((sonet_cfg_bits &  SR2_DEMUXENABLE) != 0) && (dir <= 0))
      sonet_cfg_bits = sonet_cfg_bits | SR2_SLAVE_ENABLE;

   /* Set Module For Acquisition If Desired Else Playback     */
    if (dir <= 0) {      
        sonet_cfg_bits = sonet_cfg_bits | SR2_INPUT_ENABLE;
        sonet_cfg_bits = sonet_cfg_bits | SR2_RXCLKFORTX; /* Autotmatic For Rx Data To Loop To Tx */
      }  
    else if (findflag("RXCLKFORTX",p->config) >= 0)
      sonet_cfg_bits = sonet_cfg_bits | SR2_RXCLKFORTX; 
         
   vprint("Setup SONETR2 port=%d cfgbits=%08x\n",mport,sonet_cfg_bits);
   pic_wmodreg(p,mport,0,sonet_cfg_bits,SR2_NUM_PRG_BITS);  /* Download Bit Wise ORed Bits To Module  */
   return 0;
}
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
#define  SR4_NUM_PRG_BITS                32
#define  SR4_MODRESET_REMOVE     0x00000001  /* Must Be Used For Module To Come Out Of Reset               */
#define  SR4_CARDTYPE            0x00000002  /* Set Card Type To PIC5T When Ready                          */
#define  SR4_ENABLE_ERROR_DETECT 0x00000004  /* Enable Frame Errors Detection, Only Collect Good Frames    */
#define  SR4_DISABLE_SCRAMBLING  0x00000008  /* Turn Off Fiber Optic Descrambling (Rx) or Scrambling (Tx)  */
#define  SR4_INPUT_ENABLE        0x00000010  /* Enable Module For Input                                    */
#define  SR4_SLAVE_ENABLE        0x00000020  /* First Frame Of Slave Module Is Demux #0 Channel            */
#define  SR4_DISABLE_FRAMING     0x00000040  /* Disable Search For Framing Bring In Data W/Unknown Framing */
#define  SR4_REFCLK_SEL0         0x00000080  /* Reference Clock Select For FEC Type                        */
#define  SR4_REFCLK_SEL1         0x00000100  /* Reference Clock Select For FEC Type                        */
#define  SR4_DEMUXENABLE         0x00000200  /* Enable Realtime Demux Of Incoming Signal                   */
#define  SR4_OC3_96ENABLE        0x00000400  /* A Side: Use If Line Rate  5GHz B Side: Rate 155 MBits      */
#define  SR4_OC12_192ENABLE      0x00000800  /* A Side: Use If Line Rate 10GHz B Side: Rate 622 MBits      */
#define  SR4_OC24ENABLE          0x00001000  /* B Side: Use If Line Rate Is 1244MBits/Sec                  */
#define  SR4_OC48ENABLE          0x00002000  /* B Side: Use If Line Rate Is 2488MBits/Sec                  */

#define  SR4_OC3FROMOCX_ENABLE   0x00004000  /* Pull Out OC3  Signal From OCx   Input                      */ 
#define  SR4_OC12FROMOCX_ENABLE  0x00008000  /* Pull Out OC12 Signal From OCx   Input                      */
#define  SR4_OC24FROMOCX_ENABLE  0x00010000  /* Pull Out OC24 Signal From OCx   Input                      */
#define  SR4_OC48FROMOCX_ENABLE  0x00020000  /* Pull Out OC48 Signal From OC192 Input                      */
#define  SR4_OC96FROMOCX_ENABLE  0x00040000  /* Pull Out OC48 Signal From OC192 Input                      */

/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 pic_enable_sonetr4 (PICSTRUCT *p, int_4 mport,int_4 dis_enable)
{

  /* This Puts Module Into Reset By Setting All Config Bits = 0 */                       
   if (dis_enable == 0)
     {
       pic_wmodreg(p,mport,1,0,SR4_NUM_PRG_BITS); 
       udelay(100); 
     }
   else
     {
       pic_wmodreg(p,mport,1,1,SR4_NUM_PRG_BITS); 
       udelay(100);
     }
   return 0;
}


/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 pic_setup_sonetr4 (PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 gain) 
{
   int_4 i; int_u4 sonet_cfg_bits = 0;
   int_u4 mjtrdval = 0;

   /* This Puts Module Into Reset By Setting All Config Bits = 0 */     
   pic_wmodreg(p,mport,1,sonet_cfg_bits,SR4_NUM_PRG_BITS); 
   udelay(100);                  
   pic_wmodreg(p,mport,0,sonet_cfg_bits,SR4_NUM_PRG_BITS); 
   udelay(100);
    
   /* To Configure the module for operation 'bit wise or' in configuration values                    */
   /* This Line Must Always Be Here, It Take the module out of reset mode and starts Data Acquistion */
    sonet_cfg_bits = sonet_cfg_bits | SR4_MODRESET_REMOVE; 

   /* Check For Full Rate OCc192                                 */  
    if ((findflag("OC192FULL",p->config) >= 0) && mport == 1)
     { 
        
       pic_rmodreg (p,mport,0,&mjtrdval,SR4_NUM_PRG_BITS);
       if (mjtrdval != 0xAA55AA55)
         {
           printf("SonetR4: Wrong Firmware Download For OC192 Signal\n");
           printf("Use Flags 'IOMFPGA=_192full' AND 'FORCE' For Correct Download\n");
           return(-1); 
         }
       if ((findflag("G709FEC",p->config) >= 0) && mport == 1)
        sonet_cfg_bits = sonet_cfg_bits | SR4_REFCLK_SEL1;
 
      /* Set Module For Acquisition If Desired Else Playback     */
       if (dir <= 0)      
         sonet_cfg_bits = sonet_cfg_bits | SR4_INPUT_ENABLE;
   
       vprint("Setup SONETR4 port=%d cfgbits=%08x\n",mport,sonet_cfg_bits);
       pic_wmodreg(p,mport,0,sonet_cfg_bits,SR4_NUM_PRG_BITS);  /* Download Bit Wise ORed Bits To Module  */
       return(2);
     }

   /* Set Up ITU G.709 FEC Clock Ref Source     */      
    if ((findflag("G709FEC",p->config) >= 0) && mport == 1)
       sonet_cfg_bits = sonet_cfg_bits | SR4_REFCLK_SEL1; 
    if ((findflag("G709FEC",p->config) >= 0) && mport == 2)
       sonet_cfg_bits = sonet_cfg_bits | SR4_REFCLK_SEL0; 

   /* Turn ON Error Detect-Only Acquire Valid Frames             */
    if (findflag("ERRDETON",p->config) >= 0)
       sonet_cfg_bits = sonet_cfg_bits | SR4_ENABLE_ERROR_DETECT; 
 
   /* Turn Off Scrambling/ Descrambling         */
    if (findflag("SCRAMOFF",p->config) >= 0)
       sonet_cfg_bits = sonet_cfg_bits | SR4_DISABLE_SCRAMBLING;

    /* Turn Off Scrambling/ Descrambling         */
    if (findflag("FRAMINGOFF",p->config) >= 0)
       sonet_cfg_bits = sonet_cfg_bits | SR4_DISABLE_FRAMING | SR4_DISABLE_SCRAMBLING; 

   
   /* Setup Type Of Signal To Acquire/Playback  */
    if (mport == 1) 
      {
        if (findflag("OC96",p->config) >= 0)  /* Check For OC96 Data In Open String        */
          sonet_cfg_bits = sonet_cfg_bits | SR4_OC3_96ENABLE;
        else
          sonet_cfg_bits = sonet_cfg_bits | SR4_OC12_192ENABLE;
      }
    else 
      { 
        if      (findflag("OC12",p->config) >= 0)  /* Check For OC12 Data In Open String        */
          sonet_cfg_bits = sonet_cfg_bits | SR4_OC12_192ENABLE;
        else if (findflag("OC24",p->config) >= 0)  /* Check For OC24 Data In Open String        */
          sonet_cfg_bits = sonet_cfg_bits | SR4_OC24ENABLE;
        else if (findflag("OC48",p->config) >= 0)  /* Check For OC48 Data In Open String        */
          sonet_cfg_bits = sonet_cfg_bits | SR4_OC48ENABLE;
        else
          sonet_cfg_bits = sonet_cfg_bits | SR4_OC3_96ENABLE;
      }
              

   /* Check For OC3 Remove From OCx            */
    if ((findflag("OC3FROMOCX",p->config) >= 0) || (findflag("OC3NUM",p->config) >= 0))
       { 
        /* Enable Demux Operation              */
        sonet_cfg_bits = sonet_cfg_bits | SR4_DEMUXENABLE;  

        /* Error Check OC3 Removal Operation   */
        if (((sonet_cfg_bits & SR4_OC3_96ENABLE) != 0) && (mport == 2)){
            printf("\n Error-OC12 or OC24 or OC48 Must Be Enabled For OC3 Removal\n");             
            return(-1); 
          }

        i=findintflag("OC3NUM",p->config); 
          
        if (i < 0) { /* Did Not Find Flag, Assume Zero */ 
            printf("\n Warning-OC3 Number For Removal Not Specified-Assuming OC3NUM=0\n");
            i = 0; 
          }
        if ((i >= 4) && ((sonet_cfg_bits & SR4_OC12_192ENABLE) != 0) && (mport == 2)) {
            printf("\n Error-OC3 Number For Removal Out Of Range For OC12 Input; Valid Values 0 to 3\n");
            return(-1); 
          }
        if ((i >= 8) && ((sonet_cfg_bits & SR4_OC24ENABLE) != 0)) {
            printf("\n Error-OC3 Number For Removal Out Of Range For OC24 Input; Valid Values 0 to 7\n");
            return(-1); 
          }
        if ((i >= 16) && ((sonet_cfg_bits & SR4_OC48ENABLE) != 0)) {
            printf("\n Error-OC3 Number For Removal Out Of Range For OC48 Input; Valid Values 0 to 15\n");
            return(-1); 
          }

        if ((i >= 64) && ((sonet_cfg_bits & SR4_OC12_192ENABLE) != 0) && (mport == 1)) {
            printf("\n Error-OC3 Number For Removal Out Of Range For OC192 Input; Valid Values 0 to 63\n");
            return(-1); 
          }
        
        sonet_cfg_bits = sonet_cfg_bits | SR4_OC3FROMOCX_ENABLE;
        sonet_cfg_bits = sonet_cfg_bits | ((i << 19) & 0x001f80000);            
      } 
 
      /* Check For OC12 Remove From OCx            */
    if (findflag("OC12FROMOCX",p->config) >= 0) { 
        /* Error Check OC12 Removal Operation      */
  /*      if ((((sonet_cfg_bits & SR4_OC3_96ENABLE) != 0) || ((sonet_cfg_bits & SR4_OC12_192ENABLE) != 0)) && (mport == 2)) {
            printf("\n Error-OC24, Or OC48 Must Be Enabled For OC12 Removal\n");             
            return(-1); 
          }     
  */
        /* Error Check For More Than 1 Demux Op   */
        if ((sonet_cfg_bits & SR4_DEMUXENABLE) != 0) {
            printf("\n Error-Only 1 Demux Operation Allowed\n");             
            return(-1);  
          }        
        else
          sonet_cfg_bits = sonet_cfg_bits | SR4_DEMUXENABLE;          

        i=findintflag("OC12NUM",p->config);
          
        if (i < 0) { /* Did Not Find Flag, Assume Zero */
            printf("\n Warning-OC12 Number For Removal Not Specified-Assuming OC12NUM=0\n");
            i = 0; 
          }

        if ((i >= 2) && ((sonet_cfg_bits & SR4_OC24ENABLE) != 0)) {
            printf("\n Error-OC12 Number For Removal Out Of Range For OC24 Input; Valid Values 0 to 1\n");
            return(-1); 
          }

        if ((i >= 4) && ((sonet_cfg_bits & SR4_OC48ENABLE) != 0)) {
            printf("\n Error-OC12 Number For Removal Out Of Range For OC48 Input; Valid Values 0 to 3\n");
            return(-1); 
          }
         
        if ((i >= 16) && ((sonet_cfg_bits & SR4_OC12_192ENABLE) != 0) && (mport == 1)) {
            printf("\n Error-OC12 Number For Removal Out Of Range For OC192 Input; Valid Values 0 to 15\n");
            return(-1); 
          }  

        sonet_cfg_bits = sonet_cfg_bits | SR4_OC12FROMOCX_ENABLE;
        sonet_cfg_bits = sonet_cfg_bits | ((i << 19) & 0x001f80000);         
      } 
  
    /* Check For OC24 Remove From OC48            */
    if (findflag("OC24FROMOCX",p->config) >= 0) {
        /* Error Check OC24 Removal Operation   */
      /*  if (((sonet_cfg_bits & SR4_OC48ENABLE) == 0) && (mport == 2)){
            printf("\n Error-OC48 Must Be Enabled For OC24 Removal\n");             
            return(-1); 
          }
      */     
        /* Error Check For More Than 1 Demux Op   */
        if ((sonet_cfg_bits & SR4_DEMUXENABLE) != 0) {
            printf("\n Error-Only 1 Demux Operation Allowed\n");             
            return(-1);  
          }        
        else
          sonet_cfg_bits = sonet_cfg_bits | SR4_DEMUXENABLE; 

        i=findintflag("OC24NUM",p->config);
          
        if (i < 0) { /* Flag Not Found Assume 0 */
            printf("\n Warning-OC24 Number For Removal Not Specified-Assuming OC24NUM=0\n");
            i = 0;
          }
        if (i >= 2) { 
            printf("\n Error-OC24 Number For Removal Out Of Range For OC48 Input; Valid Values 0 to 1\n");
            return(-1); 
          }            

         if ((i >= 8) && ((sonet_cfg_bits & SR4_OC12_192ENABLE) != 0) && (mport == 1)) {
            printf("\n Error-OC24 Number For Removal Out Of Range For OC192 Input; Valid Values 0 to 7\n");
            return(-1); 
          }   
        sonet_cfg_bits = sonet_cfg_bits | SR4_OC24FROMOCX_ENABLE;
        sonet_cfg_bits = sonet_cfg_bits | ((i << 19) & 0x001f80000);            
      } 

     if (findflag("OC48FROMOCX",p->config) >= 0) {
        /* Error Check OC24 Removal Operation   */
      /*  if (((sonet_cfg_bits & SR4_OC48ENABLE) == 0) && (mport == 2)){
            printf("\n Error-OC48 Must Be Enabled For OC24 Removal\n");             
            return(-1); 
          }
      */     
        /* Error Check For More Than 1 Demux Op   */
        if ((sonet_cfg_bits & SR4_DEMUXENABLE) != 0) {
            printf("\n Error-Only 1 Demux Operation Allowed\n");             
            return(-1);  
          }        
        else
          sonet_cfg_bits = sonet_cfg_bits | SR4_DEMUXENABLE; 

        i=findintflag("OC48NUM",p->config);
          
        if (i < 0) { /* Flag Not Found Assume 0 */
            printf("\n Warning-OC48 Number For Removal Not Specified-Assuming OC48NUM=0\n");
            i = 0;
          }
        if (i >= 4) { 
            printf("\n Error-OC48 Number For Removal Out Of Range For OC48 Input; Valid Values 0 to 3\n");
            return(-1); 
          }            

     
        sonet_cfg_bits = sonet_cfg_bits | SR4_OC48FROMOCX_ENABLE;
        sonet_cfg_bits = sonet_cfg_bits | ((i << 19) & 0x001f80000);            
      } 

    if ((p->type==ICEPIC4) && ((sonet_cfg_bits & SR4_OC48ENABLE) != 0) && ((sonet_cfg_bits & SR4_DEMUXENABLE) == 0)) {
        printf("\n Error-Raw OC48 Acquire/Playback Rates (320 MB/Sec) Too High For ICE-PIC4T!\n");
        printf("For Raw OC48 Acquire/Playback ICE-PIC5 Series Or Higher PCI Card Needed\n");  
        return(-1);  
      }
 
    if ((findflag("SLVENABLE",p->config) >= 0) && ((sonet_cfg_bits &  SR4_DEMUXENABLE) != 0) && (dir <= 0))
      sonet_cfg_bits = sonet_cfg_bits | SR4_SLAVE_ENABLE;

   /* Set Module For Acquisition If Desired Else Playback     */
    if (dir <= 0)      
      sonet_cfg_bits = sonet_cfg_bits | SR4_INPUT_ENABLE;
   
   vprint("Setup SONETR4 port=%d cfgbits=%08x\n",mport,sonet_cfg_bits);
   pic_wmodreg(p,mport,0,sonet_cfg_bits,SR4_NUM_PRG_BITS);  /* Download Bit Wise ORed Bits To Module  */
   return 0;
}
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
#define  SR5_NUM_PRG_BITS                32
#define  SR5_MODRESET_REMOVE     0x00000001  /* Must Be Used For Module To Come Out Of Reset               */
#define  SR5_CARDTYPE            0x00000002  /* Set Card Type To PIC5T When Ready                          */
#define  SR5_ENABLE_ERROR_DETECT 0x00000004  /* Enable Frame Errors Detection, Only Collect Good Frames    */
#define  SR5_DISABLE_SCRAMBLING  0x00000008  /* Turn Off Fiber Optic Descrambling (Rx) or Scrambling (Tx)  */
#define  SR5_INPUT_ENABLE        0x00000010  /* Enable Module For Input                                    */
#define  SR5_SLAVE_ENABLE        0x00000020  /* First Frame Of Slave Module Is Demux #0 Channel            */
#define  SR5_DISABLE_FRAMING     0x00000040  /* Disable Search For Framing Bring In Data W/Unknown Framing */
#define  SR5_REFCLK_SEL0         0x00000080  /* Reference Clock Select For FEC Type                        */
#define  SR5_REFCLK_SEL1         0x00000100  /* Reference Clock Select For FEC Type                        */
#define  SR5_DEMUXENABLE         0x00000200  /* Enable Realtime Demux Of Incoming Signal                   */
#define  SR5_OC3_96ENABLE        0x00000400  /* A Side: Use If Line Rate  5GHz B Side: Rate 155 MBits      */
#define  SR5_OC12_192ENABLE      0x00000800  /* A Side: Use If Line Rate 10GHz B Side: Rate 622 MBits      */
#define  SR5_OC24ENABLE          0x00001000  /* B Side: Use If Line Rate Is 1244MBits/Sec                  */
#define  SR5_OC48ENABLE          0x00002000  /* B Side: Use If Line Rate Is 2488MBits/Sec                  */

#define  SR5_OC3FROMOCX_ENABLE   0x00004000  /* Pull Out OC3  Signal From OCx   Input                      */ 
#define  SR5_OC12FROMOCX_ENABLE  0x00008000  /* Pull Out OC12 Signal From OCx   Input                      */
#define  SR5_OC24FROMOCX_ENABLE  0x00010000  /* Pull Out OC24 Signal From OCx   Input                      */
#define  SR5_OC48FROMOCX_ENABLE  0x00020000  /* Pull Out OC48 Signal From OC192 Input                      */
#define  SR5_OC96FROMOCX_ENABLE  0x00040000  /* Pull Out OC48 Signal From OC192 Input                      */

/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 pic_enable_sonetr5 (PICSTRUCT *p, int_4 mport,int_4 dis_enable)
{

  /* This Puts Module Into Reset By Setting All Config Bits = 0 */                       
   if (dis_enable == 0)
     {
       pic_wmodreg(p,mport,1,0,SR5_NUM_PRG_BITS); 
       udelay(100); 
     }
   else
     {
       pic_wmodreg(p,mport,1,1,SR5_NUM_PRG_BITS); 
       udelay(100);
     }
   return 0;
}
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 pic_setup_sonetr5 (PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 gain) 
{
   int_4 i; int_u4 sonet_cfg_bits = 0;

 
   /* This Puts Module Into Reset By Setting All Config Bits = 0 */  
    /* This Puts Module Into Reset By Setting All Config Bits = 0 */     
   pic_wmodreg(p,mport,1,sonet_cfg_bits,SR5_NUM_PRG_BITS);
   udelay(100);                  
   pic_wmodreg(p,mport,0,sonet_cfg_bits,SR5_NUM_PRG_BITS); 
   udelay(100);
    
   /* To Configure the module for operation 'bit wise or' in configuration values                    */
   /* This Line Must Always Be Here, It Take the module out of reset mode and starts Data Acquistion */
    sonet_cfg_bits = sonet_cfg_bits | SR5_MODRESET_REMOVE; 

   /* Set Up ITU G.709 FEC Clock Ref Source     */      
    if (findflag("G709FEC",p->config) >= 0) 
       sonet_cfg_bits = sonet_cfg_bits | SR5_REFCLK_SEL0; 

   /* Turn ON Error Detect-Only Acquire Valid Frames             */
    if (findflag("ERRDETON",p->config) >= 0)
       sonet_cfg_bits = sonet_cfg_bits | SR5_ENABLE_ERROR_DETECT; 
 
   /* Turn Off Scrambling/ Descrambling         */
    if (findflag("SCRAMOFF",p->config) >= 0)
       sonet_cfg_bits = sonet_cfg_bits | SR5_DISABLE_SCRAMBLING;

    /* Turn Off Scrambling/ Descrambling         */
    if (findflag("FRAMINGOFF",p->config) >= 0)
       sonet_cfg_bits = sonet_cfg_bits | SR5_DISABLE_FRAMING | SR5_DISABLE_SCRAMBLING; 

   
   /* Setup Type Of Signal To Acquire/Playback  */
    if      (findflag("OC12",p->config) >= 0)  /* Check For OC12 Data In Open String        */
      sonet_cfg_bits = sonet_cfg_bits | SR5_OC12_192ENABLE;
    else if (findflag("OC24",p->config) >= 0)  /* Check For OC24 Data In Open String        */
      sonet_cfg_bits = sonet_cfg_bits | SR5_OC24ENABLE;
    else if (findflag("OC48",p->config) >= 0)  /* Check For OC48 Data In Open String        */
      sonet_cfg_bits = sonet_cfg_bits | SR5_OC48ENABLE;
    else
      sonet_cfg_bits = sonet_cfg_bits | SR5_OC3_96ENABLE;
      
              

   /* Check For OC3 Remove From OCx            */
    if ((findflag("OC3FROMOCX",p->config) >= 0) || (findflag("OC3FROMOC12",p->config) >= 0))
       { 
        /* Enable Demux Operation              */
        sonet_cfg_bits = sonet_cfg_bits | SR5_DEMUXENABLE;  

        /* Error Check OC3 Removal Operation   */
        if ((sonet_cfg_bits & SR5_OC3_96ENABLE) != 0) {
            printf("\n Error-OC12 or OC24 or OC48 Must Be Enabled For OC3 Removal\n");             
            return(-1); 
          }

        i=findintflag("OC3NUM",p->config); 
          
        if (i < 0) { /* Did Not Find Flag, Assume Zero */ 
            printf("\n Warning-OC3 Number For Removal Not Specified-Assuming OC3NUM=0\n");
            i = 0; 
          }
        if ((i >= 4) && ((sonet_cfg_bits & SR5_OC12_192ENABLE) != 0))  {
            printf("\n Error-OC3 Number For Removal Out Of Range For OC12 Input; Valid Values 0 to 3\n");
            return(-1); 
          }
        if ((i >= 8) && ((sonet_cfg_bits & SR5_OC24ENABLE) != 0)) {
            printf("\n Error-OC3 Number For Removal Out Of Range For OC24 Input; Valid Values 0 to 7\n");
            return(-1); 
          }
        if ((i >= 16) && ((sonet_cfg_bits & SR5_OC48ENABLE) != 0)) {
            printf("\n Error-OC3 Number For Removal Out Of Range For OC48 Input; Valid Values 0 to 15\n");
            return(-1); 
          }

      
        sonet_cfg_bits = sonet_cfg_bits | SR5_OC3FROMOCX_ENABLE;
        sonet_cfg_bits = sonet_cfg_bits | ((i << 19) & 0x001f80000);            
      } 
 
      /* Check For OC12 Remove From OCx            */
    if (findflag("OC12FROMOCX",p->config) >= 0) { 
        /* Error Check OC12 Removal Operation      */
  /*      if ((((sonet_cfg_bits & SR5_OC3_96ENABLE) != 0) || ((sonet_cfg_bits & SR5_OC12_192ENABLE) != 0)) && (mport == 2)) {
            printf("\n Error-OC24, Or OC48 Must Be Enabled For OC12 Removal\n");             
            return(-1); 
          }     
  */
        /* Error Check For More Than 1 Demux Op   */
        if ((sonet_cfg_bits & SR5_DEMUXENABLE) != 0) {
            printf("\n Error-Only 1 Demux Operation Allowed\n");             
            return(-1);  
          }        
        else
          sonet_cfg_bits = sonet_cfg_bits | SR5_DEMUXENABLE;          

        i=findintflag("OC12NUM",p->config);
          
        if (i < 0) { /* Did Not Find Flag, Assume Zero */
            printf("\n Warning-OC12 Number For Removal Not Specified-Assuming OC12NUM=0\n");
            i = 0; 
          }

        if ((i >= 2) && ((sonet_cfg_bits & SR5_OC24ENABLE) != 0)) {
            printf("\n Error-OC12 Number For Removal Out Of Range For OC24 Input; Valid Values 0 to 1\n");
            return(-1); 
          }

        if ((i >= 4) && ((sonet_cfg_bits & SR5_OC48ENABLE) != 0)) {
            printf("\n Error-OC12 Number For Removal Out Of Range For OC48 Input; Valid Values 0 to 3\n");
            return(-1); 
          }
         
        sonet_cfg_bits = sonet_cfg_bits | SR5_OC12FROMOCX_ENABLE;
        sonet_cfg_bits = sonet_cfg_bits | ((i << 19) & 0x001f80000);         
      } 
  
    /* Check For OC24 Remove From OC48            */
    if (findflag("OC24FROMOCX",p->config) >= 0) {
        /* Error Check OC24 Removal Operation   */
      /*  if (((sonet_cfg_bits & SR5_OC48ENABLE) == 0) && (mport == 2)){
            printf("\n Error-OC48 Must Be Enabled For OC24 Removal\n");             
            return(-1); 
          }
      */     
        /* Error Check For More Than 1 Demux Op   */
        if ((sonet_cfg_bits & SR5_DEMUXENABLE) != 0) {
            printf("\n Error-Only 1 Demux Operation Allowed\n");             
            return(-1);  
          }        
        else
          sonet_cfg_bits = sonet_cfg_bits | SR5_DEMUXENABLE; 

        i=findintflag("OC24NUM",p->config);
          
        if (i < 0) { /* Flag Not Found Assume 0 */
            printf("\n Warning-OC24 Number For Removal Not Specified-Assuming OC24NUM=0\n");
            i = 0;
          }
        if (i >= 2) { 
            printf("\n Error-OC24 Number For Removal Out Of Range For OC48 Input; Valid Values 0 to 1\n");
            return(-1); 
          }            

     
        sonet_cfg_bits = sonet_cfg_bits | SR5_OC24FROMOCX_ENABLE;
        sonet_cfg_bits = sonet_cfg_bits | ((i << 19) & 0x001f80000);            
      } 

    if ((p->type==ICEPIC4) && ((sonet_cfg_bits & SR5_OC48ENABLE) != 0) && ((sonet_cfg_bits & SR5_DEMUXENABLE) == 0)) {
        printf("\n Error-Raw OC48 Acquire/Playback Rates (320 MB/Sec) Too High For ICE-PIC4T!\n");
        printf("For Raw OC48 Acquire/Playback ICE-PIC5 Series Or Higher PCI Card Needed\n");  
        return(-1);  
      }
 
    if ((findflag("SLVENABLE",p->config) >= 0) && ((sonet_cfg_bits &  SR5_DEMUXENABLE) != 0) && (dir <= 0))
      sonet_cfg_bits = sonet_cfg_bits | SR5_SLAVE_ENABLE;

   /* Set Module For Acquisition If Desired Else Playback     */
    if (dir <= 0)      
      sonet_cfg_bits = sonet_cfg_bits | SR5_INPUT_ENABLE;
   
   vprint("Setup SONETR5 port=%d cfgbits=%08x\n",mport,sonet_cfg_bits);
   pic_wmodreg(p,mport,0,sonet_cfg_bits,SR5_NUM_PRG_BITS);  /* Download Bit Wise ORed Bits To Module  */
   
   return 0;
}
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
#define  SR6_NUM_PRG_BITS                32

/* Register Address Definitions */
#define SR6_RESETREG_ADR         0x00000000
#define SR6_ENDISREG_ADR         0x00010000
#define SR6_CFGREG_ADR           0x00020000
#define SR6_SONETREG_ADR         0x00030000
#define SR6_TRCVRREG_ADR         0x00040000
#define SR6_TCLKCFGREG_ADR       0x00050000
#define SR6_DCLKCFGREG_ADR       0x00060000
#define SR6_FPGAVER_ADDR         0x00070000  /* FPGA Version Number            */
#define SR6_SFPREG_ADR           0x00080000
#define SR6_TEMPSNSREG_ADR       0x000A0000
#define SR6_CBCFGREG_ADR         0x000B0000
#define SR6_CBRSTREG_ADR         0x000C0000
#define SR6_TRCVRRAM_ADR         0x000D0000
#define SR6_TRCVRSIG_ADDR        0x000E0000  /* Transceiver Signals            */
#define SR6_HOSTMEM_ADR          0x000F0000 

#define SR6_G709CREG_ADR         0x00100000
#define SR6_G707CREG_ADR         0x00110000
#define SR6_J0BYTEREG_ADR        0x00120000
#define SR6_USRCODE_ADR          0x00130000



/* Reset Register, Register 0, Bit Definitions          */
#define SR6_RESET_BIT            0x00000001  /* Remove Reset Single Port       */       
#define SR6_GLBRESET_BIT         0x00000002  /* Remove Reset Dual   Port       */

/* Enable Register, Register 1, Bit Definitions         */
#define SR6_ENABLE_BIT           0x00000001  /* Enable Single Port Bit         */
#define SR6_GLBENABLE_BIT        0x00000002  /* Enable Dual   Port Bit         */

/* Config Register, Register 2, Bit Definitions         */
#define SR6_ACQUIRE_BIT          0x00000001  /* Enable Acquire Single Port Bit */
#define SR6_GLBACQUIRE_BIT       0x00000002  /* Enable Acquire Dual   Port Bit */
#define SR6_LVDSDBG_BIT          0x00000004  /* Enable Sing Port LVDS Rx Debug */
#define SR6_GLBLVDSDBG_BIT       0x00000008  /* Enable Dual Port LVDS Rx Debug */
#define SR6_ICEPORTLB_BIT        0x00000010  /* Loop Data From ICE O to ICE I  */ 

/* Sonet Register, Register 3, Bit Definitions          */
#define SR6_S_MODRESET_REMOVE     0x00000001  /* Must Be Used For Module To Come Out Of Reset               */
#define SR6_S_CARDTYPE            0x00000002  /* Set Card Type To PIC5T When Ready                          */
#define SR6_S_FEC_ENABLE          0x00000004  /* Enable FEC Data Processing                                 */
#define SR6_S_DISABLE_SCRAMBLING  0x00000008  /* Turn Off Fiber Optic Descrambling (Rx) or Scrambling (Tx)  */
#define SR6_S_INPUT_ENABLE        0x00000010  /* Enable Module For Input                                    */
#define SR6_S_SLAVE_ENABLE        0x00000020  /* First Frame Of Slave Module Is Demux #0 Channel            */
#define SR6_S_DISABLE_FRAMING     0x00000040  /* Disable Search For Framing Bring In Data W/Unknown Framing */
#define SR6_S_DEMUXENABLE         0x00000080  /* Enable Realtime Demux Of Incoming Signal                   */
#define SR6_S_OC96ENABLE          0x00000100  /* Use If Line Rate 4976 <Hz                                  */
#define SR6_S_OC192ENABLE         0x00000200  /* Use If Line Rate 9958 MHz                                  */
#define SR6_S_OC3ENABLE           0x00000400  /* Use If Line Rate  155 MHz                                  */
#define SR6_S_OC12ENABLE          0x00000800  /* Use If Line Rate  622 MHz                                  */
#define SR6_S_OC24ENABLE          0x00001000  /* Use If Line Rate 1244 Mhz                                  */
#define SR6_S_OC48ENABLE          0x00002000  /* Use If Line Rate 2488 MHz                                  */
#define SR6_S_OC3FROMOCX_ENABLE   0x00004000  /* Pull Out OC3  Signal From OCx   Input                      */ 
#define SR6_S_OC12FROMOCX_ENABLE  0x00008000  /* Pull Out OC12 Signal From OCx   Input                      */
#define SR6_S_OC24FROMOCX_ENABLE  0x00010000  /* Pull Out OC24 Signal From OCx   Input                      */
#define SR6_S_OC48FROMOCX_ENABLE  0x00020000  /* Pull Out OC48 Signal From OC192 Input                      */
#define SR6_S_OC96FROMOCX_ENABLE  0x00040000  /* Pull Out OC96 Signal From OC192 Input                      */

/* Transceiver Config Register, Register 4 Bit Definitions */
#define SR6_GXBPDWN_BIT           0x00000001  /* Transceiver Power Down Bit   */
#define SR6_PLLPDWN_BIT           0x00000002  /* PLL Power Down Bit           */
#define SR6_TXDREST_BIT           0x00000004  /* Tx Digital Reset             */
#define SR6_RXAREST_BIT           0x00000008  /* Rx Analog  Reset             */ 
/* Transceiver Read Bits                                   */
#define SR6_TXPLLLK_BIT           0x00000001  /* Transceiver Tx PLL Locked    */
#define SR6 RXFRQLK_BIT           0x00000002  /* Rx Locked To Data            */              

/* Crossbar Config Regiser, Register B, Bit Definitions    */
#define SR6_CBSINGPORT_BIT       0x00000001  /* Single ICE Port Op-NO Mux      */
#define SR6_CBDUALPORT_BIT       0x00000002  /* Dual ICE Port Op-Byte Mux Op   */ 

/* Host Memory, Register F, Bit Definitions                */
#define SR6_HMCLKVAL_OFFSET      0x00000000  /* Current AnyRate Freq           */
#define SR6_HMPORT_OFFSET        0x00000010  /* Offset For Each Port Config    */ 

/* J0 Byte Config Register, Register 18, Bit Definitions   */         
#define SR6_J0BYTEEN_BIT         0x00000001  /* Enable Replacement of J0 Byte  */



/* FPGA Download Versions */
#define FPGA_HIRATE_DLD  0xC3C3C3C3
#define FPGA_LORATE_DLD  0xB4B4B4B4
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
int_4 sr6_synclk_cfg (PICSTRUCT *p, int_4 mport, int_u4 maddr, int_u4 value)
{   
   
   pic_wmodreg(p,mport,maddr,((value >> 8) & 0x000000FF),SR6_NUM_PRG_BITS);         /* Set Register Address To Write */
   udelay(500);

   pic_wmodreg(p,mport,maddr,(value & 0x000000FF) | 0x00004000,SR6_NUM_PRG_BITS);   /* Write Data To Register        */ 
   udelay(500);

   return(0);    
}
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
int_4 pic_sonetr6_getkey(PICSTRUCT *p, int_4 mport,int_u4 addr)
  {
    int_u4 mbval = 0;
    int_u4 sfpdat[256];
    int_u4 rxpwrlvl;
    int_4 mtemp = 0;
    int ii;

    if ((addr == 1) || (addr == 2))  /* SFP Data */
      {
        pic_wmodreg(p,mport,SR6_SFPREG_ADR,0x00A300A3,SR6_NUM_PRG_BITS); /* "dumby Write Op, Followed by Read */
        udelay(10000);

        pic_rmodreg(p,mport,SR6_SFPREG_ADR+96,sfpdat+96,SR6_NUM_PRG_BITS);    /* Rx Pwr Level    */
        udelay(1000);
        pic_rmodreg(p,mport,SR6_SFPREG_ADR+104,sfpdat+104,SR6_NUM_PRG_BITS);  /* Temp Upper Byte */
        udelay(1000);
        pic_rmodreg(p,mport,SR6_SFPREG_ADR+105,sfpdat+105,SR6_NUM_PRG_BITS);  /* Temp Lower Byte */ 
        udelay(1000);

      /*  for (ii=0;ii<256;ii++)
          {
            pic_rmodreg(p,mport,SR6_SFPREG_ADR+ii,sfpdat+ii,SR6_NUM_PRG_BITS);
            udelay(1000);
          }
       */
        rxpwrlvl = ((sfpdat[104]<<8)|sfpdat[105])/10;      /* Need to Divide by 10 For uWatts */    
      }
    else if (addr == 3)
      {
        pic_wmodreg(p,1,SR6_TEMPSNSREG_ADR,0x00000001,SR6_NUM_PRG_BITS);             /* Enable Clk    */   
        udelay(400);
        pic_wmodreg(p,1,SR6_TEMPSNSREG_ADR|0x00000001,0x00000001,SR6_NUM_PRG_BITS);  /* Assert Clr    */
        udelay(400);
        pic_wmodreg(p,1,SR6_TEMPSNSREG_ADR|0x00000001,0x00000000,SR6_NUM_PRG_BITS);  /* De-Assert Clr */
        udelay(400);
        ii    = 0; 
        mbval = 0;
        while (((mbval & 0x00000100) == 0) && (ii < 10))
          {  
            pic_rmodreg(p,1,SR6_TEMPSNSREG_ADR,&mbval,SR6_NUM_PRG_BITS);  
            ii = ii + 1;
            udelay(400);
          }
        pic_wmodreg(p,1,SR6_TEMPSNSREG_ADR,0x00000000,SR6_NUM_PRG_BITS);             /* Disable Clk   */
        if ((mbval & 0x00000100) != 0)
          { 
            mbval = mbval & 0x000000FF;
            mtemp = ((int_4)mbval) - 128;
            /* printf("Mtemp = %d\n",mtemp); */
          }
        else
          {
            printf("Err: Module Temperature Retreival Unsuccessful-Setting Temp To -128 Degrees C\n");
            mtemp = -128;
          }
      }
    else 
      {
            pic_rmodreg(p,1,addr,&mbval,32);  
      }


    if (addr == 1)
      return (rxpwrlvl);    /* Return Pwr Level */   
    else if (addr == 2)
      return (sfpdat[96]);  /* Return Temp      */
    else if (addr == 3)
      return(mtemp);  
    else
      return ((int_4)mbval); 

  } 
/*--------------------------------------------------------------*/
int_4 pic_sonetr6_dump(PICSTRUCT *p, int_4 mport,int_4 flag)
  {
    int_u4 mbval;
    int ii;
 
   /* FPGA Version */   
    pic_rmodreg(p,1,SR6_FPGAVER_ADDR,&mbval,SR6_NUM_PRG_BITS);
    printf("\nFPGA Download Version = %x\n",mbval);
    if (mbval == FPGA_HIRATE_DLD)
      printf("High Speed Version Download\n");
    else if (mbval == FPGA_LORATE_DLD)
      printf("Low Speed Version Download\n"); 
    else 
      printf("Download Version Unrecognized\n");

   /* Transceiver Info */
    for (ii=1;ii<3;ii++)
      {
        printf("\n*** Module Port = %d ***\n",ii);
	pic_rmodreg(p,ii,SR6_TRCVRSIG_ADDR,&mbval,SR6_NUM_PRG_BITS);
	printf("Transceiver PLL = ");
	if ((mbval & 0x00000001) == 0x00000001)
	   printf("LOCKED\n");
	else
	   printf("UNLOCKED\n");
	      
	printf("Receiver CDR Locked To ");
	if ((mbval & 0x00000002) == 0x00000002)
	   printf("LINE DATA\n");
	else
	   printf("REFERENCE\n");

       /* Get SFP Parameters */
        printf("\nSFP Temperature       = %d Degrees C\n",pic_sonetr6_getkey(p,ii,2));
        printf("SFP Rx Power Level    = %d uWatts\n",pic_sonetr6_getkey(p,ii,1));	
        printf("Module Temperature    = %d Degrees C\n",pic_sonetr6_getkey(p,ii,3));	
      }  

    return(0);
  }
/*--------------------------------------------------------------*/
int_4 pic_enable_sonetr6 (PICSTRUCT *p, int_4 mport,int_4 dis_enable)
{
  int_u4 mbval;
  
 /* ICE Card Can't Run Mux Mode From Port 2 */
  if (findflag("SNTALTPORT",p->config) >= 0)
    mport = 2;  

 /* This Puts Module Into Reset By Setting All Config Bits = 0 */                       
  if (dis_enable == 0)
    {
     /* Clear Enable Bit In Module Memory*/ 
      pic_wmodreg(p,1,SR6_HOSTMEM_ADR|(mport * SR6_HMPORT_OFFSET)|(SR6_ENDISREG_ADR>>16),0,SR6_NUM_PRG_BITS);      /* Clr Mem Enable Bit */
      pic_wmodreg(p,mport,SR6_RESETREG_ADR,0,SR6_NUM_PRG_BITS);                                                    /* Port Reset         */
      pic_wmodreg(p,mport,SR6_CBRSTREG_ADR,0,SR6_NUM_PRG_BITS);                                                    /* Cross Bar Reset    */
      udelay(100); 
    }
  else
    {           
      pic_wmodreg(p,1,SR6_HOSTMEM_ADR|(mport * SR6_HMPORT_OFFSET)|(SR6_ENDISREG_ADR>>16),1,SR6_NUM_PRG_BITS);      /* Set Mem Enable Bit */
      pic_rmodreg(p,1,SR6_HOSTMEM_ADR|(mport * SR6_HMPORT_OFFSET)|(SR6_RESETREG_ADR>>16),&mbval,SR6_NUM_PRG_BITS); /* Read Reset Value   */
     /* printf("Port = %d Reset Val = %x\n",mport,mbval);  */
      pic_wmodreg(p,mport,SR6_CBRSTREG_ADR,1,SR6_NUM_PRG_BITS);                                                    /* Remove CB Reset    */
      pic_wmodreg(p,mport,SR6_RESETREG_ADR,mbval,SR6_NUM_PRG_BITS);                                                /* Reove Port Reset   */
      udelay(100); 
    }
  return 0;
}
/*--------------------------------------------------------------*/
#define MAX_ICEPORT_RATE  700000000    /* Maximum ICE Port Rate */
#define FEC192RATE       1338653164    /* FEC OC192 Byte Rate   */
#define OC192RATE        1244160000    /*     OC192 Byte Rate   */
#define FEC48RATE         333257143    /* FEC OC48  Byte Rate   */
#define OC48RATE          311040000    /*     OC48  Byte Rate   */
#define OC12RATE           77760000    /*     OC12  Byte Rate   */
#define OC3RATE            19440000    /*      OC3  Byte Rate   */

#define HIRATE_LOWCUT     125000000    /* Low Rate Cutoff For High Rate Download */
#define PREFX_FLAG       0x80000000    /* Set Flag For PREFX Use                 */

#define J0SCRUBEN        0x80000000    /* Enable Bit For J0 Scrub                */ 
#define OC192FRAMESZ         155520    /* Size of OC192 Frame In Bytes           */
#define OC192J0LOC              384    /* OC192 J0 Location                      */
#define OC48FRAMESZ           38880    /* Size of OC48  Frame In Bytes           */
#define OC48J0LOC                96    /* OC48  J0 Location                      */
#define OC12FRAMESZ            9720    /* Size of OC48  Frame In Bytes           */
#define OC12J0LOC                24    /* OC48  J0 Location                      */   
#define OC3FRAMESZ             2430    /* Size of OC48  Frame In Bytes           */
#define OC3J0LOC                  6    /* OC48  J0 Location                      */ 

int_4 pic_setup_sonetr6 (PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 gain) 
{
  Si5326_Reg_Obj Si5326_Reg; 
  int ii;    
  int i;
  int_u4 sr6_cfgbits = 0;
  float anyclkrate   = 0.0;
  int_4 altmport     = 2;
  int_u4 arclkselreg = 0x00000055;              /* AnyRate Clock Input Source 2 On-Board Oscillator,Default  */
  int_u4 mbval;
  int_u4 dldversion  = FPGA_HIRATE_DLD;  
  int_u4 cmprate     = 0;
  int_u2 sr6lrphyram[64] = { 0xF800,0x0000,0x0C30,0x4001,0x3000,0x0000,0x6055,0x2200,
	                     0x0000,0x0000,0x8000,0x0000,0x2964,0x2000,0x0000,0x0000,
	                     0x2DB4,0xBC31,0x6000,0x0000,0x0000,0x00C0,0xD05E,0x0000,
	                     0x0006,0x03E8,0x0000,0x020E,0x0016,0x6000,0x0000,0x0000,
	                     0x1800,0x0800,0x0010,0x0002,0x0400,0x0786,0x6005,0xE494,
	                     0x25C5,0x0080,0x1022,0x0000,0x0000,0x0000,0x0100,0x0000,
	                     0x0000,0x25C5,0x0080,0x1422,0x0000,0x0010,0x0400,0x0000,
                             0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 };

  int_u2 sr6hrphyram[64] = { 0xF800,0x0000,0x0C30,0x4001,0x0000,0x0000,0x6055,0x2A00,
	                     0x0000,0x0000,0x0004,0x0000,0x1164,0x1000,0x0000,0x0000,
                             0x2DB4,0xBC31,0x6010,0x0000,0x0000,0x2000,0xD05E,0x0000,
                             0x0006,0x03E8,0x0000,0x020E,0x0016,0xC000,0x0000,0x0000,
                             0x1800,0x0800,0x0610,0x0002,0x0400,0x0006,0x6005,0xE494,
                             0x0C05,0x0080,0x1022,0x0000,0x0000,0x0000,0xC100,0x0000,
                             0x0000,0x0C05,0x0080,0x1422,0x0000,0x0610,0x0400,0x0000,
                             0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 };

  int_u2 *sr6phyram;

 /* ICE Card Can't Run Mux Mode From Port 2 */
  if (findflag("SNTALTPORT",p->config) >= 0)
    mport = 2; 
         
 /* Set Alternate Port To Check Setup */
  if (mport == 2)
    altmport = 1;

 /* Find FPGA Download Version  */
  pic_rmodreg(p,1,SR6_FPGAVER_ADDR,&mbval,SR6_NUM_PRG_BITS);
  dldversion = mbval;     

 /* Set PHY Mem Programming     */
  if (dldversion == FPGA_LORATE_DLD)
    sr6phyram = sr6lrphyram;
  else
    sr6phyram = sr6hrphyram;

 /* Set Default Line Rate       */
  anyclkrate = ((float) rate) / 4.0; 

  /* Turn Off J0 Byte Scrubbing  */
  pic_wmodreg(p,mport,SR6_J0BYTEREG_ADR,0,SR6_NUM_PRG_BITS);
 
 /* G709 Framer-TURN OFF        */
  pic_wmodreg(p,mport,SR6_G709CREG_ADR|0x0000008,3,SR6_NUM_PRG_BITS);  /* Framer Enable              */
  pic_wmodreg(p,mport,SR6_G709CREG_ADR|0x000000C,4,SR6_NUM_PRG_BITS);  /* 4 Good Frame               */
  pic_wmodreg(p,mport,SR6_G709CREG_ADR|0x0000010,4,SR6_NUM_PRG_BITS);  /* 4 Bad Frame                */
  pic_wmodreg(p,mport,SR6_G709CREG_ADR|0x0000014,32,SR6_NUM_PRG_BITS); /* 4 Frame Cnt Window         */
  pic_wmodreg(p,mport,SR6_G709CREG_ADR|0x0000108,3,SR6_NUM_PRG_BITS);  /* Descrambler                */ 
  pic_wmodreg(p,mport,SR6_G709CREG_ADR|0x0000208,3,SR6_NUM_PRG_BITS);  /* Decoder Enbl, Bypass, Fec  */
 /* G707 Framer-TURN OFF        */  
  pic_wmodreg(p,mport,SR6_G707CREG_ADR|0x0000008,3,SR6_NUM_PRG_BITS);  /* Framer Disable             */
  pic_wmodreg(p,mport,SR6_G707CREG_ADR|0x000000C,4,SR6_NUM_PRG_BITS);    /* 4 Good Frame               */
  pic_wmodreg(p,mport,SR6_G707CREG_ADR|0x0000010,4,SR6_NUM_PRG_BITS);    /* 4 Bad Frame                */
  pic_wmodreg(p,mport,SR6_G707CREG_ADR|0x0000014,32,SR6_NUM_PRG_BITS);   /* 32 Frame Cnt Window        */
  pic_wmodreg(p,mport,SR6_G707CREG_ADR|0x0000108,3,SR6_NUM_PRG_BITS);/* Descrambler                */
    

 /* Check For Pre-Defined Rates */
  if ((findflag("OC192FULL",p->config) >= 0) || (findflag("OC192",p->config) >= 0))
    {
      rate = OC192RATE;
      sr6_cfgbits = (((OC192FRAMESZ/8) - 2) << 16);  /* J0 & Frame Config Bits    */

     /* G709 Enable Code */ 
      if (findflag("G709FEC",p->config) >= 0)
        {
         /* G709 Enable      */
          if (findflag("FRAMINGOFF",p->config) < 0)   /*  */
            {
              pic_wmodreg(p,mport,SR6_G709CREG_ADR|0x0000008,1,SR6_NUM_PRG_BITS);  /* Framer Enable              */
              pic_wmodreg(p,mport,SR6_G709CREG_ADR|0x000000C,4,SR6_NUM_PRG_BITS);  /* 4 Good Frame               */
              pic_wmodreg(p,mport,SR6_G709CREG_ADR|0x0000010,4,SR6_NUM_PRG_BITS);  /* 4 Bad Frame                */
              pic_wmodreg(p,mport,SR6_G709CREG_ADR|0x0000014,32,SR6_NUM_PRG_BITS); /* 32 Frame Cnt Window        */

             /* G709 Descrambler */
              pic_wmodreg(p,mport,SR6_G709CREG_ADR|0x0000108,1,SR6_NUM_PRG_BITS);  /* Descrambler                */
    
             /* G709 Decoder     */
              pic_wmodreg(p,mport,SR6_G709CREG_ADR|0x0000208,1,SR6_NUM_PRG_BITS);  /* Decoder Enbl, Bypass, Fec  */     
            }
         /* Assign Rate      */
          rate = FEC192RATE;
        }


     /* G707 Enable */
      if (findflag("FRAMINGOFF",p->config) < 0)                                      /* G707 Framer                */
        { 
          pic_wmodreg(p,mport,SR6_G707CREG_ADR|0x0000008,1,SR6_NUM_PRG_BITS);        /* Framer Enable              */
          pic_wmodreg(p,mport,SR6_G707CREG_ADR|0x000000C,4,SR6_NUM_PRG_BITS);        /* 4 Good Frame               */
          pic_wmodreg(p,mport,SR6_G707CREG_ADR|0x0000010,4,SR6_NUM_PRG_BITS);        /* 4 Bad Frame                */
          pic_wmodreg(p,mport,SR6_G707CREG_ADR|0x0000014,32,SR6_NUM_PRG_BITS);       /* 32 Frame Cnt Window        */     
          if (findflag("SCRAMOFF",p->config) < 0)                                    /* G707 Descrambler */
            pic_wmodreg(p,mport,SR6_G707CREG_ADR|0x0000108,1,SR6_NUM_PRG_BITS);
   
           /* Set J0 Byte Value         */
           if (findflag("SNTJ0BYTE",p->config) >= 0)
             { 
               sr6_cfgbits = J0SCRUBEN | (((OC192FRAMESZ/8) - 2) << 16) | (((OC192J0LOC/8) - 1) << 8);

               i=findintflag("SNTJ0BYTE",p->config);
               if (i>=0)
                 sr6_cfgbits = sr6_cfgbits | (i & 0x000000FF);
               else
                 sr6_cfgbits = sr6_cfgbits | 0x000000CC;    /* 0xCC Default Value  */   
             }
        } 
           
      pic_wmodreg(p,mport,SR6_J0BYTEREG_ADR,sr6_cfgbits,SR6_NUM_PRG_BITS);  /* Set J0 Byte & Frame Size         */    
      anyclkrate = ((float) rate) / 4.0;                                    /* Ref Clock Freq = LineRate div 32 */        

    } 
  if (findflag("OC48",p->config) >= 0)
    {
      rate = OC48RATE;
      sr6_cfgbits = (((OC48FRAMESZ/8) - 2) << 16);  /* J0 & Frame Config Bits    */

      if (findflag("G709FEC",p->config) >= 0)
        {
          rate = FEC48RATE;  
          if (findflag("FRAMINGOFF",p->config) < 0)
            {
              printf("Err: OC48 with G.709 Encapsulation Can ONLY Be input or output with use of the FRAMINGOFF flag\n");
              printf("Err: Add the FRAMINGOFF flag to acquire G.709 OC48 Data\n");
              return(-1); 
            }   
        } 
      else
        {          
          if (findflag("FRAMINGOFF",p->config) < 0)
            {
             /* Set J0 Byte Value         */
              if (findflag("SNTJ0BYTE",p->config) >= 0)
                { 
                  sr6_cfgbits = J0SCRUBEN | (((OC48FRAMESZ/8) - 2) << 16) | (((OC48J0LOC/8) - 1) << 8);

                  i=findintflag("SNTJ0BYTE",p->config);
                  if (i>=0)
                    sr6_cfgbits = sr6_cfgbits | (i & 0x000000FF);
                  else
                    sr6_cfgbits = sr6_cfgbits | 0x000000CC;    /* 0xCC Default Value  */   
                }
            }
        }
       
     
      pic_wmodreg(p,mport,SR6_J0BYTEREG_ADR,sr6_cfgbits,SR6_NUM_PRG_BITS);  /* Set J0 Byte & Frame Size               */ 
      anyclkrate = ((float) rate) / 4.0;                                    /* Ref Clock Freq = LineRate div 32 */  
    }
  if (findflag("OC12",p->config) >= 0)
    {
      rate = OC12RATE;
      sr6_cfgbits = (((OC12FRAMESZ/2) - 2) << 16); /* J0 & Frame Config Bits    */

      if (findflag("FRAMINGOFF",p->config) < 0)
        {
         /* Set J0 Byte Value         */
          if (findflag("SNTJ0BYTE",p->config) >= 0)
            { 
              sr6_cfgbits = J0SCRUBEN | (((OC12FRAMESZ/2) - 2) << 16) | (((OC12J0LOC/2) - 1) << 8);

              i=findintflag("SNTJ0BYTE",p->config);
              if (i>=0)
                sr6_cfgbits = sr6_cfgbits | (i & 0x000000FF);
              else
                sr6_cfgbits = sr6_cfgbits | 0x000000CC;    /* 0xCC Default Value  */   
            }
        }

      pic_wmodreg(p,mport,SR6_J0BYTEREG_ADR,sr6_cfgbits,SR6_NUM_PRG_BITS); 
      anyclkrate =  ((float) rate) * 2.0;          /* Reference Clock Freq = LineRate div 16 */
    }  
  if (findflag("OC3",p->config) >= 0)
    {
      rate = OC3RATE;
      sr6_cfgbits = (((OC3FRAMESZ/2) - 2) << 16); /* J0 & Frame Config Bits    */

      if (findflag("FRAMINGOFF",p->config) < 0)
        {
         /* Set J0 Byte Value         */
          if (findflag("SNTJ0BYTE",p->config) >= 0)
            { 
              sr6_cfgbits = J0SCRUBEN | (((OC3FRAMESZ/2) - 2) << 16) | (((OC3J0LOC/2) - 1) << 8);

              i=findintflag("SNTJ0BYTE",p->config);
              if (i>=0)
                sr6_cfgbits = sr6_cfgbits | (i & 0x000000FF);
              else
                sr6_cfgbits = sr6_cfgbits | 0x000000CC;    /* 0xCC Default Value  */   
            }
        }

      pic_wmodreg(p,mport,SR6_J0BYTEREG_ADR,sr6_cfgbits,SR6_NUM_PRG_BITS);
      anyclkrate =  ((float) rate) * 2.0;          /* Reference Clock Freq = LineRate div 16 */
    }




 /* Rate Check Firmware Vs. Data Rate */ 
  if ((rate < HIRATE_LOWCUT) && (dldversion == FPGA_HIRATE_DLD))
    {
       printf("ERR: SonetR6: Wrong Firmware Download For Low Rate Signal-Signals < %d MBy/Sec \n",HIRATE_LOWCUT/1000000 );
       printf("ERR: Reset Card And Use Flag IOMFPGA=lr For Correct Download\n");
       return(-1); 
    }
     
 /* Rate Check Firmware Vs. Data Rate */ 
  if ((rate > HIRATE_LOWCUT) && (dldversion == FPGA_LORATE_DLD))
    {
       printf("ERR: SonetR6: Wrong Firmware Download For High Rate Signal-Signals > %d MBy/Sec \n",HIRATE_LOWCUT/1000000 );
       printf("ERR: Reset Card WITHOUT THe Use Of Flag IOMFPGA=lr For Correct Download\n");
       return(-1); 
    } 
       
 /* Stop Port */   
  pic_wmodreg(p,mport,SR6_RESETREG_ADR,0,SR6_NUM_PRG_BITS);   /*  Port Reset     */ 
  pic_wmodreg(p,mport,SR6_CBRSTREG_ADR,0,SR6_NUM_PRG_BITS);   /* Cross Bar Reset */  
  pic_wmodreg(p,1,SR6_HOSTMEM_ADR|(mport * SR6_HMPORT_OFFSET)|(SR6_ENDISREG_ADR>>16),0,SR6_NUM_PRG_BITS); /* Record Disble  of Port */
  pic_wmodreg(p,1,SR6_HOSTMEM_ADR|(mport * SR6_HMPORT_OFFSET)|(SR6_RESETREG_ADR>>16),0,SR6_NUM_PRG_BITS); /* Record Reset   of Port */

 
 /* Read Back Current AnyRate Frequency                        */ 
  pic_rmodreg(p,1,SR6_HOSTMEM_ADR|SR6_HMCLKVAL_OFFSET,&mbval,SR6_NUM_PRG_BITS); 
  /* printf("Rate in Mem = %d\n",mbval); */  
 
 /* Set Freq Compare Value Add PREFX Flag To Rate If Necessary */
  cmprate = rate;
  if (findflag("PREFX",p->config) >= 0)
    cmprate = cmprate | PREFX_FLAG;
  
 /* AnyRate Clock Configuration */    
  if (mbval != cmprate)
    { 
      pic_rmodreg(p,1,SR6_HOSTMEM_ADR|(altmport * SR6_HMPORT_OFFSET)|(SR6_ENDISREG_ADR>>16),&mbval,SR6_NUM_PRG_BITS);
      if (mbval != 0)
        {
          printf("Err: Alternate Port, Port = %d, Active and running at different line rate. \n",altmport);
          printf("Err: Both ports must be operated at the same line rate and with the same clock reference\n");
          printf("Err: End the use of the other port, or change the line rate for the current port.\n");
          return(-1); 
        }   

     /* Power Down Both Transceivers */
      pic_wmodreg(p,1,SR6_TRCVRREG_ADR,SR6_GXBPDWN_BIT|SR6_PLLPDWN_BIT|SR6_TXDREST_BIT|SR6_RXAREST_BIT,SR6_NUM_PRG_BITS); 
      pic_wmodreg(p,2,SR6_TRCVRREG_ADR,SR6_GXBPDWN_BIT|SR6_PLLPDWN_BIT|SR6_TXDREST_BIT|SR6_RXAREST_BIT,SR6_NUM_PRG_BITS);

      Si5326_Reg.debuglevel = -1;
      Si5326_Reg.fref   =  10000000.0;
      Si5326_Reg.dclk1  = anyclkrate;
      Si5326_Reg.dclk2  = anyclkrate;
      Si5326_Reg.dwght1 = 1.0;
      Si5326_Reg.dwght2 = 1.0;   
      ii = si5326_regcfg_init(&Si5326_Reg,SI5326_REGCFG_MT_SNTXDR6);
      ii = si5326_regcfg_bwsel(&Si5326_Reg,7);       
      ii = si5326_regcfg_clkin(&Si5326_Reg,SI5326_REGCFG_CLKIN_2);             
      ii = si5326_regcfg_dividers(&Si5326_Reg);
      if ((ii != 0) && (findflag("SNTWARNOFF",p->config) < 0))
        printf("WARN: SNTXDR6 reference freq of %d Hz not possible. Using %f Hz\n",(int_u4)anyclkrate,Si5326_Reg.fclk2);
      si5326_regcfg_debug(&Si5326_Reg);
      if (findflag("PREFX",p->config) >= 0)
        arclkselreg = 0x00000015;            /* Clock Input Source 1 Ext Reference */                     
      for(ii=0; ii<Si5326_Reg.numreg; ii++) 
        {    
          if ((Si5326_Reg.regval[ii] & 0x0000FF00) == 0x00000300)                   
            Si5326_Reg.regval[ii] = (Si5326_Reg.regval[ii] & 0xFFFFFF00) | arclkselreg;  /* Set AnyRate Reference Clock Source */       
 
          sr6_synclk_cfg (p,1,SR6_TCLKCFGREG_ADR,Si5326_Reg.regval[ii]);           
          udelay(1000);
        }

      pic_wmodreg(p,1,SR6_HOSTMEM_ADR|SR6_HMCLKVAL_OFFSET,cmprate,SR6_NUM_PRG_BITS);   /* Store AnyRate Clock Frequency */

      udelay(4000);  /* Allow AnyRate To Calibrate */

     /* Remove Global Power Down Of Both Transceivers */
      pic_wmodreg(p,1,SR6_TRCVRREG_ADR,SR6_PLLPDWN_BIT|SR6_TXDREST_BIT|SR6_RXAREST_BIT,SR6_NUM_PRG_BITS); 
      pic_wmodreg(p,2,SR6_TRCVRREG_ADR,SR6_PLLPDWN_BIT|SR6_TXDREST_BIT|SR6_RXAREST_BIT,SR6_NUM_PRG_BITS);

      udelay(4000);

     /* Remove PLL Power Down Of Both Transceivers */
      pic_wmodreg(p,1,SR6_TRCVRREG_ADR,SR6_TXDREST_BIT|SR6_RXAREST_BIT,SR6_NUM_PRG_BITS); 
      pic_wmodreg(p,2,SR6_TRCVRREG_ADR,SR6_TXDREST_BIT|SR6_RXAREST_BIT,SR6_NUM_PRG_BITS);
     
      udelay(4000);

     /* Retrieve PLL Locked Bit                    */
     /* Read PLL 0 Lock                            */
      pic_rmodreg(p,1,SR6_TRCVRSIG_ADDR,&mbval,SR6_NUM_PRG_BITS);      
      if ((mbval & SR6_TXPLLLK_BIT) == 0)
        {
           if (findflag("PREFX",p->config) >= 0)
             {
               printf("Err: Using External 10MHz Reference and PLLs are NOT Locking to External Reference\n");
               printf("Err: Check That 10MHz External Reference is Connected\n");  
               return(-1); 
             }

           printf("Err: MPORT = 1: TX PLL NOT LOCKED To Reference !!!\n");
           return(-1);
        }
     /* Read PLL 1 Lock                            */
      pic_rmodreg(p,2,SR6_TRCVRSIG_ADDR,&mbval,SR6_NUM_PRG_BITS);
      if ((mbval & SR6_TXPLLLK_BIT) == 0)
        {
          if (findflag("PREFX",p->config) >= 0)
             {
               printf("Err: Using External 10MHz Reference and PLLs are NOT Locking to External Reference\n");
               printf("Err: Check That 10MHz External Reference is Connected\n");  
               return(-1); 
             }

          printf("MPORT = 2: TX PLL NOT LOCKED To Reference !!!\n");
          return(-1);
        }  
      
     /* Clr Tx Digital Reset, Clr Rx Analog Reset  */
      pic_wmodreg(p,1,SR6_TRCVRREG_ADR,0,SR6_NUM_PRG_BITS); 
      pic_wmodreg(p,2,SR6_TRCVRREG_ADR,0,SR6_NUM_PRG_BITS);            
    }

 /* Sonet Config Bits */
  sr6_cfgbits = 0;

 /* Signal Configuration Bits */
  if (dir <= 0)
    {  
      sr6_cfgbits = sr6_cfgbits | SR6_ACQUIRE_BIT;
      if (rate > MAX_ICEPORT_RATE)
        sr6_cfgbits = sr6_cfgbits | SR6_GLBACQUIRE_BIT;  /* Set Dual Port Acquire For High Data Rates */
      else
        {
          if (findflag("ICELOOPBK",p->config) >= 0)
            sr6_cfgbits = sr6_cfgbits | SR6_ICEPORTLB_BIT;
        }

      if (findflag("LVDSDBG",p->config) >= 0)
        {
          sr6_cfgbits = sr6_cfgbits | SR6_LVDSDBG_BIT;
          if (rate > MAX_ICEPORT_RATE)
           sr6_cfgbits = sr6_cfgbits | SR6_GLBLVDSDBG_BIT;
        }      
                
       sr6phyram[41] = 0x8080;     /* Turn On Loopback */ 
      /* Set Rx Gain Value  */         
       i=findintflagdef("SNTRXGAIN",p->config,gain);
       if (i == 0)
         sr6phyram[37] = 0x0006;
       else if (i == 1)
         sr6phyram[37] = 0x0086;
       else if (i==2) 
         sr6phyram[37] = 0x0186;
       else if (i==3) 
         sr6phyram[37] = 0x0386;
       else if (i==4) 
         sr6phyram[37] = 0x0786;
       else 
         { 
           printf("Err: SONETR6 Gain = %d. Valid Range 0 <= value <= 4\n",i);
           return(-1);
         }   
    } 
  else          
    sr6phyram[41] = 0x0080;       /* Turn OFF Loopback */      
     

 /* Write PHY Ram Value To Program PHY */
  for (ii=0;ii<64;ii++)
    pic_wmodreg(p,mport,SR6_TRCVRRAM_ADR+ii,sr6phyram[ii],SR6_NUM_PRG_BITS);

  pic_wmodreg(p,mport,SR6_TRCVRREG_ADR,SR6_TXDREST_BIT|SR6_RXAREST_BIT,SR6_NUM_PRG_BITS); 
  pic_wmodreg(p,mport,SR6_TRCVRREG_ADR,0x000001A0|SR6_TXDREST_BIT|SR6_RXAREST_BIT,SR6_NUM_PRG_BITS);
  udelay(2000);
  pic_wmodreg(p,mport,SR6_TRCVRREG_ADR,0x000000A0|SR6_TXDREST_BIT|SR6_RXAREST_BIT,SR6_NUM_PRG_BITS);        
  udelay(1000);
  pic_wmodreg(p,mport,SR6_TRCVRREG_ADR,SR6_RXAREST_BIT,SR6_NUM_PRG_BITS); 
  udelay(1000);       
  pic_wmodreg(p,mport,SR6_TRCVRREG_ADR,0,SR6_NUM_PRG_BITS);
 /* pic_rmodreg(p,mport,SR6_TRCVRSIG_ADDR,&mbval,SR6_NUM_PRG_BITS);  */
 /* printf("Return Val = %x\n",mbval);                               */
 
 /* Set Global Sonet Cfg Bits */ 
  pic_wmodreg(p,mport,SR6_CFGREG_ADR,sr6_cfgbits,SR6_NUM_PRG_BITS);
  pic_wmodreg(p,1,SR6_HOSTMEM_ADR|(mport * SR6_HMPORT_OFFSET)|(SR6_CFGREG_ADR>>16),sr6_cfgbits,SR6_NUM_PRG_BITS); /* Record Cfg Port */

 
 /* Sonet Config Bits */
  sr6_cfgbits = 0;

 /* Turn On FEC Processing                    */
  if (findflag("G709FEC",p->config) >= 0)
    sr6_cfgbits = sr6_cfgbits | SR6_S_FEC_ENABLE; 
 
 /* Turn Off Scrambling/ Descrambling         */
  if (findflag("SCRAMOFF",p->config) >= 0)
    sr6_cfgbits = sr6_cfgbits | SR6_S_DISABLE_SCRAMBLING;

 /* Turn Off Scrambling/ Descrambling         */
  if (findflag("FRAMINGOFF",p->config) >= 0)
    sr6_cfgbits = sr6_cfgbits | SR6_S_DISABLE_FRAMING | SR6_S_DISABLE_SCRAMBLING; 
   
 /* Setup Type Of Signal To Acquire/Playback  */   
  if (findflag("OC192",p->config) >= 0)      /* Check For OC192 Data In Open String       */         
    sr6_cfgbits = sr6_cfgbits | SR6_S_OC192ENABLE; 
  else if (findflag("OC12",p->config) >= 0)  /* Check For OC12 Data In Open String        */
    sr6_cfgbits = sr6_cfgbits | SR6_S_OC12ENABLE;
  else if (findflag("OC24",p->config) >= 0)  /* Check For OC24 Data In Open String        */
    sr6_cfgbits = sr6_cfgbits | SR6_S_OC24ENABLE;
  else if (findflag("OC48",p->config) >= 0)  /* Check For OC48 Data In Open String        */
    sr6_cfgbits = sr6_cfgbits | SR6_S_OC48ENABLE;
  else
    sr6_cfgbits = sr6_cfgbits | SR6_S_OC3ENABLE;
      
              
 /* Check For OC3 Remove From OCx            */
  if ((findflag("OC3FROMOCX",p->config) >= 0) || (findflag("OC3NUM",p->config) >= 0))
    { 
     /* Enable Demux Operation              */
      sr6_cfgbits = sr6_cfgbits | SR6_S_DEMUXENABLE;  

     /* Error Check OC3 Removal Operation   */
      if (((sr6_cfgbits & SR6_S_OC3ENABLE) != 0))
        {
          printf("\n Error-OC12 or OC48 or OC192 Must Be Enabled For OC3 Removal\n");             
          return(-1); 
        }

      i=findintflag("OC3NUM",p->config); 
         
      if (i < 0) /* Did Not Find Flag, Assume Zero */
        {  
          printf("\n Warning-OC3 Number For Removal Not Specified-Assuming OC3NUM=0\n");
          i = 0; 
        }
      if ((i >= 4) && ((sr6_cfgbits & SR6_S_OC12ENABLE) != 0))
        {
          printf("\n Error-OC3 Number For Removal Out Of Range For OC12 Input; Valid Values 0 to 3\n");
          return(-1); 
        }
      if ((i >= 8) && ((sr6_cfgbits & SR6_S_OC24ENABLE) != 0))
        {
          printf("\n Error-OC3 Number For Removal Out Of Range For OC24 Input; Valid Values 0 to 7\n");
          return(-1); 
        }
      if ((i >= 16) && ((sr6_cfgbits & SR6_S_OC48ENABLE) != 0))
        {
          printf("\n Error-OC3 Number For Removal Out Of Range For OC48 Input; Valid Values 0 to 15\n");
          return(-1); 
        }

      if ((i >= 64) && ((sr6_cfgbits & SR6_S_OC192ENABLE) != 0))
        {
          printf("\n Error-OC3 Number For Removal Out Of Range For OC192 Input; Valid Values 0 to 63\n");
          return(-1); 
        }
        
      sr6_cfgbits = sr6_cfgbits | SR6_S_OC3FROMOCX_ENABLE;
      sr6_cfgbits = sr6_cfgbits | ((i << 19) & 0x001f80000); 

      if ((sr6_cfgbits & SR6_S_OC192ENABLE) != 0)
        rate = rate / 64;
      else if ((sr6_cfgbits & SR6_S_OC48ENABLE) != 0) 
        rate = rate / 16;
      else if ((sr6_cfgbits & SR6_S_OC24ENABLE) != 0) 
        rate = rate / 8;
      else if ((sr6_cfgbits & SR6_S_OC12ENABLE) != 0) 
        rate = rate / 4;     
    } 
 
 /* Check For OC12 Remove From OCx            */
  if ((findflag("OC12FROMOCX",p->config) >= 0) || (findflag("OC12NUM",p->config) >= 0))
    { 
     /* Error Check For More Than 1 Demux Op   */
      if ((sr6_cfgbits & SR6_S_DEMUXENABLE) != 0)
        {
          printf("\n Error-Only 1 Demux Operation Allowed\n");             
          return(-1);  
        }        
      else
        sr6_cfgbits = sr6_cfgbits | SR6_S_DEMUXENABLE;          

      i=findintflag("OC12NUM",p->config);
          
      if (i < 0) /* Did Not Find Flag, Assume Zero */
        { 
          printf("\n Warning-OC12 Number For Removal Not Specified-Assuming OC12NUM=0\n");
          i = 0; 
        }

      if ((i >= 2) && ((sr6_cfgbits & SR6_S_OC24ENABLE) != 0))
        {
           printf("\n Error-OC12 Number For Removal Out Of Range For OC24 Input; Valid Values 0 to 1\n");
           return(-1); 
        }

      if ((i >= 4) && ((sr6_cfgbits & SR6_S_OC48ENABLE) != 0))
        {
          printf("\n Error-OC12 Number For Removal Out Of Range For OC48 Input; Valid Values 0 to 3\n");
          return(-1); 
        }
         
      if ((i >= 16) && ((sr6_cfgbits & SR6_S_OC192ENABLE) != 0))
        {
          printf("\n Error-OC12 Number For Removal Out Of Range For OC192 Input; Valid Values 0 to 15\n");
          return(-1); 
        }  

      sr6_cfgbits = sr6_cfgbits | SR6_S_OC12FROMOCX_ENABLE;
      sr6_cfgbits = sr6_cfgbits | ((i << 19) & 0x001f80000);    

      if ((sr6_cfgbits & SR6_S_OC192ENABLE) != 0)
        rate = rate / 16;
      else if ((sr6_cfgbits & SR6_S_OC48ENABLE) != 0) 
        rate = rate / 4;
      else if ((sr6_cfgbits & SR6_S_OC24ENABLE) != 0) 
        rate = rate / 2;          
    } 
  
 /* Check For OC24 Remove From OC48            */
  if ((findflag("OC24FROMOCX",p->config) >= 0) || (findflag("OC24NUM",p->config) >= 0))
    {
      
     /* Error Check For More Than 1 Demux Op   */
      if ((sr6_cfgbits & SR6_S_DEMUXENABLE) != 0)
        {
          printf("\n Error-Only 1 Demux Operation Allowed\n");             
          return(-1);  
        }        
      else
        sr6_cfgbits = sr6_cfgbits | SR6_S_DEMUXENABLE; 

      i=findintflag("OC24NUM",p->config);
          
      if (i < 0) /* Flag Not Found Assume 0 */
        { 
          printf("\n Warning-OC24 Number For Removal Not Specified-Assuming OC24NUM=0\n");
          i = 0;
        }
      if (i >= 2)
        { 
          printf("\n Error-OC24 Number For Removal Out Of Range For OC48 Input; Valid Values 0 to 1\n");
          return(-1); 
        }            

      if ((i >= 8) && ((sr6_cfgbits & SR6_S_OC192ENABLE) != 0))
         {
           printf("\n Error-OC24 Number For Removal Out Of Range For OC192 Input; Valid Values 0 to 7\n");
           return(-1); 
         }   
      sr6_cfgbits = sr6_cfgbits | SR6_S_OC24FROMOCX_ENABLE;
      sr6_cfgbits = sr6_cfgbits | ((i << 19) & 0x001f80000);            

      if ((sr6_cfgbits & SR6_S_OC192ENABLE) != 0)
        rate = rate / 8;
      else if ((sr6_cfgbits & SR6_S_OC48ENABLE) != 0) 
        rate = rate / 2;      
    } 

  if ((findflag("OC48FROMOCX",p->config) >= 0) || (findflag("OC48NUM",p->config) >= 0))
    {    
     /* Error Check For More Than 1 Demux Op   */
      if ((sr6_cfgbits & SR6_S_DEMUXENABLE) != 0) 
        {
          printf("\n Error-Only 1 Demux Operation Allowed\n");             
          return(-1);  
        }        
      else
        sr6_cfgbits = sr6_cfgbits | SR6_S_DEMUXENABLE; 

      i=findintflag("OC48NUM",p->config);
          
      if (i < 0) /* Flag Not Found Assume 0 */
        { 
          printf("\n Warning-OC48 Number For Removal Not Specified-Assuming OC48NUM=0\n");
          i = 0;
        }
      if (i >= 4)
        { 
          printf("\n Error-OC48 Number For Removal Out Of Range For OC48 Input; Valid Values 0 to 3\n");
          return(-1); 
        }            
 
      sr6_cfgbits = sr6_cfgbits | SR6_S_OC48FROMOCX_ENABLE;
      sr6_cfgbits = sr6_cfgbits | ((i << 19) & 0x001f80000);            
            
      if ((sr6_cfgbits & SR6_S_OC192ENABLE) != 0)
        rate = rate / 4;        
    }  

 pic_wmodreg(p,mport,SR6_SONETREG_ADR,sr6_cfgbits,SR6_NUM_PRG_BITS);                  

 /* Rate vs Number Of Ports Check */
  if (rate > MAX_ICEPORT_RATE)
    {
      pic_rmodreg(p,1,SR6_HOSTMEM_ADR|(altmport * SR6_HMPORT_OFFSET)|(SR6_ENDISREG_ADR>>16),&mbval,SR6_NUM_PRG_BITS); /* Read Enable Of Opposite Port */
      if ((mbval & SR6_ENABLE_BIT) != 0)
        {   
          printf("Err: Line Byte Rate of %d requires use of both ICE LVDS Ports\n",rate);
          printf("Err: But, alternate port, Port %d, is already in use.\n",altmport);
          printf("Err: User needs to halt Alternate Port playback or acquisition.\n");
          return(-1);  
        }
    } 
  else
    {
      pic_rmodreg(p,1,SR6_HOSTMEM_ADR|(altmport * SR6_HMPORT_OFFSET)|(SR6_ENDISREG_ADR>>16),&mbval,SR6_NUM_PRG_BITS); /* Read Enable Of Opposite Port */
      if ((mbval & SR6_GLBENABLE_BIT) != 0)
        {   
          printf("Err: Alternate port, Port %d, line rate requires use of both ICE LVDS Ports\n",altmport);
          printf("Err: Therfore current port is already in use.\n");
          printf("Err: User needs to halt Alternate Port %d playback or acquisition before using this port %d.\n",altmport,mport);
          return(-1);  
        }
    }


 /* Crossbar Configuration Bits */
  sr6_cfgbits = SR6_CBSINGPORT_BIT; 
  if (rate > MAX_ICEPORT_RATE)
    sr6_cfgbits = SR6_CBDUALPORT_BIT;      
  pic_wmodreg(p,mport,SR6_CBCFGREG_ADR,sr6_cfgbits,SR6_NUM_PRG_BITS);   /* Cross Bar Cfg For Dual or Sing Port */    


 /* Set Reset Values For Enable */
  if (rate > MAX_ICEPORT_RATE)
    {
     /* Store Dual Port Reset */ 
      pic_wmodreg(p,1,SR6_HOSTMEM_ADR|(mport * SR6_HMPORT_OFFSET)|(SR6_RESETREG_ADR>>16),SR6_RESET_BIT|SR6_GLBRESET_BIT,SR6_NUM_PRG_BITS); 
      return(2);
    }
  else
    {
     /* Store Sing Port Reset */ 
      pic_wmodreg(p,1,SR6_HOSTMEM_ADR|(mport * SR6_HMPORT_OFFSET)|(SR6_RESETREG_ADR>>16),SR6_RESET_BIT,SR6_NUM_PRG_BITS);       
      return(0); 
    }
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
#define  SR7_NUM_PRG_BITS                32

/* Register Address Definitions */
#define SR7_RESETREG_ADR         0x00000000
#define SR7_ENDISREG_ADR         0x00010000
#define SR7_CFGREG_ADR           0x00020000
#define SR7_SONETREG_ADR         0x00030000
#define SR7_TRCVRREG_ADR         0x00040000
#define SR7_TCLKCFGREG_ADR       0x00050000
#define SR7_DCLKCFGREG_ADR       0x00060000
#define SR7_FPGAVER_ADDR         0x00070000  /* FPGA Version Number            */
#define SR7_SFPREG_ADR           0x00080000
#define SR7_TEMPSNSREG_ADR       0x000A0000
#define SR7_CBCFGREG_ADR         0x000B0000
#define SR7_CBRSTREG_ADR         0x000C0000
#define SR7_PHYRECFG_ADR         0x000D0000
#define SR7_TRCVRSIG_ADDR        0x000E0000  /* Transceiver Signals            */
#define SR7_HOSTMEM_ADR          0x000F0000 

#define SR7_G709CREG_ADR         0x00100000
#define SR7_G707CREG_ADR         0x00110000
#define SR7_J0BYTEREG_ADR        0x00120000
#define SR7_USRCODE_ADR          0x00130000
#define SR7_DLYSTRT_ADR          0x00140000
#define SR7_DGGREG_ADR           0x00150000
#define SR7_PHYRST_ADR           0x00160000

/* Reset Register, Register 0, Bit Definitions          */
#define SR7_RESET_BIT             0x00000001  /* Remove Reset Single Port       */       
#define SR7_GLBRESET_BIT          0x00000002  /* Remove Reset Dual   Port       */

/* Enable Register, Register 1, Bit Definitions         */
#define SR7_ENABLE_BIT            0x00000001  /* Enable Single Port Bit         */
#define SR7_GLBENABLE_BIT         0x00000002  /* Enable Dual   Port Bit         */

/* Config Register, Register 2, Bit Definitions         */
#define SR7_ACQUIRE_BIT           0x00000001  /* Enable Acquire Single Port Bit */
#define SR7_GLBACQUIRE_BIT        0x00000002  /* Enable Acquire Dual   Port Bit */
#define SR7_LVDSDBG_BIT           0x00000004  /* Enable Sing Port LVDS Rx Debug */
#define SR7_GLBLVDSDBG_BIT        0x00000008  /* Enable Dual Port LVDS Rx Debug */
#define SR7_ICEPORTLB_BIT         0x00000010  /* Loop Data From ICE O to ICE I  */ 
#define SR7_IGNOREHLDOFF_BIT      0x00080000  /* Ignore Hold Off From PIC       */   


/* Sonet Register, Register 3, Bit Definitions          */
#define SR7_S_MODRESET_REMOVE     0x00000001  /* Must Be Used For Module To Come Out Of Reset               */
#define SR7_S_CARDTYPE            0x00000002  /* Set Card Type To PIC5T When Ready                          */
#define SR7_S_FEC_ENABLE          0x00000004  /* Enable FEC Data Processing                                 */
#define SR7_S_DISABLE_SCRAMBLING  0x00000008  /* Turn Off Fiber Optic Descrambling (Rx) or Scrambling (Tx)  */
#define SR7_S_INPUT_ENABLE        0x00000010  /* Enable Module For Input                                    */
#define SR7_S_SLAVE_ENABLE        0x00000020  /* First Frame Of Slave Module Is Demux #0 Channel            */
#define SR7_S_DISABLE_FRAMING     0x00000040  /* Disable Search For Framing Bring In Data W/Unknown Framing */
#define SR7_S_DEMUXENABLE         0x00000080  /* Enable Realtime Demux Of Incoming Signal                   */
#define SR7_S_OC96ENABLE          0x00000100  /* Use If Line Rate 4976 <Hz                                  */
#define SR7_S_OC192ENABLE         0x00000200  /* Use If Line Rate 9958 MHz                                  */
#define SR7_S_OC3ENABLE           0x00000400  /* Use If Line Rate  155 MHz                                  */
#define SR7_S_OC12ENABLE          0x00000800  /* Use If Line Rate  622 MHz                                  */
#define SR7_S_OC24ENABLE          0x00001000  /* Use If Line Rate 1244 Mhz                                  */
#define SR7_S_OC48ENABLE          0x00002000  /* Use If Line Rate 2488 MHz                                  */
#define SR7_S_OC3FROMOCX_ENABLE   0x00004000  /* Pull Out OC3  Signal From OCx   Input                      */ 
#define SR7_S_OC12FROMOCX_ENABLE  0x00008000  /* Pull Out OC12 Signal From OCx   Input                      */
#define SR7_S_OC24FROMOCX_ENABLE  0x00010000  /* Pull Out OC24 Signal From OCx   Input                      */
#define SR7_S_OC48FROMOCX_ENABLE  0x00020000  /* Pull Out OC48 Signal From OC192 Input                      */
#define SR7_S_OC96FROMOCX_ENABLE  0x00040000  /* Pull Out OC96 Signal From OC192 Input                      */

/* Transceiver Config Register, Register 4 Bit Definitions */
#define SR7_GXBPDWN_BIT           0x00000001  /* Transceiver Power Down Bit   */
#define SR7_PLLPDWN_BIT           0x00000002  /* PLL Power Down Bit           */
#define SR7_TXDREST_BIT           0x00000004  /* Tx Digital Reset             */
#define SR7_RXAREST_BIT           0x00000008  /* Rx Analog  Reset             */ 
/* Transceiver Read Bits                                   */
#define SR7_TXPLLLK_BIT           0x00000001  /* Transceiver Tx PLL Locked    */
#define SR7_RXFRQLK_BIT           0x00000002  /* Rx Locked To Data            */              

/* Crossbar Config Register, Register B, Bit Definitions   */
#define SR7_CBSINGPORT_BIT        0x00000001  /* Single ICE Port Op-NO Mux      */
#define SR7_CBDUALPORT_BIT        0x00000002  /* Dual ICE Port Op-Byte Mux Op   */ 

/* Phy Reconfig Register, Register D, Bit Definitions      */
#define SR7_PRCREAD_BIT           0x00008000  /* Bit 17 Set For Read  Reg Op    */ /* 0x00020000 */
#define SR7_PRCWRITE_BIT          0x00004000  /* Bit 16 Set For Write Reg Op    */ /* 0x00010000 */


/* Host Memory, Register F, Bit Definitions                */
#define SR7_HMCLKVAL_OFFSET       0x00000000  /* Current AnyRate Freq           */
#define SR7_HMPORT_OFFSET         0x00000010  /* Offset For Each Port Config    */ 

/* J0 Byte Config Register, Register 18, Bit Definitions   */         
#define SR7_J0BYTEEN_BIT         0x00000001  /* Enable Replacement of J0 Byte  */ 

/* FPGA Download Versions */
#define FPGA_VHSRATE_DLD 0xC3C3C3C4
#define FPGA_HIRATE_DLD  0xC3C3C3C3
#define FPGA_LORATE_DLD  0xB4B4B4B4
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
int_4 sr7_picwmodreg (PICSTRUCT *p, int_4 mport, int_u4 maddr, int_u4 value, int_u4 num_bits)
{
  int_u4 mbval,rdadr,rddat;
  int_4 status = pic_wmodreg(p,mport,maddr,value,SR7_NUM_PRG_BITS);
  
  if (findflag("SNTCHKJTG",p->config) >= 0)
    { 
      udelay(500);
  
      pic_rmodreg(p,mport,0x00150000,&mbval,SR7_NUM_PRG_BITS);
      rdadr = mbval;
      pic_rmodreg(p,mport,0x00140000,&mbval,SR7_NUM_PRG_BITS);
      rddat = mbval;

      if ((rdadr != maddr) && (rddat != value))
        printf("BOTH      Incorect:Mprt = %d Rd Adr=%08x,Wr Adr=%08x and Rd Dat=%08x,Wr Dat=%08x\n",mport,rdadr,maddr,rddat,value); 
      else if (rdadr != maddr)
        {
          printf("Addr Only Incorrect Mprt = %d Rd Adr=%08x,Wr Adr=%08x\n",mport,rdadr,maddr);
          printf("\t Correct Data = %08x\n",rddat);      
        }
      else if (rddat != value)
        {
          printf("Data Only Incorrect Mprt = %d Rd Dat=%08x,Wr Dat=%08x\n",mport,rddat,value);
          printf("\t Correct Address = %08x\n",rdadr);
        }
      else
        printf("ALL CORRECT Adr = %08x Dat = %08x\n",rdadr,rddat);
       

    }
  return status;
}
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
int_4 sr7_synclk_cfg (PICSTRUCT *p, int_4 mport, int_u4 maddr, int_u4 value)
{   
   
   sr7_picwmodreg(p,mport,maddr,((value >> 8) & 0x000000FF),SR7_NUM_PRG_BITS);         /* Set Register Address To Write */
   udelay(500);

   sr7_picwmodreg(p,mport,maddr,(value & 0x000000FF) | 0x00004000,SR7_NUM_PRG_BITS);   /* Write Data To Register        */ 
   udelay(500);

   return(0);    
}
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/
int_4 pic_sonetr7_getkey(PICSTRUCT *p, int_4 mport,int_u4 addr)
  {
    int_u4 mbval = 0;
    int_u4 sfpdat[256];
    int_u4 rxpwrlvl;
    int_4 mtemp = 0;
    int ii;

    if ((addr == 1) || (addr == 2))  /* SFP Data */
      {
        sr7_picwmodreg(p,mport,SR7_SFPREG_ADR,0x00A300A3,SR7_NUM_PRG_BITS); /* "dumby Write Op, Followed by Read */
        udelay(10000);
 
        pic_rmodreg(p,mport,SR7_SFPREG_ADR+96,sfpdat+96,SR7_NUM_PRG_BITS);    /* Rx Pwr Level    */
        
        pic_rmodreg(p,mport,SR7_SFPREG_ADR+104,sfpdat+104,SR7_NUM_PRG_BITS);  /* Temp Upper Byte */
        
        pic_rmodreg(p,mport,SR7_SFPREG_ADR+105,sfpdat+105,SR7_NUM_PRG_BITS);  /* Temp Lower Byte */ 
        

      /*  for (ii=0;ii<256;ii++)
          {
            pic_rmodreg(p,mport,SR7_SFPREG_ADR+ii,sfpdat+ii,SR7_NUM_PRG_BITS);
            udelay(1000);
          }
       */
        
        rxpwrlvl = ((sfpdat[104]<<8)|sfpdat[105])/10;      /* Need to Divide by 10 For uWatts */    
      }
    else if (addr == 3)
      {
        sr7_picwmodreg(p,1,SR7_TEMPSNSREG_ADR,0x00000001,SR7_NUM_PRG_BITS);             /* Enable Clk    */   
         
        sr7_picwmodreg(p,1,SR7_TEMPSNSREG_ADR|0x00000001,0x00000001,SR7_NUM_PRG_BITS);  /* Assert Clr    */
        
        sr7_picwmodreg(p,1,SR7_TEMPSNSREG_ADR|0x00000001,0x00000000,SR7_NUM_PRG_BITS);  /* De-Assert Clr */
        
        ii    = 0; 
        mbval = 0;
        while (((mbval & 0x00000100) == 0) && (ii < 10))
          { 
            udelay(400); 
            pic_rmodreg(p,1,SR7_TEMPSNSREG_ADR,&mbval,SR7_NUM_PRG_BITS);  
            ii = ii + 1;            
          }
        
        pic_rmodreg(p,1,SR7_TEMPSNSREG_ADR,&mbval,SR7_NUM_PRG_BITS);                    /* Extra Rd      */

        /* printf("Altera Temp = %08x\n",mbval); */

        sr7_picwmodreg(p,1,SR7_TEMPSNSREG_ADR,0x00000000,SR7_NUM_PRG_BITS);             /* Disable Clk   */
        if ((mbval & 0x00000100) != 0)
          { 
            mbval = mbval & 0x000000FF;
            mtemp = ((int_4)mbval) - 128;
            /* printf("Mtemp = %d\n",mtemp); */
          }
        else
          {
            printf("Err: Module Temperature Retreival Unsuccessful-Setting Temp To -128 Degrees C\n");
            mtemp = -128;
          }
      }
    else if (addr == 4)
      {
        sr7_picwmodreg(p,mport,0x00090000,0,SR7_NUM_PRG_BITS); 
        udelay(4000); 
        pic_rmodreg(p,mport,0x00090000,&mbval,32);
        udelay(4000);
        sr7_picwmodreg(p,mport,0x00090000,0,SR7_NUM_PRG_BITS);
        udelay(4000); 
      }
    else 
      {              
        pic_rmodreg(p,mport,addr,&mbval,32);  
      }


    if (addr == 1)
      return (rxpwrlvl);    /* Return Pwr Level */   
    else if (addr == 2)
      return (sfpdat[96]);  /* Return Temp      */
    else if (addr == 3)
      return(mtemp);  
    else
      return ((int_4)mbval); 

  } 
/*--------------------------------------------------------------*/
int_4 pic_sonetr7_dump(PICSTRUCT *p, int_4 mport,int_4 flag)
  {
    int_u4 mbval;
    int ii;
 
   /* FPGA Version */   
    pic_rmodreg(p,1,SR7_FPGAVER_ADDR,&mbval,SR7_NUM_PRG_BITS);
    printf("\nFPGA Download Version = %x\n",mbval);
    if (mbval == FPGA_HIRATE_DLD)
      printf("High Speed Version Download\n");
    else if (mbval == FPGA_LORATE_DLD)
      printf("Low Speed Version Download\n"); 
    else if (mbval == FPGA_VHSRATE_DLD)
      printf("VHS Version Input Download\n");  
    else 
      printf("Download Version Unrecognized\n");

   /* Transceiver Info */
    for (ii=1;ii<3;ii++)
      {
        printf("\n*** Module Port = %d ***\n",ii);
	pic_rmodreg(p,ii,SR7_TRCVRSIG_ADDR,&mbval,SR7_NUM_PRG_BITS);
	printf("Transceiver PLL = ");
	if ((mbval & 0x00000001) == 0x00000001)
	   printf("LOCKED\n");
	else
	   printf("UNLOCKED\n");
	      
	printf("Receiver CDR Locked To ");
	if ((mbval & 0x00000020) != 0)
	   printf("LINE DATA\n");
	else
	   printf("REFERENCE\n");
	
       /* Get SFP Parameters */
        printf("\nSFP Temperature       = %d Degrees C\n",pic_sonetr7_getkey(p,ii,2));
        printf("SFP Rx Power Level    = %d uWatts\n",pic_sonetr7_getkey(p,ii,1));
        printf("Module Temperature    = %d Degrees C\n",pic_sonetr7_getkey(p,ii,3)); 
      }  

    return(0);
  }
/*--------------------------------------------------------------*/
int_4 pic_enable_sonetr7 (PICSTRUCT *p, int_4 mport,int_4 dis_enable)
{
  int_u4 mbval;
  
 /* ICE Card Can't Run Mux Mode From Port 2 */
  if (findflag("SNTALTPORT",p->config) >= 0)
    mport = 2;  

 /* This Puts Module Into Reset By Setting All Config Bits = 0 */                       
  if (dis_enable == 0)
    {
     /* Clear Enable Bit In Module Memory*/ 
      sr7_picwmodreg(p,1,SR7_HOSTMEM_ADR|(mport * SR7_HMPORT_OFFSET)|(SR7_ENDISREG_ADR>>16),0,SR7_NUM_PRG_BITS); /* Clr Mem Enable Bit */
      sr7_picwmodreg(p,mport,SR7_RESETREG_ADR,0,SR7_NUM_PRG_BITS);                                               /*  Port Reset     */ 
      sr7_picwmodreg(p,mport,SR7_CBRSTREG_ADR,0,SR7_NUM_PRG_BITS);                                               /* Cross Bar Reset */  
      udelay(100); 
    }
  else
    {           
      sr7_picwmodreg(p,1,SR7_HOSTMEM_ADR|(mport * SR7_HMPORT_OFFSET)|(SR7_ENDISREG_ADR>>16),1,SR7_NUM_PRG_BITS); /* Set Mem Enable Bit */
      pic_rmodreg(p,1,SR7_HOSTMEM_ADR|(mport * SR7_HMPORT_OFFSET)|(SR7_RESETREG_ADR>>16),&mbval,SR7_NUM_PRG_BITS); /* Read Reset Value   */
     /* printf("Port = %d Reset Val = %x\n",mport,mbval);  */
      sr7_picwmodreg(p,mport,SR7_CBRSTREG_ADR,1,SR7_NUM_PRG_BITS);                                               /* Remove CB Reset    */
      sr7_picwmodreg(p,mport,SR7_RESETREG_ADR,mbval,SR7_NUM_PRG_BITS);                                           /* Reove Port Reset   */   
      udelay(100); 
    }
  return 0;
}
/*--------------------------------------------------------------*/
int_4 write_reconfigphy_reg (PICSTRUCT *p, int_4 mport, int_u4 addr, int_u4 val)
{ 
  int ii;
  int_u4 mbval; 


 /* Write PHY Reconfig Value To Program Loopback For Acquire */
  for (ii=0;ii<10;ii++)
    {
      sr7_picwmodreg(p,mport,SR7_PHYRECFG_ADR|SR7_PRCREAD_BIT|0x0000000A,0,SR7_NUM_PRG_BITS);  /* Write Read Command */
      pic_rmodreg(p,mport,SR7_PHYRECFG_ADR,&mbval,SR7_NUM_PRG_BITS);        
      if ((mbval & 0x00000100) == 0)   /* &BILL */               /* Check Bit 8 For Busy */
        break;

      udelay(100);
    }  
  if (ii>=10)
    {
      printf("Err: Reconfig Controller Busy, Not Moving To Idle State\n");
      return(-1);
    }

  sr7_picwmodreg(p,mport,SR7_PHYRECFG_ADR|SR7_PRCWRITE_BIT|0x00000008,0,SR7_NUM_PRG_BITS);    /* Write Logical Chan Num */
  udelay(100);
  sr7_picwmodreg(p,mport,SR7_PHYRECFG_ADR|SR7_PRCWRITE_BIT|0x0000000B,addr,SR7_NUM_PRG_BITS); /* Write Address of Write */
  udelay(100);
  sr7_picwmodreg(p,mport,SR7_PHYRECFG_ADR|SR7_PRCWRITE_BIT|0x0000000C,val,SR7_NUM_PRG_BITS);  /* Write Value of Write   */
  udelay(100);
  sr7_picwmodreg(p,mport,SR7_PHYRECFG_ADR|SR7_PRCWRITE_BIT|0x0000000A,0x00000001,SR7_NUM_PRG_BITS); /* Set Wr Bit       */
  udelay(100);

  for (ii=0;ii<10;ii++)
    {
      sr7_picwmodreg(p,mport,SR7_PHYRECFG_ADR|SR7_PRCREAD_BIT|0x0000000A,0,SR7_NUM_PRG_BITS);     /* Write Read Command */
      pic_rmodreg(p,mport,SR7_PHYRECFG_ADR,&mbval,SR7_NUM_PRG_BITS);       
      if ((mbval & 0x00000100) == 0)  /* &BILL */               /* Check Bit 8 For Busy */
        break;

      udelay(100);
    }  
  if (ii>=10)
    {
      printf("Err: Reconfig Controller Busy, Not Completing Write Register Operation\n");
      return(-1);
    }

  return(0);
}
/*--------------------------------------------------------------*/
int_4 sr7_phypll_locked (PICSTRUCT *p, int_4 mport, int_u4 loopval)
{
  int ii;
  int_u4 mbval;
 
  for (ii=0;ii<loopval;ii++)
    { 
     /* Retrieve Tx PLL Locked Bit */                         
      pic_rmodreg(p,mport,SR7_TRCVRSIG_ADDR,&mbval,SR7_NUM_PRG_BITS); /* Check Tx Ready */
     
     /* Check Tx Phy Locked */  
      if ((mbval & SR7_TXPLLLK_BIT) != 0)            
        break;            
       
     /* printf("\t Port = %d PHY Val = %08x ",mport,mbval);       */
     /* printf("\t***Retry PLL Reset, Retry Num = %d***\n",ii+1); */
      sr7_picwmodreg(p,1,SR7_PHYRST_ADR,1,SR7_NUM_PRG_BITS);
      udelay(200000);

      /* Deassert Both PHYs  Reset */
      sr7_picwmodreg(p,1,SR7_PHYRST_ADR,0,SR7_NUM_PRG_BITS);
      udelay(200000); 
    }

  if (ii>=loopval)  /* Failed to Lock */
    {
      /* printf("Port = %d PHY Failed to Lock\n PHY Val = %08x \n",mport,mbval);  */            
      return(-1);
    }
  else
    { 
      /* printf("Phy %d Tx Rx Locked After %d Tries\n",mport,ii+1); */
      return(0);
    }   
}
/*--------------------------------------------------------------*/
#define MAX_ICE16x0PORT_RATE 1550000000    /* Max ICE 12x4 Port Rate */
#define MAX_ICE8x8PORT_RATE   700000000    /* Max ICE 8x8  Port Rate */
#define FEC192RATE       1338653164    /* FEC OC192 Byte Rate   */
#define OC192RATE        1244160000    /*     OC192 Byte Rate   */
#define FEC48RATE         333257143    /* FEC OC48  Byte Rate   */
#define OC48RATE          311040000    /*     OC48  Byte Rate   */
#define OC12RATE           77760000    /*     OC12  Byte Rate   */
#define OC3RATE            19440000    /*      OC3  Byte Rate   */

#define HIRATE_LOWCUT     125000000    /* Low Rate Cutoff For High Rate Download */
#define PREFX_FLAG       0x80000000    /* Set Flag For PREFX Use                 */

#define J0SCRUBEN        0x80000000    /* Enable Bit For J0 Scrub                */ 
#define OC192FRAMESZ         155520    /* Size of OC192 Frame In Bytes           */
#define OC192J0LOC              384    /* OC192 J0 Location                      */
#define OC48FRAMESZ           38880    /* Size of OC48  Frame In Bytes           */
#define OC48J0LOC                96    /* OC48  J0 Location                      */
#define OC12FRAMESZ            9720    /* Size of OC48  Frame In Bytes           */
#define OC12J0LOC                24    /* OC48  J0 Location                      */   
#define OC3FRAMESZ             2430    /* Size of OC48  Frame In Bytes           */
#define OC3J0LOC                  6    /* OC48  J0 Location                      */                  

int_4 pic_setup_sonetr7 (PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 gain) 
{
  Si5326_Reg_Obj Si5326_Reg; 
  int ii,jj;    
  int i;
  int_u4 sr7_cfgbits = 0;
  float anyclkrate   = 0.0;
  int_4 altmport     = 2;
  int_u4 arclkselreg = 0x00000055;              /* AnyRate Clock Input Source 2 On-Board Oscillator,Default  */
  int_u4 mbval;
  int_u4 dldversion  = FPGA_HIRATE_DLD;  
  int_u4 cmprate     = 0;
  int_u4 maxiportrate = MAX_ICE8x8PORT_RATE;
  int_u4 delay_start = 0;
  int_u4 lvdsdbgval = 0;
  int_u4 txplllockedbit[2];

 /* ICE Card Can't Run Mux Mode From Port 2 */
  if (findflag("SNTALTPORT",p->config) >= 0)
    mport = 2; 
         
 /* Set Alternate Port To Check Setup */
  if (mport == 2)
    altmport = 1;

 /* Find FPGA Download Version  */
  pic_rmodreg(p,1,SR7_FPGAVER_ADDR,&mbval,SR7_NUM_PRG_BITS);
  dldversion = mbval;     

 /* printf("Module Download Value = %08x\n",dldversion); */

 /* Set Up 16x0 Acq Mode        */
  if (dldversion == FPGA_VHSRATE_DLD)
    {
      dldversion   = FPGA_HIRATE_DLD;
      maxiportrate = MAX_ICE16x0PORT_RATE;   /* Increase Max Allowable ICE LVDS Rate to 1600 MBsec */
    }
  

 /* Set Default Line Rate       */
  anyclkrate = ((float) rate) / 4.0; 

 /* Turn Off J0 Byte Scrubbing  */
  sr7_picwmodreg(p,mport,SR7_J0BYTEREG_ADR,0,SR7_NUM_PRG_BITS);
  
 
 /* G709 Framer-TURN OFF        */
  sr7_picwmodreg(p,mport,SR7_G709CREG_ADR|0x0000008,3,SR7_NUM_PRG_BITS);  /* Framer Enable              */
  sr7_picwmodreg(p,mport,SR7_G709CREG_ADR|0x000000C,4,SR7_NUM_PRG_BITS);  /* 4 Good Frame               */
  sr7_picwmodreg(p,mport,SR7_G709CREG_ADR|0x0000010,4,SR7_NUM_PRG_BITS);  /* 4 Bad Frame                */
  sr7_picwmodreg(p,mport,SR7_G709CREG_ADR|0x0000014,32,SR7_NUM_PRG_BITS); /* 4 Frame Cnt Window         */
  sr7_picwmodreg(p,mport,SR7_G709CREG_ADR|0x0000108,3,SR7_NUM_PRG_BITS);  /* Descrambler                */ 
  sr7_picwmodreg(p,mport,SR7_G709CREG_ADR|0x0000208,3,SR7_NUM_PRG_BITS);  /* Decoder Enbl, Bypass, Fec  */
 /* G707 Framer-TURN OFF        */  
  sr7_picwmodreg(p,mport,SR7_G707CREG_ADR|0x0000008,3,SR7_NUM_PRG_BITS);  /* Framer Disable             */
  sr7_picwmodreg(p,mport,SR7_G707CREG_ADR|0x000000C,4,SR7_NUM_PRG_BITS);  /* 4 Good Frame               */
  sr7_picwmodreg(p,mport,SR7_G707CREG_ADR|0x0000010,4,SR7_NUM_PRG_BITS);  /* 4 Bad Frame                */
  sr7_picwmodreg(p,mport,SR7_G707CREG_ADR|0x0000014,32,SR7_NUM_PRG_BITS); /* 32 Frame Cnt Window        */
  sr7_picwmodreg(p,mport,SR7_G707CREG_ADR|0x0000108,3,SR7_NUM_PRG_BITS);  /* Descrambler                */
    
 /* Delay Start In 16x0 Module  */
  jj=findintflag("SNTDLYSTART",p->config);
  if (jj > 0)
    delay_start = jj * 200;      /* Internal Clock 200MHz Set Number of Micro Second Delay */
  sr7_picwmodreg(p,mport,SR7_DLYSTRT_ADR,delay_start,SR7_NUM_PRG_BITS);


 /* Check For Pre-Defined Rates */
  if ((findflag("OC192FULL",p->config) >= 0) || (findflag("OC192",p->config) >= 0))
    {
      rate = OC192RATE;  
      sr7_cfgbits = (((OC192FRAMESZ/8) - 2) << 16);  /* J0 & Frame Config Bits    */
     
     /* G709 Enable Code */ 
      if (findflag("G709FEC",p->config) >= 0)
        {
         /* G709 Enable      */
          if (findflag("FRAMINGOFF",p->config) < 0)   /*  */
            {
              sr7_picwmodreg(p,mport,SR7_G709CREG_ADR|0x0000008,1,SR7_NUM_PRG_BITS);  /* Framer Enable              */
              sr7_picwmodreg(p,mport,SR7_G709CREG_ADR|0x000000C,4,SR7_NUM_PRG_BITS);  /* 4 Good Frame               */
              sr7_picwmodreg(p,mport,SR7_G709CREG_ADR|0x0000010,4,SR7_NUM_PRG_BITS);  /* 4 Bad Frame                */
              sr7_picwmodreg(p,mport,SR7_G709CREG_ADR|0x0000014,32,SR7_NUM_PRG_BITS); /* 32 Frame Cnt Window        */

             /* G709 Descrambler */
              sr7_picwmodreg(p,mport,SR7_G709CREG_ADR|0x0000108,1,SR7_NUM_PRG_BITS);  /* Descrambler                */
    
             /* G709 Decoder     */
              sr7_picwmodreg(p,mport,SR7_G709CREG_ADR|0x0000208,1,SR7_NUM_PRG_BITS);  /* Decoder Enbl, Bypass, Fec  */     
            }
         /* Assign Rate      */
          rate = FEC192RATE;
        }

     
     /* G707 Enable */
      if (findflag("FRAMINGOFF",p->config) < 0)                                    /* G707 Framer                */
        { 
          sr7_picwmodreg(p,mport,SR7_G707CREG_ADR|0x0000008,1,SR7_NUM_PRG_BITS);      /* Framer Enable              */
          sr7_picwmodreg(p,mport,SR7_G707CREG_ADR|0x000000C,4,SR7_NUM_PRG_BITS);      /* 4 Good Frame               */
          sr7_picwmodreg(p,mport,SR7_G707CREG_ADR|0x0000010,4,SR7_NUM_PRG_BITS);      /* 4 Bad Frame                */
          sr7_picwmodreg(p,mport,SR7_G707CREG_ADR|0x0000014,32,SR7_NUM_PRG_BITS);     /* 32 Frame Cnt Window        */     
          if (findflag("SCRAMOFF",p->config) < 0)                                  /* G707 Descrambler           */
            sr7_picwmodreg(p,mport,SR7_G707CREG_ADR|0x0000108,1,SR7_NUM_PRG_BITS);   
          

          /* Set J0 Byte Value         */
           if (findflag("SNTJ0BYTE",p->config) >= 0)
             { 
               sr7_cfgbits = J0SCRUBEN | (((OC192FRAMESZ/8) - 2) << 16) | (((OC192J0LOC/8) - 1) << 8);

               i=findintflag("SNTJ0BYTE",p->config);
               if (i>=0)
                 sr7_cfgbits = sr7_cfgbits | (i & 0x000000FF);
               else
                 sr7_cfgbits = sr7_cfgbits | 0x000000CC;    /* 0xCC Default Value  */   
             }
        } 
      
     
      sr7_picwmodreg(p,mport,SR7_J0BYTEREG_ADR,sr7_cfgbits,SR7_NUM_PRG_BITS);  /* Set J0 Byte & Frame Size         */
      anyclkrate = ((float) rate) / 4.0;                                    /* Ref Clock Freq = LineRate div 32 */        
    } 


  if (findflag("OC48",p->config) >= 0)
    {
      rate = OC48RATE;    
      sr7_cfgbits = (((OC48FRAMESZ/8) - 2) << 16); /* J0 & Frame Config Bits    */
      
      if (findflag("G709FEC",p->config) >= 0)
        {
          rate = FEC48RATE;

          if (findflag("FRAMINGOFF",p->config) < 0)
            {
              printf("Err: OC48 with G.709 Encapsulation Can ONLY Be input or output with use of the FRAMINGOFF flag\n");
              printf("Err: Add the FRAMINGOFF flag to acquire G.709 OC48 Data\n");
              return(-1); 
            }   
        } 
      else
        {          
          if (findflag("FRAMINGOFF",p->config) < 0)
            {
             /* Set J0 Byte Value         */
              if (findflag("SNTJ0BYTE",p->config) >= 0)
                { 
                  sr7_cfgbits = J0SCRUBEN | (((OC48FRAMESZ/8) - 2) << 16) | (((OC48J0LOC/8) - 1) << 8);

                  i=findintflag("SNTJ0BYTE",p->config);
                  if (i>=0)
                    sr7_cfgbits = sr7_cfgbits | (i & 0x000000FF);
                  else
                    sr7_cfgbits = sr7_cfgbits | 0x000000CC;    /* 0xCC Default Value  */   
                }
            }
        }
       
     
      sr7_picwmodreg(p,mport,SR7_J0BYTEREG_ADR,sr7_cfgbits,SR7_NUM_PRG_BITS);  /* Set J0 Byte & Frame Size               */
      anyclkrate = ((float) rate) / 4.0;                                    /* Reference Clock Freq = LineRate div 32 */  
    }

  if (findflag("OC12",p->config) >= 0)
    {
      rate = OC12RATE;
      sr7_cfgbits = (((OC12FRAMESZ/2) - 2) << 16); /* J0 & Frame Config Bits    */

      if (findflag("FRAMINGOFF",p->config) < 0)
        {
         /* Set J0 Byte Value         */
          if (findflag("SNTJ0BYTE",p->config) >= 0)
            { 
              sr7_cfgbits = J0SCRUBEN | (((OC12FRAMESZ/2) - 2) << 16) | (((OC12J0LOC/2) - 1) << 8);

              i=findintflag("SNTJ0BYTE",p->config);
              if (i>=0)
                sr7_cfgbits = sr7_cfgbits | (i & 0x000000FF);
              else
                sr7_cfgbits = sr7_cfgbits | 0x000000CC;    /* 0xCC Default Value  */   
            }
        }

      sr7_picwmodreg(p,mport,SR7_J0BYTEREG_ADR,sr7_cfgbits,SR7_NUM_PRG_BITS);  
      anyclkrate =  ((float) rate) * 2.0;          /* Reference Clock Freq = LineRate div 16 */
    }  
  else if (findflag("OC3",p->config) >= 0)
    {
      rate = OC3RATE;
      sr7_cfgbits = (((OC3FRAMESZ/2) - 2) << 16); /* J0 & Frame Config Bits    */

      if (findflag("FRAMINGOFF",p->config) < 0)
        {
         /* Set J0 Byte Value         */
          if (findflag("SNTJ0BYTE",p->config) >= 0)
            { 
              sr7_cfgbits = J0SCRUBEN | (((OC3FRAMESZ/2) - 2) << 16) | (((OC3J0LOC/2) - 1) << 8);

              i=findintflag("SNTJ0BYTE",p->config);
              if (i>=0)
                sr7_cfgbits = sr7_cfgbits | (i & 0x000000FF);
              else
                sr7_cfgbits = sr7_cfgbits | 0x000000CC;    /* 0xCC Default Value  */   
            }
        }

      sr7_picwmodreg(p,mport,SR7_J0BYTEREG_ADR,sr7_cfgbits,SR7_NUM_PRG_BITS);  
      anyclkrate =  ((float) rate) * 2.0;          /* Reference Clock Freq = LineRate div 16 */
    }
  else if (dldversion == FPGA_LORATE_DLD)
    {
      anyclkrate =  ((float) rate) * 2.0;           /* Reference Clock Freq = LineRate div 16 */    
    }

 /* Rate Check Firmware Vs. Data Rate */ 
  if ((rate < HIRATE_LOWCUT) && (dldversion == FPGA_HIRATE_DLD))
    {
       printf("ERR: SonetR7: Wrong Firmware Download For Low Rate Signal-Signals < %d MBy/Sec \n",HIRATE_LOWCUT/1000000 );
       printf("ERR: Reset Card And Use Flag IOMFPGA=lr For Correct Download\n");
       return(-1); 
    }
     
 /* Rate Check Firmware Vs. Data Rate */ 
  if ((rate > HIRATE_LOWCUT) && (dldversion == FPGA_LORATE_DLD))
    {
       printf("ERR: SonetR7: Wrong Firmware Download For High Rate Signal-Signals > %d MBy/Sec \n",HIRATE_LOWCUT/1000000 );
       printf("ERR: Reset Card WITHOUT THe Use Of Flag IOMFPGA=lr For Correct Download\n");
       return(-1); 
    } 
       
 /* Stop Port */   
  sr7_picwmodreg(p,mport,SR7_RESETREG_ADR,0,SR7_NUM_PRG_BITS);   /*  Port Reset     */ 
  sr7_picwmodreg(p,mport,SR7_CBRSTREG_ADR,0,SR7_NUM_PRG_BITS);   /* Cross Bar Reset */  
  sr7_picwmodreg(p,1,SR7_HOSTMEM_ADR|(mport * SR7_HMPORT_OFFSET)|(SR7_ENDISREG_ADR>>16),0,SR7_NUM_PRG_BITS); /* Record Disble  of Port */
  sr7_picwmodreg(p,1,SR7_HOSTMEM_ADR|(mport * SR7_HMPORT_OFFSET)|(SR7_RESETREG_ADR>>16),0,SR7_NUM_PRG_BITS); /* Record Reset   of Port */

 
 /* Read Back Current AnyRate Frequency                       */ 
  pic_rmodreg(p,1,SR7_HOSTMEM_ADR|SR7_HMCLKVAL_OFFSET,&mbval,SR7_NUM_PRG_BITS); 
 /* printf("Rate in Mem = %d\n",mbval);  */
 
 /* Set Freq Compare Value Add PREFX Flag To Rate If Needed   */
  cmprate = rate;
  if (findflag("PREFX",p->config) >= 0)
    cmprate = cmprate | PREFX_FLAG;
  
 /* AnyRate Clock Configuration */    
  if (mbval != cmprate)
    { 
      pic_rmodreg(p,1,SR7_HOSTMEM_ADR|(altmport * SR7_HMPORT_OFFSET)|(SR7_ENDISREG_ADR>>16),&mbval,SR7_NUM_PRG_BITS);
      if (mbval != 0)
        {
          printf("Err: Alternate Port, Port = %d, Active and running at different line rate. \n",altmport);
          printf("Err: Both ports must be operated at the same line rate and with the same clock reference\n");
          printf("Err: End the use of the other port, or change the line rate for the current port.\n");
          return(-1); 
        }   





        
         /* Reset AnyRate Part & BOTH PHYs            */ 
          sr7_picwmodreg(p,1,SR7_PHYRST_ADR,3,SR7_NUM_PRG_BITS);
          udelay(200000);
         /* Deassert AnyRate Reset, Keep PHYs In Reset*/
          sr7_picwmodreg(p,1,SR7_PHYRST_ADR,1,SR7_NUM_PRG_BITS);  

          Si5326_Reg.debuglevel = -1;
          Si5326_Reg.fref   =  10000000.0;
          Si5326_Reg.dclk1  = anyclkrate;
          Si5326_Reg.dclk2  = anyclkrate;
          Si5326_Reg.dwght1 = 1.0;
          Si5326_Reg.dwght2 = 1.0;   
          ii = si5326_regcfg_init(&Si5326_Reg,SI5326_REGCFG_MT_SNTXDR6);
          ii = si5326_regcfg_bwsel(&Si5326_Reg,7);       
          ii = si5326_regcfg_clkin(&Si5326_Reg,SI5326_REGCFG_CLKIN_2);             
          ii = si5326_regcfg_dividers(&Si5326_Reg);
          if ((ii != 0) && (findflag("SNTWARNOFF",p->config) < 0))
            printf("WARN: SNTXDR7 reference freq of %d Hz not possible. Using %f Hz\n",(int_u4)anyclkrate,Si5326_Reg.fclk2);
          si5326_regcfg_debug(&Si5326_Reg);
          if (findflag("PREFX",p->config) >= 0)
            arclkselreg = 0x00000015;            /* Clock Input Source 1 Ext Reference */                     
          for(ii=0; ii<Si5326_Reg.numreg; ii++) 
            {    
              if ((Si5326_Reg.regval[ii] & 0x0000FF00) == 0x00000300)                   
                Si5326_Reg.regval[ii] = (Si5326_Reg.regval[ii] & 0xFFFFFF00) | arclkselreg;  /* Set AnyRate Reference Clock Source */       
 
              sr7_synclk_cfg (p,1,SR7_TCLKCFGREG_ADR,Si5326_Reg.regval[ii]);           
              udelay(1000);
            }

          sr7_picwmodreg(p,1,SR7_HOSTMEM_ADR|SR7_HMCLKVAL_OFFSET,cmprate,SR7_NUM_PRG_BITS);   /* Store AnyRate Clock Frequency */

          udelay(40000);  /* Allow AnyRate To Calibrate */
          udelay(40000);  /* Allow AnyRate To Calibrate */
          udelay(40000);  /* Allow AnyRate To Calibrate */
          udelay(40000);  /* Allow AnyRate To Calibrate */
          udelay(40000);  /* Allow AnyRate To Calibrate */

         /* Deassert BOTH PHYs  Reset                   */
          sr7_picwmodreg(p,1,SR7_PHYRST_ADR,0,SR7_NUM_PRG_BITS); 

         /* Retrieve PLL Locked Bit                     */
         /* Read PLL 0 Lock                             */
          if (sr7_phypll_locked(p,1,10) < 0)
            {
               if (findflag("PREFX",p->config) >= 0)
                 {
                   printf("Err: Using External 10MHz Reference and PLLs are NOT Locking to External Reference\n");
                   printf("Err: Check That 10MHz External Reference is Connected\n");  
                   return(-1); 
                 }

               printf("Err: MPORT = 1: TX PLL NOT LOCKED To Reference !!!\n");              
               return(-1);
            }
         /* Read PLL 1 Lock                            */
          if (sr7_phypll_locked(p,2,10) < 0)            
            {
              if (findflag("PREFX",p->config) >= 0)
                 {
                   printf("Err: Using External 10MHz Reference and PLLs are NOT Locking to External Reference\n");
                   printf("Err: Check That 10MHz External Reference is Connected\n");  
                   return(-1); 
                 }

              printf("MPORT = 2: TX PLL NOT LOCKED To Reference !!!\n");              
              return(-1);
            }  

        
            
    }
  


 /* Sonet Config Bits */
  sr7_cfgbits = 0;

 /* Signal Configuration Bits */
  if (dir <= 0)
    {
           
   
      if (findflag("SNTDBGSEL",p->config) >= 0)
        {
          ii = findintflag("SNTDBGSEL",p->config);
          if (ii < 0)
            ii = 0; 
          
          sr7_picwmodreg(p,mport,SR7_DGGREG_ADR,ii,SR7_NUM_PRG_BITS);       
                 
        } 
      else
        sr7_picwmodreg(p,mport,SR7_DGGREG_ADR,0,SR7_NUM_PRG_BITS); 

      if (findflag("SR7IGNOREHO",p->config) >= 0)
        sr7_cfgbits = sr7_cfgbits | SR7_IGNOREHLDOFF_BIT;     
      
      sr7_cfgbits = sr7_cfgbits | SR7_ACQUIRE_BIT;
      if (rate > maxiportrate)
        sr7_cfgbits = sr7_cfgbits | SR7_GLBACQUIRE_BIT;  /* Set Dual Port Acquire For High Data Rates */
      else
        {
          if (findflag("ICELOOPBK",p->config) >= 0)
            sr7_cfgbits = sr7_cfgbits | SR7_ICEPORTLB_BIT;
        }


       if (findflag("LVDSDBG",p->config) >= 0)
        {
          ii = findintflag("LVDSDBG",p->config);
          if (ii > 0)
            lvdsdbgval = ii - 1; 
                                    
          sr7_cfgbits = sr7_cfgbits | SR7_LVDSDBG_BIT | ((lvdsdbgval << 6) & 0x00003FC0);

          if (findflag("SNTDBGDECIM",p->config) >= 0)
             {
               lvdsdbgval = 15;  /* Take All Data */
               ii = findintflag("SNTDBGDECIM",p->config);
               if (ii > 0)
                  lvdsdbgval = ii - 1; 
                   
               sr7_cfgbits = sr7_cfgbits | 0x00004000 | ((lvdsdbgval << 15) & 0x00078000);
             } 
                      
           if (findflag("SNTDBGFCOFF",p->config) >= 0)
             sr7_cfgbits = sr7_cfgbits | 0x00080000;  

          if (rate > maxiportrate)
           sr7_cfgbits = sr7_cfgbits | SR7_GLBLVDSDBG_BIT;
        }  
                            
      /* Set Rx Gain Value  */         
       i=findintflagdef("SNTRXGAIN",p->config,gain);
       if (i == 0) ;
         
       else if (i==1) ;
         
       else if (i==2) ; 
         
       else if (i==3) ; 
         
       else if (i==4) ; 
         
       else 
         { 
           printf("Err: SONETR7 Gain = %d. Valid Range 0 <= value <= 4\n",i);
           return(-1);
         }   
    } 
          
  if (dir <=0)   
    ii = write_reconfigphy_reg (p,mport,0x00000021,1);      /* Turn On  Loopback */    
  else     
    ii = write_reconfigphy_reg (p,mport,0x00000021,0);      /* Turn Off Loopback */     
  
  if (ii < 0) 
    return(-1);                          
 
 /* Set Global Sonet Cfg Bits */ 
  sr7_picwmodreg(p,mport,SR7_CFGREG_ADR,sr7_cfgbits,SR7_NUM_PRG_BITS);
  sr7_picwmodreg(p,1,SR7_HOSTMEM_ADR|(mport * SR7_HMPORT_OFFSET)|(SR7_CFGREG_ADR>>16),sr7_cfgbits,SR7_NUM_PRG_BITS); /* Record Cfg Port */
  
    
 /* Sonet Config Bits */
  sr7_cfgbits = 0;

 /* Turn On FEC Processing                    */
  if (findflag("G709FEC",p->config) >= 0)
    sr7_cfgbits = sr7_cfgbits | SR7_S_FEC_ENABLE; 
 
 /* Turn Off Scrambling/ Descrambling         */
  if (findflag("SCRAMOFF",p->config) >= 0)
    sr7_cfgbits = sr7_cfgbits | SR7_S_DISABLE_SCRAMBLING;

 /* Turn Off Scrambling/ Descrambling         */
  if (findflag("FRAMINGOFF",p->config) >= 0)
    sr7_cfgbits = sr7_cfgbits | SR7_S_DISABLE_FRAMING | SR7_S_DISABLE_SCRAMBLING; 
   
 /* Setup Type Of Signal To Acquire/Playback  */   
  if (findflag("OC192",p->config) >= 0)      /* Check For OC192 Data In Open String       */         
    sr7_cfgbits = sr7_cfgbits | SR7_S_OC192ENABLE; 
  else if (findflag("OC12",p->config) >= 0)  /* Check For OC12 Data In Open String        */
    sr7_cfgbits = sr7_cfgbits | SR7_S_OC12ENABLE;
  else if (findflag("OC24",p->config) >= 0)  /* Check For OC24 Data In Open String        */
    sr7_cfgbits = sr7_cfgbits | SR7_S_OC24ENABLE;
  else if (findflag("OC48",p->config) >= 0)  /* Check For OC48 Data In Open String        */
    sr7_cfgbits = sr7_cfgbits | SR7_S_OC48ENABLE;
  else if (findflag("OC3",p->config) >= 0)   /* Check For OC3  Data In Open String        */
    sr7_cfgbits = sr7_cfgbits | SR7_S_OC3ENABLE;
  else
    sr7_cfgbits = sr7_cfgbits | SR7_S_OC12ENABLE | SR7_S_DISABLE_FRAMING | SR7_S_DISABLE_SCRAMBLING;
      
              
 /* Check For OC3 Remove From OCx            */
  if ((findflag("OC3FROMOCX",p->config) >= 0) || (findflag("OC3NUM",p->config) >= 0))
    { 
     /* Enable Demux Operation              */
      sr7_cfgbits = sr7_cfgbits | SR7_S_DEMUXENABLE;  

     /* Error Check OC3 Removal Operation   */
      if (((sr7_cfgbits & SR7_S_OC3ENABLE) != 0))
        {
          printf("\n Error-OC12 or OC48 or OC192 Must Be Enabled For OC3 Removal\n");             
          return(-1); 
        }

      i=findintflag("OC3NUM",p->config); 
         
      if (i < 0) /* Did Not Find Flag, Assume Zero */
        {  
          printf("\n Warning-OC3 Number For Removal Not Specified-Assuming OC3NUM=0\n");
          i = 0; 
        }
      if ((i >= 4) && ((sr7_cfgbits & SR7_S_OC12ENABLE) != 0))
        {
          printf("\n Error-OC3 Number For Removal Out Of Range For OC12 Input; Valid Values 0 to 3\n");
          return(-1); 
        }
      if ((i >= 8) && ((sr7_cfgbits & SR7_S_OC24ENABLE) != 0))
        {
          printf("\n Error-OC3 Number For Removal Out Of Range For OC24 Input; Valid Values 0 to 7\n");
          return(-1); 
        }
      if ((i >= 16) && ((sr7_cfgbits & SR7_S_OC48ENABLE) != 0))
        {
          printf("\n Error-OC3 Number For Removal Out Of Range For OC48 Input; Valid Values 0 to 15\n");
          return(-1); 
        }

      if ((i >= 64) && ((sr7_cfgbits & SR7_S_OC192ENABLE) != 0))
        {
          printf("\n Error-OC3 Number For Removal Out Of Range For OC192 Input; Valid Values 0 to 63\n");
          return(-1); 
        }
        
      sr7_cfgbits = sr7_cfgbits | SR7_S_OC3FROMOCX_ENABLE;
      sr7_cfgbits = sr7_cfgbits | ((i << 19) & 0x001f80000); 

      if ((sr7_cfgbits & SR7_S_OC192ENABLE) != 0)
        rate = rate / 64;
      else if ((sr7_cfgbits & SR7_S_OC48ENABLE) != 0) 
        rate = rate / 16;
      else if ((sr7_cfgbits & SR7_S_OC24ENABLE) != 0) 
        rate = rate / 8;
      else if ((sr7_cfgbits & SR7_S_OC12ENABLE) != 0) 
        rate = rate / 4;     
    } 
 
 /* Check For OC12 Remove From OCx            */
  if ((findflag("OC12FROMOCX",p->config) >= 0) || (findflag("OC12NUM",p->config) >= 0))
    { 
     /* Error Check For More Than 1 Demux Op   */
      if ((sr7_cfgbits & SR7_S_DEMUXENABLE) != 0)
        {
          printf("\n Error-Only 1 Demux Operation Allowed\n");             
          return(-1);  
        }        
      else
        sr7_cfgbits = sr7_cfgbits | SR7_S_DEMUXENABLE;          

      i=findintflag("OC12NUM",p->config);
          
      if (i < 0) /* Did Not Find Flag, Assume Zero */
        { 
          printf("\n Warning-OC12 Number For Removal Not Specified-Assuming OC12NUM=0\n");
          i = 0; 
        }

      if ((i >= 2) && ((sr7_cfgbits & SR7_S_OC24ENABLE) != 0))
        {
           printf("\n Error-OC12 Number For Removal Out Of Range For OC24 Input; Valid Values 0 to 1\n");
           return(-1); 
        }

      if ((i >= 4) && ((sr7_cfgbits & SR7_S_OC48ENABLE) != 0))
        {
          printf("\n Error-OC12 Number For Removal Out Of Range For OC48 Input; Valid Values 0 to 3\n");
          return(-1); 
        }
         
      if ((i >= 16) && ((sr7_cfgbits & SR7_S_OC192ENABLE) != 0))
        {
          printf("\n Error-OC12 Number For Removal Out Of Range For OC192 Input; Valid Values 0 to 15\n");
          return(-1); 
        }  

      sr7_cfgbits = sr7_cfgbits | SR7_S_OC12FROMOCX_ENABLE;
      sr7_cfgbits = sr7_cfgbits | ((i << 19) & 0x001f80000);    

      if ((sr7_cfgbits & SR7_S_OC192ENABLE) != 0)
        rate = rate / 16;
      else if ((sr7_cfgbits & SR7_S_OC48ENABLE) != 0) 
        rate = rate / 4;
      else if ((sr7_cfgbits & SR7_S_OC24ENABLE) != 0) 
        rate = rate / 2;          
    } 
  
 /* Check For OC24 Remove From OC48            */
  if ((findflag("OC24FROMOCX",p->config) >= 0) || (findflag("OC24NUM",p->config) >= 0))
    {
      
     /* Error Check For More Than 1 Demux Op   */
      if ((sr7_cfgbits & SR7_S_DEMUXENABLE) != 0)
        {
          printf("\n Error-Only 1 Demux Operation Allowed\n");             
          return(-1);  
        }        
      else
        sr7_cfgbits = sr7_cfgbits | SR7_S_DEMUXENABLE; 

      i=findintflag("OC24NUM",p->config);
          
      if (i < 0) /* Flag Not Found Assume 0 */
        { 
          printf("\n Warning-OC24 Number For Removal Not Specified-Assuming OC24NUM=0\n");
          i = 0;
        }
      if (i >= 2)
        { 
          printf("\n Error-OC24 Number For Removal Out Of Range For OC48 Input; Valid Values 0 to 1\n");
          return(-1); 
        }            

      if ((i >= 8) && ((sr7_cfgbits & SR7_S_OC192ENABLE) != 0))
         {
           printf("\n Error-OC24 Number For Removal Out Of Range For OC192 Input; Valid Values 0 to 7\n");
           return(-1); 
         }   
      sr7_cfgbits = sr7_cfgbits | SR7_S_OC24FROMOCX_ENABLE;
      sr7_cfgbits = sr7_cfgbits | ((i << 19) & 0x001f80000);            

      if ((sr7_cfgbits & SR7_S_OC192ENABLE) != 0)
        rate = rate / 8;
      else if ((sr7_cfgbits & SR7_S_OC48ENABLE) != 0) 
        rate = rate / 2;      
    } 

  if ((findflag("OC48FROMOCX",p->config) >= 0) || (findflag("OC48NUM",p->config) >= 0))
    {    
     /* Error Check For More Than 1 Demux Op   */
      if ((sr7_cfgbits & SR7_S_DEMUXENABLE) != 0) 
        {
          printf("\n Error-Only 1 Demux Operation Allowed\n");             
          return(-1);  
        }        
      else
        sr7_cfgbits = sr7_cfgbits | SR7_S_DEMUXENABLE; 

      i=findintflag("OC48NUM",p->config);
          
      if (i < 0) /* Flag Not Found Assume 0 */
        { 
          printf("\n Warning-OC48 Number For Removal Not Specified-Assuming OC48NUM=0\n");
          i = 0;
        }
      if (i >= 4)
        { 
          printf("\n Error-OC48 Number For Removal Out Of Range For OC48 Input; Valid Values 0 to 3\n");
          return(-1); 
        }            
 
      sr7_cfgbits = sr7_cfgbits | SR7_S_OC48FROMOCX_ENABLE;
      sr7_cfgbits = sr7_cfgbits | ((i << 19) & 0x001f80000);            
            
      if ((sr7_cfgbits & SR7_S_OC192ENABLE) != 0)
        rate = rate / 4;        
    }  

 sr7_picwmodreg(p,mport,SR7_SONETREG_ADR,sr7_cfgbits,SR7_NUM_PRG_BITS);                  

 /* Rate vs Number Of Ports Check */
  if (rate > maxiportrate)
    {
      pic_rmodreg(p,1,SR7_HOSTMEM_ADR|(altmport * SR7_HMPORT_OFFSET)|(SR7_ENDISREG_ADR>>16),&mbval,SR7_NUM_PRG_BITS); /* Rd Enable Opposite Port */
      if ((mbval & SR7_ENABLE_BIT) != 0)
        {   
          printf("Err: Line Byte Rate of %d requires use of both ICE LVDS Ports\n",rate);
          printf("Err: But, alternate port, Port %d, is already in use.\n",altmport);
          printf("Err: User needs to halt Alternate Port playback or acquisition.\n");
          return(-1);  
        }
    } 
  else
    {
      pic_rmodreg(p,1,SR7_HOSTMEM_ADR|(altmport * SR7_HMPORT_OFFSET)|(SR7_ENDISREG_ADR>>16),&mbval,SR7_NUM_PRG_BITS); /* Rd Enable Opposite Port */
      if ((mbval & SR7_GLBENABLE_BIT) != 0)
        {   
          printf("Err: Alternate port, Port %d, line rate requires use of both ICE LVDS Ports\n",altmport);
          printf("Err: Therfore current port is already in use.\n");
          printf("Err: User needs to halt Alternate Port %d playback or acquisition before using this port %d.\n",altmport,mport);
          return(-1);  
        }
    }


 /* Crossbar Configuration Bits */
  sr7_cfgbits = SR7_CBSINGPORT_BIT; 
  if (rate > maxiportrate)
    sr7_cfgbits = SR7_CBDUALPORT_BIT;      
  sr7_picwmodreg(p,mport,SR7_CBCFGREG_ADR,sr7_cfgbits,SR7_NUM_PRG_BITS);   /* Cross Bar Cfg For Dual or Sing Port */    


 /* Set Reset Values For Enable */
  if (rate > maxiportrate)
    {
     /* Store Dual Port Reset */ 
      sr7_picwmodreg(p,1,SR7_HOSTMEM_ADR|(mport * SR7_HMPORT_OFFSET)|(SR7_RESETREG_ADR>>16),SR7_RESET_BIT|SR7_GLBRESET_BIT,SR7_NUM_PRG_BITS); 
      return(2);
    }
  else
    {
     /* Store Sing Port Reset */ 
      sr7_picwmodreg(p,1,SR7_HOSTMEM_ADR|(mport * SR7_HMPORT_OFFSET)|(SR7_RESETREG_ADR>>16),SR7_RESET_BIT,SR7_NUM_PRG_BITS);       
      return(0); 
    }
}
