/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/* NGC Fiber Module-Uses SonetR5 Board w/FPGA Code Replacement  */
/*--------------------------------------------------------------*/
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 pic_reset_ngcfiber (PICSTRUCT *p, int_4 mport)
{
  /* This Puts Module Into Reset By Setting All Config Bits = 0 */                       
   pic_wmodreg(p,mport,0,0,SR5_NUM_PRG_BITS); 
   return 0;
}
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 pic_setup_ngcfiber (PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 gain) 
{
   int_4 i; int_u4 sonet_cfg_bits = 0;


   /* This Puts Module Into Reset By Setting All Config Bits = 0 */                       
   pic_wmodreg(p,mport,0,sonet_cfg_bits,SR5_NUM_PRG_BITS); 
   udelay(100);
    
   /* To Configure the module for operation 'bit wise or' in configuration values                    */
   /* This Line Must Always Be Here, It Take the module out of reset mode and starts Data Acquistion */
   /* sonet_cfg_bits = sonet_cfg_bits | SR5_MODRESET_REMOVE;  */ 

   /* Set Up 100 MHz Reference                  */      
    if (findflag("TESTREFCLK",p->config) < 0)
      sonet_cfg_bits = sonet_cfg_bits | SR5_REFCLK_SEL0;   

   /* Turn Off Scrambling/ Descrambling         */
    if ((findflag("SCRAMOFF",p->config) >= 0) || ((gain & 0x0001) > 0))
       sonet_cfg_bits = sonet_cfg_bits | SR5_DISABLE_SCRAMBLING;

   /* Select PN7 Line Encoding/Decoding        */
    if ((findflag("PN7SEL",p->config) >= 0) || ((gain & 0x0002) > 0))
       sonet_cfg_bits = sonet_cfg_bits | SR5_DISABLE_FRAMING; 

   /* Bit De-Interleaving Select               */
    if ((findflag("BITDINT",p->config) >= 0) || ((gain & 0x0008) > 0))
      sonet_cfg_bits = sonet_cfg_bits | SR5_ENABLE_ERROR_DETECT; 

   /* Bit KICKSTART Enable                     */
    if ((findflag("KICKEN",p->config) >= 0) || ((gain & 0x0010) > 0))
      sonet_cfg_bits = sonet_cfg_bits | SR5_SLAVE_ENABLE; 

    if (rate == 50000000)        /*  400 MHz Serial */
      sonet_cfg_bits = sonet_cfg_bits | SR5_OC12_192ENABLE;
    else if (rate == 100000000)  /*  800 MHz Serial */
      sonet_cfg_bits = sonet_cfg_bits | SR5_OC24ENABLE;
    else if (rate == 200000000)  /* 1600 MHz Serial */ 
      sonet_cfg_bits = sonet_cfg_bits | SR5_OC48ENABLE;
    else
      {
        printf("ERROR-Only Rates Supported Are 50,100 & 200 MHz Byte Rates\n");
        printf("Data Rate Must Be Specified At Byte Rate of 50,100 or 200 MHz\n");
        return(-1);  
      }
      
    if ((findflag("SLAVEOVRIDE",p->config) >= 0) || ((gain & 0x0004) > 0))
      sonet_cfg_bits = sonet_cfg_bits | SR5_DEMUXENABLE;
   
   /* Set Module For Acquisition If Desired Else Playback     */
    if (dir <= 0)      
      sonet_cfg_bits = sonet_cfg_bits | SR5_INPUT_ENABLE;
   

   pic_wmodreg(p,mport,0,sonet_cfg_bits,SR5_NUM_PRG_BITS);  /* Download Bit Wise ORed Bits To Module  */

   udelay (1000);
   sonet_cfg_bits = sonet_cfg_bits | SR5_MODRESET_REMOVE;

   vprint("Setup NFXD port=%d cfgbits=%08x\n",mport,sonet_cfg_bits);
   pic_wmodreg(p,mport,0,sonet_cfg_bits,SR5_NUM_PRG_BITS);  /* Download Bit Wise ORed Bits To Module  */
   return 0;
}
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*--------------------------------------------------------------*/

#define FLZR_RAMADDR   0x00000000
#define FLZR_SBYADDR   0x40000000
#define FLZR_CFGADDR   0x80000000

#define FLZR_SIGCFGAREG  0x80000000
#define FLZR_RESETREG    0x88000000 
#define FLZR_TXCFGREG    0x90000000
#define FLZR_RXCFGREG    0x98000000

/*--------------------------------------------------------------*/
int_4 pic_enable_uflzxdr1 (PICSTRUCT *p, int_4 mport,int_4 dis_enable)
{  

  /* printf("Module = %d Enable = %d\n",mport,dis_enable);  */

  /* This Puts Module Into Reset By Setting All Config Bits = 0 */                       
   if (dis_enable == 0)
     pic_wmodreg(p,mport,0,FLZR_RESETREG,32);                       
   else
     pic_wmodreg(p,mport,0,FLZR_RESETREG|0x00000001,32);
       

   udelay(2000);            
   return 0; 

}

/*--------------------------------------------------------------*/
int_4 pic_setup_uflz(PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 gain) 
{
   int_4 ii,kk; 
   int_u4 channum;
   int_u4 flzr_sigcfg_bits = FLZR_SIGCFGAREG;
   int_u4 flzr_txcfg_bits  = FLZR_TXCFGREG;
   int_u4 flzr_rxcfg_bits  = FLZR_RXCFGREG;
   int jj;  
   int_u4 chanen;

    
         
   pic_wmodreg(p,mport,0,FLZR_RESETREG,32);                   /* Put Module In I/O Reset           */ 

   if (findflag("ENDCNV",p->config) >= 0)                 /* Endian Convert 32 Bit Data        */
     flzr_sigcfg_bits = flzr_sigcfg_bits | 0x00000002;

   if (findflag("DISINTLV",p->config) >= 0)               /* Disable Bit Interleaving          */
     flzr_sigcfg_bits = flzr_sigcfg_bits | 0x00000004;
  
   if (findflag("DISSTRMINTLV",p->config) >= 0)           /* Disable Stream Interleaving       */
     flzr_sigcfg_bits = flzr_sigcfg_bits | 0x00000008;

   if (findflag("SCRAMOFF",p->config) >= 0)               /* Turn Off Scrambling/ Descrambling */ 
     flzr_sigcfg_bits = flzr_sigcfg_bits | 0x00000010;

   if (findflag("PN7SCRAM",p->config) >= 0)
     flzr_sigcfg_bits = flzr_sigcfg_bits | 0x00000020;

   if (findflag("KICKEN",p->config) >= 0)
     flzr_sigcfg_bits = flzr_sigcfg_bits | 0x00000040;

   if (findflag("FLZRFGO",p->config) >= 0)                /* Force Go Without TX PLL Lock      */ 
     flzr_sigcfg_bits = flzr_sigcfg_bits | 0x00000080;
                 
   if (dir > 0)
     {
      /* Output Mode */ 
       
       flzr_txcfg_bits = flzr_txcfg_bits | 0x00000001;   /* Set To Only One Channel */
 
      /* Always ONLY One Channel-Code Not Needed */
      /*
       if ((ii=findintflag("CHANCFGVAL",p->config)) >= 0)
         chanen = ii;                           
       else if (gain > 0)
         chanen = gain;                  
       else 
         {
           printf("User Must Specify CHANCFGVAL=<value> flag or set <gain> parameter for Tx Operation!\n");
           return(-1);
         }
       
       flzr_txcfg_bits = flzr_txcfg_bits | chanen;  
      */  

       if (findflag("FLZRTXTEST",p->config) >=0)
         flzr_txcfg_bits= flzr_txcfg_bits | 0x8000;
     }
   else
     {
      /* Input Mode */
       flzr_sigcfg_bits = flzr_sigcfg_bits | 0x00000001;    /* Enable Input */            

       if (findflag("MODDEBUG",p->config) >=0)              /* LVDS Ramp Output-Fiber Input Ignored */
         flzr_rxcfg_bits =  flzr_rxcfg_bits | 0x08000;  
       
       
       flzr_rxcfg_bits =  flzr_rxcfg_bits | 0x00000001;  /* Set To Only One Channel */ 

      /* Always ONLY One Channel-Code Not Needed */ 
      /* 
       if ((ii=findintflag("CHANCFGVAL",p->config)) >= 0)
         flzr_rxcfg_bits =  flzr_rxcfg_bits | ii;                           
       else if (gain > 0)
         flzr_rxcfg_bits = flzr_rxcfg_bits | gain;                  
       else 
         {
           printf("User Must Specify CHANCFGVAL=<value> flag or set <gain> parameter for Rx Operation!\n");
           return(-1);
         }   
      */

       if ((kk=findintflag("RXALIGNCH",p->config)) >= 0)
         {  
           channum =  (int_u4) kk; 
           ii = 0x0001 << channum;
           if ((ii & flzr_rxcfg_bits) == 0)
             {
               printf("Alignment Channel Number Not Specified As An Active Channel Using Variable gain or Flag CHANCFGVAL!\n");
               printf("Ignoring Alignment of Channels!\n");
             }
           else
             { 
               pic_wmodreg(p,mport,0,0xC0040002|((channum<<27) & 0x38000000),32);  /* Enable Channel Alignment Bit */ 
            
               if ((kk=findintflag("RXALIGNVAL",p->config)) >= 0)              /* Set Alignment Value          */
                 pic_wmodreg(p,mport,0,0xC0100000|((channum<<27) & 0x38000000)| (((int_u4) kk) & 0x0000FFFF),32);                    
             }
         }

             
     } 

   pic_wmodreg(p,mport,0,flzr_sigcfg_bits,32);
   udelay(2000);
   pic_wmodreg(p,mport,0,flzr_rxcfg_bits,32);
   udelay(2000);
   pic_wmodreg(p,mport,0,flzr_txcfg_bits,32);
   udelay(2000);
 /*  pic_wmodreg(p,mport,0,FLZR_RESETREG|0x00000001,32); */
 /*  udelay(2000);                                   */


  return(0);
}
/*--------------------------------------------------------------*/
int_4 pic_enable_flzrxdr1 (PICSTRUCT *p, int_4 mport,int_4 dis_enable)
{
  
   if (mport == 1)
     return(0);
   
  /* This Puts Module Into Reset By Setting All Config Bits = 0 */                       
   if (dis_enable == 0)
     pic_wmodreg(p,2,0,FLZR_RESETREG,32);                       
   else
     pic_wmodreg(p,2,0,FLZR_RESETREG|0x00000001,32);
       

   udelay(2000);            
   return 0; 

}
/*--------------------------------------------------------------*/
int_4 pic_setup_flzr(PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 gain) 
{
   int_4 ii,kk; 
   int_u4 channum;
   int_u4 flzr_sigcfg_bits = FLZR_SIGCFGAREG;
   int_u4 flzr_txcfg_bits  = FLZR_TXCFGREG;
   int_u4 flzr_rxcfg_bits  = FLZR_RXCFGREG;
   int jj;  
   int_u4 chanen;

   
   if (mport == 1)
     return(0);
        
   pic_wmodreg(p,2,0,FLZR_RESETREG,32);                   /* Put Module In I/O Reset           */ 

   if (findflag("ENDCNV",p->config) >= 0)                 /* Endian Convert 32 Bit Data        */
     flzr_sigcfg_bits = flzr_sigcfg_bits | 0x00000002;

   if (findflag("DISINTLV",p->config) >= 0)               /* Disable Bit Interleaving          */
     flzr_sigcfg_bits = flzr_sigcfg_bits | 0x00000004;
  
   if (findflag("DISSTRMINTLV",p->config) >= 0)           /* Disable Stream Interleaving       */
     flzr_sigcfg_bits = flzr_sigcfg_bits | 0x00000008;

   if (findflag("SCRAMOFF",p->config) >= 0)               /* Turn Off Scrambling/ Descrambling */ 
     flzr_sigcfg_bits = flzr_sigcfg_bits | 0x00000010;

   if (findflag("PN7SCRAM",p->config) >= 0)
     flzr_sigcfg_bits = flzr_sigcfg_bits | 0x00000020;

   if (findflag("KICKEN",p->config) >= 0)
     flzr_sigcfg_bits = flzr_sigcfg_bits | 0x00000040;

   if (findflag("FLZRFGO",p->config) >= 0)                /* Force Go Without TX PLL Lock      */ 
     flzr_sigcfg_bits = flzr_sigcfg_bits | 0x00000080;
   
   if (findflag("TXCFGVAL",p->config) >= 0) 
     {
       printf("Flag TXCFGVAL Is Being Depricated!!\n");
       printf("Future Software Will Not Support Its Use.\n");
       printf("Use Flag CHANCFGVAL To Avoid Receiving This Message--And For Future Compatibility \n");  
     } 
 
               
   if (dir > 0)
     {
      /* Output Mode */ 
       if ((ii=findintflag("TXCFGVAL",p->config)) >= 0)
         chanen = ii;
       else if ((ii=findintflag("CHANCFGVAL",p->config)) >= 0)
         chanen = ii;                           
       else if (gain > 0)
         chanen = gain;                  
       else 
         {
           printf("User Must Specify CHANCFGVAL=<value> flag or set <gain> parameter for Tx Operation!\n");
           return(-1);
         }

       flzr_txcfg_bits = flzr_txcfg_bits | chanen;  

       if (findflag("FLZRTXTEST",p->config) >=0)
         flzr_txcfg_bits= flzr_txcfg_bits | 0x8000;
     }
   else
     {
      /* Input Mode */
       flzr_sigcfg_bits = flzr_sigcfg_bits | 0x00000001;    /* Enable Input */            

       if (findflag("MODDEBUG",p->config) >=0)              /* LVDS Ramp Output-Fiber Input Ignored */
         flzr_rxcfg_bits =  flzr_rxcfg_bits | 0x08000;  
       
       if ((ii=findintflag("CHANCFGVAL",p->config)) >= 0)
         flzr_rxcfg_bits =  flzr_rxcfg_bits | ii;                           
       else if (gain > 0)
         flzr_rxcfg_bits = flzr_rxcfg_bits | gain;                  
       else 
         {
           printf("User Must Specify CHANCFGVAL=<value> flag or set <gain> parameter for Rx Operation!\n");
           return(-1);
         }   

       if ((kk=findintflag("RXALIGNCH",p->config)) >= 0)
         {  
           channum =  (int_u4) kk; 
           ii = 0x0001 << channum;
           if ((ii & flzr_rxcfg_bits) == 0)
             {
               printf("Alignment Channel Number Not Specified As An Active Channel Using Variable gain or Flag CHANCFGVAL!\n");
               printf("Ignoring Alignment of Channels!\n");
             }
           else
             { 
               pic_wmodreg(p,2,0,0xC0040002|((channum<<27) & 0x38000000),32);  /* Enable Channel Alignment Bit */ 
            
               if ((kk=findintflag("RXALIGNVAL",p->config)) >= 0)              /* Set Alignment Value          */
                 pic_wmodreg(p,2,0,0xC0100000|((channum<<27) & 0x38000000)| (((int_u4) kk) & 0x0000FFFF),32);                    
             }
         }

             
     } 

   pic_wmodreg(p,2,0,flzr_sigcfg_bits,32);
   udelay(2000);
   pic_wmodreg(p,2,0,flzr_rxcfg_bits,32);
   udelay(2000);
   pic_wmodreg(p,2,0,flzr_txcfg_bits,32);
   udelay(2000);
 /*  pic_wmodreg(p,2,0,FLZR_RESETREG|0x00000001,32); */
 /*  udelay(2000);                                   */


  return(0);
}
