#define D2A_NUM_PRG_BITS              32  /* Number Of Programming Bits                                  */ 
#define D2A_MODRESET_REMOVE   0x00000001  /* This one must be in config word to remove reset/allow start */ 
#define D2A_REF_FREQ          10000000    /* Programmable Clock Reference Frequency                      */
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 pic_reset_d2a (PICSTRUCT *p, int_4 mport)
{
   pic_wmodreg(p,mport,0,0,D2A_NUM_PRG_BITS);  /* Write Down Zeroes For Reset */
   return 0;
} 
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 pic_setup_d2a (PICSTRUCT *p, int_4 mport, int_4 dir,int_4 bits, int_4 rate, int_4 gain, int_4 flags) 
{   
   int_u4 d2a_cfg_bits = 0; 
    
   /* enable comparator clock circuit */
   d2a_cfg_bits  = calc_synthetic_clkbits(D2A_REF_FREQ,rate,0);
   d2a_cfg_bits |= D2A_MODRESET_REMOVE ; 
   
   vprint("Setup D2A clock port=%d rate=%d\n",mport,rate);
   pic_wmodreg(p,mport,0,d2a_cfg_bits,D2A_NUM_PRG_BITS);     
   return 0;    
}

#define D2AR9_NUM_PRG_BITS         32 
#define D2AR9_MAX_RATE     500000000
#define D2AR9_REF_OSC       20000000
#define D2AR9_CLKCFG_INDEX         0
#define D2AR9_PLLCFG_INDEX         1
#define D2AR9_SYSCFG_INDEX         2 
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 pic_enable_d2ar9 (PICSTRUCT *p, int_4 mport,int_4 dis_enable)
{
   pic_wmodreg(p,mport,D2AR9_SYSCFG_INDEX,0,D2AR9_NUM_PRG_BITS);       /* Set System Reg = 0, Module In Reset    */
   if (dis_enable != 0)
     pic_wmodreg(p,mport,D2AR9_SYSCFG_INDEX,0x01,D2AR9_NUM_PRG_BITS);  /* If Enabling Remove Reset               */
   return 0;    
} 
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 pic_setup_d2ar9 (PICSTRUCT *p, int_4 mport, int_4 dir,int_4 bits,int_4 rate, int_4 gain,int_4 flags) 
{   
   int i,ii; 
   int_u4 reffreq =  D2AR9_REF_OSC; 
   int clksrc = 3;  /* 0-Syn Clk From On-Board Crystal  */
                    /* 1-Syn Clk From Ext Ref           */
                    /* 2-Clk From On-Board LVDS Crystal */
                    /* 3-Clk From Ext Input--Default    */
   int_u4 pllcfgval[11] = {0x00000000,0x0000000C,0x00000163,0x00000501,0x00001404,
                           0x00005010,0x00004040,0x00000101,0x00000405,0x00000004,0x000021EC}; 
   
 
  /* Assert Reset To Module */
   pic_wmodreg(p,mport,D2AR9_SYSCFG_INDEX,0,D2AR9_NUM_PRG_BITS);  /* Turn On Reset Bit Control */
   pic_wmodreg(p,mport,D2AR9_CLKCFG_INDEX,0,D2AR9_NUM_PRG_BITS);


  if ((i=findflag("MUXCLK",p->config)) >= 0)
    {
      if (p->config[i+6]!='=') ;
      else if (p->config[i+7]=='P')  
        {
          clksrc = 0;
          if (findflag("PREFX",p->config) >= 0)
           {
              clksrc = 1;                            /* Set Clock Source To PLL With Ext Ref Frequency */

              ii = findintflag("PREFX",p->config);   
              if (ii <= 1)
                {
                  reffreq = 10000000;
                  if (rate > 250000000)
                    {
              printf("\nERROR: Using 10MHz Reference Maximum Rate Clock Rate is 250MHz\n");
              printf("OPTIONS: 1) Lower Clock Rate To Below 250MHz\n");
              printf("         2) Supply 20MHz Ref, Use Flag PREFX=20000000, Then Maximum Clock Rate = %dMHz\n\n",D2AR9_MAX_RATE/1000000);  
              return(-1);
                    }
                }    
              else
                reffreq = ii;                
           }            
        } 
      else if ((p->config[i+7]=='A') &&  (mport == 1));
      else if ((p->config[i+7]=='B') &&  (mport == 2));
      else if (p->config[i+7]=='N');
         
      else if (p->config[i+7]=='C') clksrc = 2; 
      else 
       {
         printf("Illegal MUXCLK=%c flag - ignored\n",p->config[i+7]);
         printf("Allowable Clock Choices: MUXCLK=");
         if (mport != 2)  
           printf("A,");
         if (mport != 1)
           printf("B,");
         printf("C,P,or P w/flag PREFX\n");
       } 
   }

 
   if (bits==16)                                                                       /* Enable 16 Bit Data Else 8 Bit    */
     clksrc = clksrc | 4;                                                              
   if (findflag("INVMSB",p->config) >= 0)                                                /* Turn Off MSB Inversion In Module */
     clksrc = clksrc | 8;
   if (findflag("MODDEBUG",p->config) >= 0)                                            /* Turn Off A/D Send Ramp            */
     clksrc = clksrc | 0x10;

   if ((clksrc & 0x03) < 2)                                                            /* Check PLL Needs To Be Programmed  */
     {    
       if (calc_enhancedpll_values(rate,reffreq,D2AR9_MAX_RATE,pllcfgval) < 0)
         return(-1);              

       pic_wmodreg(p,mport,D2AR9_CLKCFG_INDEX,(clksrc<<1)|0x01,D2AR9_NUM_PRG_BITS);  /* Remove PLL Programming Reset      */
    
       udelay(40000);
       for (ii=0;ii<11;ii++)
         {
           pic_wmodreg(p,mport,D2AR9_PLLCFG_INDEX,0,D2AR9_NUM_PRG_BITS);
           udelay(100);
           if (ii != 10)
             pllcfgval[ii] = pllcfgval[ii] | 0x802F0000;                             /* Set PLL Cfg Val Bit & Num Bits-1  */           
           else
             pllcfgval[ii] = pllcfgval[ii] | 0x803D0000;                             /* Set Val Bit, End Bit & Num Bits-1 */                                    
           pic_wmodreg(p,mport,D2AR9_PLLCFG_INDEX,pllcfgval[ii],D2AR9_NUM_PRG_BITS); /* Set PLL Program Bits              */

           udelay(100);  
      /*   printf("%s%d%s%0x\n","Index = ",ii," Value = ",pllcfgval[ii]); */
         }
       pic_wmodreg(p,mport,D2AR9_PLLCFG_INDEX,0,D2AR9_NUM_PRG_BITS);                 /* Clear Programming Word            */
       udelay(40000);                                                                /* Delay 40mS For PLL Lock           */       
     }
   else
     pic_wmodreg(p,mport,CLKCFG_INDEX,(clksrc<<1)&0xFFFFFFFE,D2AR9_NUM_PRG_BITS);    /* Keep PLL Program Reset Asserted */
    
   udelay(100);
  /* pic_wmodreg(p,mport,D2AR9_SYSCFG_INDEX,0x01,D2AR9_NUM_PRG_BITS); */       
    
   return 0;    
}  
