/****************************************************************************/
/*                                                                          */
/*   partlib_common.h: you need this if you plan on using objects and       */
/*                     methods in the partlib library                       */
/*                                                                          */
/****************************************************************************/
#ifndef _PART_COMMON_H
#define _PART_COMMON_H

/*---------------------------------------------------------------------------*/
/* Includes */                              
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <unistd.h>
#include <math.h>   
#include <fcntl.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>

#ifndef __STDFLOAT
#define __STDFLOAT
typedef float float32_t;
typedef double float64_t;
typedef long double float128_t;
#endif

/*---------------------------------------------------------------------------*/
/*      Master list of unique module identifiers     */
/*           !!!DO NOT EDIT THESE VALUES!!!          */
/* These must be kept in sync with the FGPA firmware */
/*                                                   */
#define FPGA_MODID_LB2DM3     0x01
#define FPGA_MODID_D2RF       0x02
#define FPGA_MODID_A2DM18     0x03
#define FPGA_MODID_D2AWGM3    0x04

/*---------------------------------------------------------------------------*/
/*      Master list of unique part identifiers       */
/*           !!!DO NOT EDIT THESE VALUES!!!          */
/* These must be kept in sync with the FGPA firmware */
/*                                                   */
#define FPGA_PTID_ROOT        0
#define FPGA_PTID_MODTYPE     1
#define FPGA_PTID_VMMK2103   10
#define FPGA_PTID_SKY13384   11
#define FPGA_PTID_PE43204    12
#define FPGA_PTID_LTC2362    13
#define FPGA_PTID_STV6111    14
#define FPGA_PTID_LTC2630    15
#define FPGA_PTID_ADS42B49   16
#define FPGA_PTID_TMP112     17
#define FPGA_PTID_LTC6957    18
#define FPGA_PTID_SI5338     19
#define FPGA_PTID_FXLH42245  20
#define FPGA_PTID_PE42423    21
#define FPGA_PTID_SKY13317   22
#define FPGA_PTID_AD9361     23
#define FPGA_PTID_PGEN       24
#define FPGA_PTID_HBDECFIR   25
#define FPGA_PTID_ADCLM      26
#define FPGA_PTID_AIS        27
#define FPGA_PTID_CMD        28
#define FPGA_PTID_DELAY      29
#define FPGA_PTID_MEM        30
#define FPGA_PTID_HBINTFIR   31
#define FPGA_PTID_PE4302     32
#define FPGA_PTID_ADC12D     33
#define FPGA_PTID_ADF4350    34
#define FPGA_PTID_PTFDFIR    35
#define FPGA_PTID_DCS        36
#define FPGA_PTID_STATIS     37
#define FPGA_PTID_JVM        38
#define FPGA_PTID_FIR        39
#define FPGA_PTID_MTGO       40
#define FPGA_PTID_MAX5868    41
#define FPGA_PTID_LMH6401    42
#define FPGA_PTID_RFFC5072   43
#define FPGA_PTID_PE43704    44
#define FPGA_PTID_LMX2582    45
#define FPGA_PTID_HBINTERP   46
#define FPGA_PTID_SI5344     47
#define FPGA_PTID_MCP3421    48
#define FPGA_PTID_MIC280     49
#define FPGA_PTID_NULLPART   0x01

/***************************/
/* BAD BAD BAD BAD BAD BAD */
/***************************/
#define BAD_ROOT_ID      FPGA_PTID_ROOT
#define BAD_MOD_ID       FPGA_PTID_MODTYPE
#define BAD_AD9361_ID    FPGA_PTID_AD9361
#define BAD_PE42423_ID   FPGA_PTID_PE42423
#define BAD_VMMK2103_ID  FPGA_PTID_VMMK2103
#define BAD_CMD_ID       FPGA_PTID_CMD
#define BAD_SI5338_ID    FPGA_PTID_SI5338
#define BAD_SKY13317_ID  FPGA_PTID_SKY13317
#define BAD_PE43204_ID   FPGA_PTID_PE43204 
#define BAD_HBINTFIR_ID  FPGA_PTID_HBINTFIR
#define BAD_AIS_ID       FPGA_PTID_AIS
#define BAD_DELAY_ID     FPGA_PTID_DELAY
#define BAD_ADC12D_ID    FPGA_PTID_ADC12D
#define BAD_ADF4350_ID   FPGA_PTID_ADF4350
#define BAD_PE4302_ID    FPGA_PTID_PE4302
#define BAD_ADCLM_ID     FPGA_PTID_ADCLM   
#define BAD_PTFDFIR_ID   FPGA_PTID_PTFDFIR 
#define BAD_FXLH42245_ID FPGA_PTID_FXLH42245
#define BAD_MTGO_ID      FPGA_PTID_MTGO
#define BAD_MAX5868_ID   FPGA_PTID_MAX5868 
#define BAD_LMH6401_ID   FPGA_PTID_LMH6401 
#define BAD_RFFC5072_ID  FPGA_PTID_RFFC5072
#define BAD_PE43704_ID   FPGA_PTID_PE43704 
#define BAD_LMX2582_ID   FPGA_PTID_LMX2582 
#define BAD_HBINTERP_ID  FPGA_PTID_HBINTERP
#define BAD_MEM_ID       FPGA_PTID_MEM
#define BAD_SI5344_ID    FPGA_PTID_SI5344
#define BAD_MCP3421_ID   FPGA_PTID_MCP3421
#define BAD_PGEN_ID      FPGA_PTID_PGEN
#define BAD_MIC280_ID    FPGA_PTID_MIC280

/***************************/
/* BAD BAD BAD BAD BAD BAD */
/***************************/

/*---------------------------------------------------------------------------*/
/* Useful functions and inline definitions */

/* UDB - Union Data Buffer                                         */
/*       Typedef to easily access bits of words and an initializer */
/*       Not to be confused with RTWB (Right To Work Buffer)...    */
typedef union {

  /* Overlap data types in a single 64-bit word */
  uint8_t   u8[8];
  int8_t    i8[8];  
  uint16_t  u16[4];
  int16_t   i16[4];  
  uint32_t  u32[2];
  int32_t   i32[2];  
  float32_t f32[2];
  uint64_t  u64[1];
  int64_t   i64[1];  
  float64_t f64[1];

#ifdef _ISOC99_SOURCE
  /* Nibble (4-bit) positions within 64 bit word */
  struct {
    uint8_t p00:4;
    uint8_t p01:4;
    uint8_t p02:4;
    uint8_t p03:4;
    uint8_t p04:4;
    uint8_t p05:4;
    uint8_t p06:4;
    uint8_t p07:4;
    uint8_t p08:4;
    uint8_t p09:4;
    uint8_t p10:4;
    uint8_t p11:4;
    uint8_t p12:4;
    uint8_t p13:4;
    uint8_t p14:4;
    uint8_t p15:4;
  } n;

  /* Single bit positions within 64 bit word */
  struct {
    uint8_t p00:1;
    uint8_t p01:1;
    uint8_t p02:1;
    uint8_t p03:1;
    uint8_t p04:1;
    uint8_t p05:1;
    uint8_t p06:1;
    uint8_t p07:1;
    uint8_t p08:1;
    uint8_t p09:1;
    uint8_t p10:1;
    uint8_t p11:1;
    uint8_t p12:1;
    uint8_t p13:1;
    uint8_t p14:1;
    uint8_t p15:1;
    uint8_t p16:1;
    uint8_t p17:1;
    uint8_t p18:1;
    uint8_t p19:1;
    uint8_t p20:1;
    uint8_t p21:1;
    uint8_t p22:1;
    uint8_t p23:1;
    uint8_t p24:1;
    uint8_t p25:1;
    uint8_t p26:1;
    uint8_t p27:1;
    uint8_t p28:1;
    uint8_t p29:1;
    uint8_t p30:1;
    uint8_t p31:1;
    uint8_t p32:1;
    uint8_t p33:1;
    uint8_t p34:1;
    uint8_t p35:1;
    uint8_t p36:1;
    uint8_t p37:1;
    uint8_t p38:1;
    uint8_t p39:1;
    uint8_t p40:1;
    uint8_t p41:1;
    uint8_t p42:1;
    uint8_t p43:1;
    uint8_t p44:1;
    uint8_t p45:1;
    uint8_t p46:1;
    uint8_t p47:1;
    uint8_t p48:1;
    uint8_t p49:1;
    uint8_t p50:1;
    uint8_t p51:1;
    uint8_t p52:1;
    uint8_t p53:1;
    uint8_t p54:1;
    uint8_t p55:1;
    uint8_t p56:1;
    uint8_t p57:1;
    uint8_t p58:1;
    uint8_t p59:1;
    uint8_t p60:1;
    uint8_t p61:1;
    uint8_t p62:1;
    uint8_t p63:1;
    } b;
#endif
} UDB;
  
static const UDB udb_initializer = {
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00} 
}; 

enum UDB_FMT_LIST {
  UDB_FMT_BIT = (0x00000001<<0),  /* Packed bit array                */
  UDB_FMT_U8  = (0x00000001<<1),  /* Unsigned 8 bit integer array    */
  UDB_FMT_I8  = (0x00000001<<2),  /* Signed 8 bit integer array      */
  UDB_FMT_U16 = (0x00000001<<3),  /* Unsigned 16 bit integer array   */
  UDB_FMT_I16 = (0x00000001<<4),  /* Signed 16 bit integer array     */
  UDB_FMT_U32 = (0x00000001<<5),  /* Unsigned 32 bit integer array   */
  UDB_FMT_I32 = (0x00000001<<6),  /* Signed 32 bit integer array     */
  UDB_FMT_F32 = (0x00000001<<7),  /* Single precision floating point */
  UDB_FMT_U64 = (0x00000001<<8),  /* Unsigned 64 bit integer array   */
  UDB_FMT_I64 = (0x00000001<<9),  /* Signed 64 bit integer array     */
  UDB_FMT_F64 = (0x00000001<<10)  /* Double precision floating point */
};

/*---------------------------------------------------------------------------*/
/* Debug output macros that can be conditionally compiled out of program     */
/*   dbgprint(level, mask, fmt, ...)  - conditional printf                   */
/*   dbgsource(level, mask, fmt, ...) - conditional printf w/ source         */
/*   dbginfo(fmt, ...)  - unconditional information using printf             */
/*   dbgwarn(fmt, ...)  - unconditional warning using printf                 */
/*   dbgerror(fmt, ...) - unconditional error using printf                   */
/*   dbgabort(fmt, ...) - unconditional error using printf w/ program abort  */

#define DBG_OUTPUT_MACROS 1

#if DBG_OUTPUT_MACROS > 0
#define dbgprintmsg(level, mask, fmt) do {\
  if ((level & mask) == mask) \
    printf(fmt);\
} while (0)
#define dbgprint(level, mask, fmt, ...) do {\
  if ((level & mask) == mask) \
    printf(fmt, ##__VA_ARGS__);\
} while (0)
#define dbginfomsg(fmt) do {\
    printf("INFO: " fmt);\
} while (0)
#define dbginfo(fmt, ...) do {\
    printf("INFO: " fmt, ##__VA_ARGS__);\
} while (0)
#define dbgwarnmsg(fmt) do {\
    printf("WARNING: " fmt);\
} while (0)
#define dbgwarn(fmt, ...) do {\
    printf("WARNING: " fmt, ##__VA_ARGS__);\
} while (0)
#define dbgerrormsg(fmt) do {\
    printf("ERROR: " fmt);\
} while (0)
#define dbgerror(fmt, ...) do {\
    printf("ERROR: " fmt, ##__VA_ARGS__);\
} while (0)
#define dbgsource(level, mask, fmt, ...) do {\
  if ((level & mask) == mask) \
    printf("%s: %d: " fmt, __FILE__, __LINE__, ##__VA_ARGS__);\
} while (0)
#define dbgabort(fmt, ...) do {\
    printf("ABORT: %s: %d: " fmt, __FILE__, __LINE__, ##__VA_ARGS__);\
    exit(1);\
} while (0)
#else
#define dbgprintmsg(level, mask, fmt) 
#define dbgprint(level, mask, fmt, ...) 
#define dbginfomsg(fmt) 
#define dbginfo(fmt, ...) 
#define dbgwarnmsg(fmt) 
#define dbgwarn(fmt, ...) 
#define dbgerrormsg(fmt) 
#define dbgerror(fmt, ...) 
#define dbgsource(level, mask, fmt, ...) 
#define dbgabort(fmt, ...) 
#endif

/* Define module or part specific debug masks */
enum DBG_OUTPUT_LEVEL_MASKS {
  DBG_PT = (0x00000001<<2),  /* Generic part debug output           */
  DBG_MO = (0x00000001<<3),  /* Generic module debug output         */
  DBG_AD = (0x00000001<<4),  /* A2D  debug output                   */
  DBG_DA = (0x00000001<<5),  /* D2A  debug output                   */
  DBG_LB = (0x00000001<<6),  /* LB2D debug output                   */
  DBG_RF = (0x00000001<<7)   /* RF   debug output                   */
};


/*---------------------------------------------------------------------------*/
/* Function Prototypes */
#ifndef EXTERN_CDEFINE
#ifdef __cplusplus
#define EXTERN_CDEFINE extern "C"
#else
#define EXTERN_CDEFINE extern
#endif
#endif

EXTERN_CDEFINE uint8_t u8_setbits(uint8_t ur, uint8_t um, uint8_t uv);
EXTERN_CDEFINE uint8_t u8_getbits(uint8_t umask, uint8_t uval);
EXTERN_CDEFINE uint16_t u16_setbits(uint16_t ur, uint16_t um, uint16_t uv);
EXTERN_CDEFINE uint16_t u16_getbits(uint16_t umask, uint16_t uval);
EXTERN_CDEFINE uint32_t u32_setbits(uint32_t ur, uint32_t um, uint32_t uv);
EXTERN_CDEFINE uint32_t u32_getbits(uint32_t umask, uint32_t uval);
EXTERN_CDEFINE UDB *alloc_udb(int32_t numel);
EXTERN_CDEFINE void free_udb(UDB *b);
EXTERN_CDEFINE int32_t udb_f64_to_i32wf(UDB *b);
EXTERN_CDEFINE int32_t udb_f64_to_i32rnd(UDB *b);
EXTERN_CDEFINE int32_t udb_i32wf_to_f64(UDB *b);


#endif /* _PART_COMMON_H */
