/*****************************************************************************/
/*                                                                           */
/* part_ais.h                                                                */
/*                                                                           */
/*****************************************************************************/
#ifndef _PART_AIS_H
#define _PART_AIS_H

#include "part_common.h"

/* AIS unique part identifier  */
enum AIS_PART_ID {
  PTID_AIS = FPGA_PTID_AIS 
};

/* AIS Pin control Masks */
enum AIS_PIN_MASK {
  AIS_PIN_NULL   = 0x00000000,  /* Null function place holder */
  AIS_PIN_BYPASS = 0x00000001   /* Enable/Bypass control      */
};

/* AIS Register ID's */
enum AIS_RG_ID {
  AIS_RG_DCI = 0x00,  /* In-Phase DC Correction Term         */
  AIS_RG_DCQ = 0x01,  /* Quadrature DC Correction Term       */
  AIS_RG_CXA = 0x02,  /* Complex Rotation Matrix Element A   */
  AIS_RG_CXC = 0x03,  /* Complex Rotation Matrix Element C   */
  AIS_RG_CXD = 0x04   /* Complex Rotation Matrix Element D   */
};


/* AIS Register Keys and Masks */
enum AIS_RG_MASK {
  AIS_RGM_00_DATA = 0x0000FFFF,  /* DCI: 16-Bit Data  */
  AIS_RGM_01_DATA = 0x0000FFFF,  /* DCQ: 16-Bit Data  */
  AIS_RGM_02_DATA = 0x0000FFFF,  /* CXA: 16-Bit Data  */
  AIS_RGM_03_DATA = 0x0000FFFF,  /* CXC: 16-Bit Data  */
  AIS_RGM_04_DATA = 0x0000FFFF   /* CXD: 16-Bit Data  */
};


/*---------------------------------------------------------------------------*/
/* Public function prototypes from part_ais.c */


#endif  /* _PART_AIS_H */
