/*****************************************************************************/
/*                                                                           */
/* part_adclm.h                                                              */
/*                                                                           */
/*****************************************************************************/
#ifndef _PART_ADCLM_H
#define _PART_ADCLM_H

#include <math.h>
#include "part_common.h"

/* ADCLM unique part identifier  */
enum ADCLM_PART_ID {
  PTID_ADCLM = FPGA_PTID_ADCLM 
};

/* ADCLM Pin control Masks */
enum ADCLM_PIN_MASK {
  ADCLM_PIN_NULL = 0x00000001   /* Null function place holder */
};

/* ADCLM Register ID's */
enum ADCLM_RG_ID {
  ADCLM_RG_LOAD = 0x00,  /* Loading                             */
  ADCLM_RG_B1   = 0x01,
  ADCLM_RG_B2   = 0x02,
  ADCLM_RG_DEC  = 0x03 
};


/* ADCLM Register Keys and Masks */
enum ADCLM_RG_MASK {
  ADCLM_RGM_00_DATA = 0x0000FFFF,  /* 16-Bit Data  */
  ADCLM_RGM_B1      = 0x000000FF,  /* 8-Bit Data  */
  ADCLM_RGM_B2      = 0x000000FF,  /* 8-Bit Data  */
  ADCLM_RGM_DEC     = 0x000000FF   /* 8-Bit Data  */
};


/*---------------------------------------------------------------------------*/
/* Public function prototypes from part_adclm.c */

EXTERN_CDEFINE float64_t adclm_to_cf_f64(int32_t adcmeas);
EXTERN_CDEFINE int32_t adclm_to_cf_i32(int32_t adcmeas);

#endif  /* _PART_ADCLM_H */
