/*****************************************************************************/
/*                                                                           */
/* module_common.h                                                           */
/*                                                                           */
/*****************************************************************************/
#ifndef _MODULE_COMMON_H
#define _MODULE_COMMON_H

#include "part_common.h"
#include "part_root.h"       /* Every module contains root part    */ 
#include "part_cmd.h"        /* Every module contains cmd part     */
#include "part_state.h"      /* Every module contains a state part */
#include "c3_target_core.h"  /* Every module contains a C3 target  */

#define MOBJ_INITMAGIC  0xA035FC41 /* Initialization key                     */
#define MOBJ_CMD_QUEUE_MAX    4096 /* Maximum of 4096 queued commands before */
                                   /*   dispatch must occur to module queue  */

#define PICLOCK_BLD 1              /* Build with pic_lock thread safe method */

/* Generic Module Object */ 
typedef struct {
  uint32_t initmagic;              /* Simple check for initialized struct    */
  uint32_t mod_typeid;             /* Module type identifier part_common.h   */
  int32_t  dbg;                    /* Debug / verbose execution              */
  PT_ROOT_Obj  RT;                 /* Root part map                          */
  PT_STATE_Obj LS;                 /* Local state representation of module   */
  CMDBUF QCMD[MOBJ_CMD_QUEUE_MAX]; /* Local registers of commands to be sent */
  int32_t qcmdcnt;
  CMDBUF QSTA[MOBJ_CMD_QUEUE_MAX]; /* Local registers of received status     */
  int32_t qstacnt;
  TGT_Config_Obj TGT;              /* Target / transport configuration       */
  Part_Config_Obj part_config[PT_CFG_OBJ_MAX]; /* Part handles on module  */
  char *config;
} Module_Config_Obj;


/*---------------------------------------------------------------------------*/
/* Public Function Prototypes */

EXTERN_CDEFINE Module_Config_Obj *module_alloc_obj(uint32_t typeid, TGT_Config_Obj *T, uint32_t flags);
EXTERN_CDEFINE int32_t module_validate_obj(Module_Config_Obj *mco);
EXTERN_CDEFINE int32_t module_init_obj(Module_Config_Obj *mco, uint32_t typeid, TGT_Config_Obj *T, uint32_t flags);
EXTERN_CDEFINE int32_t module_free_obj(Module_Config_Obj *mco, uint32_t flags);
EXTERN_CDEFINE int32_t module_lock(Module_Config_Obj *mco, uint32_t flags);
EXTERN_CDEFINE int32_t module_unlock(Module_Config_Obj *mco, uint32_t flags);
EXTERN_CDEFINE int32_t module_fcn(Module_Config_Obj *mco, uint32_t flags, UDB *data);
EXTERN_CDEFINE int32_t module_get_state(Module_Config_Obj *mco);
EXTERN_CDEFINE int32_t module_set_state(Module_Config_Obj *mco);

EXTERN_CDEFINE Module_Config_Obj *mod_alloc_obj();
EXTERN_CDEFINE int32_t mod_init_obj(Module_Config_Obj *M);
EXTERN_CDEFINE int32_t mod_force_init_obj(Module_Config_Obj *M);
EXTERN_CDEFINE int32_t mod_free_obj(Module_Config_Obj *M);
EXTERN_CDEFINE int32_t mod_validate_obj(Module_Config_Obj *M);
EXTERN_CDEFINE int32_t mod_add_qcmd(Module_Config_Obj *M, CMDBUF *cbuf);
EXTERN_CDEFINE int32_t mod_dispatch_qcmd(Module_Config_Obj *M);
EXTERN_CDEFINE int32_t mod_clear_qsta(Module_Config_Obj *M);
EXTERN_CDEFINE int32_t mod_retrieve_qsta(Module_Config_Obj *M);
EXTERN_CDEFINE int32_t mod_get_state(Module_Config_Obj *M);
EXTERN_CDEFINE int32_t mod_set_state(Module_Config_Obj *M);

              /* BAD BAD BAD BAD BAD */
EXTERN_CDEFINE int32_t module_fcn_lb2dm3(Module_Config_Obj *M, uint32_t flags, UDB *data);
EXTERN_CDEFINE int32_t module_fcn_lb2dm4(Module_Config_Obj *M, uint32_t flags, UDB *data);

EXTERN_CDEFINE int32_t getmoduleconfig(Module_Config_Obj *module_cfg);
EXTERN_CDEFINE int32_t cmdcfg_ctl(Module_Config_Obj *module_cfg, 
    int32_t part_ID, int32_t sub_ID, int32_t func, int32_t addr, int32_t data, uint32_t mask);
EXTERN_CDEFINE int32_t cmdcfg_stat(Module_Config_Obj *module_cfg, 
    int32_t part_ID, int32_t sub_ID, int32_t *func, int32_t *pin, int32_t *addr, int32_t *data);
EXTERN_CDEFINE int32_t cmdcfg_getcmdkey(Module_Config_Obj *module_cfg);
EXTERN_CDEFINE int32_t cmdcfg_checklock(Module_Config_Obj *module_cfg);
EXTERN_CDEFINE int32_t cmdcfg_locksession(Module_Config_Obj *module_cfg);
EXTERN_CDEFINE int32_t cmdcfg_delay(Module_Config_Obj *module_cfg, int32_t delay);
EXTERN_CDEFINE int32_t cmdcfg_bufclr(Module_Config_Obj *module_cfg);
EXTERN_CDEFINE int_4 partcfg_read(Module_Config_Obj *module_cfg,
    int_4 part_ID, int_4 sub_ID, int_4 func, int_4 *pin, int_4 addr, int_4 *data, int_u4 mask);

              /* BAD BAD BAD BAD BAD */

#endif  /* _MODULE_COMMON_H */
