/****************************************************************************/
/*                                                                          */
/*   iomlib_d2awgm3.h: includes for D2AWGM3 library interfaces                */
/*                                                                          */
/****************************************************************************/
#ifndef _IOMLIB_D2AWGM3_H
#define _IOMLIB_D2AWGM3_H

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>   
#include <fcntl.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "icelib.h" 
#include "../part/module_common.h"
#include "../part/part_common.h"
#include "../part/part_si5338.h"
#include "../part/part_lmx2582.h"

#define MAXDACRATE  4960000000ull
#define MINDACRATE  1775000000ull
#define MINVCORATE  3550000000ull
#define MAXFPGARATEHS 500000000
#define MAXFPGARATELS 225000000

#define D2AWGM3_ROOT       0
#define D2AWGM3_JVM        1
#define D2AWGM3_MAX5868    2
#define D2AWGM3_LMH6401    3
#define D2AWGM3_PE42553_0  4
#define D2AWGM3_PE42553_1  5
#define D2AWGM3_PE43704    6
#define D2AWGM3_LTC5549    7
#define D2AWGM3_MCP3421    8
#define D2AWGM3_LTC6957    9
#define D2AWGM3_OSC        10
#define D2AWGM3_SI5335     11
#define D2AWGM3_LMX2582    12
#define D2AWGM3_MTGO       13
#define D2AWGM3_DELAY      14
#define D2AWGM3_HBINTFIR   15
#define D2AWGM3_MEM        16
#define D2AWGM3_MIC280     17
#define D2AWGM3_MODULE     18
#define D2AWGM3_CMD        19
#define D2AWGM3_ADCLM      20

#define D2AWGM3_NUMPARTS   19

#define GAINTBLSIZE 64 /* Size of gain table */
#define GAINCORSIZE 30 /* Size of gain correction table */
#define GAINCORRES 100 /* Frequency resolution of the gain correction table */

#define MAX5868_RESET   0x0001
#define MAX5868_MUTE    0x0002
#define MAX5868_CLKDIS  0x0100
#define MAX5868_DATDIS  0x0200
#define MAX5868_CLKINV  0x1000
#define MAX5868_SYNCTY  0x2000
#define MAX5868_ALL     0xFFFF

int_4 d2awgm3_mtgo_tbl[8] = {
  0, 146, 310, 510, 782, 1070, 1646, 2798
};

int_4 d2awgm3_mtgo_tbl_pp[17] = {
  0, 12, 21, 33, 73, 92, 116, 156,
  198, 356, 491, 512, 659, 746, 955, 1091,
  1331
};

int_4 d2awgm3_dac_interp [9] = {
  24, 20, 16, 12, 10, 8, 6, 5, 4
};

int_4 d2awgm3_fpga_interp [8] = {
  128, 64, 32, 16, 8, 4, 2, 1
};

int_4 d2awgm3_fpga_interp_pp [17] = {
  128, 96, 84, 72, 64, 50, 48, 32,
  20, 16, 12, 10, 8, 4, 3, 2, 1
};

int_4 d2awgm3_gaintbl [GAINTBLSIZE][2] = {
  {31,32}, {31,31}, {31,30}, {31,29},
  {31,28}, {31,27}, {31,26}, {30,26},
  {29,26}, {28,26}, {27,26}, {26,26},
  {25,26}, {24,26}, {23,26}, {22,26},
  {21,26}, {20,26}, {19,26}, {18,26},
  {17,26}, {16,26}, {15,26}, {14,26},
  {13,26}, {12,26}, {11,26}, {10,26},
   {9,26},  {8,26},  {7,26},  {6,26},
   {5,26},  {4,26},  {3,26},  {2,26},
   {1,26},  {0,26},  {0,25},  {0,24},
   {0,23},  {0,22},  {0,21},  {0,20},
   {0,19},  {0,18},  {0,17},  {0,16},
   {0,15},  {0,14},  {0,13},  {0,12},
   {0,11},  {0,10},  {0, 9},   {0,8},
   {0, 7},  {0, 6},  {0, 5},   {0,4},
   {0, 3},  {0, 2},  {0, 1},   {0,0}
};

int_4 d2awgm3_gaincor [GAINCORSIZE] = {
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

int_4 d2awgm3_hbfir0 [] = {
  -1,2,-3,5,-8,12,-17,23,
  -31,41,-54,69,-87,109,-135,165,
  -201,242,-291,347,-413,489,-579,684,
  -810,963,-1153,1394,-1715,2168,-2862,4087,
  -6902,20844
};

int_4 d2awgm3_hbfir1 [] = {
  -1,-3,-8,-17,-31,-54,-87,-135,
  -201,-291,-413,-579,-810,-1153,-1715,-2862,
  -6902,20844,4087,2168,1394,963,684,489,
  347,242,165,109,69,41,23,12,
  5,2
};

int_4 d2awgm3_polyfir_1 [] = {
  0,0,0,0,0,0,0,0,
  0,0,65536,0,0,0,0,0,
  0,0,0,0,0,0
};

int_4 d2awgm3_polyfir_2 [] = {
  122,585,1188,1023,-365,-1524,-508,1645,
  1401,-1537,-2376,1198,3512,-549,-4934,-605,
  6946,2808,-10567,-8334,22315,55907,55907,22315,
  -8334,-10567,2808,6946,-605,-4934,-549,3512,
  1198,-2376,-1537,1401,1645,-508,-1524,-365,
  1023,1188,585,122
};

int_4 d2awgm3_polyfir_3 [] = {
  40,180,448,752,860,528,-249,-1088,
  -1360,-664,710,1790,1576,-48,-1962,-2501,
  -867,1912,3495,2118,-1596,-4647,-3920,870,
  6154,6840,691,-8655,-12985,-4963,15905,41411,
  58852,58852,41411,15905,-4963,-12985,-8655,691,
  6840,6154,870,-3920,-4647,-1596,2118,3495,
  1912,-867,-2501,-1962,-48,1576,1790,710,
  -664,-1360,-1088,-249,528,860,752,448,
  180,40
};

int_4 d2awgm3_polyfir_4 [] = {
  22,87,214,396,585,690,608,276,
  -270,-872,-1282,-1261,-705,255,1260,1841,
  1636,605,-884,-2157,-2528,-1655,214,2263,
  3438,2966,820,-2134,-4437,-4717,-2435,1657,
  5673,7364,5237,-491,-7606,-12512,-11615,-2920,
  12843,32108,49534,59866,59866,49534,32108,12843,
  -2920,-11615,-12512,-7606,-491,5237,7364,5673,
  1657,-2435,-4717,-4437,-2134,820,2966,3438,
  2263,214,-1655,-2528,-2157,-884,605,1636,
  1841,1260,255,-705,-1261,-1282,-872,-270,
  276,608,690,585,396,214,87,22
};

int_4 d2awgm3_polyfir_8 [] = {
  9,24,49,86,137,201,274,353,
  427,488,522,518,466,359,194,-23,
  -281,-559,-832,-1070,-1240,-1315,-1272,-1100,
  -800,-391,95,612,1104,1511,1778,1861,
  1732,1388,852,172,-580,-1316,-1945,-2377,
  -2543,-2398,-1937,-1193,-239,818,1849,2716,
  3294,3483,3225,2518,1419,41,-1456,-2881,
  -4038,-4746,-4873,-4346,-3177,-1463,615,2813,
  4845,6417,7266,7196,6111,4036,1129,-2324,
  -5931,-9226,-11719,-12941,-12505,-10150,-5781,513,
  8447,17564,27266,36864,45641,52920,58125,60837,
  60837,58125,52920,45641,36864,27266,17564,8447,
  513,-5781,-10150,-12505,-12941,-11719,-9226,-5931,
  -2324,1129,4036,6111,7196,7266,6417,4845,
  2813,615,-1463,-3177,-4346,-4873,-4746,-4038,
  -2881,-1456,41,1419,2518,3225,3483,3294,
  2716,1849,818,-239,-1193,-1937,-2398,-2543,
  -2377,-1945,-1316,-580,172,852,1388,1732,
  1861,1778,1511,1104,612,95,-391,-800,
  -1100,-1272,-1315,-1240,-1070,-832,-559,-281,
  -23,194,359,466,518,522,488,427,
  353,274,201,137,86,49,24,9
};

int_4 d2awgm3_polyfir_10 [] = {
  7,17,33,56,88,127,175,230,
  289,350,407,457,492,506,495,452,
  375,261,111,-69,-274,-493,-713,-921,
  -1099,-1232,-1305,-1307,-1229,-1067,-825,-512,
  -142,262,675,1067,1408,1670,1826,1857,
  1751,1507,1134,651,89,-513,-1111,-1657,
  -2104,-2410,-2540,-2473,-2201,-1734,-1097,-332,
  506,1353,2139,2794,3255,3472,3409,3054,
  2418,1536,467,-712,-1907,-3018,-3944,-4592,
  -4888,-4782,-4252,-3314,-2018,-448,1282,3036,
  4664,6014,6948,7347,7131,6260,4749,2664,
  127,-2692,-5583,-8305,-10606,-12239,-12976,-12629,
  -11062,-8210,-4078,1246,7599,14744,22388,30191,
  37791,44819,50927,55806,59207,60953,60953,59207,
  55806,50927,44819,37791,30191,22388,14744,7599,
  1246,-4078,-8210,-11062,-12629,-12976,-12239,-10606,
  -8305,-5583,-2692,127,2664,4749,6260,7131,
  7347,6948,6014,4664,3036,1282,-448,-2018,
  -3314,-4252,-4782,-4888,-4592,-3944,-3018,-1907,
  -712,467,1536,2418,3054,3409,3472,3255,
  2794,2139,1353,506,-332,-1097,-1734,-2201,
  -2473,-2540,-2410,-2104,-1657,-1111,-513,89,
  651,1134,1507,1751,1857,1826,1670,1408,
  1067,675,262,-142,-512,-825,-1067,-1229,
  -1307,-1305,-1232,-1099,-921,-713,-493,-274,
  -69,111,261,375,452,495,506,492,
  457,407,350,289,230,175,127,88,
  56,33,17,7
};

int_4 d2awgm3_polyfir_12 [] = {
  6,14,25,41,62,89,121,159,
  203,250,299,349,396,438,470,491,
  496,481,445,385,300,190,57,-97,
  -267,-448,-631,-810,-975,-1117,-1226,-1295,
  -1315,-1282,-1193,-1045,-842,-590,-295,30,
  372,715,1041,1334,1576,1751,1847,1852,
  1763,1577,1300,939,511,34,-468,-970,
  -1444,-1862,-2198,-2429,-2536,-2508,-2337,-2026,
  -1586,-1034,-395,298,1008,1696,2321,2843,
  3227,3443,3470,3295,2918,2350,1614,743,
  -218,-1218,-2201,-3107,-3879,-4462,-4812,-4894,
  -4688,-4187,-3404,-2368,-1125,265,1728,3182,
  4540,5713,6619,7185,7353,7082,6355,5181,
  3592,1649,-563,-2938,-5348,-7657,-9717,-11383,
  -12516,-12990,-12701,-11571,-9553,-6636,-2849,1743,
  7039,12903,19167,25643,32126,38403,44262,49502,
  53937,57412,59800,61016,61016,59800,57412,53937,
  49502,44262,38403,32126,25643,19167,12903,7039,
  1743,-2849,-6636,-9553,-11571,-12701,-12990,-12516,
  -11383,-9717,-7657,-5348,-2938,-563,1649,3592,
  5181,6355,7082,7353,7185,6619,5713,4540,
  3182,1728,265,-1125,-2368,-3404,-4187,-4688,
  -4894,-4812,-4462,-3879,-3107,-2201,-1218,-218,
  743,1614,2350,2918,3295,3470,3443,3227,
  2843,2321,1696,1008,298,-395,-1034,-1586,
  -2026,-2337,-2508,-2536,-2429,-2198,-1862,-1444,
  -970,-468,34,511,939,1300,1577,1763,
  1852,1847,1751,1576,1334,1041,715,372,
  30,-295,-590,-842,-1045,-1193,-1282,-1315,
  -1295,-1226,-1117,-975,-810,-631,-448,-267,
  -97,57,190,300,385,445,481,496,
  491,470,438,396,349,299,250,203,
  159,121,89,62,41,25,14,6
};

int_4 d2awgm3_polyfir_16 [] = {
  5,10,17,26,38,53,70,91,
  115,142,172,205,240,276,313,349,
  384,415,443,465,480,486,482,467,
  439,399,344,275,193,97,-11,-129,
  -256,-390,-526,-663,-796,-922,-1037,-1137,
  -1218,-1276,-1309,-1314,-1288,-1230,-1140,-1018,
  -865,-684,-477,-249,-5,250,508,763,
  1007,1234,1436,1605,1735,1822,1860,1846,
  1778,1656,1480,1255,984,674,332,-33,
  -410,-789,-1157,-1504,-1817,-2086,-2300,-2451,
  -2531,-2534,-2459,-2303,-2070,-1762,-1386,-953,
  -474,39,569,1101,1617,2100,2534,2902,
  3190,3385,3477,3459,3327,3080,2724,2263,
  1710,1079,386,-346,-1097,-1842,-2557,-3215,
  -3794,-4270,-4624,-4838,-4899,-4799,-4532,-4101,
  -3513,-2780,-1919,-953,90,1181,2283,3363,
  4382,5303,6090,6711,7136,7339,7303,7014,
  6469,5669,4628,3363,1904,287,-1445,-3244,
  -5053,-6815,-8469,-9952,-11203,-12163,-12777,-12997,
  -12780,-12094,-10916,-9234,-7046,-4364,-1213,2374,
  6347,10651,15218,19971,24831,29709,34516,39163,
  43559,47620,51266,54424,57031,59034,60393,61079,
  61079,60393,59034,57031,54424,51266,47620,43559,
  39163,34516,29709,24831,19971,15218,10651,6347,
  2374,-1213,-4364,-7046,-9234,-10916,-12094,-12780,
  -12997,-12777,-12163,-11203,-9952,-8469,-6815,-5053,
  -3244,-1445,287,1904,3363,4628,5669,6469,
  7014,7303,7339,7136,6711,6090,5303,4382,
  3363,2283,1181,90,-953,-1919,-2780,-3513,
  -4101,-4532,-4799,-4899,-4838,-4624,-4270,-3794,
  -3215,-2557,-1842,-1097,-346,386,1079,1710,
  2263,2724,3080,3327,3459,3477,3385,3190,
  2902,2534,2100,1617,1101,569,39,-474,
  -953,-1386,-1762,-2070,-2303,-2459,-2534,-2531,
  -2451,-2300,-2086,-1817,-1504,-1157,-789,-410,
  -33,332,674,984,1255,1480,1656,1778,
  1846,1860,1822,1735,1605,1436,1234,1007,
  763,508,250,-5,-249,-477,-684,-865,
  -1018,-1140,-1230,-1288,-1314,-1309,-1276,-1218,
  -1137,-1037,-922,-796,-663,-526,-390,-256,
  -129,-11,97,193,275,344,399,439,
  467,482,486,480,465,443,415,384,
  349,313,276,240,205,172,142,115,
  91,70,53,38,26,17,10,5
};

int_4 d2awgm3_polyfir_20 [] = {
  5,9,13,20,27,37,48,61,
  76,92,112,133,156,180,207,234,
  263,292,321,350,377,403,426,447,
  463,474,481,481,474,460,437,407,
  367,319,262,196,121,39,-51,-147,
  -249,-354,-462,-572,-681,-787,-889,-984,
  -1071,-1148,-1212,-1262,-1297,-1314,-1312,-1291,
  -1250,-1188,-1105,-1002,-879,-738,-580,-407,
  -222,-27,176,382,588,791,986,1171,
  1340,1492,1621,1725,1802,1848,1861,1841,
  1786,1697,1573,1416,1228,1011,768,504,
  222,-73,-375,-678,-977,-1266,-1539,-1789,
  -2012,-2202,-2353,-2463,-2526,-2541,-2506,-2420,
  -2283,-2095,-1860,-1580,-1260,-905,-521,-115,
  305,731,1155,1569,1962,2326,2654,2936,
  3166,3337,3444,3483,3450,3344,3165,2914,
  2595,2210,1767,1273,737,168,-423,-1024,
  -1623,-2207,-2763,-3278,-3742,-4140,-4464,-4704,
  -4851,-4900,-4846,-4685,-4419,-4048,-3577,-3013,
  -2362,-1637,-850,-15,853,1735,2613,3470,
  4285,5040,5716,6296,6763,7103,7303,7352,
  7243,6971,6534,5934,5176,4269,3224,2056,
  785,-570,-1982,-3427,-4875,-6297,-7661,-8936,
  -10089,-11090,-11909,-12516,-12886,-12995,-12822,-12350,
  -11567,-10463,-9036,-7285,-5218,-2843,-179,2756,
  5936,9331,12908,16629,20455,24344,28250,32128,
  35931,39615,43133,46441,49499,52267,54709,56795,
  58498,59794,60668,61108,61108,60668,59794,58498,
  56795,54709,52267,49499,46441,43133,39615,35931,
  32128,28250,24344,20455,16629,12908,9331,5936,
  2756,-179,-2843,-5218,-7285,-9036,-10463,-11567,
  -12350,-12822,-12995,-12886,-12516,-11909,-11090,-10089,
  -8936,-7661,-6297,-4875,-3427,-1982,-570,785,
  2056,3224,4269,5176,5934,6534,6971,7243,
  7352,7303,7103,6763,6296,5716,5040,4285,
  3470,2613,1735,853,-15,-850,-1637,-2362,
  -3013,-3577,-4048,-4419,-4685,-4846,-4900,-4851,
  -4704,-4464,-4140,-3742,-3278,-2763,-2207,-1623,
  -1024,-423,168,737,1273,1767,2210,2595,
  2914,3165,3344,3450,3483,3444,3337,3166,
  2936,2654,2326,1962,1569,1155,731,305,
  -115,-521,-905,-1260,-1580,-1860,-2095,-2283,
  -2420,-2506,-2541,-2526,-2463,-2353,-2202,-2012,
  -1789,-1539,-1266,-977,-678,-375,-73,222,
  504,768,1011,1228,1416,1573,1697,1786,
  1841,1861,1848,1802,1725,1621,1492,1340,
  1171,986,791,588,382,176,-27,-222,
  -407,-580,-738,-879,-1002,-1105,-1188,-1250,
  -1291,-1312,-1314,-1297,-1262,-1212,-1148,-1071,
  -984,-889,-787,-681,-572,-462,-354,-249,
  -147,-51,39,121,196,262,319,367,
  407,437,460,474,481,481,474,463,
  447,426,403,377,350,321,292,263,
  234,207,180,156,133,112,92,76,
  61,48,37,27,20,13,9,5
};

int_4 d2awgm3_polyfir_32 [] = {
  4,6,9,12,15,19,23,29,
  34,41,48,56,64,74,84,95,
  107,119,133,147,162,177,193,210,
  227,245,262,280,298,316,334,352,
  369,385,401,416,429,441,452,461,
  468,473,476,476,474,469,461,450,
  436,419,399,375,347,316,282,244,
  203,158,110,59,6,-51,-110,-171,
  -235,-300,-366,-434,-502,-570,-638,-705,
  -771,-836,-898,-958,-1015,-1069,-1118,-1163,
  -1203,-1237,-1266,-1289,-1304,-1313,-1315,-1309,
  -1296,-1275,-1245,-1208,-1162,-1109,-1047,-978,
  -901,-817,-726,-628,-525,-415,-301,-183,
  -60,65,192,321,450,578,706,831,
  953,1071,1184,1292,1392,1485,1569,1644,
  1709,1763,1806,1837,1856,1861,1854,1833,
  1799,1751,1689,1614,1526,1425,1312,1187,
  1051,905,750,586,415,237,55,-132,
  -320,-510,-699,-887,-1071,-1251,-1424,-1590,
  -1746,-1892,-2026,-2148,-2254,-2346,-2421,-2479,
  -2518,-2539,-2541,-2522,-2484,-2426,-2348,-2250,
  -2133,-1996,-1842,-1670,-1482,-1279,-1062,-833,
  -593,-344,-87,175,440,707,973,1236,
  1495,1746,1987,2218,2434,2636,2820,2984,
  3128,3249,3346,3418,3464,3483,3473,3435,
  3369,3274,3151,2999,2820,2615,2384,2130,
  1853,1555,1239,906,560,202,-165,-538,
  -913,-1289,-1662,-2029,-2386,-2731,-3060,-3371,
  -3661,-3926,-4164,-4373,-4550,-4692,-4799,-4868,
  -4899,-4889,-4838,-4746,-4613,-4438,-4222,-3966,
  -3672,-3340,-2973,-2572,-2141,-1682,-1199,-694,
  -172,364,910,1461,2013,2561,3101,3628,
  4138,4625,5086,5516,5910,6264,6575,6838,
  7050,7208,7310,7353,7335,7254,7109,6900,
  6627,6290,5890,5428,4906,4328,3695,3012,
  2282,1509,700,-141,-1008,-1895,-2795,-3701,
  -4607,-5504,-6386,-7245,-8072,-8861,-9603,-10291,
  -10917,-11473,-11954,-12351,-12659,-12870,-12981,-12984,
  -12876,-12652,-12309,-11844,-11255,-10540,-9699,-8730,
  -7636,-6417,-5076,-3615,-2039,-351,1443,3337,
  5325,7399,9551,11774,14059,16395,18773,21182,
  23613,26054,28494,30922,33327,35697,38021,40288,
  42488,44608,46640,48572,50396,52102,53682,55127,
  56431,57587,58589,59432,60111,60624,60967,61140,
  61140,60967,60624,60111,59432,58589,57587,56431,
  55127,53682,52102,50396,48572,46640,44608,42488,
  40288,38021,35697,33327,30922,28494,26054,23613,
  21182,18773,16395,14059,11774,9551,7399,5325,
  3337,1443,-351,-2039,-3615,-5076,-6417,-7636,
  -8730,-9699,-10540,-11255,-11844,-12309,-12652,-12876,
  -12984,-12981,-12870,-12659,-12351,-11954,-11473,-10917,
  -10291,-9603,-8861,-8072,-7245,-6386,-5504,-4607,
  -3701,-2795,-1895,-1008,-141,700,1509,2282,
  3012,3695,4328,4906,5428,5890,6290,6627,
  6900,7109,7254,7335,7353,7310,7208,7050,
  6838,6575,6264,5910,5516,5086,4625,4138,
  3628,3101,2561,2013,1461,910,364,-172,
  -694,-1199,-1682,-2141,-2572,-2973,-3340,-3672,
  -3966,-4222,-4438,-4613,-4746,-4838,-4889,-4899,
  -4868,-4799,-4692,-4550,-4373,-4164,-3926,-3661,
  -3371,-3060,-2731,-2386,-2029,-1662,-1289,-913,
  -538,-165,202,560,906,1239,1555,1853,
  2130,2384,2615,2820,2999,3151,3274,3369,
  3435,3473,3483,3464,3418,3346,3249,3128,
  2984,2820,2636,2434,2218,1987,1746,1495,
  1236,973,707,440,175,-87,-344,-593,
  -833,-1062,-1279,-1482,-1670,-1842,-1996,-2133,
  -2250,-2348,-2426,-2484,-2522,-2541,-2539,-2518,
  -2479,-2421,-2346,-2254,-2148,-2026,-1892,-1746,
  -1590,-1424,-1251,-1071,-887,-699,-510,-320,
  -132,55,237,415,586,750,905,1051,
  1187,1312,1425,1526,1614,1689,1751,1799,
  1833,1854,1861,1856,1837,1806,1763,1709,
  1644,1569,1485,1392,1292,1184,1071,953,
  831,706,578,450,321,192,65,-60,
  -183,-301,-415,-525,-628,-726,-817,-901,
  -978,-1047,-1109,-1162,-1208,-1245,-1275,-1296,
  -1309,-1315,-1313,-1304,-1289,-1266,-1237,-1203,
  -1163,-1118,-1069,-1015,-958,-898,-836,-771,
  -705,-638,-570,-502,-434,-366,-300,-235,
  -171,-110,-51,6,59,110,158,203,
  244,282,316,347,375,399,419,436,
  450,461,469,474,476,476,473,468,
  461,452,441,429,416,401,385,369,
  352,334,316,298,280,262,245,227,
  210,193,177,162,147,133,119,107,
  95,84,74,64,56,48,41,34,
  29,23,19,15,12,9,6,4
};

int_4 d2awgm3_polyfir_48 [] = {
  4,5,7,8,10,12,14,17,
  20,23,26,29,33,37,42,46,
  52,57,63,69,75,82,89,97,
  105,113,121,130,139,149,159,169,
  179,190,201,212,224,235,247,259,
  271,283,295,307,319,330,342,354,
  365,376,387,397,407,417,426,434,
  442,449,455,461,465,469,472,474,
  475,474,473,470,466,461,454,446,
  437,426,414,400,385,368,350,330,
  309,286,261,235,208,179,148,116,
  83,48,13,-25,-63,-102,-143,-184,
  -226,-269,-313,-357,-402,-447,-492,-538,
  -583,-628,-673,-718,-762,-805,-848,-889,
  -930,-969,-1007,-1043,-1078,-1111,-1142,-1171,
  -1197,-1221,-1243,-1262,-1278,-1292,-1302,-1310,
  -1314,-1315,-1313,-1308,-1299,-1286,-1270,-1250,
  -1227,-1200,-1170,-1136,-1098,-1057,-1013,-965,
  -914,-859,-801,-741,-677,-610,-541,-470,
  -396,-319,-241,-161,-80,3,87,172,
  257,343,429,515,601,686,770,853,
  934,1014,1091,1167,1240,1310,1377,1440,
  1500,1556,1608,1656,1699,1738,1772,1800,
  1823,1841,1854,1860,1861,1856,1845,1828,
  1805,1776,1741,1700,1653,1600,1541,1476,
  1406,1331,1250,1164,1074,979,879,775,
  668,557,443,326,206,84,-39,-164,
  -290,-416,-543,-669,-794,-919,-1042,-1163,
  -1281,-1396,-1509,-1617,-1721,-1821,-1916,-2005,
  -2089,-2167,-2238,-2303,-2360,-2410,-2452,-2487,
  -2513,-2531,-2541,-2542,-2534,-2517,-2492,-2458,
  -2414,-2362,-2301,-2231,-2153,-2066,-1971,-1868,
  -1758,-1639,-1514,-1382,-1243,-1099,-948,-793,
  -633,-468,-301,-129,44,220,397,574,
  752,930,1106,1281,1453,1622,1787,1948,
  2105,2255,2400,2538,2668,2791,2905,3010,
  3106,3192,3267,3332,3386,3428,3458,3477,
  3483,3477,3458,3426,3382,3325,3255,3173,
  3078,2971,2851,2720,2578,2424,2259,2084,
  1900,1706,1503,1292,1074,849,618,381,
  141,-104,-351,-601,-851,-1102,-1352,-1601,
  -1847,-2090,-2328,-2561,-2788,-3007,-3219,-3422,
  -3615,-3797,-3968,-4127,-4273,-4405,-4523,-4626,
  -4713,-4784,-4839,-4876,-4896,-4899,-4883,-4849,
  -4797,-4727,-4638,-4530,-4404,-4260,-4099,-3919,
  -3723,-3510,-3280,-3036,-2776,-2502,-2214,-1914,
  -1603,-1280,-948,-608,-259,95,455,819,
  1185,1553,1921,2288,2652,3012,3367,3715,
  4055,4385,4705,5012,5306,5584,5847,6092,
  6319,6526,6713,6877,7018,7136,7229,7297,
  7339,7354,7342,7302,7234,7137,7012,6859,
  6677,6466,6227,5960,5666,5345,4997,4624,
  4225,3803,3359,2892,2406,1900,1376,837,
  282,-285,-863,-1450,-2045,-2645,-3248,-3853,
  -4457,-5058,-5653,-6241,-6819,-7385,-7937,-8472,
  -8988,-9483,-9954,-10400,-10817,-11204,-11559,-11880,
  -12163,-12409,-12614,-12777,-12896,-12969,-12996,-12974,
  -12902,-12778,-12603,-12374,-12092,-11754,-11362,-10913,
  -10408,-9847,-9230,-8556,-7826,-7041,-6201,-5307,
  -4360,-3360,-2309,-1208,-59,1137,2378,3662,
  4988,6352,7753,9188,10655,12152,13675,15221,
  16789,18374,19975,21587,23207,24833,26461,28088,
  29711,31325,32928,34517,36088,37638,39163,40660,
  42126,43558,44953,46307,47619,48884,50099,51264,
  52374,53427,54421,55354,56223,57027,57764,58432,
  59030,59556,60009,60388,60692,60921,61074,61151,
  61151,61074,60921,60692,60388,60009,59556,59030,
  58432,57764,57027,56223,55354,54421,53427,52374,
  51264,50099,48884,47619,46307,44953,43558,42126,
  40660,39163,37638,36088,34517,32928,31325,29711,
  28088,26461,24833,23207,21587,19975,18374,16789,
  15221,13675,12152,10655,9188,7753,6352,4988,
  3662,2378,1137,-59,-1208,-2309,-3360,-4360,
  -5307,-6201,-7041,-7826,-8556,-9230,-9847,-10408,
  -10913,-11362,-11754,-12092,-12374,-12603,-12778,-12902,
  -12974,-12996,-12969,-12896,-12777,-12614,-12409,-12163,
  -11880,-11559,-11204,-10817,-10400,-9954,-9483,-8988,
  -8472,-7937,-7385,-6819,-6241,-5653,-5058,-4457,
  -3853,-3248,-2645,-2045,-1450,-863,-285,282,
  837,1376,1900,2406,2892,3359,3803,4225,
  4624,4997,5345,5666,5960,6227,6466,6677,
  6859,7012,7137,7234,7302,7342,7354,7339,
  7297,7229,7136,7018,6877,6713,6526,6319,
  6092,5847,5584,5306,5012,4705,4385,4055,
  3715,3367,3012,2652,2288,1921,1553,1185,
  819,455,95,-259,-608,-948,-1280,-1603,
  -1914,-2214,-2502,-2776,-3036,-3280,-3510,-3723,
  -3919,-4099,-4260,-4404,-4530,-4638,-4727,-4797,
  -4849,-4883,-4899,-4896,-4876,-4839,-4784,-4713,
  -4626,-4523,-4405,-4273,-4127,-3968,-3797,-3615,
  -3422,-3219,-3007,-2788,-2561,-2328,-2090,-1847,
  -1601,-1352,-1102,-851,-601,-351,-104,141,
  381,618,849,1074,1292,1503,1706,1900,
  2084,2259,2424,2578,2720,2851,2971,3078,
  3173,3255,3325,3382,3426,3458,3477,3483,
  3477,3458,3428,3386,3332,3267,3192,3106,
  3010,2905,2791,2668,2538,2400,2255,2105,
  1948,1787,1622,1453,1281,1106,930,752,
  574,397,220,44,-129,-301,-468,-633,
  -793,-948,-1099,-1243,-1382,-1514,-1639,-1758,
  -1868,-1971,-2066,-2153,-2231,-2301,-2362,-2414,
  -2458,-2492,-2517,-2534,-2542,-2541,-2531,-2513,
  -2487,-2452,-2410,-2360,-2303,-2238,-2167,-2089,
  -2005,-1916,-1821,-1721,-1617,-1509,-1396,-1281,
  -1163,-1042,-919,-794,-669,-543,-416,-290,
  -164,-39,84,206,326,443,557,668,
  775,879,979,1074,1164,1250,1331,1406,
  1476,1541,1600,1653,1700,1741,1776,1805,
  1828,1845,1856,1861,1860,1854,1841,1823,
  1800,1772,1738,1699,1656,1608,1556,1500,
  1440,1377,1310,1240,1167,1091,1014,934,
  853,770,686,601,515,429,343,257,
  172,87,3,-80,-161,-241,-319,-396,
  -470,-541,-610,-677,-741,-801,-859,-914,
  -965,-1013,-1057,-1098,-1136,-1170,-1200,-1227,
  -1250,-1270,-1286,-1299,-1308,-1313,-1315,-1314,
  -1310,-1302,-1292,-1278,-1262,-1243,-1221,-1197,
  -1171,-1142,-1111,-1078,-1043,-1007,-969,-930,
  -889,-848,-805,-762,-718,-673,-628,-583,
  -538,-492,-447,-402,-357,-313,-269,-226,
  -184,-143,-102,-63,-25,13,48,83,
  116,148,179,208,235,261,286,309,
  330,350,368,385,400,414,426,437,
  446,454,461,466,470,473,474,475,
  474,472,469,465,461,455,449,442,
  434,426,417,407,397,387,376,365,
  354,342,330,319,307,295,283,271,
  259,247,235,224,212,201,190,179,
  169,159,149,139,130,121,113,105,
  97,89,82,75,69,63,57,52,
  46,42,37,33,29,26,23,20,
  17,14,12,10,8,7,5,4
};

int_4 d2awgm3_polyfir_50 [] = {
  4,5,7,8,10,12,14,16,
  19,21,24,28,31,35,39,43,
  48,53,58,64,70,76,83,90,
  97,104,112,120,129,138,147,156,
  166,176,186,196,207,218,229,240,
  251,263,274,286,297,309,320,331,
  343,354,365,375,386,396,405,415,
  423,431,439,446,452,458,463,467,
  470,473,474,474,474,472,469,465,
  460,454,446,437,427,415,402,388,
  372,355,336,316,294,271,247,221,
  194,166,136,105,73,39,4,-31,
  -68,-106,-145,-185,-225,-267,-309,-351,
  -394,-437,-480,-524,-568,-611,-654,-697,
  -740,-782,-823,-864,-903,-942,-979,-1015,
  -1050,-1083,-1114,-1144,-1171,-1197,-1220,-1241,
  -1260,-1276,-1289,-1300,-1308,-1313,-1315,-1315,
  -1311,-1303,-1293,-1280,-1263,-1243,-1219,-1193,
  -1163,-1129,-1093,-1053,-1010,-964,-915,-862,
  -807,-749,-688,-625,-559,-491,-421,-348,
  -274,-198,-121,-42,38,119,201,283,
  366,448,531,613,694,775,854,933,
  1009,1084,1157,1227,1295,1360,1422,1480,
  1536,1587,1635,1678,1718,1753,1783,1809,
  1829,1845,1856,1861,1861,1855,1844,1828,
  1805,1778,1745,1706,1662,1612,1557,1496,
  1431,1360,1285,1204,1120,1031,937,840,
  739,635,527,417,304,189,72,-47,
  -167,-287,-409,-530,-651,-772,-892,-1010,
  -1127,-1241,-1353,-1462,-1568,-1670,-1768,-1862,
  -1951,-2035,-2113,-2186,-2253,-2313,-2367,-2414,
  -2455,-2487,-2513,-2530,-2540,-2542,-2536,-2522,
  -2499,-2469,-2430,-2383,-2328,-2264,-2193,-2114,
  -2027,-1933,-1832,-1723,-1607,-1485,-1357,-1223,
  -1084,-939,-790,-636,-478,-317,-154,13,
  181,351,521,692,862,1032,1201,1367,
  1531,1692,1849,2002,2151,2294,2431,2562,
  2686,2803,2912,3012,3104,3187,3260,3324,
  3377,3420,3452,3473,3482,3480,3467,3442,
  3406,3357,3297,3225,3142,3047,2941,2824,
  2695,2557,2408,2249,2081,1903,1718,1524,
  1322,1114,899,678,453,223,-11,-247,
  -486,-726,-967,-1208,-1447,-1685,-1920,-2152,
  -2380,-2602,-2819,-3029,-3231,-3426,-3611,-3786,
  -3951,-4105,-4247,-4377,-4493,-4596,-4685,-4759,
  -4818,-4861,-4889,-4900,-4894,-4873,-4834,-4778,
  -4705,-4615,-4509,-4385,-4245,-4088,-3915,-3727,
  -3523,-3304,-3071,-2824,-2563,-2290,-2006,-1710,
  -1404,-1089,-765,-434,-97,246,593,943,
  1296,1649,2002,2354,2703,3048,3388,3722,
  4048,4366,4673,4970,5254,5525,5781,6021,
  6244,6450,6637,6804,6951,7076,7178,7258,
  7314,7346,7353,7335,7292,7222,7126,7004,
  6855,6681,6479,6252,5999,5721,5417,5090,
  4738,4363,3967,3548,3109,2651,2175,1682,
  1173,650,113,-434,-991,-1557,-2129,-2705,
  -3285,-3865,-4445,-5022,-5594,-6159,-6716,-7262,
  -7795,-8314,-8815,-9298,-9759,-10198,-10612,-10999,
  -11357,-11685,-11980,-12241,-12466,-12654,-12802,-12909,
  -12974,-12996,-12973,-12904,-12787,-12623,-12410,-12147,
  -11833,-11469,-11053,-10586,-10067,-9496,-8873,-8198,
  -7472,-6695,-5868,-4991,-4065,-3091,-2071,-1004,
  106,1260,2454,3689,4961,6269,7611,8985,
  10389,11820,13276,14755,16254,17770,19301,20844,
  22396,23955,25517,27080,28641,30196,31743,33279,
  34801,36306,37791,39253,40690,42097,43473,44815,
  46120,47386,48609,49788,50920,52003,53034,54011,
  54933,55797,56601,57345,58026,58643,59195,59681,
  60099,60448,60729,60940,61081,61151,61151,61081,
  60940,60729,60448,60099,59681,59195,58643,58026,
  57345,56601,55797,54933,54011,53034,52003,50920,
  49788,48609,47386,46120,44815,43473,42097,40690,
  39253,37791,36306,34801,33279,31743,30196,28641,
  27080,25517,23955,22396,20844,19301,17770,16254,
  14755,13276,11820,10389,8985,7611,6269,4961,
  3689,2454,1260,106,-1004,-2071,-3091,-4065,
  -4991,-5868,-6695,-7472,-8198,-8873,-9496,-10067,
  -10586,-11053,-11469,-11833,-12147,-12410,-12623,-12787,
  -12904,-12973,-12996,-12974,-12909,-12802,-12654,-12466,
  -12241,-11980,-11685,-11357,-10999,-10612,-10198,-9759,
  -9298,-8815,-8314,-7795,-7262,-6716,-6159,-5594,
  -5022,-4445,-3865,-3285,-2705,-2129,-1557,-991,
  -434,113,650,1173,1682,2175,2651,3109,
  3548,3967,4363,4738,5090,5417,5721,5999,
  6252,6479,6681,6855,7004,7126,7222,7292,
  7335,7353,7346,7314,7258,7178,7076,6951,
  6804,6637,6450,6244,6021,5781,5525,5254,
  4970,4673,4366,4048,3722,3388,3048,2703,
  2354,2002,1649,1296,943,593,246,-97,
  -434,-765,-1089,-1404,-1710,-2006,-2290,-2563,
  -2824,-3071,-3304,-3523,-3727,-3915,-4088,-4245,
  -4385,-4509,-4615,-4705,-4778,-4834,-4873,-4894,
  -4900,-4889,-4861,-4818,-4759,-4685,-4596,-4493,
  -4377,-4247,-4105,-3951,-3786,-3611,-3426,-3231,
  -3029,-2819,-2602,-2380,-2152,-1920,-1685,-1447,
  -1208,-967,-726,-486,-247,-11,223,453,
  678,899,1114,1322,1524,1718,1903,2081,
  2249,2408,2557,2695,2824,2941,3047,3142,
  3225,3297,3357,3406,3442,3467,3480,3482,
  3473,3452,3420,3377,3324,3260,3187,3104,
  3012,2912,2803,2686,2562,2431,2294,2151,
  2002,1849,1692,1531,1367,1201,1032,862,
  692,521,351,181,13,-154,-317,-478,
  -636,-790,-939,-1084,-1223,-1357,-1485,-1607,
  -1723,-1832,-1933,-2027,-2114,-2193,-2264,-2328,
  -2383,-2430,-2469,-2499,-2522,-2536,-2542,-2540,
  -2530,-2513,-2487,-2455,-2414,-2367,-2313,-2253,
  -2186,-2113,-2035,-1951,-1862,-1768,-1670,-1568,
  -1462,-1353,-1241,-1127,-1010,-892,-772,-651,
  -530,-409,-287,-167,-47,72,189,304,
  417,527,635,739,840,937,1031,1120,
  1204,1285,1360,1431,1496,1557,1612,1662,
  1706,1745,1778,1805,1828,1844,1855,1861,
  1861,1856,1845,1829,1809,1783,1753,1718,
  1678,1635,1587,1536,1480,1422,1360,1295,
  1227,1157,1084,1009,933,854,775,694,
  613,531,448,366,283,201,119,38,
  -42,-121,-198,-274,-348,-421,-491,-559,
  -625,-688,-749,-807,-862,-915,-964,-1010,
  -1053,-1093,-1129,-1163,-1193,-1219,-1243,-1263,
  -1280,-1293,-1303,-1311,-1315,-1315,-1313,-1308,
  -1300,-1289,-1276,-1260,-1241,-1220,-1197,-1171,
  -1144,-1114,-1083,-1050,-1015,-979,-942,-903,
  -864,-823,-782,-740,-697,-654,-611,-568,
  -524,-480,-437,-394,-351,-309,-267,-225,
  -185,-145,-106,-68,-31,4,39,73,
  105,136,166,194,221,247,271,294,
  316,336,355,372,388,402,415,427,
  437,446,454,460,465,469,472,474,
  474,474,473,470,467,463,458,452,
  446,439,431,423,415,405,396,386,
  375,365,354,343,331,320,309,297,
  286,274,263,251,240,229,218,207,
  196,186,176,166,156,147,138,129,
  120,112,104,97,90,83,76,70,
  64,58,53,48,43,39,35,31,
  28,24,21,19,16,14,12,10,
  8,7,5,4
};

int_4 d2awgm3_polyfir_64 [] = {
  4,5,6,7,8,9,11,12,
  14,16,18,20,22,25,27,30,
  33,36,39,42,46,50,53,58,
  62,66,71,76,81,86,92,98,
  103,109,116,122,129,136,143,150,
  157,165,173,180,188,197,205,213,
  222,230,239,248,257,266,275,284,
  293,302,311,320,329,337,346,355,
  363,372,380,388,395,403,410,417,
  424,430,436,442,447,452,457,461,
  464,467,470,472,473,474,474,473,
  472,471,468,465,461,456,451,445,
  437,430,421,412,401,390,378,365,
  351,337,321,305,288,270,251,231,
  210,189,167,144,120,95,69,43,
  16,-11,-40,-68,-98,-128,-159,-190,
  -222,-254,-286,-319,-352,-386,-419,-453,
  -487,-521,-555,-589,-623,-657,-691,-724,
  -757,-790,-822,-854,-885,-915,-945,-974,
  -1003,-1030,-1057,-1083,-1107,-1131,-1153,-1174,
  -1194,-1213,-1230,-1246,-1260,-1273,-1284,-1294,
  -1301,-1308,-1312,-1315,-1315,-1314,-1311,-1307,
  -1300,-1291,-1280,-1268,-1253,-1236,-1217,-1197,
  -1174,-1149,-1122,-1093,-1062,-1030,-995,-958,
  -920,-880,-837,-794,-748,-701,-652,-601,
  -550,-496,-442,-386,-329,-270,-211,-151,
  -90,-28,35,98,162,226,290,354,
  419,484,548,612,676,739,802,863,
  924,985,1044,1101,1158,1213,1267,1319,
  1369,1417,1463,1508,1550,1590,1627,1662,
  1694,1724,1751,1776,1797,1815,1831,1843,
  1852,1858,1861,1861,1857,1850,1839,1825,
  1808,1787,1763,1736,1705,1671,1633,1592,
  1548,1501,1451,1397,1340,1281,1218,1153,
  1085,1015,941,866,788,708,626,542,
  457,369,281,191,99,7,-86,-180,
  -274,-369,-464,-559,-654,-748,-842,-935,
  -1027,-1118,-1208,-1296,-1382,-1467,-1550,-1631,
  -1709,-1785,-1858,-1928,-1995,-2059,-2119,-2176,
  -2230,-2279,-2325,-2367,-2404,-2437,-2466,-2491,
  -2510,-2525,-2536,-2541,-2542,-2538,-2529,-2515,
  -2495,-2471,-2442,-2408,-2369,-2325,-2276,-2222,
  -2163,-2100,-2031,-1959,-1881,-1800,-1714,-1624,
  -1530,-1432,-1330,-1225,-1117,-1005,-890,-773,
  -653,-530,-406,-279,-151,-21,110,242,
  375,508,641,775,908,1040,1172,1302,
  1432,1559,1685,1808,1929,2047,2162,2274,
  2382,2487,2588,2684,2776,2863,2946,3023,
  3095,3161,3221,3276,3325,3367,3403,3432,
  3455,3471,3481,3483,3478,3466,3447,3421,
  3388,3348,3300,3245,3184,3115,3039,2956,
  2867,2771,2668,2559,2443,2322,2195,2062,
  1923,1779,1630,1477,1319,1156,990,820,
  647,470,291,110,-74,-259,-445,-632,
  -820,-1009,-1196,-1384,-1570,-1755,-1939,-2120,
  -2299,-2474,-2647,-2816,-2980,-3141,-3296,-3446,
  -3591,-3730,-3863,-3989,-4108,-4220,-4324,-4420,
  -4509,-4589,-4660,-4723,-4776,-4820,-4855,-4880,
  -4895,-4900,-4895,-4880,-4855,-4819,-4773,-4716,
  -4650,-4572,-4485,-4387,-4279,-4161,-4033,-3895,
  -3748,-3591,-3425,-3250,-3067,-2875,-2674,-2466,
  -2251,-2028,-1799,-1563,-1321,-1074,-821,-564,
  -303,-38,230,501,774,1048,1324,1600,
  1876,2151,2425,2698,2968,3235,3499,3758,
  4013,4263,4507,4744,4974,5197,5412,5618,
  5815,6003,6180,6346,6502,6645,6777,6896,
  7002,7095,7174,7239,7290,7326,7348,7354,
  7345,7320,7280,7223,7151,7062,6958,6837,
  6701,6548,6380,6195,5995,5779,5548,5302,
  5042,4766,4477,4174,3857,3528,3186,2832,
  2467,2091,1705,1309,905,492,71,-357,
  -790,-1229,-1673,-2120,-2570,-3022,-3475,-3929,
  -4382,-4833,-5282,-5727,-6168,-6604,-7033,-7455,
  -7869,-8274,-8668,-9051,-9423,-9781,-10125,-10454,
  -10767,-11063,-11341,-11601,-11842,-12061,-12260,-12437,
  -12591,-12721,-12827,-12908,-12963,-12991,-12993,-12967,
  -12913,-12831,-12719,-12577,-12406,-12204,-11972,-11708,
  -11414,-11088,-10730,-10341,-9920,-9468,-8983,-8468,
  -7921,-7342,-6733,-6092,-5422,-4721,-3990,-3231,
  -2443,-1626,-782,89,986,1908,2855,3826,
  4820,5836,6873,7931,9007,10102,11213,12341,
  13483,14639,15807,16986,18176,19373,20578,21789,
  23005,24223,25444,26665,27885,29103,30317,31526,
  32729,33923,35108,36283,37445,38594,39728,40845,
  41945,43025,44086,45125,46140,47132,48098,49038,
  49950,50833,51686,52508,53298,54055,54778,55466,
  56118,56733,57311,57851,58352,58814,59235,59616,
  59956,60254,60511,60725,60897,61026,61112,61155,
  61155,61112,61026,60897,60725,60511,60254,59956,
  59616,59235,58814,58352,57851,57311,56733,56118,
  55466,54778,54055,53298,52508,51686,50833,49950,
  49038,48098,47132,46140,45125,44086,43025,41945,
  40845,39728,38594,37445,36283,35108,33923,32729,
  31526,30317,29103,27885,26665,25444,24223,23005,
  21789,20578,19373,18176,16986,15807,14639,13483,
  12341,11213,10102,9007,7931,6873,5836,4820,
  3826,2855,1908,986,89,-782,-1626,-2443,
  -3231,-3990,-4721,-5422,-6092,-6733,-7342,-7921,
  -8468,-8983,-9468,-9920,-10341,-10730,-11088,-11414,
  -11708,-11972,-12204,-12406,-12577,-12719,-12831,-12913,
  -12967,-12993,-12991,-12963,-12908,-12827,-12721,-12591,
  -12437,-12260,-12061,-11842,-11601,-11341,-11063,-10767,
  -10454,-10125,-9781,-9423,-9051,-8668,-8274,-7869,
  -7455,-7033,-6604,-6168,-5727,-5282,-4833,-4382,
  -3929,-3475,-3022,-2570,-2120,-1673,-1229,-790,
  -357,71,492,905,1309,1705,2091,2467,
  2832,3186,3528,3857,4174,4477,4766,5042,
  5302,5548,5779,5995,6195,6380,6548,6701,
  6837,6958,7062,7151,7223,7280,7320,7345,
  7354,7348,7326,7290,7239,7174,7095,7002,
  6896,6777,6645,6502,6346,6180,6003,5815,
  5618,5412,5197,4974,4744,4507,4263,4013,
  3758,3499,3235,2968,2698,2425,2151,1876,
  1600,1324,1048,774,501,230,-38,-303,
  -564,-821,-1074,-1321,-1563,-1799,-2028,-2251,
  -2466,-2674,-2875,-3067,-3250,-3425,-3591,-3748,
  -3895,-4033,-4161,-4279,-4387,-4485,-4572,-4650,
  -4716,-4773,-4819,-4855,-4880,-4895,-4900,-4895,
  -4880,-4855,-4820,-4776,-4723,-4660,-4589,-4509,
  -4420,-4324,-4220,-4108,-3989,-3863,-3730,-3591,
  -3446,-3296,-3141,-2980,-2816,-2647,-2474,-2299,
  -2120,-1939,-1755,-1570,-1384,-1196,-1009,-820,
  -632,-445,-259,-74,110,291,470,647,
  820,990,1156,1319,1477,1630,1779,1923,
  2062,2195,2322,2443,2559,2668,2771,2867,
  2956,3039,3115,3184,3245,3300,3348,3388,
  3421,3447,3466,3478,3483,3481,3471,3455,
  3432,3403,3367,3325,3276,3221,3161,3095,
  3023,2946,2863,2776,2684,2588,2487,2382,
  2274,2162,2047,1929,1808,1685,1559,1432,
  1302,1172,1040,908,775,641,508,375,
  242,110,-21,-151,-279,-406,-530,-653,
  -773,-890,-1005,-1117,-1225,-1330,-1432,-1530,
  -1624,-1714,-1800,-1881,-1959,-2031,-2100,-2163,
  -2222,-2276,-2325,-2369,-2408,-2442,-2471,-2495,
  -2515,-2529,-2538,-2542,-2541,-2536,-2525,-2510,
  -2491,-2466,-2437,-2404,-2367,-2325,-2279,-2230,
  -2176,-2119,-2059,-1995,-1928,-1858,-1785,-1709,
  -1631,-1550,-1467,-1382,-1296,-1208,-1118,-1027,
  -935,-842,-748,-654,-559,-464,-369,-274,
  -180,-86,7,99,191,281,369,457,
  542,626,708,788,866,941,1015,1085,
  1153,1218,1281,1340,1397,1451,1501,1548,
  1592,1633,1671,1705,1736,1763,1787,1808,
  1825,1839,1850,1857,1861,1861,1858,1852,
  1843,1831,1815,1797,1776,1751,1724,1694,
  1662,1627,1590,1550,1508,1463,1417,1369,
  1319,1267,1213,1158,1101,1044,985,924,
  863,802,739,676,612,548,484,419,
  354,290,226,162,98,35,-28,-90,
  -151,-211,-270,-329,-386,-442,-496,-550,
  -601,-652,-701,-748,-794,-837,-880,-920,
  -958,-995,-1030,-1062,-1093,-1122,-1149,-1174,
  -1197,-1217,-1236,-1253,-1268,-1280,-1291,-1300,
  -1307,-1311,-1314,-1315,-1315,-1312,-1308,-1301,
  -1294,-1284,-1273,-1260,-1246,-1230,-1213,-1194,
  -1174,-1153,-1131,-1107,-1083,-1057,-1030,-1003,
  -974,-945,-915,-885,-854,-822,-790,-757,
  -724,-691,-657,-623,-589,-555,-521,-487,
  -453,-419,-386,-352,-319,-286,-254,-222,
  -190,-159,-128,-98,-68,-40,-11,16,
  43,69,95,120,144,167,189,210,
  231,251,270,288,305,321,337,351,
  365,378,390,401,412,421,430,437,
  445,451,456,461,465,468,471,472,
  473,474,474,473,472,470,467,464,
  461,457,452,447,442,436,430,424,
  417,410,403,395,388,380,372,363,
  355,346,337,329,320,311,302,293,
  284,275,266,257,248,239,230,222,
  213,205,197,188,180,173,165,157,
  150,143,136,129,122,116,109,103,
  98,92,86,81,76,71,66,62,
  58,53,50,46,42,39,36,33,
  30,27,25,22,20,18,16,14,
  12,11,9,8,7,6,5,4
};

int_4 d2awgm3_polyfir_72 [] = {
  4,5,5,6,7,9,10,11,
  12,14,16,17,19,21,23,25,
  27,30,32,35,38,41,44,47,
  51,54,58,62,66,70,74,78,
  83,88,93,98,103,108,114,120,
  125,131,138,144,150,157,164,170,
  177,184,192,199,206,214,221,229,
  237,244,252,260,268,276,284,292,
  300,308,316,324,332,340,347,355,
  363,370,377,385,391,398,405,411,
  418,424,429,435,440,445,449,453,
  457,461,464,467,469,471,472,473,
  474,474,473,472,471,469,466,463,
  459,455,450,444,438,431,423,415,
  406,397,387,376,364,352,339,326,
  311,296,281,264,247,230,211,192,
  173,152,131,110,88,65,42,18,
  -7,-32,-57,-83,-110,-137,-164,-192,
  -220,-249,-277,-306,-336,-365,-395,-425,
  -455,-485,-516,-546,-576,-606,-636,-666,
  -696,-726,-755,-784,-813,-841,-869,-897,
  -924,-950,-976,-1001,-1026,-1050,-1073,-1095,
  -1117,-1137,-1157,-1176,-1193,-1210,-1225,-1240,
  -1253,-1265,-1276,-1286,-1294,-1301,-1307,-1311,
  -1314,-1315,-1315,-1314,-1311,-1306,-1300,-1293,
  -1283,-1273,-1260,-1247,-1231,-1214,-1195,-1175,
  -1153,-1130,-1105,-1078,-1050,-1020,-989,-956,
  -922,-886,-849,-811,-771,-730,-687,-643,
  -599,-552,-505,-457,-407,-357,-306,-254,
  -201,-147,-93,-38,18,73,130,187,
  244,301,358,416,473,530,587,644,
  700,756,812,867,921,975,1027,1079,
  1130,1180,1228,1275,1321,1366,1409,1451,
  1491,1529,1566,1600,1633,1664,1693,1720,
  1744,1767,1787,1805,1820,1833,1844,1852,
  1858,1861,1861,1859,1855,1847,1837,1825,
  1809,1791,1770,1747,1721,1692,1661,1627,
  1590,1551,1509,1465,1418,1369,1318,1264,
  1208,1149,1089,1026,962,896,827,757,
  686,612,538,461,384,305,226,145,
  63,-19,-102,-185,-269,-353,-438,-522,
  -606,-690,-774,-857,-940,-1022,-1103,-1183,
  -1262,-1339,-1416,-1491,-1564,-1635,-1705,-1772,
  -1838,-1901,-1962,-2020,-2076,-2129,-2179,-2227,
  -2271,-2313,-2351,-2386,-2418,-2446,-2471,-2492,
  -2509,-2523,-2533,-2540,-2542,-2541,-2536,-2527,
  -2514,-2497,-2476,-2451,-2422,-2389,-2352,-2312,
  -2267,-2219,-2166,-2110,-2051,-1987,-1921,-1850,
  -1776,-1699,-1619,-1535,-1448,-1359,-1266,-1171,
  -1074,-973,-871,-766,-659,-551,-440,-328,
  -215,-100,15,132,249,367,486,604,
  723,841,960,1077,1194,1310,1425,1538,
  1650,1760,1869,1975,2079,2181,2280,2377,
  2470,2560,2647,2731,2811,2887,2959,3027,
  3091,3150,3205,3256,3301,3342,3378,3408,
  3434,3454,3469,3479,3483,3481,3474,3462,
  3443,3420,3390,3355,3314,3268,3215,3158,
  3094,3026,2952,2872,2787,2697,2602,2502,
  2397,2287,2173,2054,1931,1803,1672,1537,
  1398,1256,1110,962,810,656,500,341,
  181,18,-145,-310,-476,-643,-810,-977,
  -1144,-1311,-1477,-1643,-1807,-1969,-2130,-2289,
  -2445,-2599,-2751,-2899,-3043,-3184,-3322,-3455,
  -3583,-3707,-3827,-3940,-4049,-4152,-4249,-4341,
  -4426,-4504,-4576,-4641,-4699,-4751,-4794,-4831,
  -4860,-4881,-4894,-4900,-4897,-4887,-4869,-4842,
  -4807,-4764,-4713,-4654,-4586,-4510,-4426,-4334,
  -4234,-4127,-4011,-3887,-3756,-3618,-3472,-3319,
  -3160,-2993,-2820,-2640,-2454,-2263,-2066,-1863,
  -1655,-1443,-1225,-1004,-779,-550,-317,-82,
  155,395,637,880,1125,1370,1615,1860,
  2105,2349,2592,2833,3072,3309,3542,3773,
  3999,4222,4440,4653,4860,5062,5258,5447,
  5630,5805,5972,6132,6283,6425,6559,6683,
  6798,6902,6997,7080,7154,7216,7267,7306,
  7334,7350,7354,7346,7325,7292,7247,7189,
  7118,7035,6939,6830,6709,6575,6428,6269,
  6097,5913,5717,5508,5288,5056,4813,4559,
  4293,4017,3731,3434,3128,2812,2488,2155,
  1813,1464,1108,745,375,0,-381,-766,
  -1156,-1549,-1946,-2345,-2746,-3148,-3551,-3954,
  -4357,-4758,-5158,-5555,-5948,-6338,-6724,-7104,
  -7479,-7846,-8207,-8560,-8904,-9239,-9563,-9878,
  -10181,-10471,-10750,-11015,-11266,-11502,-11724,-11930,
  -12119,-12291,-12446,-12583,-12701,-12800,-12879,-12938,
  -12977,-12995,-12991,-12965,-12917,-12846,-12753,-12636,
  -12495,-12331,-12143,-11930,-11693,-11431,-11144,-10832,
  -10496,-10134,-9748,-9336,-8900,-8438,-7952,-7441,
  -6905,-6345,-5761,-5153,-4521,-3866,-3188,-2487,
  -1764,-1019,-253,534,1341,2169,3015,3881,
  4764,5665,6583,7517,8467,9431,10409,11400,
  12404,13419,14446,15482,16527,17580,18640,19707,
  20780,21856,22937,24020,25105,26190,27275,28359,
  29441,30519,31593,32662,33725,34780,35828,36866,
  37894,38910,39915,40906,41884,42847,43793,44723,
  45635,46529,47403,48257,49090,49900,50688,51452,
  52192,52907,53597,54259,54895,55503,56083,56633,
  57155,57646,58107,58537,58935,59302,59636,59938,
  60208,60444,60647,60816,60952,61054,61122,61156,
  61156,61122,61054,60952,60816,60647,60444,60208,
  59938,59636,59302,58935,58537,58107,57646,57155,
  56633,56083,55503,54895,54259,53597,52907,52192,
  51452,50688,49900,49090,48257,47403,46529,45635,
  44723,43793,42847,41884,40906,39915,38910,37894,
  36866,35828,34780,33725,32662,31593,30519,29441,
  28359,27275,26190,25105,24020,22937,21856,20780,
  19707,18640,17580,16527,15482,14446,13419,12404,
  11400,10409,9431,8467,7517,6583,5665,4764,
  3881,3015,2169,1341,534,-253,-1019,-1764,
  -2487,-3188,-3866,-4521,-5153,-5761,-6345,-6905,
  -7441,-7952,-8438,-8900,-9336,-9748,-10134,-10496,
  -10832,-11144,-11431,-11693,-11930,-12143,-12331,-12495,
  -12636,-12753,-12846,-12917,-12965,-12991,-12995,-12977,
  -12938,-12879,-12800,-12701,-12583,-12446,-12291,-12119,
  -11930,-11724,-11502,-11266,-11015,-10750,-10471,-10181,
  -9878,-9563,-9239,-8904,-8560,-8207,-7846,-7479,
  -7104,-6724,-6338,-5948,-5555,-5158,-4758,-4357,
  -3954,-3551,-3148,-2746,-2345,-1946,-1549,-1156,
  -766,-381,0,375,745,1108,1464,1813,
  2155,2488,2812,3128,3434,3731,4017,4293,
  4559,4813,5056,5288,5508,5717,5913,6097,
  6269,6428,6575,6709,6830,6939,7035,7118,
  7189,7247,7292,7325,7346,7354,7350,7334,
  7306,7267,7216,7154,7080,6997,6902,6798,
  6683,6559,6425,6283,6132,5972,5805,5630,
  5447,5258,5062,4860,4653,4440,4222,3999,
  3773,3542,3309,3072,2833,2592,2349,2105,
  1860,1615,1370,1125,880,637,395,155,
  -82,-317,-550,-779,-1004,-1225,-1443,-1655,
  -1863,-2066,-2263,-2454,-2640,-2820,-2993,-3160,
  -3319,-3472,-3618,-3756,-3887,-4011,-4127,-4234,
  -4334,-4426,-4510,-4586,-4654,-4713,-4764,-4807,
  -4842,-4869,-4887,-4897,-4900,-4894,-4881,-4860,
  -4831,-4794,-4751,-4699,-4641,-4576,-4504,-4426,
  -4341,-4249,-4152,-4049,-3940,-3827,-3707,-3583,
  -3455,-3322,-3184,-3043,-2899,-2751,-2599,-2445,
  -2289,-2130,-1969,-1807,-1643,-1477,-1311,-1144,
  -977,-810,-643,-476,-310,-145,18,181,
  341,500,656,810,962,1110,1256,1398,
  1537,1672,1803,1931,2054,2173,2287,2397,
  2502,2602,2697,2787,2872,2952,3026,3094,
  3158,3215,3268,3314,3355,3390,3420,3443,
  3462,3474,3481,3483,3479,3469,3454,3434,
  3408,3378,3342,3301,3256,3205,3150,3091,
  3027,2959,2887,2811,2731,2647,2560,2470,
  2377,2280,2181,2079,1975,1869,1760,1650,
  1538,1425,1310,1194,1077,960,841,723,
  604,486,367,249,132,15,-100,-215,
  -328,-440,-551,-659,-766,-871,-973,-1074,
  -1171,-1266,-1359,-1448,-1535,-1619,-1699,-1776,
  -1850,-1921,-1987,-2051,-2110,-2166,-2219,-2267,
  -2312,-2352,-2389,-2422,-2451,-2476,-2497,-2514,
  -2527,-2536,-2541,-2542,-2540,-2533,-2523,-2509,
  -2492,-2471,-2446,-2418,-2386,-2351,-2313,-2271,
  -2227,-2179,-2129,-2076,-2020,-1962,-1901,-1838,
  -1772,-1705,-1635,-1564,-1491,-1416,-1339,-1262,
  -1183,-1103,-1022,-940,-857,-774,-690,-606,
  -522,-438,-353,-269,-185,-102,-19,63,
  145,226,305,384,461,538,612,686,
  757,827,896,962,1026,1089,1149,1208,
  1264,1318,1369,1418,1465,1509,1551,1590,
  1627,1661,1692,1721,1747,1770,1791,1809,
  1825,1837,1847,1855,1859,1861,1861,1858,
  1852,1844,1833,1820,1805,1787,1767,1744,
  1720,1693,1664,1633,1600,1566,1529,1491,
  1451,1409,1366,1321,1275,1228,1180,1130,
  1079,1027,975,921,867,812,756,700,
  644,587,530,473,416,358,301,244,
  187,130,73,18,-38,-93,-147,-201,
  -254,-306,-357,-407,-457,-505,-552,-599,
  -643,-687,-730,-771,-811,-849,-886,-922,
  -956,-989,-1020,-1050,-1078,-1105,-1130,-1153,
  -1175,-1195,-1214,-1231,-1247,-1260,-1273,-1283,
  -1293,-1300,-1306,-1311,-1314,-1315,-1315,-1314,
  -1311,-1307,-1301,-1294,-1286,-1276,-1265,-1253,
  -1240,-1225,-1210,-1193,-1176,-1157,-1137,-1117,
  -1095,-1073,-1050,-1026,-1001,-976,-950,-924,
  -897,-869,-841,-813,-784,-755,-726,-696,
  -666,-636,-606,-576,-546,-516,-485,-455,
  -425,-395,-365,-336,-306,-277,-249,-220,
  -192,-164,-137,-110,-83,-57,-32,-7,
  18,42,65,88,110,131,152,173,
  192,211,230,247,264,281,296,311,
  326,339,352,364,376,387,397,406,
  415,423,431,438,444,450,455,459,
  463,466,469,471,472,473,474,474,
  473,472,471,469,467,464,461,457,
  453,449,445,440,435,429,424,418,
  411,405,398,391,385,377,370,363,
  355,347,340,332,324,316,308,300,
  292,284,276,268,260,252,244,237,
  229,221,214,206,199,192,184,177,
  170,164,157,150,144,138,131,125,
  120,114,108,103,98,93,88,83,
  78,74,70,66,62,58,54,51,
  47,44,41,38,35,32,30,27,
  25,23,21,19,17,16,14,12,
  11,10,9,7,6,5,5,4
};

int_4 d2awgm3_polyfir_84 [] = {
  4,4,5,6,7,8,9,10,
  11,12,13,15,16,17,19,21,
  22,24,26,28,30,32,35,37,
  39,42,45,47,50,53,56,60,
  63,66,70,74,77,81,85,90,
  94,98,103,107,112,117,122,127,
  132,137,142,148,154,159,165,171,
  177,183,189,195,201,208,214,221,
  227,234,241,247,254,261,268,274,
  281,288,295,302,309,315,322,329,
  336,342,349,356,362,368,375,381,
  387,393,399,404,410,415,420,425,
  430,435,439,444,448,451,455,458,
  461,464,466,468,470,471,472,473,
  474,474,473,473,472,470,468,466,
  463,460,457,453,448,443,438,432,
  426,419,412,404,396,387,378,368,
  358,347,336,324,312,299,286,272,
  258,243,228,212,196,180,162,145,
  127,108,89,70,50,29,9,-12,
  -34,-56,-78,-101,-123,-147,-170,-194,
  -218,-243,-267,-292,-317,-342,-368,-393,
  -419,-445,-470,-496,-522,-548,-574,-600,
  -626,-652,-677,-703,-728,-753,-778,-803,
  -827,-852,-875,-899,-922,-945,-967,-989,
  -1010,-1031,-1052,-1071,-1091,-1109,-1127,-1144,
  -1161,-1177,-1192,-1206,-1220,-1233,-1245,-1256,
  -1266,-1275,-1284,-1291,-1298,-1303,-1308,-1311,
  -1314,-1315,-1315,-1315,-1313,-1310,-1306,-1301,
  -1294,-1287,-1278,-1268,-1258,-1245,-1232,-1218,
  -1202,-1185,-1167,-1148,-1128,-1106,-1084,-1060,
  -1035,-1009,-982,-954,-924,-894,-863,-830,
  -797,-762,-727,-690,-653,-615,-576,-536,
  -495,-453,-411,-368,-324,-280,-235,-189,
  -143,-97,-50,-2,46,94,142,191,
  240,289,338,387,436,485,534,583,
  632,680,729,776,824,871,917,963,
  1009,1053,1097,1141,1183,1225,1265,1305,
  1344,1382,1418,1454,1488,1521,1553,1583,
  1612,1640,1666,1691,1714,1736,1756,1774,
  1791,1806,1819,1831,1840,1848,1854,1859,
  1861,1861,1860,1857,1851,1844,1835,1823,
  1810,1795,1778,1759,1738,1715,1690,1663,
  1634,1603,1571,1536,1500,1462,1422,1380,
  1336,1291,1244,1195,1145,1093,1040,985,
  929,871,812,752,691,628,564,500,
  434,367,300,231,162,93,22,-49,
  -120,-191,-263,-335,-408,-480,-552,-624,
  -696,-768,-840,-911,-981,-1051,-1120,-1189,
  -1256,-1323,-1389,-1453,-1517,-1579,-1640,-1700,
  -1758,-1815,-1870,-1923,-1975,-2024,-2072,-2118,
  -2162,-2204,-2243,-2281,-2316,-2348,-2379,-2407,
  -2432,-2455,-2475,-2493,-2508,-2521,-2530,-2537,
  -2541,-2542,-2541,-2536,-2529,-2519,-2506,-2490,
  -2471,-2449,-2424,-2396,-2366,-2332,-2296,-2257,
  -2215,-2170,-2123,-2073,-2020,-1964,-1906,-1845,
  -1782,-1716,-1648,-1577,-1504,-1429,-1352,-1273,
  -1192,-1109,-1024,-937,-849,-758,-667,-574,
  -480,-384,-288,-190,-92,7,107,208,
  309,410,511,613,715,816,917,1018,
  1119,1219,1318,1416,1514,1610,1705,1799,
  1892,1983,2072,2160,2245,2329,2410,2490,
  2567,2641,2713,2783,2849,2913,2974,3032,
  3086,3138,3186,3231,3272,3310,3345,3375,
  3402,3425,3445,3460,3472,3479,3483,3482,
  3477,3469,3456,3439,3418,3392,3363,3329,
  3291,3250,3203,3153,3099,3041,2979,2912,
  2842,2768,2690,2609,2524,2435,2343,2247,
  2148,2045,1940,1831,1719,1605,1488,1368,
  1246,1121,994,865,734,601,466,330,
  192,53,-87,-228,-370,-512,-655,-798,
  -941,-1085,-1228,-1371,-1513,-1654,-1795,-1934,
  -2073,-2210,-2345,-2479,-2610,-2740,-2867,-2992,
  -3114,-3234,-3351,-3464,-3574,-3681,-3785,-3884,
  -3980,-4072,-4159,-4243,-4322,-4396,-4466,-4531,
  -4591,-4646,-4696,-4740,-4780,-4814,-4842,-4865,
  -4882,-4894,-4899,-4899,-4893,-4881,-4864,-4840,
  -4810,-4774,-4732,-4684,-4630,-4570,-4504,-4433,
  -4355,-4271,-4181,-4086,-3985,-3878,-3766,-3648,
  -3525,-3397,-3263,-3124,-2981,-2832,-2679,-2521,
  -2359,-2193,-2023,-1848,-1670,-1488,-1303,-1115,
  -924,-730,-533,-334,-133,70,275,481,
  689,898,1107,1317,1528,1738,1948,2158,
  2367,2575,2782,2987,3191,3393,3592,3789,
  3983,4174,4362,4547,4727,4904,5076,5244,
  5407,5565,5718,5865,6007,6143,6272,6396,
  6512,6622,6725,6821,6909,6990,7063,7129,
  7186,7235,7276,7308,7332,7347,7354,7351,
  7340,7319,7289,7251,7202,7145,7078,7002,
  6917,6822,6718,6604,6482,6350,6209,6058,
  5899,5731,5554,5368,5174,4971,4759,4540,
  4312,4077,3834,3584,3326,3061,2789,2511,
  2227,1936,1640,1338,1031,719,402,81,
  -244,-573,-905,-1240,-1577,-1917,-2259,-2602,
  -2947,-3292,-3637,-3983,-4328,-4672,-5015,-5357,
  -5696,-6032,-6366,-6697,-7023,-7346,-7663,-7976,
  -8283,-8585,-8880,-9168,-9449,-9722,-9987,-10244,
  -10492,-10730,-10959,-11178,-11386,-11583,-11769,-11944,
  -12106,-12256,-12393,-12517,-12627,-12724,-12806,-12874,
  -12927,-12966,-12989,-12996,-12987,-12962,-12921,-12863,
  -12789,-12697,-12588,-12462,-12318,-12157,-11977,-11780,
  -11565,-11331,-11079,-10809,-10521,-10214,-9889,-9545,
  -9183,-8803,-8404,-7987,-7552,-7099,-6628,-6139,
  -5632,-5108,-4567,-4008,-3432,-2840,-2231,-1606,
  -965,-308,364,1051,1753,2469,3199,3943,
  4701,5471,6254,7048,7855,8672,9500,10339,
  11187,12044,12910,13785,14667,15556,16452,17354,
  18261,19173,20090,21010,21934,22860,23788,24717,
  25647,26578,27508,28437,29364,30288,31210,32128,
  33042,33952,34855,35753,36644,37528,38403,39271,
  40129,40977,41815,42642,43457,44260,45051,45828,
  46592,47341,48076,48795,49498,50184,50854,51506,
  52140,52756,53353,53931,54490,55028,55545,56042,
  56518,56972,57404,57814,58201,58566,58908,59226,
  59520,59791,60038,60261,60459,60633,60782,60907,
  61007,61082,61132,61157,61157,61132,61082,61007,
  60907,60782,60633,60459,60261,60038,59791,59520,
  59226,58908,58566,58201,57814,57404,56972,56518,
  56042,55545,55028,54490,53931,53353,52756,52140,
  51506,50854,50184,49498,48795,48076,47341,46592,
  45828,45051,44260,43457,42642,41815,40977,40129,
  39271,38403,37528,36644,35753,34855,33952,33042,
  32128,31210,30288,29364,28437,27508,26578,25647,
  24717,23788,22860,21934,21010,20090,19173,18261,
  17354,16452,15556,14667,13785,12910,12044,11187,
  10339,9500,8672,7855,7048,6254,5471,4701,
  3943,3199,2469,1753,1051,364,-308,-965,
  -1606,-2231,-2840,-3432,-4008,-4567,-5108,-5632,
  -6139,-6628,-7099,-7552,-7987,-8404,-8803,-9183,
  -9545,-9889,-10214,-10521,-10809,-11079,-11331,-11565,
  -11780,-11977,-12157,-12318,-12462,-12588,-12697,-12789,
  -12863,-12921,-12962,-12987,-12996,-12989,-12966,-12927,
  -12874,-12806,-12724,-12627,-12517,-12393,-12256,-12106,
  -11944,-11769,-11583,-11386,-11178,-10959,-10730,-10492,
  -10244,-9987,-9722,-9449,-9168,-8880,-8585,-8283,
  -7976,-7663,-7346,-7023,-6697,-6366,-6032,-5696,
  -5357,-5015,-4672,-4328,-3983,-3637,-3292,-2947,
  -2602,-2259,-1917,-1577,-1240,-905,-573,-244,
  81,402,719,1031,1338,1640,1936,2227,
  2511,2789,3061,3326,3584,3834,4077,4312,
  4540,4759,4971,5174,5368,5554,5731,5899,
  6058,6209,6350,6482,6604,6718,6822,6917,
  7002,7078,7145,7202,7251,7289,7319,7340,
  7351,7354,7347,7332,7308,7276,7235,7186,
  7129,7063,6990,6909,6821,6725,6622,6512,
  6396,6272,6143,6007,5865,5718,5565,5407,
  5244,5076,4904,4727,4547,4362,4174,3983,
  3789,3592,3393,3191,2987,2782,2575,2367,
  2158,1948,1738,1528,1317,1107,898,689,
  481,275,70,-133,-334,-533,-730,-924,
  -1115,-1303,-1488,-1670,-1848,-2023,-2193,-2359,
  -2521,-2679,-2832,-2981,-3124,-3263,-3397,-3525,
  -3648,-3766,-3878,-3985,-4086,-4181,-4271,-4355,
  -4433,-4504,-4570,-4630,-4684,-4732,-4774,-4810,
  -4840,-4864,-4881,-4893,-4899,-4899,-4894,-4882,
  -4865,-4842,-4814,-4780,-4740,-4696,-4646,-4591,
  -4531,-4466,-4396,-4322,-4243,-4159,-4072,-3980,
  -3884,-3785,-3681,-3574,-3464,-3351,-3234,-3114,
  -2992,-2867,-2740,-2610,-2479,-2345,-2210,-2073,
  -1934,-1795,-1654,-1513,-1371,-1228,-1085,-941,
  -798,-655,-512,-370,-228,-87,53,192,
  330,466,601,734,865,994,1121,1246,
  1368,1488,1605,1719,1831,1940,2045,2148,
  2247,2343,2435,2524,2609,2690,2768,2842,
  2912,2979,3041,3099,3153,3203,3250,3291,
  3329,3363,3392,3418,3439,3456,3469,3477,
  3482,3483,3479,3472,3460,3445,3425,3402,
  3375,3345,3310,3272,3231,3186,3138,3086,
  3032,2974,2913,2849,2783,2713,2641,2567,
  2490,2410,2329,2245,2160,2072,1983,1892,
  1799,1705,1610,1514,1416,1318,1219,1119,
  1018,917,816,715,613,511,410,309,
  208,107,7,-92,-190,-288,-384,-480,
  -574,-667,-758,-849,-937,-1024,-1109,-1192,
  -1273,-1352,-1429,-1504,-1577,-1648,-1716,-1782,
  -1845,-1906,-1964,-2020,-2073,-2123,-2170,-2215,
  -2257,-2296,-2332,-2366,-2396,-2424,-2449,-2471,
  -2490,-2506,-2519,-2529,-2536,-2541,-2542,-2541,
  -2537,-2530,-2521,-2508,-2493,-2475,-2455,-2432,
  -2407,-2379,-2348,-2316,-2281,-2243,-2204,-2162,
  -2118,-2072,-2024,-1975,-1923,-1870,-1815,-1758,
  -1700,-1640,-1579,-1517,-1453,-1389,-1323,-1256,
  -1189,-1120,-1051,-981,-911,-840,-768,-696,
  -624,-552,-480,-408,-335,-263,-191,-120,
  -49,22,93,162,231,300,367,434,
  500,564,628,691,752,812,871,929,
  985,1040,1093,1145,1195,1244,1291,1336,
  1380,1422,1462,1500,1536,1571,1603,1634,
  1663,1690,1715,1738,1759,1778,1795,1810,
  1823,1835,1844,1851,1857,1860,1861,1861,
  1859,1854,1848,1840,1831,1819,1806,1791,
  1774,1756,1736,1714,1691,1666,1640,1612,
  1583,1553,1521,1488,1454,1418,1382,1344,
  1305,1265,1225,1183,1141,1097,1053,1009,
  963,917,871,824,776,729,680,632,
  583,534,485,436,387,338,289,240,
  191,142,94,46,-2,-50,-97,-143,
  -189,-235,-280,-324,-368,-411,-453,-495,
  -536,-576,-615,-653,-690,-727,-762,-797,
  -830,-863,-894,-924,-954,-982,-1009,-1035,
  -1060,-1084,-1106,-1128,-1148,-1167,-1185,-1202,
  -1218,-1232,-1245,-1258,-1268,-1278,-1287,-1294,
  -1301,-1306,-1310,-1313,-1315,-1315,-1315,-1314,
  -1311,-1308,-1303,-1298,-1291,-1284,-1275,-1266,
  -1256,-1245,-1233,-1220,-1206,-1192,-1177,-1161,
  -1144,-1127,-1109,-1091,-1071,-1052,-1031,-1010,
  -989,-967,-945,-922,-899,-875,-852,-827,
  -803,-778,-753,-728,-703,-677,-652,-626,
  -600,-574,-548,-522,-496,-470,-445,-419,
  -393,-368,-342,-317,-292,-267,-243,-218,
  -194,-170,-147,-123,-101,-78,-56,-34,
  -12,9,29,50,70,89,108,127,
  145,162,180,196,212,228,243,258,
  272,286,299,312,324,336,347,358,
  368,378,387,396,404,412,419,426,
  432,438,443,448,453,457,460,463,
  466,468,470,472,473,473,474,474,
  473,472,471,470,468,466,464,461,
  458,455,451,448,444,439,435,430,
  425,420,415,410,404,399,393,387,
  381,375,368,362,356,349,342,336,
  329,322,315,309,302,295,288,281,
  274,268,261,254,247,241,234,227,
  221,214,208,201,195,189,183,177,
  171,165,159,154,148,142,137,132,
  127,122,117,112,107,103,98,94,
  90,85,81,77,74,70,66,63,
  60,56,53,50,47,45,42,39,
  37,35,32,30,28,26,24,22,
  21,19,17,16,15,13,12,11,
  10,9,8,7,6,5,4,4
};

int_4 d2awgm3_polyfir_96 [] = {
  4,4,5,6,6,7,8,9,
  10,11,12,13,14,15,16,17,
  19,20,22,23,25,27,28,30,
  32,34,36,38,40,43,45,48,
  50,53,55,58,61,64,67,70,
  73,77,80,84,87,91,95,98,
  102,106,110,115,119,123,128,132,
  137,141,146,151,156,161,166,171,
  176,182,187,192,198,203,209,215,
  220,226,232,238,243,249,255,261,
  267,273,279,285,291,297,303,309,
  315,321,327,333,339,344,350,356,
  362,367,373,378,383,389,394,399,
  404,409,414,418,423,427,431,435,
  439,443,446,450,453,456,458,461,
  463,465,467,469,470,472,472,473,
  473,474,473,473,472,471,470,468,
  466,464,461,458,455,451,447,443,
  438,433,428,422,416,409,402,395,
  388,380,371,362,353,344,334,323,
  313,302,290,278,266,253,240,227,
  213,199,185,170,155,139,123,107,
  90,73,56,38,20,2,-16,-35,
  -54,-74,-94,-113,-134,-154,-175,-196,
  -217,-238,-260,-281,-303,-325,-347,-369,
  -392,-414,-437,-459,-482,-505,-527,-550,
  -573,-595,-618,-640,-663,-685,-708,-730,
  -752,-774,-795,-817,-838,-859,-880,-900,
  -921,-941,-960,-980,-998,-1017,-1035,-1053,
  -1070,-1087,-1103,-1119,-1135,-1150,-1164,-1178,
  -1191,-1204,-1216,-1227,-1238,-1248,-1258,-1267,
  -1275,-1282,-1289,-1295,-1300,-1305,-1308,-1311,
  -1314,-1315,-1315,-1315,-1314,-1312,-1309,-1306,
  -1301,-1296,-1289,-1282,-1274,-1265,-1255,-1245,
  -1233,-1220,-1207,-1193,-1178,-1161,-1144,-1127,
  -1108,-1088,-1068,-1046,-1024,-1001,-977,-952,
  -926,-900,-872,-844,-815,-786,-755,-724,
  -692,-660,-627,-593,-558,-523,-487,-451,
  -414,-376,-338,-299,-260,-221,-181,-140,
  -100,-58,-17,25,67,109,151,194,
  237,280,323,366,409,452,495,537,
  580,623,665,708,750,791,833,874,
  915,955,995,1034,1073,1111,1149,1186,
  1222,1258,1293,1327,1361,1393,1425,1456,
  1486,1515,1543,1570,1596,1621,1645,1668,
  1689,1710,1729,1747,1764,1779,1794,1807,
  1818,1829,1837,1845,1851,1856,1859,1861,
  1861,1860,1858,1854,1848,1841,1833,1823,
  1811,1798,1784,1768,1750,1731,1710,1688,
  1665,1640,1613,1585,1556,1525,1493,1459,
  1424,1388,1350,1311,1270,1229,1186,1142,
  1096,1050,1002,954,904,853,801,748,
  695,640,584,528,471,413,355,295,
  236,175,114,53,-9,-71,-133,-196,
  -259,-322,-385,-448,-512,-575,-638,-701,
  -764,-826,-888,-950,-1012,-1073,-1133,-1193,
  -1252,-1311,-1368,-1425,-1481,-1537,-1591,-1644,
  -1696,-1747,-1797,-1846,-1893,-1939,-1984,-2027,
  -2069,-2110,-2148,-2186,-2221,-2255,-2287,-2318,
  -2346,-2373,-2398,-2421,-2443,-2462,-2479,-2494,
  -2507,-2518,-2527,-2534,-2539,-2542,-2542,-2541,
  -2537,-2531,-2522,-2512,-2499,-2484,-2467,-2447,
  -2426,-2402,-2376,-2347,-2317,-2284,-2249,-2212,
  -2173,-2132,-2088,-2043,-1996,-1946,-1895,-1841,
  -1786,-1728,-1669,-1608,-1546,-1481,-1415,-1347,
  -1278,-1207,-1135,-1061,-986,-909,-832,-753,
  -673,-592,-509,-426,-342,-258,-172,-86,
  1,88,176,264,353,442,530,619,
  708,797,886,974,1063,1150,1238,1324,
  1410,1496,1580,1664,1747,1828,1909,1988,
  2067,2143,2219,2293,2365,2435,2504,2571,
  2637,2700,2761,2820,2878,2932,2985,3035,
  3083,3129,3172,3212,3250,3285,3317,3347,
  3374,3397,3419,3437,3452,3464,3473,3479,
  3483,3482,3479,3473,3464,3451,3435,3416,
  3394,3369,3340,3308,3274,3236,3194,3150,
  3103,3052,2998,2942,2882,2819,2754,2685,
  2614,2540,2463,2383,2301,2216,2129,2039,
  1946,1852,1755,1655,1554,1451,1345,1238,
  1129,1018,905,791,676,559,440,321,
  201,79,-43,-166,-290,-414,-539,-664,
  -789,-915,-1040,-1165,-1290,-1415,-1539,-1663,
  -1786,-1908,-2030,-2150,-2269,-2387,-2504,-2619,
  -2732,-2844,-2953,-3061,-3167,-3271,-3372,-3471,
  -3568,-3662,-3753,-3841,-3927,-4009,-4088,-4165,
  -4238,-4307,-4373,-4436,-4495,-4550,-4601,-4649,
  -4693,-4732,-4768,-4799,-4827,-4850,-4868,-4883,
  -4893,-4899,-4900,-4897,-4889,-4876,-4860,-4838,
  -4812,-4781,-4746,-4706,-4661,-4612,-4558,-4500,
  -4437,-4370,-4298,-4221,-4140,-4055,-3965,-3871,
  -3773,-3671,-3564,-3453,-3339,-3220,-3098,-2972,
  -2842,-2708,-2571,-2431,-2287,-2140,-1990,-1837,
  -1681,-1523,-1361,-1198,-1032,-863,-693,-521,
  -347,-171,7,185,365,546,728,911,
  1094,1278,1462,1646,1830,2014,2197,2380,
  2562,2743,2923,3102,3279,3455,3629,3801,
  3971,4139,4304,4467,4626,4783,4937,5087,
  5234,5377,5517,5652,5783,5910,6033,6151,
  6265,6373,6477,6575,6668,6756,6838,6915,
  6985,7050,7109,7162,7209,7249,7283,7310,
  7331,7345,7353,7353,7347,7334,7314,7287,
  7253,7212,7164,7109,7046,6976,6900,6816,
  6725,6626,6521,6409,6289,6163,6029,5889,
  5742,5588,5427,5260,5086,4906,4719,4526,
  4327,4122,3911,3694,3472,3244,3011,2772,
  2529,2280,2027,1770,1508,1242,972,699,
  422,141,-142,-429,-718,-1009,-1303,-1599,
  -1896,-2195,-2495,-2796,-3098,-3400,-3702,-4005,
  -4307,-4608,-4908,-5207,-5505,-5801,-6095,-6387,
  -6676,-6962,-7245,-7525,-7801,-8073,-8340,-8603,
  -8861,-9114,-9362,-9603,-9839,-10068,-10291,-10507,
  -10716,-10917,-11111,-11296,-11474,-11643,-11803,-11954,
  -12096,-12229,-12351,-12464,-12567,-12659,-12740,-12811,
  -12870,-12919,-12955,-12980,-12994,-12995,-12984,-12960,
  -12924,-12875,-12814,-12739,-12652,-12551,-12436,-12309,
  -12167,-12012,-11844,-11661,-11465,-11254,-11030,-10792,
  -10539,-10273,-9992,-9698,-9389,-9066,-8729,-8379,
  -8014,-7635,-7242,-6836,-6416,-5982,-5535,-5075,
  -4601,-4114,-3614,-3101,-2576,-2038,-1487,-925,
  -350,237,835,1444,2064,2696,3338,3990,
  4653,5326,6008,6699,7400,8109,8827,9553,
  10286,11027,11775,12531,13292,14060,14833,15612,
  16396,17184,17977,18773,19574,20377,21183,21991,
  22802,23614,24427,25240,26055,26869,27682,28495,
  29306,30115,30923,31727,32529,33327,34122,34912,
  35697,36477,37252,38021,38784,39540,40288,41029,
  41763,42487,43204,43910,44608,45295,45973,46639,
  47295,47939,48572,49192,49800,50395,50977,51546,
  52101,52642,53169,53681,54178,54660,55126,55577,
  56012,56430,56832,57218,57586,57937,58271,58588,
  58887,59168,59431,59676,59902,60110,60300,60471,
  60623,60756,60871,60966,61043,61100,61138,61157,
  61157,61138,61100,61043,60966,60871,60756,60623,
  60471,60300,60110,59902,59676,59431,59168,58887,
  58588,58271,57937,57586,57218,56832,56430,56012,
  55577,55126,54660,54178,53681,53169,52642,52101,
  51546,50977,50395,49800,49192,48572,47939,47295,
  46639,45973,45295,44608,43910,43204,42487,41763,
  41029,40288,39540,38784,38021,37252,36477,35697,
  34912,34122,33327,32529,31727,30923,30115,29306,
  28495,27682,26869,26055,25240,24427,23614,22802,
  21991,21183,20377,19574,18773,17977,17184,16396,
  15612,14833,14060,13292,12531,11775,11027,10286,
  9553,8827,8109,7400,6699,6008,5326,4653,
  3990,3338,2696,2064,1444,835,237,-350,
  -925,-1487,-2038,-2576,-3101,-3614,-4114,-4601,
  -5075,-5535,-5982,-6416,-6836,-7242,-7635,-8014,
  -8379,-8729,-9066,-9389,-9698,-9992,-10273,-10539,
  -10792,-11030,-11254,-11465,-11661,-11844,-12012,-12167,
  -12309,-12436,-12551,-12652,-12739,-12814,-12875,-12924,
  -12960,-12984,-12995,-12994,-12980,-12955,-12919,-12870,
  -12811,-12740,-12659,-12567,-12464,-12351,-12229,-12096,
  -11954,-11803,-11643,-11474,-11296,-11111,-10917,-10716,
  -10507,-10291,-10068,-9839,-9603,-9362,-9114,-8861,
  -8603,-8340,-8073,-7801,-7525,-7245,-6962,-6676,
  -6387,-6095,-5801,-5505,-5207,-4908,-4608,-4307,
  -4005,-3702,-3400,-3098,-2796,-2495,-2195,-1896,
  -1599,-1303,-1009,-718,-429,-142,141,422,
  699,972,1242,1508,1770,2027,2280,2529,
  2772,3011,3244,3472,3694,3911,4122,4327,
  4526,4719,4906,5086,5260,5427,5588,5742,
  5889,6029,6163,6289,6409,6521,6626,6725,
  6816,6900,6976,7046,7109,7164,7212,7253,
  7287,7314,7334,7347,7353,7353,7345,7331,
  7310,7283,7249,7209,7162,7109,7050,6985,
  6915,6838,6756,6668,6575,6477,6373,6265,
  6151,6033,5910,5783,5652,5517,5377,5234,
  5087,4937,4783,4626,4467,4304,4139,3971,
  3801,3629,3455,3279,3102,2923,2743,2562,
  2380,2197,2014,1830,1646,1462,1278,1094,
  911,728,546,365,185,7,-171,-347,
  -521,-693,-863,-1032,-1198,-1361,-1523,-1681,
  -1837,-1990,-2140,-2287,-2431,-2571,-2708,-2842,
  -2972,-3098,-3220,-3339,-3453,-3564,-3671,-3773,
  -3871,-3965,-4055,-4140,-4221,-4298,-4370,-4437,
  -4500,-4558,-4612,-4661,-4706,-4746,-4781,-4812,
  -4838,-4860,-4876,-4889,-4897,-4900,-4899,-4893,
  -4883,-4868,-4850,-4827,-4799,-4768,-4732,-4693,
  -4649,-4601,-4550,-4495,-4436,-4373,-4307,-4238,
  -4165,-4088,-4009,-3927,-3841,-3753,-3662,-3568,
  -3471,-3372,-3271,-3167,-3061,-2953,-2844,-2732,
  -2619,-2504,-2387,-2269,-2150,-2030,-1908,-1786,
  -1663,-1539,-1415,-1290,-1165,-1040,-915,-789,
  -664,-539,-414,-290,-166,-43,79,201,
  321,440,559,676,791,905,1018,1129,
  1238,1345,1451,1554,1655,1755,1852,1946,
  2039,2129,2216,2301,2383,2463,2540,2614,
  2685,2754,2819,2882,2942,2998,3052,3103,
  3150,3194,3236,3274,3308,3340,3369,3394,
  3416,3435,3451,3464,3473,3479,3482,3483,
  3479,3473,3464,3452,3437,3419,3397,3374,
  3347,3317,3285,3250,3212,3172,3129,3083,
  3035,2985,2932,2878,2820,2761,2700,2637,
  2571,2504,2435,2365,2293,2219,2143,2067,
  1988,1909,1828,1747,1664,1580,1496,1410,
  1324,1238,1150,1063,974,886,797,708,
  619,530,442,353,264,176,88,1,
  -86,-172,-258,-342,-426,-509,-592,-673,
  -753,-832,-909,-986,-1061,-1135,-1207,-1278,
  -1347,-1415,-1481,-1546,-1608,-1669,-1728,-1786,
  -1841,-1895,-1946,-1996,-2043,-2088,-2132,-2173,
  -2212,-2249,-2284,-2317,-2347,-2376,-2402,-2426,
  -2447,-2467,-2484,-2499,-2512,-2522,-2531,-2537,
  -2541,-2542,-2542,-2539,-2534,-2527,-2518,-2507,
  -2494,-2479,-2462,-2443,-2421,-2398,-2373,-2346,
  -2318,-2287,-2255,-2221,-2186,-2148,-2110,-2069,
  -2027,-1984,-1939,-1893,-1846,-1797,-1747,-1696,
  -1644,-1591,-1537,-1481,-1425,-1368,-1311,-1252,
  -1193,-1133,-1073,-1012,-950,-888,-826,-764,
  -701,-638,-575,-512,-448,-385,-322,-259,
  -196,-133,-71,-9,53,114,175,236,
  295,355,413,471,528,584,640,695,
  748,801,853,904,954,1002,1050,1096,
  1142,1186,1229,1270,1311,1350,1388,1424,
  1459,1493,1525,1556,1585,1613,1640,1665,
  1688,1710,1731,1750,1768,1784,1798,1811,
  1823,1833,1841,1848,1854,1858,1860,1861,
  1861,1859,1856,1851,1845,1837,1829,1818,
  1807,1794,1779,1764,1747,1729,1710,1689,
  1668,1645,1621,1596,1570,1543,1515,1486,
  1456,1425,1393,1361,1327,1293,1258,1222,
  1186,1149,1111,1073,1034,995,955,915,
  874,833,791,750,708,665,623,580,
  537,495,452,409,366,323,280,237,
  194,151,109,67,25,-17,-58,-100,
  -140,-181,-221,-260,-299,-338,-376,-414,
  -451,-487,-523,-558,-593,-627,-660,-692,
  -724,-755,-786,-815,-844,-872,-900,-926,
  -952,-977,-1001,-1024,-1046,-1068,-1088,-1108,
  -1127,-1144,-1161,-1178,-1193,-1207,-1220,-1233,
  -1245,-1255,-1265,-1274,-1282,-1289,-1296,-1301,
  -1306,-1309,-1312,-1314,-1315,-1315,-1315,-1314,
  -1311,-1308,-1305,-1300,-1295,-1289,-1282,-1275,
  -1267,-1258,-1248,-1238,-1227,-1216,-1204,-1191,
  -1178,-1164,-1150,-1135,-1119,-1103,-1087,-1070,
  -1053,-1035,-1017,-998,-980,-960,-941,-921,
  -900,-880,-859,-838,-817,-795,-774,-752,
  -730,-708,-685,-663,-640,-618,-595,-573,
  -550,-527,-505,-482,-459,-437,-414,-392,
  -369,-347,-325,-303,-281,-260,-238,-217,
  -196,-175,-154,-134,-113,-94,-74,-54,
  -35,-16,2,20,38,56,73,90,
  107,123,139,155,170,185,199,213,
  227,240,253,266,278,290,302,313,
  323,334,344,353,362,371,380,388,
  395,402,409,416,422,428,433,438,
  443,447,451,455,458,461,464,466,
  468,470,471,472,473,473,474,473,
  473,472,472,470,469,467,465,463,
  461,458,456,453,450,446,443,439,
  435,431,427,423,418,414,409,404,
  399,394,389,383,378,373,367,362,
  356,350,344,339,333,327,321,315,
  309,303,297,291,285,279,273,267,
  261,255,249,243,238,232,226,220,
  215,209,203,198,192,187,182,176,
  171,166,161,156,151,146,141,137,
  132,128,123,119,115,110,106,102,
  98,95,91,87,84,80,77,73,
  70,67,64,61,58,55,53,50,
  48,45,43,40,38,36,34,32,
  30,28,27,25,23,22,20,19,
  17,16,15,14,13,12,11,10,
  9,8,7,6,6,5,4,4
};

int_4 d2awgm3_polyfir_128 [] = {
  4,4,5,5,6,6,7,7,
  8,8,9,10,10,11,12,13,
  14,14,15,16,17,18,19,20,
  22,23,24,25,26,28,29,30,
  32,33,35,36,38,40,41,43,
  45,47,49,50,52,54,56,59,
  61,63,65,67,70,72,75,77,
  80,82,85,88,90,93,96,99,
  102,105,108,111,114,117,120,124,
  127,130,134,137,141,144,148,152,
  155,159,163,167,170,174,178,182,
  186,190,194,198,203,207,211,215,
  219,224,228,232,237,241,246,250,
  254,259,263,268,272,277,281,286,
  290,295,299,304,308,313,317,322,
  326,330,335,339,344,348,352,356,
  361,365,369,373,377,381,385,389,
  393,397,401,404,408,412,415,419,
  422,425,428,431,435,437,440,443,
  446,448,451,453,455,457,459,461,
  463,465,466,467,469,470,471,472,
  472,473,473,473,473,473,473,473,
  472,471,470,469,468,467,465,463,
  461,459,457,454,452,449,445,442,
  439,435,431,427,423,418,413,408,
  403,398,392,386,380,374,368,361,
  354,347,340,332,325,317,308,300,
  291,283,274,264,255,245,235,225,
  215,204,194,183,172,160,149,137,
  125,113,100,88,75,62,49,36,
  22,9,-5,-19,-33,-47,-62,-76,
  -91,-106,-121,-136,-152,-167,-183,-199,
  -214,-230,-246,-262,-279,-295,-311,-328,
  -345,-361,-378,-395,-411,-428,-445,-462,
  -479,-496,-513,-530,-547,-564,-581,-598,
  -615,-632,-649,-666,-683,-699,-716,-733,
  -749,-766,-782,-798,-814,-830,-846,-862,
  -877,-893,-908,-923,-938,-953,-968,-982,
  -996,-1010,-1024,-1037,-1051,-1064,-1077,-1089,
  -1102,-1114,-1125,-1137,-1148,-1159,-1169,-1180,
  -1190,-1199,-1208,-1217,-1226,-1234,-1242,-1250,
  -1257,-1264,-1270,-1276,-1281,-1287,-1291,-1296,
  -1300,-1303,-1306,-1309,-1311,-1313,-1314,-1315,
  -1315,-1315,-1315,-1314,-1312,-1310,-1308,-1305,
  -1302,-1298,-1293,-1288,-1283,-1277,-1271,-1264,
  -1257,-1249,-1240,-1231,-1222,-1212,-1202,-1191,
  -1179,-1168,-1155,-1142,-1129,-1115,-1100,-1085,
  -1070,-1054,-1038,-1021,-1004,-986,-967,-949,
  -929,-910,-889,-869,-848,-826,-804,-782,
  -759,-736,-712,-688,-664,-639,-614,-588,
  -562,-536,-509,-482,-455,-427,-399,-371,
  -343,-314,-285,-255,-226,-196,-165,-135,
  -105,-74,-43,-12,20,51,83,114,
  146,178,210,242,274,307,339,371,
  403,436,468,500,532,564,596,628,
  660,692,724,755,786,817,848,879,
  910,940,970,1000,1029,1058,1087,1116,
  1144,1172,1200,1227,1254,1280,1306,1332,
  1357,1381,1405,1429,1452,1475,1497,1519,
  1540,1560,1580,1599,1618,1636,1654,1671,
  1687,1702,1717,1731,1745,1758,1770,1781,
  1792,1802,1811,1820,1827,1834,1840,1846,
  1850,1854,1857,1859,1861,1861,1861,1860,
  1858,1855,1852,1847,1842,1836,1829,1821,
  1813,1803,1793,1782,1770,1757,1743,1728,
  1713,1697,1680,1662,1643,1623,1603,1582,
  1560,1537,1513,1489,1463,1437,1411,1383,
  1355,1326,1296,1265,1234,1202,1169,1136,
  1102,1067,1032,996,960,923,885,846,
  808,768,728,688,647,605,563,521,
  478,435,391,347,303,258,213,168,
  122,76,30,-17,-63,-110,-157,-204,
  -251,-298,-346,-393,-441,-488,-535,-583,
  -630,-677,-725,-772,-819,-865,-912,-958,
  -1004,-1050,-1095,-1141,-1186,-1230,-1274,-1318,
  -1361,-1404,-1447,-1488,-1530,-1571,-1611,-1651,
  -1690,-1728,-1766,-1803,-1840,-1876,-1911,-1945,
  -1979,-2011,-2043,-2074,-2105,-2134,-2163,-2190,
  -2217,-2243,-2267,-2291,-2314,-2336,-2357,-2377,
  -2395,-2413,-2430,-2445,-2459,-2473,-2485,-2496,
  -2506,-2515,-2522,-2528,-2534,-2538,-2540,-2542,
  -2542,-2541,-2539,-2536,-2531,-2526,-2519,-2510,
  -2501,-2490,-2478,-2464,-2450,-2434,-2417,-2399,
  -2379,-2358,-2336,-2313,-2288,-2263,-2236,-2207,
  -2178,-2148,-2116,-2083,-2049,-2014,-1977,-1940,
  -1901,-1861,-1820,-1779,-1736,-1692,-1647,-1601,
  -1554,-1506,-1457,-1407,-1356,-1304,-1252,-1198,
  -1144,-1089,-1033,-976,-919,-861,-802,-743,
  -683,-622,-561,-499,-437,-374,-311,-247,
  -183,-118,-53,12,78,143,209,275,
  342,408,475,542,608,675,742,808,
  875,941,1008,1074,1139,1205,1270,1335,
  1400,1464,1528,1591,1654,1716,1778,1839,
  1899,1959,2018,2076,2134,2191,2247,2302,
  2356,2409,2462,2513,2563,2612,2661,2708,
  2754,2799,2842,2885,2926,2966,3004,3041,
  3077,3112,3145,3177,3207,3236,3263,3289,
  3313,3336,3357,3377,3395,3411,3426,3439,
  3450,3460,3468,3474,3479,3482,3483,3482,
  3480,3476,3470,3462,3453,3441,3428,3414,
  3397,3379,3358,3336,3313,3287,3260,3231,
  3200,3167,3133,3096,3058,3019,2978,2934,
  2890,2843,2795,2745,2694,2641,2587,2530,
  2473,2413,2353,2291,2227,2162,2095,2027,
  1958,1887,1815,1742,1668,1592,1515,1437,
  1358,1278,1197,1115,1032,948,863,777,
  690,603,514,426,336,246,155,64,
  -28,-120,-213,-305,-399,-492,-586,-680,
  -774,-868,-962,-1056,-1150,-1244,-1337,-1431,
  -1524,-1617,-1709,-1802,-1893,-1984,-2075,-2165,
  -2254,-2343,-2431,-2518,-2604,-2690,-2774,-2857,
  -2940,-3021,-3101,-3180,-3258,-3334,-3410,-3483,
  -3556,-3627,-3696,-3764,-3830,-3895,-3958,-4019,
  -4079,-4137,-4192,-4247,-4299,-4349,-4397,-4443,
  -4488,-4530,-4570,-4608,-4643,-4677,-4708,-4737,
  -4764,-4788,-4810,-4830,-4847,-4862,-4874,-4884,
  -4892,-4897,-4900,-4900,-4897,-4892,-4885,-4875,
  -4862,-4847,-4829,-4808,-4785,-4760,-4731,-4701,
  -4667,-4631,-4593,-4551,-4508,-4461,-4412,-4361,
  -4307,-4250,-4191,-4130,-4066,-3999,-3931,-3859,
  -3786,-3710,-3631,-3550,-3468,-3382,-3295,-3205,
  -3113,-3019,-2923,-2825,-2725,-2623,-2519,-2413,
  -2305,-2195,-2084,-1971,-1856,-1740,-1622,-1503,
  -1382,-1259,-1136,-1011,-885,-757,-629,-499,
  -368,-237,-104,29,163,298,433,569,
  705,842,980,1117,1255,1393,1531,1669,
  1807,1945,2083,2220,2357,2494,2630,2766,
  2901,3035,3169,3302,3433,3564,3694,3823,
  3950,4076,4201,4325,4446,4567,4686,4803,
  4918,5031,5143,5252,5359,5465,5568,5669,
  5767,5863,5957,6048,6137,6223,6306,6386,
  6464,6539,6611,6679,6745,6808,6867,6924,
  6977,7027,7073,7116,7156,7192,7224,7253,
  7279,7301,7319,7333,7344,7351,7354,7353,
  7348,7340,7328,7311,7291,7267,7239,7206,
  7170,7130,7086,7038,6986,6929,6869,6805,
  6736,6664,6588,6507,6423,6335,6243,6146,
  6046,5942,5834,5723,5607,5488,5365,5238,
  5108,4974,4836,4695,4550,4402,4251,4096,
  3937,3776,3611,3443,3272,3099,2922,2742,
  2559,2374,2186,1995,1802,1607,1409,1209,
  1006,802,595,387,176,-36,-249,-465,
  -682,-900,-1119,-1340,-1562,-1784,-2008,-2232,
  -2457,-2683,-2909,-3136,-3362,-3589,-3816,-4042,
  -4269,-4495,-4721,-4946,-5170,-5394,-5617,-5838,
  -6059,-6278,-6496,-6712,-6927,-7140,-7351,-7560,
  -7767,-7971,-8174,-8374,-8571,-8765,-8957,-9146,
  -9331,-9514,-9693,-9868,-10040,-10208,-10373,-10534,
  -10690,-10842,-10991,-11134,-11274,-11408,-11538,-11663,
  -11783,-11899,-12009,-12113,-12213,-12306,-12395,-12477,
  -12554,-12625,-12691,-12750,-12803,-12849,-12890,-12924,
  -12951,-12972,-12987,-12994,-12995,-12989,-12976,-12956,
  -12929,-12895,-12854,-12805,-12749,-12686,-12615,-12537,
  -12451,-12358,-12257,-12149,-12032,-11908,-11777,-11637,
  -11490,-11335,-11172,-11001,-10822,-10636,-10441,-10239,
  -10028,-9810,-9584,-9349,-9107,-8857,-8599,-8334,
  -8060,-7779,-7489,-7192,-6888,-6575,-6255,-5927,
  -5592,-5249,-4899,-4541,-4176,-3803,-3423,-3036,
  -2642,-2241,-1833,-1417,-995,-567,-131,311,
  759,1214,1675,2143,2616,3096,3582,4073,
  4570,5072,5580,6094,6612,7136,7665,8198,
  8737,9280,9827,10378,10934,11494,12058,12625,
  13197,13771,14349,14930,15514,16101,16691,17283,
  17878,18474,19073,19674,20276,20881,21486,22093,
  22700,23309,23918,24528,25139,25749,26360,26970,
  27580,28190,28799,29407,30014,30620,31225,31828,
  32429,33028,33626,34221,34813,35403,35990,36575,
  37156,37734,38308,38879,39446,40008,40567,41122,
  41671,42217,42757,43292,43823,44347,44867,45381,
  45889,46391,46886,47376,47859,48336,48806,49269,
  49725,50174,50615,51049,51476,51895,52306,52709,
  53104,53491,53869,54239,54600,54953,55297,55632,
  55958,56275,56583,56881,57170,57450,57720,57980,
  58231,58471,58702,58923,59134,59334,59525,59705,
  59875,60034,60184,60322,60450,60568,60675,60772,
  60857,60933,60997,61051,61094,61126,61148,61158,
  61158,61148,61126,61094,61051,60997,60933,60857,
  60772,60675,60568,60450,60322,60184,60034,59875,
  59705,59525,59334,59134,58923,58702,58471,58231,
  57980,57720,57450,57170,56881,56583,56275,55958,
  55632,55297,54953,54600,54239,53869,53491,53104,
  52709,52306,51895,51476,51049,50615,50174,49725,
  49269,48806,48336,47859,47376,46886,46391,45889,
  45381,44867,44347,43823,43292,42757,42217,41671,
  41122,40567,40008,39446,38879,38308,37734,37156,
  36575,35990,35403,34813,34221,33626,33028,32429,
  31828,31225,30620,30014,29407,28799,28190,27580,
  26970,26360,25749,25139,24528,23918,23309,22700,
  22093,21486,20881,20276,19674,19073,18474,17878,
  17283,16691,16101,15514,14930,14349,13771,13197,
  12625,12058,11494,10934,10378,9827,9280,8737,
  8198,7665,7136,6612,6094,5580,5072,4570,
  4073,3582,3096,2616,2143,1675,1214,759,
  311,-131,-567,-995,-1417,-1833,-2241,-2642,
  -3036,-3423,-3803,-4176,-4541,-4899,-5249,-5592,
  -5927,-6255,-6575,-6888,-7192,-7489,-7779,-8060,
  -8334,-8599,-8857,-9107,-9349,-9584,-9810,-10028,
  -10239,-10441,-10636,-10822,-11001,-11172,-11335,-11490,
  -11637,-11777,-11908,-12032,-12149,-12257,-12358,-12451,
  -12537,-12615,-12686,-12749,-12805,-12854,-12895,-12929,
  -12956,-12976,-12989,-12995,-12994,-12987,-12972,-12951,
  -12924,-12890,-12849,-12803,-12750,-12691,-12625,-12554,
  -12477,-12395,-12306,-12213,-12113,-12009,-11899,-11783,
  -11663,-11538,-11408,-11274,-11134,-10991,-10842,-10690,
  -10534,-10373,-10208,-10040,-9868,-9693,-9514,-9331,
  -9146,-8957,-8765,-8571,-8374,-8174,-7971,-7767,
  -7560,-7351,-7140,-6927,-6712,-6496,-6278,-6059,
  -5838,-5617,-5394,-5170,-4946,-4721,-4495,-4269,
  -4042,-3816,-3589,-3362,-3136,-2909,-2683,-2457,
  -2232,-2008,-1784,-1562,-1340,-1119,-900,-682,
  -465,-249,-36,176,387,595,802,1006,
  1209,1409,1607,1802,1995,2186,2374,2559,
  2742,2922,3099,3272,3443,3611,3776,3937,
  4096,4251,4402,4550,4695,4836,4974,5108,
  5238,5365,5488,5607,5723,5834,5942,6046,
  6146,6243,6335,6423,6507,6588,6664,6736,
  6805,6869,6929,6986,7038,7086,7130,7170,
  7206,7239,7267,7291,7311,7328,7340,7348,
  7353,7354,7351,7344,7333,7319,7301,7279,
  7253,7224,7192,7156,7116,7073,7027,6977,
  6924,6867,6808,6745,6679,6611,6539,6464,
  6386,6306,6223,6137,6048,5957,5863,5767,
  5669,5568,5465,5359,5252,5143,5031,4918,
  4803,4686,4567,4446,4325,4201,4076,3950,
  3823,3694,3564,3433,3302,3169,3035,2901,
  2766,2630,2494,2357,2220,2083,1945,1807,
  1669,1531,1393,1255,1117,980,842,705,
  569,433,298,163,29,-104,-237,-368,
  -499,-629,-757,-885,-1011,-1136,-1259,-1382,
  -1503,-1622,-1740,-1856,-1971,-2084,-2195,-2305,
  -2413,-2519,-2623,-2725,-2825,-2923,-3019,-3113,
  -3205,-3295,-3382,-3468,-3550,-3631,-3710,-3786,
  -3859,-3931,-3999,-4066,-4130,-4191,-4250,-4307,
  -4361,-4412,-4461,-4508,-4551,-4593,-4631,-4667,
  -4701,-4731,-4760,-4785,-4808,-4829,-4847,-4862,
  -4875,-4885,-4892,-4897,-4900,-4900,-4897,-4892,
  -4884,-4874,-4862,-4847,-4830,-4810,-4788,-4764,
  -4737,-4708,-4677,-4643,-4608,-4570,-4530,-4488,
  -4443,-4397,-4349,-4299,-4247,-4192,-4137,-4079,
  -4019,-3958,-3895,-3830,-3764,-3696,-3627,-3556,
  -3483,-3410,-3334,-3258,-3180,-3101,-3021,-2940,
  -2857,-2774,-2690,-2604,-2518,-2431,-2343,-2254,
  -2165,-2075,-1984,-1893,-1802,-1709,-1617,-1524,
  -1431,-1337,-1244,-1150,-1056,-962,-868,-774,
  -680,-586,-492,-399,-305,-213,-120,-28,
  64,155,246,336,426,514,603,690,
  777,863,948,1032,1115,1197,1278,1358,
  1437,1515,1592,1668,1742,1815,1887,1958,
  2027,2095,2162,2227,2291,2353,2413,2473,
  2530,2587,2641,2694,2745,2795,2843,2890,
  2934,2978,3019,3058,3096,3133,3167,3200,
  3231,3260,3287,3313,3336,3358,3379,3397,
  3414,3428,3441,3453,3462,3470,3476,3480,
  3482,3483,3482,3479,3474,3468,3460,3450,
  3439,3426,3411,3395,3377,3357,3336,3313,
  3289,3263,3236,3207,3177,3145,3112,3077,
  3041,3004,2966,2926,2885,2842,2799,2754,
  2708,2661,2612,2563,2513,2462,2409,2356,
  2302,2247,2191,2134,2076,2018,1959,1899,
  1839,1778,1716,1654,1591,1528,1464,1400,
  1335,1270,1205,1139,1074,1008,941,875,
  808,742,675,608,542,475,408,342,
  275,209,143,78,12,-53,-118,-183,
  -247,-311,-374,-437,-499,-561,-622,-683,
  -743,-802,-861,-919,-976,-1033,-1089,-1144,
  -1198,-1252,-1304,-1356,-1407,-1457,-1506,-1554,
  -1601,-1647,-1692,-1736,-1779,-1820,-1861,-1901,
  -1940,-1977,-2014,-2049,-2083,-2116,-2148,-2178,
  -2207,-2236,-2263,-2288,-2313,-2336,-2358,-2379,
  -2399,-2417,-2434,-2450,-2464,-2478,-2490,-2501,
  -2510,-2519,-2526,-2531,-2536,-2539,-2541,-2542,
  -2542,-2540,-2538,-2534,-2528,-2522,-2515,-2506,
  -2496,-2485,-2473,-2459,-2445,-2430,-2413,-2395,
  -2377,-2357,-2336,-2314,-2291,-2267,-2243,-2217,
  -2190,-2163,-2134,-2105,-2074,-2043,-2011,-1979,
  -1945,-1911,-1876,-1840,-1803,-1766,-1728,-1690,
  -1651,-1611,-1571,-1530,-1488,-1447,-1404,-1361,
  -1318,-1274,-1230,-1186,-1141,-1095,-1050,-1004,
  -958,-912,-865,-819,-772,-725,-677,-630,
  -583,-535,-488,-441,-393,-346,-298,-251,
  -204,-157,-110,-63,-17,30,76,122,
  168,213,258,303,347,391,435,478,
  521,563,605,647,688,728,768,808,
  846,885,923,960,996,1032,1067,1102,
  1136,1169,1202,1234,1265,1296,1326,1355,
  1383,1411,1437,1463,1489,1513,1537,1560,
  1582,1603,1623,1643,1662,1680,1697,1713,
  1728,1743,1757,1770,1782,1793,1803,1813,
  1821,1829,1836,1842,1847,1852,1855,1858,
  1860,1861,1861,1861,1859,1857,1854,1850,
  1846,1840,1834,1827,1820,1811,1802,1792,
  1781,1770,1758,1745,1731,1717,1702,1687,
  1671,1654,1636,1618,1599,1580,1560,1540,
  1519,1497,1475,1452,1429,1405,1381,1357,
  1332,1306,1280,1254,1227,1200,1172,1144,
  1116,1087,1058,1029,1000,970,940,910,
  879,848,817,786,755,724,692,660,
  628,596,564,532,500,468,436,403,
  371,339,307,274,242,210,178,146,
  114,83,51,20,-12,-43,-74,-105,
  -135,-165,-196,-226,-255,-285,-314,-343,
  -371,-399,-427,-455,-482,-509,-536,-562,
  -588,-614,-639,-664,-688,-712,-736,-759,
  -782,-804,-826,-848,-869,-889,-910,-929,
  -949,-967,-986,-1004,-1021,-1038,-1054,-1070,
  -1085,-1100,-1115,-1129,-1142,-1155,-1168,-1179,
  -1191,-1202,-1212,-1222,-1231,-1240,-1249,-1257,
  -1264,-1271,-1277,-1283,-1288,-1293,-1298,-1302,
  -1305,-1308,-1310,-1312,-1314,-1315,-1315,-1315,
  -1315,-1314,-1313,-1311,-1309,-1306,-1303,-1300,
  -1296,-1291,-1287,-1281,-1276,-1270,-1264,-1257,
  -1250,-1242,-1234,-1226,-1217,-1208,-1199,-1190,
  -1180,-1169,-1159,-1148,-1137,-1125,-1114,-1102,
  -1089,-1077,-1064,-1051,-1037,-1024,-1010,-996,
  -982,-968,-953,-938,-923,-908,-893,-877,
  -862,-846,-830,-814,-798,-782,-766,-749,
  -733,-716,-699,-683,-666,-649,-632,-615,
  -598,-581,-564,-547,-530,-513,-496,-479,
  -462,-445,-428,-411,-395,-378,-361,-345,
  -328,-311,-295,-279,-262,-246,-230,-214,
  -199,-183,-167,-152,-136,-121,-106,-91,
  -76,-62,-47,-33,-19,-5,9,22,
  36,49,62,75,88,100,113,125,
  137,149,160,172,183,194,204,215,
  225,235,245,255,264,274,283,291,
  300,308,317,325,332,340,347,354,
  361,368,374,380,386,392,398,403,
  408,413,418,423,427,431,435,439,
  442,445,449,452,454,457,459,461,
  463,465,467,468,469,470,471,472,
  473,473,473,473,473,473,473,472,
  472,471,470,469,467,466,465,463,
  461,459,457,455,453,451,448,446,
  443,440,437,435,431,428,425,422,
  419,415,412,408,404,401,397,393,
  389,385,381,377,373,369,365,361,
  356,352,348,344,339,335,330,326,
  322,317,313,308,304,299,295,290,
  286,281,277,272,268,263,259,254,
  250,246,241,237,232,228,224,219,
  215,211,207,203,198,194,190,186,
  182,178,174,170,167,163,159,155,
  152,148,144,141,137,134,130,127,
  124,120,117,114,111,108,105,102,
  99,96,93,90,88,85,82,80,
  77,75,72,70,67,65,63,61,
  59,56,54,52,50,49,47,45,
  43,41,40,38,36,35,33,32,
  30,29,28,26,25,24,23,22,
  20,19,18,17,16,15,14,14,
  13,12,11,10,10,9,8,8,
  7,7,6,6,5,5,4,4
};

#endif /* _IOMLIB_D2AWGM3_H */
