#include <jni.h>
#include <string.h>
#include "nxm_ice_lib_VCore.h"
#include "native.h"

jint VCore_open();
jint VCore_syswr (jint addr, jint value);
jint VCore_syswrn (jint addr, jint value, jint clocks);
jint VCore_sysrd (jint addr);
jint VCore_process (jbyte *in, jint nin, jbyte *out, jint nout, jint nbw);
jint VCore_close();

JNIEXPORT jint JNICALL Java_nxm_ice_lib_VCore_open (JNIEnv *env, jobject obj) {
  return VCore_open();
}
JNIEXPORT jint JNICALL Java_nxm_ice_lib_VCore_syswr (JNIEnv *env, jobject obj, jint addr, jint value) {
  return VCore_syswr (addr,value);
}
JNIEXPORT jint JNICALL Java_nxm_ice_lib_VCore_syswrn (JNIEnv *env, jobject obj, jint addr, jint value, jint clocks) {
  return VCore_syswrn (addr,value,clocks);
}
JNIEXPORT jint JNICALL Java_nxm_ice_lib_VCore_sysrd (JNIEnv *env, jobject obj, jint addr) {
  return VCore_sysrd (addr);
}
JNIEXPORT jint JNICALL Java_nxm_ice_lib_VCore_process (JNIEnv *env, jobject obj,
    			jobject bufin, jint nin, jobject bufout, jint nout, jint nbw) {
  jbyte *bbufin = GetArray (bufin);
  jbyte *bbufout = GetArray (bufout);
  jint status = VCore_process (bbufin,nin,bbufout,nout,nbw);
  ReleaseArray(bufin,bbufin);
  ReleaseArray(bufout,bbufout);
  return status;
}
JNIEXPORT jint JNICALL Java_nxm_ice_lib_VCore_close (JNIEnv *env, jobject obj) {
  return VCore_close();
}

#ifndef _LINX
  
jint VCore_open(){};
jint VCore_syswr (jint addr, jint value){};
jint VCore_sysrd (jint addr){};
jint VCore_process (jbyte *in, jint nin, jbyte *out, jint nout, jint nbw){};
jint VCore_close(){};

#endif
