#include "icelib.c"

#include <jni.h>
#include <string.h>
#include "nxm_ice_lib_DevIce.h"
#include "native.h"

#define PICHANDLE(A) PICSTRUCT *(A) = (PICSTRUCT *)GetPointer(obj,"handle")

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_open (JNIEnv *env, jobject obj, jstring config, jint flags) {
  const char *ctext; int status;
  PICSTRUCT *p = (PICSTRUCT *)malloc( sizeof(PICSTRUCT) );
  SetPointer(obj,"handle",p);
  ctext = GetString(config);
  status = pic_open (p,(char *)ctext,(int_4 *)0,flags);
  ReleaseString(config,ctext);
  return status;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_close (JNIEnv *env, jobject obj) {
  jint status;
  PICHANDLE(p);
  status = pic_close (p);
  free((void *)p);
  return status;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_sniff (JNIEnv *env, jobject obj, jint flags) {
  PICHANDLE(p);
  return pic_sniff (p,flags);
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_detect (JNIEnv *env, jclass clazz, jint flags) {
  return pic_detect (flags);
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_reset (JNIEnv *env, jobject obj, jint flags) {
  PICHANDLE(p);
  return pic_reset (p,flags);
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_read (JNIEnv *env, jobject obj, jint offset) {
  jint value;
  PICHANDLE(p);
  pic_read (p,offset,(int_4*)&value);
  return value;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_write (JNIEnv *env, jobject obj, jint offset, jint value) {
  PICHANDLE(p);
  return pic_write (p,offset,(int_4*)&value);
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_name2offset (JNIEnv *env, jobject obj, jstring name, jint flags) {
  const char *ctext; jint offset;
  PICHANDLE(p);
  ctext = GetString(name);
  offset = pic_name2offset (p,(char *)ctext,flags);
  ReleaseString(name,ctext);
  return offset;
}

JNIEXPORT jbyte JNICALL Java_nxm_ice_lib_DevIce_getKeyType (JNIEnv *env, jobject obj, jint key) {
  PICHANDLE(p);
  return pic_getkeytype (p,key);
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_getKeySize (JNIEnv *env, jobject obj, jint key) {
  PICHANDLE(p);
  return pic_getkeysize (p,key);
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_name2key (JNIEnv *env, jobject obj, jstring name) {
  const char *ctext; jint key;
  PICHANDLE(p);
  ctext = GetString(name);
  key = pic_name2key (p,(char *)ctext);
  ReleaseString(name,ctext);
  return key;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_getKey (JNIEnv *env, jobject obj, jint dmac, jint key, jobject array, jint len) {
  PICHANDLE(p);
  jbyte *bbuf = GetArray(array);
  jint status = pic_getkey (p,dmac,key,(void*)bbuf,len);
  ReleaseArray(array,bbuf);
  return status;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_setKey (JNIEnv *env, jobject obj, jint dmac, jint key, jobject array, jint len) {
  PICHANDLE(p);
  jbyte *bbuf = GetArray (array);
  jint status = pic_setkey (p,dmac,key,(void*)bbuf,len);
  ReleaseArray(array,bbuf);
  return status;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_getKeyV__II (JNIEnv *env, jobject obj, jint dmac, jint key) {
  PICHANDLE(p);
  return pic_getkeyv (p,dmac,key);
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_getKeyL__II (JNIEnv *env, jobject obj, jint dmac, jint key) {
  PICHANDLE(p);
  return pic_getkeyl (p,dmac,key);
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_setKeyL (JNIEnv *env, jobject obj, jint dmac, jint key, jint value) {
  PICHANDLE(p);
  return pic_setkeyl (p,dmac,key,value);
}

JNIEXPORT jdouble JNICALL Java_nxm_ice_lib_DevIce_getKeyD__II (JNIEnv *env, jobject obj, jint dmac, jint key) {
  PICHANDLE(p);
  return pic_getkeyd (p,dmac,key);
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_setKeyD (JNIEnv *env, jobject obj, jint dmac, jint key, jdouble value) {
  PICHANDLE(p);
  return pic_setkeyd (p,dmac,key,value);
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_getKeyL__III (JNIEnv *env, jobject obj, jint dmac, jint key, jint value) {
  PICHANDLE(p);
  pic_getkey (p,dmac,key,&value,4);
  return value;
}

JNIEXPORT jdouble JNICALL Java_nxm_ice_lib_DevIce_getKeyD__IID (JNIEnv *env, jobject obj, jint dmac, jint key, jdouble value) {
  PICHANDLE(p);
  pic_getkey (p,dmac,key,&value,8);
  return value;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_getIntFlagDef (JNIEnv *env, jobject obj, jstring name, jint def) {
  const char *ctext; jint value;
  PICHANDLE(p);
  ctext = GetString(name);
  value = pic_getintflagdef (p,(char *)ctext,def);
  ReleaseString(name,ctext);
  return value;
}

JNIEXPORT jdouble JNICALL Java_nxm_ice_lib_DevIce_getDblFlagDef (JNIEnv *env, jobject obj, jstring name, jdouble def) {
  const char *ctext; jdouble value;
  PICHANDLE(p);
  ctext = GetString(name);
  value = pic_getdblflagdef (p,(char *)ctext,def);
  ReleaseString(name,ctext);
  return value;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_getRawFlag (JNIEnv *env, jobject obj, jstring name, jobject data, jint len) {
  const char *ctext; jbyte *pdata; jint value;
  PICHANDLE(p);
  ctext = GetString(name);
  pdata = GetArray(data);
  value = pic_getstrflag (p,(char *)ctext,(char *)pdata,0);
  ReleaseArray(data,pdata);
  ReleaseString(name,ctext);
  return value;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_rpm (JNIEnv *env, jobject obj, jint node, jint offset) {
  PICHANDLE(p);
  jint value;
  jint status = pic_rpm (p,node,offset,(void*)&value,4,FLG_PPC_MEM);
  return value;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_wpm (JNIEnv *env, jobject obj, jint node, jint offset, jint value) {
  PICHANDLE(p);
  jint status = pic_wpm (p,node,offset,(void*)&value,4,FLG_PPC_MEM);
  return status;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_rpb (JNIEnv *env, jobject obj, jint node, jint offset) {
  PICHANDLE(p);
  jint value;
  jint status = pic_rpm (p,node,offset,(void*)&value,4,FLG_PPC_BUS);
  return value;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_wpb (JNIEnv *env, jobject obj, jint node, jint offset, jint value) {
  PICHANDLE(p);
  jint status = pic_wpm (p,node,offset,(void*)&value,4,FLG_PPC_BUS);
  return status;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_rpc (JNIEnv *env, jobject obj, jint node, jint offset, jint size) {
  PICHANDLE(p);
  jint value;
  jint status = pic_rpm (p,node,offset,(void*)&value,size,FLG_CTL_BUS);
  return value;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_wpc (JNIEnv *env, jobject obj, jint node, jint offset, jint value, jint size) {
  PICHANDLE(p);
  jint status = pic_wpm (p,node,offset,(void*)&value,size,FLG_CTL_BUS);
  return status;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_loadFile (JNIEnv *env, jobject obj, jstring name, jint flags) {
  const char *ctext; int status;
  PICHANDLE(p);
  ctext = GetString(name);
  status = pic_loadfile (p,(char *)ctext,flags);
  ReleaseString(name,ctext);
  return status;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_loadFC (JNIEnv *env, jobject obj, jint port, jobject data, jint size, jint flags) {
  PICHANDLE(p);
  jbyte *pdata = GetArray(data);
  jint status = pic_loadfc (p, (int_4)port, (int_2*)pdata, (int_4)size, (int_4)flags);
  ReleaseArray(data,pdata);
  return status;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_test (JNIEnv *env, jobject obj, jint test, jint flags) {
  PICHANDLE(p);
  return pic_test (p,test,flags);
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_dmaDump (JNIEnv *env, jobject obj, jint dmac, jint flags) {
  PICHANDLE(p);
  return pic_dmadump (p,dmac,flags);
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_nvRam (JNIEnv *env, jobject obj, jstring filename, jint flags) {
  PICHANDLE(p);
  pic_nvram (p,"",flags);
  return 0;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_ioPort (JNIEnv *env, jobject obj,
	jint type, jint index, jint dmac, jint dir, jint bits, jint rate, jdouble fcny, jint dec, jint gain, jint flags) {
  PICHANDLE(p);
  return pic_ioport (p,type,index,dmac,dir,bits,rate,fcny,dec,gain,flags); 
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_mapMem (JNIEnv *env, jobject obj, jobject map, jint psize, jint mode) {
  jint status=1; 
  jobject devn;
  const char *ctext;
  DMAMAP _map;
  PICHANDLE(p);
  _map.paddr = GetLong(map,"paddr");
  _map.bytes = GetLong(map,"bytes");
  _map.offset = GetLong(map,"offset");
  _map.vbytes = GetLong(map,"vbytes");
  _map.vaddr = (char *)GetPointer(map,"vaddr");
  devn = GetStringObject(map,"devn");
  if (devn != 0) {
    ctext = GetString(devn);
    strcpy(_map.devn,ctext);
    ReleaseString(devn,ctext);
  }
  else _map.devn[0] = 0;
  status = pic_mapmem (p,&_map,psize,mode); 
  if (mode>0) {
    SetLong(map,"paddr",_map.paddr);
    SetLong(map,"bytes",_map.bytes);
    SetLong(map,"offset",_map.offset);
    SetLong(map,"vbytes",_map.vbytes);
    SetPointer(map,"vaddr",_map.vaddr);
  } 
  return status;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_dmaStat (JNIEnv *env, jobject obj, jint dmac, jobject dmastat) {
  jint index,cycle,status; 
  PICHANDLE(p);
  status = pic_dmastat (p,dmac,&index,&cycle); 
  SetInt(dmastat,"index",index);
  SetInt(dmastat,"cycle",cycle);
  return status;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_dmaSetup (JNIEnv *env, jobject obj, jint dmac, jint dir, jobject map, jint block, jint flags) {
  DMAMAP _map;
  PICHANDLE(p);
  _map.bytes = GetLong(map,"bytes");
  _map.offset = GetLong(map,"offset");
  _map.vaddr = (char *)GetPointer(map,"vaddr");
  _map.paddr = GetLong(map,"paddr");
  return pic_dmasetup (p,dmac,dir,&_map,block,flags); 
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_dmaChain (JNIEnv *env, jobject obj, jint dmac, jint index, jobject map, jint todo, jint next) {
  DMAMAP _map;
  PICHANDLE(p);
  _map.bytes = GetLong(map,"bytes");
  _map.offset = GetLong(map,"offset");
  _map.vaddr = (char *)GetPointer(map,"vaddr");
  _map.paddr = GetLong(map,"paddr");
  return pic_dmachain (p,dmac,index,&_map,todo,next); 
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_setMapData (JNIEnv *env, jobject obj, jlong vaddr, jint moff, jobject array, jint boff, jint bytes) {
  PICHANDLE(p);
  jbyte *bbuf = GetArray (array);
  memcpy((jbyte *)((jpointer)vaddr)+moff,bbuf+boff,bytes);
  ReleaseArray(array,bbuf);
  return bytes;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_getMapData (JNIEnv *env, jobject obj, jlong vaddr, jint moff, jobject array, jint boff, jint bytes) {
  PICHANDLE(p);
  jbyte *bbuf = GetArray(array);
  memcpy(bbuf+boff,((jbyte *)(jpointer)vaddr)+moff,bytes);
  ReleaseArray(array,bbuf);
  return bytes;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_dmaFunc (JNIEnv *env, jobject obj, jint dmac, jint func) {
  PICHANDLE(p);
  return pic_dmafunc (p,dmac,func); 
}

JNIEXPORT jlong JNICALL Java_nxm_ice_lib_DevIce_dmaFuncX (JNIEnv *env, jobject obj, jint dmac, jint func) {
  PICHANDLE(p);
  return pic_dmafuncx (p,dmac,func); 
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_spec (JNIEnv *env, jobject obj, jobject map, jobject spec, jint flags) {
  jint bytes,*vaddr; jlong paddr;
  jint block,total,sjump,bjump,status; 
  jfloat srate,brate;
  PICHANDLE(p);
  vaddr = GetPointer(map,"vaddr");
  paddr = GetLong(map,"paddr");
  bytes = (int)GetLong(map,"bytes");
  block = GetInt(spec,"block");
  status = pic_spec (p,(int_4*)vaddr,long2phys(paddr),bytes/4,block,
	(int_4*)&total,(float*)&srate,(int_4*)&sjump,(float*)&brate,(int_4*)&bjump,(int_4)flags);
  SetInt(spec,"total",total);
  SetInt(spec,"sjump",sjump);
  SetFloat(spec,"srate",srate);
  SetInt(spec,"bjump",bjump);
  SetFloat(spec,"brate",brate);
  return status;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_tc (JNIEnv *env, jobject obj, jint dmac, jdouble offset, jdouble delta, jobject tc, jint flag) {
  jint status; jdouble wsec,fsec;
  PICHANDLE(p);
  status = pic_tc (p,dmac,&offset,&delta,&wsec,&fsec,flag);
  SetDouble(tc,"offset",offset);
  SetDouble(tc,"wsec",wsec);
  SetDouble(tc,"fsec",fsec);
  return status;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_tcInsert (JNIEnv *env, jobject obj, jobject map, jobject tc, jint flag) {
  jint status,*vaddr; jlong bytes; jdouble wsec,fsec,delta;
  PICHANDLE(p);
  vaddr  = GetPointer(map,"vaddr");
  bytes  = GetLong(map,"bytes");
  wsec   = GetDouble(tc,"wsec");
  fsec   = GetDouble(tc,"fsec");
  delta  = GetDouble(tc,"delta");
  status = pic_tc_insert (p,(int_2*)vaddr,(int_4)(bytes/2),
			delta,wsec,fsec,flag);
  return status;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_buffer (JNIEnv *env, jobject obj, jobject map, jint offset, jobject array, jint length, jint mode) {
  jint status;  jbyte *bbuf=0;
  DMAMAP _map;
  PICHANDLE(p);
  if (map!=0) {
    _map.bytes = GetLong(map,"bytes");
    _map.offset = GetLong(map,"offset");
    _map.vaddr = (char *)GetPointer(map,"vaddr");
    _map.paddr = GetLong(map,"paddr");
  }
  if (array!=0) bbuf = GetArray(array);
  status = pic_buffer (p,&_map, (int_4)offset, (int_1*)bbuf, (int_4)length, (int_4)mode);
  if (array!=0) ReleaseArray(array,bbuf);
  return status;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_sendrecv (JNIEnv *env, jobject obj, jint node, jobject head, jobject data, jint bytes, jint maxbytes, jint flags, jint timeout) {
  PICHANDLE(p);
  jbyte *phead = GetArray(head);
  jbyte *pdata = GetArray(data);
  jint status = pic_sendrecv (p, (int_4)node, (int_4*)phead, (int_4*)pdata, (int_4)bytes,
				 (int_4)maxbytes, (int_4)flags, (int_4)timeout);
  ReleaseArray(head,phead);
  ReleaseArray(data,pdata);
  return status;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_send (JNIEnv *env, jobject obj, jint node, jobject head, jobject data, jint bytes, jint flags) {
  PICHANDLE(p);
  jbyte *phead = GetArray(head);
  jbyte *pdata = GetArray(data);
  jint status = pic_send (p, (int_4)node, (int_4*)phead, (int_4*)pdata, (int_4)bytes, (int_4)flags);
  ReleaseArray(head,phead);
  ReleaseArray(data,pdata);
  return status;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_recv (JNIEnv *env, jobject obj, jint node, jobject head, jobject data, jint bytes, jint flags) {
  PICHANDLE(p);
  jbyte *phead = GetArray(head);
  jbyte *pdata = GetArray(data);
  jint status = pic_recv (p, (int_4)node, (int_4*)phead, (int_4*)pdata, (int_4)bytes, (int_4)flags);
  ReleaseArray(head,phead);
  ReleaseArray(data,pdata);
  return status;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_str2ip (JNIEnv *env, jobject obj, jstring str) { const char *ctext; jint status;
  PICHANDLE(p);
  ctext = GetString(str);
  status = pic_str2ip (p,(char *)ctext);
  ReleaseString(str,ctext);
  return status;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_compress (JNIEnv *env, jobject obj, jobject ibuf, jint ilen, jobject obuf, jint olen, jint dir) {
  jbyte *pibuf = GetArray(ibuf);
  jbyte *pobuf = GetArray(obuf);
  jint status = pic_compress ((int_1*)pibuf,ilen, (int_1*)pobuf,olen, dir);
  ReleaseArray(ibuf,pibuf);
  ReleaseArray(obuf,pobuf);
  return status;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_cvt12 (JNIEnv *env, jobject obj, jlong vaddr, jobject data, jint bytes, jint dir) {
  jbyte *pdata = GetArray(data);
  int_u1 *b12=(int_u1*)(jpointer)vaddr, *b16=(int_u1*)pdata;
  jint i,j, ndata=bytes/4;
  if (dir==0) for (i=0; i<ndata; i++,b16+=4,b12+=4) {
    b16[0] = b12[0];
    b16[1] = b12[1];
    b16[2] = b12[2];
    b16[3] = b12[3];
  }
  if (dir<0) for (i=j=0; i<ndata; i+=1,b16+=4,b12+=3) {
    b16[0] =  b12[0]<<4;
    b16[1] = (b12[0]>>4)|(b12[1]<<4);
    b16[2] =  b12[1]&0xF0;
    b16[3] =  b12[2];
  }
  if (dir<0) for (i=j=0; i<ndata; i+=1,b16+=4,b12+=3) {
    b12[0] = (b16[1]<<4)|((b16[0]>>4)&0x0F);
    b12[1] = (b16[2]&0xF0)|((b16[1]>>4)&0x0F);
    b12[2] =  b16[3];
  }
  ReleaseArray(data,pdata);
  return 0;
}

JNIEXPORT jint JNICALL Java_nxm_ice_lib_DevIce_query (JNIEnv *env, jobject obj, jint type, jint info, jobject array, jint len) {
  PICHANDLE(p);
  jbyte *bbuf = GetArray (array);
  jint status = pic_query (p,type,info,(void*)bbuf,len);
  ReleaseArray(array,bbuf);
  return status;
}

