c************
c  Description:	Header file for ICE-PIC data packet headers 
c
c  Author:	Jeff Schoen 7/99
c
c  $Revision:	$
c  $Modtime:	$
c
c************
	integer*4 ICE_HDR_SZ
	parameter (ICE_HDR_SZ=64)

	structure /PACKETSTRUCT/
	  byte		keys(4)		! barker syncs(3) and packet type(1)
	  integer*4	count		! packet number since start of xfer
	  integer*4	elem		! data elements in packet
	  integer*2	user		! user defined field
	  integer*2	channel		! port channel number
	  byte		id1,id2		! subsystem IDs
	  byte		rep		! data rep (Vax,Ieee,Eeei)
	  byte		bpa		! bytes per atom=(mode,type)
	  byte		mode		! data format mode (Complex, Scalar)
	  byte		type		! data format type (Pack,Byte,Int,Long)
	  byte		tcmode		! timecode mode
	  byte		tcstatus	! timecode status
	  real*8	tcoff		! sample offset from data(1) to TC
	  real*8	tcwsec		! timecode 1950 whole seconds
	  real*8	tcfsec		! timecode fractional seconds
	  UNION
	  MAP
	  real*8	xdelta,xstart	! frame start and delta fields
	  END MAP
	  MAP
	  real*8	dval(2)		! user fields
	  END MAP
	  MAP
	  real*4	fval(4)		! user fields
	  END MAP
	  MAP
	  integer*4	lval(4)		! user fields
	  END MAP
	  MAP
	  integer*2	ival(8)		! user fields
	  END MAP
	  MAP
	  byte		bval(16)	! user fields
	  END MAP
	  MAP
	  integer*4	ramphys		! RAM buffer physical address
	  integer*4	ramsize		! RAM buffer physical size
	  integer*4	dataoffset	! RAM buffer data offset (bytes)
	  integer*4	datasize	! RAM buffer data size (bytes)
	  END MAP
	  END UNION
	endstructure

	structure /RMIFPACKETSTRUCT/
	  byte func         ! defines the method to call
	  byte flag         ! is the protocol version number and options mask
	  byte info         ! channel number for fast routing of monitored properties
	  byte rep          ! packet data representation (VAX|IEEE|EEEI)
	  byte seq          ! sequence number (0-127) for Reliable packets
	  byte try          ! number of resends for Reliable packets
	  byte rpt          ! report sequence number 
	  byte adj          ! number of bytes in adjunct header
	endstructure

	integer*4 SDDS_HDR_SZ,SDDS_DATA_SZ,SDDS_PACKET_SZ
	parameter (SDDS_HDR_SZ=56,SDDS_DATA_SZ=1024,SDDS_PACKET_SZ=1080)

	structure /SDDSPACKETSTRUCT/
	  byte  keys(2)		! barker packet sync 0x55AA
	  byte	port(2)		! UDP source|destination port
	  byte	addr(4)		! UDP source|destination address
				! now starts the actual SDDS UDP payload
	  byte	format(2)	! format identifier
	  byte	frame(2)	! frame sequence number
	  byte	tcvalid(4)	! TC valid and 1ms Delta
	  byte	tctics(8)	! TC 250psec tics since jan 1
	  byte	tcext(4)	! TC extended precision
	  byte	sscinfo(12)	! SSC information
	  byte	ssdinfo(4)	! SSD information | IP address
	  byte	aadinfo(20)	! AAD information
	  byte  data(1024)	! packet data
	endstructure
