/***********************************************************************
	Description:	SHARC DMA MAP definitions for ICE cards
	Author: 	Jeff Schoen - Innovative Computer Engineering
	Date:		1/97
************************************************************************/

#if HOST
#define IMS p->ims
#define EMS p->ems
#elif _PPC
#define IMS 0x00020000
#define EMS 0x00400000
#define IMSBIT 17
#define EMSBIT 23
#elif _2116X
#define IMS 0x00040000
#define EMS 0x00800000
#define IMSBIT 18
#define EMSBIT 24
#else
#define IMS 0x00020000
#define EMS 0x00400000
#define IMSBIT 17
#define EMSBIT 23
#endif

#define EMS_B0	(EMS+0x000000)
#define EMS_B1	(EMS+0x100000)
#define EMS_B2	(EMS+0x200000)
#define EMS_B3	(EMS+0x300000)
#define EMS_BU	(EMS+0x400000)

/* Host DMA Structure Base Address */
#define DMA_STK		(IMS|0x7000)
#define DMA_SEP		0x30
#define DMA_CHNSX	48
#define DMA_CHNSY	76
#define DMA_STK1        (DMA_STK+DMA_SEP*DMA_CHNSX)

/* IO Module State Structure Storage */
#define IOM_SSB1	(IMS|0x7900)
#define IOM_SSB2	(IMS|0x7940)

/* Host APP Structure Base Address */
#define APP_STK		(IMS|0x7900)
#define APP_SEP		0x10
#define APP_CHNS 	14

/* Version info address */
#define CHECKSUM_ADDR	(IMS|0x79E0)
#define APP_GENA	(IMS|0x79F0)
#define RSTIME_ADDR	(IMS|0x79F8)
#define IOMCODE_ADDR	(IMS|0x79FB)
#define TIMER_ADDR	(IMS|0x79FC)
#define SOCCODE_ADDR	(IMS|0x79FD)
#define IOCCODE_ADDR	(IMS|0x79FE)
#define VERSION_ADDR	(IMS|0x79FF)

/* Host DMA Structure Secondary Address */
#define DMA_STK2	(IMS|0x7A00)
#define DMA_CHNS2	32

/* Look-up Table Address */
#define DM_LUT		(IMS|0x4800)		/* must be 2K word aligned */
#define DM_CHAIN1	(IMS|0x4800)
#define DM_CHAIN2	(IMS|0x4C00)
#define DM_CHAIN3	(IMS|0x7A00)
#define DM_CHAIN_SIZE	0x400

/* Filter taps (PIC3 only) */
#define DM_FILT1	(IMS|0x7E00)
#define DM_FILT2	(IMS|0x7E80)

/* Alg TTDM scratch area */
#define DM_ALG_ADDR	(IMS|0x7E00)
#define DM_ALG_SIZE	0x100

/* Host Port Queue */
#define DM_HPQUEUE      (IMS|0x7E00)

/* TCB Chain Pointer areas */
#define DMA_TCBCP	(IMS|0x7F00)

/* Host DMA Request Struct Base Address */
#define DMA_TEMP	(IMS|0x7F70)
#define DMA_DTCP	(IMS|0x7F78)
#define DMA_HPQL	(IMS|0x7F7D)
#define DMA_HPQI	(IMS|0x7F7E)
#define DMA_QPTR	(IMS|0x7F7F)
#define DMA_QUE		(IMS|0x7F80)
#define APP_QUE		(IMS|0x7FB0)

/* Temporary Status Registers */
#define DMA_TCBTMP	(IMS|0x7FD0)
#define DMA_TSEL	(IMS|0x7FDE)
#define DMA_GICLK	(IMS|0x7FDF)

#define DMA_TCFGS	(IMS|0x7FE0)

#define DMA_ROUTD	(IMS|0x7FEB)
#define DMA_OVSR	(IMS|0x7FEC)
#define DMA_ROUTF	(IMS|0x7FED)
#define DMA_IOPCFG	(IMS|0x7FEE)
#define DMA_JRWIOB	(IMS|0x7FEF)
#define DMA_TCDAT	(IMS|0x7FF0) 		/* TimeCode Return area */
#define DMA_GPASS	(IMS|0x7FF9)
#define DMA_GSTAT	(IMS|0x7FFA)
#define DMA_MTAP	(IMS|0x7FFB)
#define DMA_GMCFG	(IMS|0x7FFC)
#define DMA_HBT		(IMS|0x7FFF)

/* TEMP DMA buffer Address */
#define DMA_TEMP_ADDR	(IMS|0x8000)
#define DMA_TEMP_SIZE	0x01000

/* TEMP DMA buffer Address */
#define DMA_INT_ADDR	(IMS|0x7A00)
#define DMA_INT_SIZE	0x00400

/* Host DMA control registers */
#define EP0_CTL	0x1c
#define EP1_CTL	0x1d
#define EP2_CTL	0x1e
#define EP3_CTL	0x1f
#define EP0_TCB	0x40
#define EP1_TCB	0x48
#define EP2_TCB	0x50
#define EP3_TCB	0x58

/* SHARC TCB interrupt handler structure offsets */
#define TCB_II	0
#define TCB_IM	1
#define TCB_IC	2
#define TCB_CP	3
#define TCB_GP	4
#define TCB_DB	5
#define TCB_DA	6
#define TCB_EI	5
#define TCB_EM	6
#define TCB_EC	7
#define TCB_YC	4
#define TCB_YI	5

/* Host DMA interrupt handler structure offsets */
#define DMA_HADDR	0
#define DMA_HSIZE	1
#define DMA_HINDEX 	2
#define DMA_HCYCLE 	3
#define DMA_CADDR	4
#define DMA_CSIZE	5
#define DMA_CINDEX 	6
#define DMA_CCYCLE 	7

#define DMA_STAT	8
#define DMA_DIR	 	9
#define DMA_TODO	10
#define DMA_BLOCK	11
#define DMA_CNTRL	12
#define DMA_TCBP	13
#define DMA_REG		14
#define DMA_MCSR	15

#define DMA_ENB		16
#define DMA_ENBX	17
#define DMA_MCFG	18
#define DMA_MCFGX	19
#define DMA_ERR		20
#define DMA_MISS	21
#define DMA_IPER	22
#define DMA_MULTI	23

#define DMA_HXFER	24
#define DMA_HXFES	25
#define DMA_CXFER	26
#define DMA_CXFES	27
#define DMA_CINDP	28
#define DMA_HINDP	29
#define DMA_CIND	30
#define DMA_HIND	31

#define DMA_TYPE	32
#define DMA_PORT	33
#define DMA_BITS	34
#define DMA_DEC		35
#define DMA_RATE	36
#define DMA_GAIN	37
#define DMA_FCNY	38
#define DMA_FRAME	39

#define DMA_MASTER	40
#define DMA_SLAVE	41
#define DMA_FEED	42
#define DMA_TCOFF	43
#define DMA_ALG		44
#define DMA_APPP	45
#define DMA_CHAIN	46
#define DMA_FLAGS	47

/* Host APP handler structure offsets */
#define APP_ENA		0
#define APP_ALG 	1
#define APP_XFERI	2
#define APP_XFERO	3
#define APP_DMAI	4
#define APP_DMAO 	5
#define APP_INDI	6
#define APP_INDO 	7
#define APP_ARGS 	8
#define APP_ICI	 	12
#define APP_ICO 	13
#define APP_TC 		14
#define APP_TCBP 	15

