/***********************************************************************
  Description:	IOC definitions for JTAG interfaces
  Author: 	Jeff Schoen - Innovative Computer Engineering
  Date:		1/97

  Bits are shifted in from LSB to MSB for each control word

  Command register lengths are 10, 14, 22, and 30,

  MSK bits 0xEE0S0R0W 
           Enable TDO mask 
           Select TDI input 
           Read bit per byte 
           Write bit per byte 

  All CMD end up in Shift-DR
  All Data end up in Exit-DR
  RTI = Run Test/Idle
  TLR = Test Logic Reset

************************************************************************/
#define JTAG_PORT_SOC		0
#define JTAG_PORT_IOMOFF	0
#define JTAG_PORT_FLASH		4
#define JTAG_PORT_IOOFF		2
#define JTAG_PORT_IOALL		3
#define JTAG_PORT_PMOFF		10
#define JTAG_PORT_PMALL		15

#define JTAG_MSK_CMD     0x0000000F	/* 14-bit command from anywhere */
#define JTAG_TMS_CMD     0x380000DF	/* to Shift-DR */
#define JTAG_TMS_CMDR    0x180000DF	/* to Run/Test/Idle */
#define JTAG_FRTIMASK    0xFFFFFFC0	/* from RTI instead of from TLR */
#define JTAG_TMS_RCMD    0x380000C0	/* from Run/Test/Idle */
#define JTAG_TMS_XCMD    0x380000F0	/* from Exit-DR */
#define JTAG_TMS_XCMDR   0x180000F0	/* from Exit-DR to RTI */

#define JTAG_MSK_CMDP    0x00000007	/* 14-bit command prep from anywhere */
#define JTAG_TMS_CMDP    0x000000DF	
#define JTAG_TMS_XCMDP   0x000000F0	/* 14-bit command prep from Exit-DR */
#define JTAG_TMS_RCMDP   0x000000C0	/* 14-bit command prep from Run/Test/Idle */
#define JTAG_MSK_PCMD    0x00000007	/* 16-bit command from Prep */		
#define JTAG_TMS_PCMD    0x00388000
#define JTAG_TMS_PCMD1   0x001C8000	/* 16-bit command from Prep with 1 delay */	
#define JTAG_TMS_PCMDR   0x00018000	/* 16-bit command from Prep to RTI */

#define JTAG_MSK_SD2R    0x00000001	/* Shift-DR  to RTI */
#define JTAG_TMS_SD2R    0x00000001	

#define JTAG_MSK_R2SD    0x00000001	/* RTI to Shift-DR */
#define JTAG_TMS_R2SD    0x00000020	
#define JTAG_TMS_R2SD1   0x00000010	

#define JTAG_MSK_STARTUP 0x00000003
#define JTAG_TMS_STARTUP 0x0000F000	/* to Reset */

#define JTAG_MSK_RST     0x00000001	/* to reset */
#define JTAG_TMS_RST     0x000000FF
#define JTAG_MSK_RSTC    0x00000001	/* to RTI */
#define JTAG_TMS_RSTC    0x0000007F
#define JTAG_MSK_RSTX    0x0000000F	/* to Exit-IR */
#define JTAG_TMS_RSTX    0x8000037F

#define JTAG_MSK_GET8    0x00000101
#define JTAG_TMS_GET8    0x00000080
#define JTAG_MSK_GET8R   0x00000303
#define JTAG_TMS_GET8R   0x0000FF80
#define JTAG_MSK_GET16   0x00000303
#define JTAG_TMS_GET16   0x00008000
#define JTAG_MSK_GET16X  0x00000303
#define JTAG_TMS_GET16X  0x00000000
#define JTAG_MSK_GET16R  0x00000707
#define JTAG_TMS_GET16R  0x00FF8000
#define JTAG_MSK_GET24   0x00000707
#define JTAG_TMS_GET24   0x00800000
#define JTAG_MSK_GET24R  0x00000F0F
#define JTAG_TMS_GET24R  0xFF800000
#define JTAG_MSK_GET32   0x00000F0F
#define JTAG_TMS_GET32   0x80000000
#define JTAG_MSK_GET32X  0x00000F0F
#define JTAG_TMS_GET32X  0x00000000

#define JTAG_MSK_SET8    0x00000001
#define JTAG_TMS_SET8    0x00000080
#define JTAG_MSK_SET8R   0x00000003
#define JTAG_TMS_SET8R   0x0000FF80
#define JTAG_MSK_SET16   0x00000003
#define JTAG_TMS_SET16   0x00008000
#define JTAG_MSK_SET16X  0x00000003
#define JTAG_TMS_SET16X  0x00000000
#define JTAG_MSK_SET16R  0x00000007
#define JTAG_TMS_SET16R  0x00FF8000
#define JTAG_MSK_SET24   0x00000007
#define JTAG_TMS_SET24   0x00800000
#define JTAG_MSK_SET24R  0x0000000F
#define JTAG_TMS_SET24R  0xFF800000
#define JTAG_MSK_SET32   0x0000000F
#define JTAG_TMS_SET32   0x80000000
#define JTAG_MSK_SET32X  0x0000000F
#define JTAG_TMS_SET32X  0x00000000

#define JTAG_MSK_WMOD32  0x0000000F
#define JTAG_MSK_RMOD32  0x00000F0F
#define JTAG_TMS_WMOD32  0xFFFFFFFE
#define JTAG_TMS_RMOD32  0xFFFFFFFE
#define JTAG_MSK_WMOD16  0x00000003
#define JTAG_TMS_WMOD16  0x0000FFFE

#define JTAG_CMD_EXTEST   0x3FC0
#define JTAG_CMD_SAMPLE   0x3FC1
#define JTAG_CMD_USER1    0x3FC2
#define JTAG_CMD_USER2    0x3FC3
#define JTAG_CMD_USER3    0x3FD2
#define JTAG_CMD_USER4    0x3FD3
#define JTAG_CMD_CFGOUT   0x3FC4
#define JTAG_CMD_CFGIN    0x3FC5
#define JTAG_CMD_UIDCODE  0x3FC8
#define JTAG_CMD_IDCODE   0x3FC9
#define JTAG_CMD_JPROGB   0x3FCB
#define JTAG_CMD_JSTART   0x3FCC
#define JTAG_CMD_JSHUTD   0x3FCD
#define JTAG_CMD_SYSMON   0x3FF7
#define JTAG_CMD_BYPASS   0x3FFF

#define JTAG_STXCMD_EXTEST   0x3FC00
#define JTAG_STXCMD_PULSNCFG 0x3FC01
#define JTAG_STXCMD_PGMCMD   0x3FC02
#define JTAG_STXCMD_STARTUP  0x3FC03
#define JTAG_STXCMD_CHKSTATS 0x3FC04
#define JTAG_STXCMD_SAMPLE   0x3FC05
#define JTAG_STXCMD_IDCODE   0x3FC06
#define JTAG_STXCMD_UIDCODE  0x3FC07
#define JTAG_STXCMD_INTEST   0x3FC08
#define JTAG_STXCMD_REGSCAN  0x3FC09
#define JTAG_STXCMD_USER0    0x3FC0C
#define JTAG_STXCMD_USER1    0x3FC0E
#define JTAG_STXCMD_SCMCMD   0x3FEFF
#define JTAG_STXCMD_BYPASS   0x3FFFF
#define JTAG_EPC2CMD_IDCODE  0x3FC59

#define JTAG_CMD_PPC_BYPASS 0x3E0
#define JTAG_CMD_PPC_DEBUG1 0x160
#define JTAG_CMD_PPC_DEBUG2 0x1E0
#define JTAG_CMD_PPC_DEBUG3 0x260
#define JTAG_CMD_PPC_DEBUG4 0x2A0
#define JTAG_CMD_PPC_DEBUG5 0x2E0
#define JTAG_CMD_PPC_DEBUG6 0x320
#define JTAG_CMD_PPC_DEBUG7 0x360
#define JTAG_CMD_PPC_DEBUG8 0x3A0

