/* CORE Hardware Abstraction Layer Object fields */

#ifndef _IceHalo_
#define _IceHalo_

typedef struct {

  int_4 sys;		// system register
  int_4 dec;		// decimation register
  int_4 gain;		// gain register
  int_4 rate;		// sample rate register
  int_4 ratio;		// resampler ratio register
  int_4 frame;		// frame register
  int_4 freq;		// frequency register
  int_4 flag;		// flags register

  int_4 user[8];	// user0 registers

// 64 bytes to here

  int_4 func;           // HW action to perform
  int_4 fmts;           // HW formats
  int_4 flow;
  int_4 impl;

  int_4 flgs;
  int_4 psize;          // parameter section size in bytes
  int_4 status;         // completion status
  int_4 scid;		// subCore ID

  int_4 mcid;		// multicore channel
  int_4 ncvar;		// number of class variables for JVCC core
  char  name[8];	// core name

  int_4 state;		// current state
  int_4 vbpr;		// verbose print
  int_4 prep;		// has preProcess/postProcess
  int_4 loadOff;

// 128 bytes to here

  char* config;
  PICSTRUCT* ph;	// PIC handle

  int_4 (*init)(void *halo);
  int_4 (*work)(void *halo, void *si, void *sip, void *so, void *sop, int_4 bw);
  int_4 (*free)(void *halo);
  int_4 (*set)(void *halo, void *key, void *value);
  int_4 (*get)(void *halo, void *key, void *value);
  int_4 (*open)(void *halo);
  int_4 (*process)(void *halo, void *si, void *so);
  int_4 (*close)(void *halo);
  int_4 (*poll)(void *halo);
  int_4 (*upload)(void *halo, void *planp);
  int_4 (*sysrd)(void *halo, int_4 addr); 
  int_4 (*syswr)(void *halo, int_4 addr, int_4 value);

  int_4 (*process4)(void *halo, void *si, void *sip, void *so, void *sop);
  int_4 *loadBuf;

#ifndef _LONG64
  int_4 filler[16];	// PAD 16 pointers to 256 byte length;
#endif

} HALO;

typedef struct {
  HALO halo;
} CorePlan;

typedef struct {
  HALO halo;
} CORE;

void *core_alloc (char *name, char *impl, void*context);
int_4 core_open (void *handle);
int_4 core_close (void *handle);
int_4 core_setkeytable (void *handle, char *stable);

#endif
