#define FIO_INPUT  0x01
#define FIO_OUTPUT 0x02
#define FIO_INOUT  0x03
#define FIO_BLUE   0x04
#define FIO_RTFILE 0x08
#define FIO_COMPARE 0x10
#define FIO_ICERAM  0x20
#define FIO_VERBOSE 0x40
#define FIO_DEBUG   0x80

#include "icehdr.h"
  
typedef struct {
  ICEHDR hcb;
  int_4 fd,fdh;
  int_4 start;
  int_4 flags;
  int_8 length;
  int_8 offset;
  int_8 loff;
  int_8 paddr;
  int_8 psize;
  void *pbuffer;
} FIOSTRUCT;
  
#ifdef __cplusplus
extern "C" {
#endif
FIOSTRUCT* fioOpen (const char *url, int_4 flags);
int_4 fioSeek  (FIOSTRUCT *f, int_8 offset);
int_4 fioWrite (FIOSTRUCT *f, void* buffer, int_4 len);
int_4 fioRead  (FIOSTRUCT *f, void* buffer, int_4 len);
int_4 fioClose (FIOSTRUCT *f);
// here for Freya for now
int_4 fioGetKey (const char* table, const char *key, char *value, int_4 flag);
int_4 fioGetKeyL (const char* table, const char *key, int_4 def);
int_8 fioGetKeyX (const char* table, const char *key, int_8 def);
real_8 fioGetKeyD (const char* table, const char *key, real_8 def);
int_4 fioGetKeyState (const char* table, const char *key, int_4 def);
int_4 fioGetKeyCmp (const char* table, const char *key, const char *match);
#ifdef __cplusplus
}
#endif

