c************
c   Description : PIC Functions Primitive
c
c   Author :    JGS   1/20/99
c
c   $Revision:   1.15  $
c   $Modtime:   01/17/96 10:14:44  $
c   
c************
	program PICFUNC
c
	implicit none
	include 'picfunc.inc'
	record /HEADER/ HP,HF(mfiles),HWF,HPIPE,HSOCK
c
	character*8 cnum, mode
	real*4    pause / 0.025 /
	byte      buf(1),out(1)
	pointer   (pbuf,buf),(pout,out)
	pointer   (phpipe,hpipe)
	logical*4 pkt_hdrs
        integer*8 vaddr
c
	call M$CHECKIN
c
c validate the mode
	mode = M$UPICK(1)
	if (mode.eq.'GSM') then
	  dir = -1
	elseif (mode.eq.'E1MUX') then
	  dir = -1
	elseif (mode.eq.'PACK') then
	  dir = 1
	elseif (mode.eq.'UNPACK') then
	  dir = -1
	else
	  call M$ERROR('Invalid mode: '//mode)
	endif
	usefile = M$UPICK(2) .eq. 'FILE'
	usesock = M$UPICK(2) .eq. 'SOCKET'
	usepic = .not. (usefile.or.usesock)
	sockbuf  = M$GET_SWITCH_DEF('SOCKBUF',16384)
c
c find the PIC device
	if (usepic) then
	i  = M$HWF_OPEN (hwf) 
	ls = M$HWF_ALIAS (hwf, M$APICK(2), string) 
	i  = M$HWF_CLOSE (hwf) 
c
c open the PIC device
	flags = 0
	if (M$GET_PSWITCH('VERBOSE')) flags = flags .or. FLG_VERBOSE
	if (M$GET_USWITCH('PORT',tmpstr) .gt. 0) then
	  string(ls+1:) = ',PORT='//tmpstr
	  ls = M$LENGTH(string)
	endif
	if (M$GET_USWITCH('FLAGS',tmpstr) .gt. 0) then
	  string = tmpstr(1:M$LENGTH(tmpstr))//','//string
	  ls = M$LENGTH(string)
	endif
	string(ls+1:ls+2) = ','//CHAR(0)
	status = M$PIC_OPEN (p,string,Mc.break,flags)
	if (status .le. 0) call M$ERROR ('Opening port: '//string)
	status = M$PIC_RESET (p, 0) 
	endif
c
c open and check pic file
	if (usepic) then
	  call M$INIT (HP, M$APICK(3),'1000','SP,SB,SI,CI',0)
	  call M$OPEN (HP, HCBF_INPUT+HCBF_PRESERVE)
	elseif (usefile .and. dir.lt.0) then
	  call M$INIT (HP, M$APICK(3),'1000','SP,SB,SI,CI',0)
	  call M$OPEN (HP, HCBF_INPUT)
	elseif (usesock .and. dir.gt.0) then
	  sockport = M$LPICK(3)
	elseif (usesock .and. dir.lt.0) then
	  sockport = M$LPICK(3)
	  i = M$GET_USWITCH('HOST',sockhost)
	  if (i.le.0) call M$ERROR ('No socket host name given')
	  call M$LOWERCASE (sockhost)
	  do while ( M$CONNECT_TO_SOCKET (socket, 
     &			sockhost(1:i), sockport) .lt. 0)
	    call M$WARNING ('Retry connect to: '//sockhost)
	    call M$PAUSE (1.0)
	    if (Mc.break) call M$ERROR('Could not make socket connection')
	  enddo
          i = M$BUFFER_SOCKET(socket, 'w', sockbuf)
	  i = M$READ_SOCKET (socket, HP, 512)	! read header
	  HP.bpe = M$BPE(HP)
	  HP.dbpe = HP.bpe
	  HP.size = HP.data_size / HP.dbpe
	endif
c
c calculate transfer lengths and mode dependent pic flags
	ioflags = 0
	if (mode.eq.'GSM') then
	  tl = M$GET_SWITCH_DEF('TL',64)
	  frame = M$GET_SWITCH_DEF('BPF',256)
	  block = frame*8	! block of 8 frames
	  blockx = block*4	! plus 3 reorganized blocks
	  nframe = frame/8
	  nblock = block/8
	  nblockx = blockx/8
	  ! expansion by 4 in IOC, 8 frames per block
	  iper = tl * nblockx 
	  i = HP.size*HP.dbpe / iper
	  if (i*iper .ne. HP.size*HP.dbpe) call M$ERROR
     +	  ('Output buffer must be evenly divisible by 4*8*256 bits')
	  call M$MALLOC (iper,pout)
	elseif (mode.eq.'E1MUX') then
	  tl = M$GET_SWITCH_DEF('TL',16)
	  frame = M$GET_SWITCH_DEF('BPF',512)
	  block = frame*16	! block of 16 frames
	  blockx = block*2	! plus 1 channel blocks
	  nframe = frame/8
	  nblock = block/8
	  nblockx = blockx/8
	  iper = tl * nblockx 
	  i = HP.size*HP.dbpe / iper
	  if (i*iper .ne. HP.size*HP.dbpe) call M$ERROR
     +	  ('Output buffer must be evenly divisible by 512*16*tl bits')
	  call M$MALLOC (16*iper/2,pout)
	  ioflags = FLG_DUAL
	elseif (mode.eq.'UNPACK') then
	  frame = 1
	  iper = 0
	  tl = M$GET_SWITCH('TL')
	  pkt_hdrs = M$GET_PSWITCH('HDRS')
	elseif (mode.eq.'PACK') then
	  frame = 1
	  iper = 0
	  tl = M$GET_SWITCH('TL')
	  renum = M$GET_PSWITCH('RENUM')
	endif
c
c fill out header and open files
	afiles = M$GET_SWITCH('AFN')
	nfiles = Mc.number_parameters-3
	if (afiles.gt.0) nfiles = afiles
	do n = 1, nfiles
	  if (afiles.gt.0) then
	    HF(n).file_name = M$APICK(4)
	    i = M$LENGTH(HF(n).file_name)
	    i = M$L2A(n, HF(n).file_name(i+1:))
	  else
	    HF(n).file_name = M$APICK(n+3)
	  endif
	  if (mode.eq.'PACK') then
	    call M$INIT (HF(n),HF(n).file_name,' ',' ',0)
	    call M$OPEN (HF(n), HCBF_INPUT)
	    if (n.eq.1) then
	      call M$PROPAGATE (HF(1),HP)
	      if (usesock) HP.file_name = ' '
	      if (usefile) HP.file_name = M$APICK(3)
	      call M$OPEN (HP, HCBF_OUTPUT+HCBF_OPTIONAL)
	    endif
	    if (HF(n).type.ne.HP.type) call M$ERROR
     &		('Input type does not match output type')
	    if (HF(n).format.ne.HP.format) call M$ERROR
     &		('Input format does not match output format')
	  elseif (mode.eq.'UNPACK') then
	    call M$PROPAGATE (HP,HF(n))
	    call M$OPEN (HF(n), HCBF_OUTPUT)
	  elseif (mode.eq.'GSM' .or. mode.eq.'E1MUX') then
	    call M$PROPAGATE (HP,HF(n))
	    call M$EXISTENCE (HF(n), 1)
	    bpc(n) = M$GET_QUALIFIER(HF(n),'BPC')
	    if (bpc(n).lt.0) bpc(n) = frame
	    bco(n) = M$GET_QUALIFIER(HF(n),'BCO')
	    if (bco(n).lt.0 .and. mode.eq.'E1MUX') bco(n) = n-1
	    if (bco(n).lt.0) bco(n) = 0
	    HF(n).size  = HP.size * frame / bpc(n)
	    HF(n).xdelta = HP.xdelta *  bpc(n) / frame
	    call M$OPEN (HF(n), HCBF_OUTPUT)
	  endif
	enddo
c
c now connect output socket
        if (usesock .and. dir.gt.0) then
	  ! print *,'attempting create socket '
	  if (M$CREATE_SERVER(server, sockport, 1) .ne. 0) 
     &		call M$ERROR('Creating socket server')
	  if (M$UNBLOCK_SERVER(server, 1) .ne. 0) 
     &		call M$WARNING('Unblocking socket server')
	  status = M$ACCEPT_CLIENT (socket, server) 
	  if (status.ne.0) call M$INFO ('Waiting to connect ...')
          do while (status .lt. 0 .and. .not.Mc.break)
            call M$PAUSE (0.1)
	    status = M$ACCEPT_CLIENT (socket, server) 
          enddo
	  call M$DESTROY_SERVER(server)
	  if (Mc.break) goto 999
          call M$INFO ('Created SOCKET at port ...')
          i = M$BUFFER_SOCKET(socket, 'w', sockbuf)
          HSOCK.main = HP.main
          HSOCK.detached = 0
          HSOCK.data_start = 512
          i = M$WRITE_SOCKET (socket, HSOCK, 512)
	  ! print *,'wrote socket header create socket '
        endif
c
c adjust pipe sizes to maximize performance in packet modes
	ipkt = 64 / HP.dbpe
	if (mode.eq.'PACK') then
	  if (ipkt.le.0) call M$ERROR
     &          ('Int Packet Mode Format Incompatibility')
	endif
c
c get startup modes
	mpp = 0
	mgo = -1			! non-piped default
	if (Mc.mode.ne.0) mgo = 2	! piped default
	mgo = M$GET_SWITCH_DEF('REPLAY',mgo)
c
c init the PIC device for IO
	flags = 0
	if (usepic) then
	dmac = M$PIC_IOPORT (p, -1, -1, -1, dir,
     &		1, NINT(1/HP.xdelta), 0.d0, 0, 0, ioflags)
        if (dmac.le.0) call M$ERROR ('Bad I/O Port parameters')
	fmode = M$GET_SWITCH_DEF('FMODE',1)
	status = M$PIC_FILE (p, HP, nstart, nbytes, fmode) 
	if (status.le.0) call M$ERROR('Unacceptable input file for DMA')  
        call M$MOVE (HP.out_bytes(8),vaddr,8)
	pbuf = vaddr
	status = M$PIC_DMA (p, dmac, -1, buf, nstart, nbytes, -1, 0)
	if (status.le.0) call M$ERROR ('Unacceptable channel for DMA')  
	endif
c
c set up real time controls
	idm = M$MWINIT('Replay Mode',mgo,'REPLAY;Play One,Continuous,'//
     &		'Stop Top,Stop Now,Spin,Archive,ReStart,Abort')
	idc = M$LWINIT('Curr Cycle', 0, 1, -1, 1)
	if (mode.eq.'GSM') then
	 do n = 1,nfiles
	  idbpc(n) = M$LWINIT('BPC', bpc(n), 0, frame, bpc(n))
	  idbco(n) = M$LWINIT('BCO', bco(n), 0, frame, bpc(n))
	 enddo
	elseif (mode.eq.'E1MUX') then
	 do n = 1,nfiles
	  idbco(n) = M$LWINIT('CHAN', bco(n), -1, 15, 1)
	 enddo
	endif
c
c initialize parameters
	nlost = 0
	npass = 0
	ncycle = 1
	np = 1
	call RAMSYNC (P_SYNCINIT,status)
c
c signal start of processing block
	call M$SYNC()
c
c top of throttle loop
  1	do while (mgo.eq.0 .or. mgo.eq.3 .or. mgo.eq.4 .or. mgo.eq.7)
	  call UPDATE(status,0)
	  isok = M$MWGET(idm,mgo)
	  if (mgo.eq.7) then ! restart ?
	    mgo = 2 ! already stopped - just start
	    call M$MWPUT(idm,mgo)
	  endif
	  if (Mc.break .or. mgo.eq.8) goto 999
	  call M$PAUSE(pause)
        enddo
c
c make sure the PIC device is running
	if (mpp.ne.1 .and. usepic) then
	  mpp = 1
	  if (mgo.lt.0) then
	    status = M$PIC_DMAFUNC (p,dmac,-mgo)
	  elseif (mgo.eq.2) then
	    status = M$PIC_DMAFUNC (p,dmac,DMA_CIRCULAR)
	  else
	    status = M$PIC_DMAFUNC (p,dmac,DMA_ONESHOT)
	  endif
	  call RAMSYNC (P_SYNCSET,status)
	endif 
c
c update the pass through RAM buffer count
  2	npass = npass + 1
	call M$LWPUT (idc,npass)
	if (.not.usepic) ncycle = npass
c
c set xfer parameters
  3	dnext = 0
	ntogo = HP.size
c
c warn if we are falling way behind
	if (ncycle.gt.npass+nlost) then
	  status = M$L2A (ncycle-(npass+nlost),cnum)
	  call M$WARNING ('Fell behind '//cnum//' RAM buffers')
	endif
c
c wait for current data pointer
	do while (npass+nlost.gt.ncycle .and. .not.Mc.break)
          call RAMSYNC (P_SYNCSTAT,status)
	  call M$PAUSE (pause)
	enddo
c
c loop through buffers of data  (data buffer loop)
c
	do while (ntogo.gt.0 .and. .not.Mc.break)
	  if (HP.bpe.lt.0) nget = min(iper*8,ntogo)
	  if (HP.bpe.ge.0) nget = min(iper,ntogo)
          call RAMSYNC (P_SYNCSTAT,status)
c
c get new real time controls
	  call UPDATE(status,1)
c
c check for falling behind
	  if (npass+nlost.eq.ncycle-1 .and. usepic) then
	    status = M$PIC_DMAFUNC (p,dmac,DMA_STATUS)
	    nnext = NINT(dnext*HP.dbpe)
	    if (status .gt. nnext) then
	      call M$WARNING ('Falling behind one RAM buffer')
	      nlost = nlost + 1
	    endif
	  endif
c
c wait until data is available
	  if (npass+nlost.ge.ncycle .and. usepic) then
	    nnext = NINT((dnext+nget)*HP.dbpe)
	    status = M$PIC_DMAFUNC (p,dmac,DMA_STATUS)
	    do while (status.lt.nnext .and. npass+nlost.ge.ncycle)
	      call UPDATE(status,1)
	      call M$PAUSE(pause)
              call RAMSYNC (P_SYNCSTAT,status)
	      if (Mc.break) goto 999
	    enddo
	  endif
c
c get the data
	  if (usepic) then
	    ! its already in memory - go for speed
	    pbuf = vaddr + NINT(dnext*HP.dbpe) 
	    ngot = nget
	    blocks = ngot / blockx
	  elseif (mode.eq.'UNPACK') then
	    HP.xfer_len = ipkt
	    if (usefile) call M$GRABX (HP,pkt,ngot)
	    if (usesock) ngot = M$READ_SOCKET (socket,pkt,ipkt*HP.bpe)
     &						 / HP.bpe
	    if (ngot.ne.ipkt) goto 999
	    if (pkt.keys(1).ne.101) call M$ERROR('Bad packet key')
	    HP.xfer_len = pkt.elem
	    if (pkt.elem.gt.iper) then
	      iper = pkt.elem
	      call M$MALLOC (iper*HP.bpe, pbuf)
	    endif
	    if (usefile) call M$GRABX (HP,buf,ngot)
	    if (usesock) i = M$READ_SOCKET (socket,buf,pkt.elem*HP.bpe)
	    ngot = ipkt + pkt.elem
	  elseif (mode.eq.'PACK') then
	    nplast = np
	    call M$HCBFUNC(HF(np),HCBF_AVAIL,i)
	    do while (i.lt.ipkt+HF(np).xfer_len .and. .not.Mc.break)
	      np = mod(np,nfiles)+1
	      if (np.eq.nplast) call M$PAUSE(Mc.pause)
	      call M$HCBFUNC(HF(np),HCBF_AVAIL,i)
	    enddo
	    HF(np).xfer_len = ipkt
	    call M$GRABX (HF(np),pkt,ngot)
	    if (pkt.keys(1).ne.101) call M$ERROR('Bad packet key')
	    HF(np).xfer_len = pkt.elem
	    if (pkt.elem.gt.iper) then
	      iper = pkt.elem
	      call M$MALLOC (iper*HP.bpe, pbuf)
	    endif
	    call M$GRABX (HF(np),buf,ngot)
	    ngot = ipkt + pkt.elem
	  else
	    call M$GRABX (HP,buf,ngot)
	    blocks = ngot / blockx
	  endif
	  ntogo = ntogo - ngot
	  dnext = NINT(dnext) + ngot
c
c handle GSM output buffer
	if (mode.eq.'GSM') then
	  do n = 1,nfiles		! loop on output pipes
	    ibpc = bpc(n)
	    ibco = bco(n)
	    if (ibpc.eq.frame) then	! frame-bit in 1st raw block
	      j = 0
	      k = 0
	      do i = 1,blocks
	        call M$MOVE (buf(j+1),out(k+1),nblock)
		j = j + nblockx
		k = k + nblock
	      enddo
	      npot = blocks*frame*8
	    elseif (ibpc.eq.8) then	! 8-bit in 1st raw block
	      k = 0
	      ioff = ibco/8
	      do i = 1,blocks
		do j = 1,8
		  out(k+1) = buf(ioff+1)
		  k = k+1
		  ioff = ioff + nframe
		enddo
	        ioff = ioff + 3*nblock
	      enddo
	      npot = blocks*8*8
	    elseif (ibpc.eq.0) then
	      npot = 0
	    elseif (ibpc.eq.1) then
	      ioff = nblock*3 + ibco	! 1-bit in 4th block
	      call M$VMOVNB( buf(ioff+1),nblockx, out,1, blocks,1)
	      npot = blocks*1*8
	    elseif (ibpc.eq.2) then
	      ioff = nblock*2 + ibco	! 2-bit in 3rd block
	      call M$VMOVNB( buf(ioff+1),nblockx, out,2, blocks,2)
	      npot = blocks*2*8
	    elseif (ibpc.eq.4) then
	      ioff = nblock*1 + ibco	! 4-bit in 2nd block
	      call M$VMOVNB( buf(ioff+1),nblockx, out,4, blocks,4)
	      npot = blocks*4*8
	    else
	      nbpc = ibpc/8
	      k = 0
	      ioff = ibco/8
	      do i = 1,blocks
	        call M$VMOVNB(buf(ioff+1),nframe,out(k+1),nbpc,8,nbpc)
		k = k + nbpc*8
		ioff = ioff + nblockx
	      enddo
	      npot = blocks*ibpc*8
	    endif
	    call M$FILAD (HF(n),out,npot)
	  enddo
c
c handle E1MUX output buffer
	elseif (mode.eq.'E1MUX') then
	  call M$ERROR('E1MUX not supported')
c
c handle UNPACK output buffer
	elseif (mode.eq.'UNPACK') then
	  n = pkt.channel
	  npot = pkt.elem
	  if (n.ge.1 .and. n.le.nfiles) then
     	    if (pkt_hdrs) call M$FILAD (HF(n),pkt,ipkt)
     	    call M$FILAD (HF(n),buf,npot)
	  endif
c
c handle PACK output buffer
	elseif (mode.eq.'PACK') then
	  if (renum) pkt.channel = np
	  npot = pkt.elem
	  if (mgo.ne.5) then
     	    if (usefile) call M$FILAD (HP,pkt,ipkt)
     	    if (usefile) call M$FILAD (HP,buf,npot)
     	    if (usesock) i = M$WRITE_SOCKET (socket,pkt,ipkt*HP.bpe)
     	    if (usesock) i = M$WRITE_SOCKET (socket,buf,npot*HP.bpe)
	  endif
	  np = mod(np,nfiles)+1
	endif
c
c check throttle control widget
	  isok = M$MWGET(idm,mgo)
	  if (mgo.eq.4) ntogo = 0

	enddo
c
c stop PIC if necessary
	if ((mgo.eq.1 .or. mgo.ge.3) .and. mpp.eq.1 .and. usepic) then
	  mpp = 0
	  status = M$PIC_DMAFUNC (p,dmac,DMA_STOP)
	  status = M$PIC_DMAFUNC (p,dmac,DMA_RESET)
	  npass = 0
	  nlost = 0
	  ncycle = 1
	endif
c
c go back for replay
	if (mgo.ge.0) then
	  if (mgo.eq.1.or.mgo.eq.3.or.mgo.eq.4) then
	    mgo = 0
	    call M$MWPUT(idm,mgo)
	  endif
	  if (mgo.eq.2 .and. .not.Mc.break) goto 2
	  if (mgo.ne.8 .and. .not.Mc.break) goto 1
	else
	  mgo = mgo + 1 ! replicate mode
	  call M$MWPUT(idm,mgo)
	  if (mgo.lt.0 .and. .not.Mc.break) goto 1
	endif
c
c close PIC DEVICE
  999	continue
	if (usepic) then
  	  status = M$PIC_DMAFUNC (p,dmac,DMA_CANCEL)
	  status = M$PIC_FILE  (p, HP, nstart, nbytes, -fmode) 
	  status = M$PIC_CLOSE (p)
	endif
c
c close input/output files
	do n = 1,nfiles
	  call M$CLOSE(HF(n))
	enddo
	if (usesock) call M$CLOSE_SOCKET (socket)
	if (.not.usesock) call M$CLOSE(HP)
c
	call M$RETURN
	end


	subroutine RAMSYNC (mode,status)
	implicit none
	include 'picfunc.inc'
	integer*4 mode
	SAVE 
	integer*4 statuslast
	if (.not.usepic) then
	  status = 1e9
	  return
	endif
	if (mode.eq.P_SYNCINIT) then		! to initialize
	  statuslast = 0
	  return
	endif
	status = M$PIC_DMAFUNC (p,dmac,DMA_STATUS)
	if (status.eq.-1) call M$ERROR ('ICE-PIC is down')
	status = max(0,min(nbytes,status))
	if (status.lt.statuslast .or. mode.eq.P_SYNCSET) then 	! next buffer
	  if (mode.eq.P_SYNCSET) return
  	  ncycle = M$PIC_DMAFUNC (p,dmac,DMA_CYCLE) + 1	! 0->1 based
	endif
	statuslast = status
	return
	end


	subroutine UPDATE (status,flags)
	implicit none
	include 'picfunc.inc'
	include 'qmessages.inc'
	real*8 time, time1, time2

	! look for messages
	if (Mu.id .le. 0) goto 100
	if (M$GET_MSG(mqh,mqd,L_mqd,0.0,0).le.0) goto 100
	if (mqh.name .eq. 'MGO') then
	  call M$NOW (time1,time2)
	  time = time1 + time2
	  call M$SEND_MSGL ('=MGO',0,mqh.sender,mqh.info,0,1,'D',time,0)
	  call M$MWPUT (idm, mqh.info)
	elseif (mqh.name .eq. 'CHNCFG') then
	  call M$LWPUT (idbpc(mqh.info), mqd.lbuf(1) )
	  call M$LWPUT (idbco(mqh.info), mqd.lbuf(2) )
        elseif (mqh.name .eq. 'EXIT') then
          call M$MWPUT (idm,8)
	else
	  call M$WARNING ('Unexpected message: '//mqh.name)
	endif

 100	continue	! look for widgets
	do n = 1,nfiles
	  if (idbpc(n).gt.0) then
	    if (M$LWGET(idbpc(n),bpc(n)).gt.0) then
	    endif
	  endif
	  if (idbco(n).gt.0) then
     	    if (M$LWGET(idbco(n),bco(n)).gt.0) then
	    endif
	  endif
	enddo

	return
	end

